/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import net.i2p.data.DataHelper;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.SimpleTimer;

public class CoalesceStatsEvent
implements SimpleTimer.TimedEvent {
    private final RouterContext _ctx;
    private final long _maxMemory;
    private static final long LOW_MEMORY_THRESHOLD = 0x500000L;

    public CoalesceStatsEvent(RouterContext ctx) {
        this._ctx = ctx;
        ctx.statManager().createRequiredRateStat("bw.receiveBps", CoalesceStatsEvent._x("Message receive rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRequiredRateStat("bw.sendBps", CoalesceStatsEvent._x("Message send rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRequiredRateStat("bw.sendRate", CoalesceStatsEvent._x("Low-level send rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
        ctx.statManager().createRequiredRateStat("bw.recvRate", CoalesceStatsEvent._x("Low-level receive rate (bytes/sec)"), "Bandwidth", new long[]{60000L, 300000L, 600000L, 3600000L});
        ctx.statManager().createRequiredRateStat("router.activePeers", CoalesceStatsEvent._x("How many peers we are actively talking with"), "Throttle", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRequiredRateStat("router.highCapacityPeers", "How many high capacity peers we know", "Throttle", new long[]{300000L, 3600000L});
        ctx.statManager().createRateStat("router.activeSendPeers", "How many peers we've sent to this minute", "Throttle", new long[]{60000L, 300000L, 3600000L});
        ctx.statManager().createRequiredRateStat("router.fastPeers", CoalesceStatsEvent._x("Known fast peers"), "Throttle", new long[]{300000L, 3600000L});
        this._maxMemory = Runtime.getRuntime().maxMemory();
        String legend = "(Bytes)";
        if (this._maxMemory < Long.MAX_VALUE) {
            legend = legend + " Max is " + DataHelper.formatSize((long)this._maxMemory) + 'B';
        }
        ctx.statManager().createRequiredRateStat("router.memoryUsed", legend, "Router", new long[]{60000L});
    }

    private RouterContext getContext() {
        return this._ctx;
    }

    public void timeReached() {
        Rate rate;
        RateStat sendRate;
        Rate rate2;
        int active = this.getContext().commSystem().countActivePeers();
        this.getContext().statManager().addRateData("router.activePeers", (long)active, 60000L);
        int activeSend = this.getContext().commSystem().countActiveSendPeers();
        this.getContext().statManager().addRateData("router.activeSendPeers", (long)activeSend, 60000L);
        int fast = this.getContext().profileOrganizer().countFastPeers();
        this.getContext().statManager().addRateData("router.fastPeers", (long)fast, 60000L);
        int highCap = this.getContext().profileOrganizer().countHighCapacityPeers();
        this.getContext().statManager().addRateData("router.highCapacityPeers", (long)highCap, 60000L);
        this.getContext().statManager().addRateData("bw.sendRate", (long)this.getContext().bandwidthLimiter().getSendBps());
        this.getContext().statManager().addRateData("bw.recvRate", (long)this.getContext().bandwidthLimiter().getReceiveBps());
        long used = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.getContext().statManager().addRateData("router.memoryUsed", used);
        if (this._maxMemory - used < 0x500000L) {
            Router.clearCaches();
        }
        this.getContext().tunnelDispatcher().updateParticipatingStats(50000);
        this.getContext().statManager().coalesceStats();
        RateStat receiveRate = this.getContext().statManager().getRate("transport.receiveMessageSize");
        if (receiveRate != null && (rate2 = receiveRate.getRate(60000L)) != null) {
            double bytes = rate2.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate2.getPeriod();
            this.getContext().statManager().addRateData("bw.receiveBps", (long)bps, 60000L);
        }
        if ((sendRate = this.getContext().statManager().getRate("transport.sendMessageSize")) != null && (rate = sendRate.getRate(60000L)) != null) {
            double bytes = rate.getLastTotalValue();
            double bps = bytes * 1000.0 / (double)rate.getPeriod();
            this.getContext().statManager().addRateData("bw.sendBps", (long)bps, 60000L);
        }
    }

    private static final String _x(String s) {
        return s;
    }
}

