/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.RouterInfo;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.Job;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.IterativeLookupSelector;
import net.i2p.router.networkdb.kademlia.IterativeTimeoutJob;
import net.i2p.router.networkdb.kademlia.KBucketSet;
import net.i2p.router.networkdb.kademlia.XORComparator;
import net.i2p.router.util.RandomIterator;

class IterativeSearchJob
extends FloodSearchJob {
    private final SortedSet<Hash> _toTry;
    private final Set<Hash> _unheardFrom;
    private final Set<Hash> _failedPeers;
    private final Map<Hash, Long> _sentTime;
    private final Hash _rkey;
    private OutNetMessage _out;
    private static final int MAX_NON_FF = 3;
    private static final int TOTAL_SEARCH_LIMIT = 8;
    private static final int MAX_SEARCH_TIME = 30000;
    private static final long SINGLE_SEARCH_TIME = 3000L;
    private static final long SINGLE_SEARCH_MSG_TIME = 10000L;
    private static final int MAX_CONCURRENT = 1;

    public IterativeSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        this._timeoutMs = Math.min(timeoutMs, 30000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._rkey = ctx.routingKeyGenerator().getRoutingKey(key);
        this._toTry = new TreeSet<Hash>(new XORComparator(this._rkey));
        this._unheardFrom = new HashSet<Hash>(2);
        this._failedPeers = new HashSet<Hash>(8);
        this._sentTime = new ConcurrentHashMap<Hash, Long>(8);
    }

    public void runJob() {
        if (this._facade.isNegativeCached(this._key)) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Negative cached, not searching: " + this._key);
            }
            this.failed();
            return;
        }
        KBucketSet ks = this._facade.getKBuckets();
        List<Object> floodfillPeers = ks != null ? ((FloodfillPeerSelector)this._facade.getPeerSelector()).selectFloodfillParticipants(this._rkey, 8, ks) : new ArrayList(8);
        if (floodfillPeers.isEmpty()) {
            ArrayList<Hash> all;
            if (this._log.shouldLog(30)) {
                this._log.warn("Running netDb searches against the floodfill peers, but we don't know any");
            }
            if ((all = new ArrayList<Hash>(this._facade.getAllRouters())).isEmpty()) {
                if (this._log.shouldLog(40)) {
                    this._log.error("We don't know any peers at all");
                }
                this.failed();
                return;
            }
            RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
            for (int i = 0; iter.hasNext() && i < 3; ++i) {
                floodfillPeers.add(iter.next());
            }
        }
        this._toTry.addAll(floodfillPeers);
        this._toTry.remove(this.getContext().routerHash());
        this._toTry.remove(this._key);
        if (this._toTry.isEmpty()) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": Iterative search for " + this._key + " had no peers to send to");
            }
            this.failed();
            return;
        }
        IterativeLookupSelector replySelector = new IterativeLookupSelector(this.getContext(), this);
        FloodOnlyLookupMatchJob onReply = new FloodOnlyLookupMatchJob(this.getContext(), this);
        FloodOnlyLookupTimeoutJob onTimeout = new FloodOnlyLookupTimeoutJob(this.getContext(), this);
        this._out = this.getContext().messageRegistry().registerPending(replySelector, onReply, onTimeout, this._timeoutMs);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Iterative search for " + this._key + " (rkey " + this._rkey + ") timeout " + DataHelper.formatDuration((long)this._timeoutMs) + " toTry: " + DataHelper.toString(this._toTry));
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        long now = this.getContext().clock().now();
        if (this._expiration < now) {
            this.failed();
            return;
        }
        if (this._expiration - 500L < now) {
            return;
        }
        while (true) {
            Hash peer;
            IterativeSearchJob iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                if (this._dead) {
                    return;
                }
                int pend = this._unheardFrom.size();
                if (pend >= 1) {
                    return;
                }
                int done = this._failedPeers.size();
                if (done >= 8) {
                    this.failed();
                    return;
                }
                if (done + pend >= 8) {
                    return;
                }
                if (this._toTry.isEmpty()) {
                    return;
                }
                Iterator iter = this._toTry.iterator();
                peer = (Hash)iter.next();
                iter.remove();
                this._unheardFrom.add(peer);
            }
            this.sendQuery(peer);
        }
    }

    private void sendQuery(Hash peer) {
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundExploratoryTunnel(peer);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(peer);
        if (replyTunnel == null || outTunnel == null) {
            this.failed();
            return;
        }
        if (outTunnel.getLength() <= 1 && peer.equals((Object)this._key)) {
            this.failed(peer, false);
            return;
        }
        dlm.setFrom(replyTunnel.getPeer(0));
        dlm.setMessageExpiration(this.getContext().clock().now() + 10000L);
        dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
        dlm.setSearchKey(this._key);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Iterative search for " + this._key + " to " + peer);
        }
        long now = this.getContext().clock().now();
        this._sentTime.put(peer, now);
        this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), peer);
        IterativeTimeoutJob j = new IterativeTimeoutJob(this.getContext(), peer, this);
        long expire = Math.min(this._expiration, now + 3000L);
        j.getTiming().setStartAfter(expire);
        this.getContext().jobQueue().addJob(j);
    }

    public String getName() {
        return "Iterative search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Hash peer, boolean timedOut) {
        boolean isNewFail;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._unheardFrom.remove(peer);
            isNewFail = this._failedPeers.add(peer);
        }
        if (isNewFail) {
            if (timedOut) {
                this.getContext().profileManager().dbLookupFailed(peer);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": search timed out to " + peer);
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": search failed to " + peer);
            }
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newPeerToTry(Hash peer) {
        if (peer.equals((Object)this.getContext().routerHash()) || peer.equals((Object)this._key)) {
            return;
        }
        RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
        if (!FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
            return;
        }
        if (this.getContext().banlist().isBanlistedForever(peer)) {
            return;
        }
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._failedPeers.contains(peer) || this._unheardFrom.contains(peer)) {
                return;
            }
            if (!this._toTry.add(peer)) {
                return;
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": new peer from DSRM " + peer);
        }
        this.retry();
    }

    long timeSent(Hash peer) {
        Long rv = this._sentTime.get(peer);
        return rv == null ? -1L : rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed() {
        int tries;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this._facade.complete(this._key);
        if (this.getContext().commSystem().getReachabilityStatus() != 3) {
            this._facade.lookupFailed(this._key);
        }
        this.getContext().messageRegistry().unregisterPending(this._out);
        IterativeSearchJob iterativeSearchJob2 = this;
        synchronized (iterativeSearchJob2) {
            tries = this._unheardFrom.size() + this._failedPeers.size();
            Iterator<Hash> iter = this._unheardFrom.iterator();
            while (iter.hasNext()) {
                this.getContext().profileManager().dbLookupFailed(iter.next());
            }
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldLog(20)) {
            long timeRemaining = this._expiration - this.getContext().clock().now();
            this._log.info(this.getJobId() + ": Iterative search for " + this._key + " failed with " + timeRemaining + " remaining after " + time + ", peers queried: " + tries);
        }
        this.getContext().statManager().addRateData("netDb.failedTime", time, 0L);
        this.getContext().statManager().addRateData("netDb.retries", (long)Math.max(0, tries - 1), 0L);
        for (Job j : this._onFailed) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFailed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void success() {
        Long timeSent;
        int tries;
        Hash peer = null;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
            tries = this._unheardFrom.size() + this._failedPeers.size();
            if (this._unheardFrom.size() == 1) {
                peer = this._unheardFrom.iterator().next();
                this._unheardFrom.clear();
            }
        }
        this._facade.complete(this._key);
        if (peer != null && (timeSent = this._sentTime.get(peer)) != null) {
            this.getContext().profileManager().dbLookupSuccessful(peer, this.getContext().clock().now() - timeSent);
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": Iterative search for " + this._key + " successful after " + time + ", peers queried: " + tries);
        }
        this.getContext().statManager().addRateData("netDb.successTime", time, 0L);
        this.getContext().statManager().addRateData("netDb.retries", (long)(tries - 1), 0L);
        for (Job j : this._onFind) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFind.clear();
    }
}

