/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.RouterInfo;
import net.i2p.data.SigningPrivateKey;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.router.message.GarlicMessageHandler;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.startup.StartupJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.router.tasks.CoalesceStatsEvent;
import net.i2p.router.tasks.GracefulShutdown;
import net.i2p.router.tasks.MarkLiveliness;
import net.i2p.router.tasks.OOMListener;
import net.i2p.router.tasks.PersistRouterInfoJob;
import net.i2p.router.tasks.Republish;
import net.i2p.router.tasks.Restarter;
import net.i2p.router.tasks.RouterWatchdog;
import net.i2p.router.tasks.ShutdownHook;
import net.i2p.router.tasks.Spinner;
import net.i2p.router.tasks.UpdateRoutingKeyModifierJob;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.util.EventLog;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.ByteCache;
import net.i2p.util.FileUtil;
import net.i2p.util.FortunaRandomSource;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Router
implements RouterClock.ClockShiftListener {
    private Log _log;
    private final RouterContext _context;
    private final Map<String, String> _config;
    private String _configFilename;
    private RouterInfo _routerInfo;
    public final Object routerInfoFileLock = new Object();
    private final Object _configFileLock = new Object();
    private long _started;
    private boolean _higherVersionSeen;
    private boolean _killVMOnEnd;
    private volatile boolean _isAlive;
    private int _gracefulExitCode = -1;
    private I2PThread.OOMEventListener _oomListener;
    private ShutdownHook _shutdownHook;
    private volatile boolean _shutdownInProgress;
    private I2PThread _gracefulShutdownDetector;
    private RouterWatchdog _watchdog;
    private Thread _watchdogThread;
    private final EventLog _eventLog;
    public static final String PROP_CONFIG_FILE = "router.configLocation";
    public static final long CLOCK_FUDGE_FACTOR = 60000L;
    public static final int NETWORK_ID = 2;
    public static final int COALESCE_TIME = 50000;
    public static final String PROP_HIDDEN = "router.hiddenMode";
    public static final String PROP_HIDDEN_HIDDEN = "router.isHidden";
    public static final String PROP_DYNAMIC_KEYS = "router.dynamicKeys";
    public static final String PROP_INFO_FILENAME = "router.info.location";
    public static final String PROP_INFO_FILENAME_DEFAULT = "router.info";
    public static final String PROP_KEYS_FILENAME = "router.keys.location";
    public static final String PROP_KEYS_FILENAME_DEFAULT = "router.keys";
    public static final String PROP_SHUTDOWN_IN_PROGRESS = "__shutdownInProgress";
    public static final String DNS_CACHE_TIME = "300";
    private static final String EVENTLOG = "eventlog.txt";
    private static final String originalTimeZoneID;
    public static final char CAPABILITY_BW12 = 'K';
    public static final char CAPABILITY_BW32 = 'L';
    public static final char CAPABILITY_BW64 = 'M';
    public static final char CAPABILITY_BW128 = 'N';
    public static final char CAPABILITY_BW256 = 'O';
    public static final String PROP_FORCE_BWCLASS = "router.forceBandwidthClass";
    public static final char CAPABILITY_REACHABLE = 'R';
    public static final char CAPABILITY_UNREACHABLE = 'U';
    public static final String PROP_FORCE_UNREACHABLE = "router.forceUnreachable";
    public static final char CAPABILITY_NEW_TUNNEL = 'T';
    private static final String[] _rebuildFiles;
    public static final int EXIT_GRACEFUL = 2;
    public static final int EXIT_HARD = 3;
    public static final int EXIT_OOM = 10;
    public static final int EXIT_HARD_RESTART = 4;
    public static final int EXIT_GRACEFUL_RESTART = 5;
    private static final boolean ALLOW_DYNAMIC_KEYS = false;
    public static final String UPDATE_FILE = "i2pupdate.zip";
    private static final String DELETE_FILE = "deletelist.txt";
    static final long LIVELINESS_DELAY = 60000L;
    public static final String PROP_BANDWIDTH_SHARE_PERCENTAGE = "router.sharePercentage";
    public static final int DEFAULT_SHARE_PERCENTAGE = 80;

    public Router() {
        this(null, null);
    }

    public Router(Properties envProps) {
        this(null, envProps);
    }

    public Router(String configFilename) {
        this(configFilename, null);
    }

    public Router(String configFilename, Properties envProps) {
        this._config = new ConcurrentHashMap<String, String>();
        if (configFilename == null) {
            if (envProps != null) {
                this._configFilename = envProps.getProperty(PROP_CONFIG_FILE);
            }
            if (this._configFilename == null) {
                this._configFilename = System.getProperty(PROP_CONFIG_FILE, "router.config");
            }
        } else {
            this._configFilename = configFilename;
        }
        String migrate = System.getProperty("i2p.dir.migrate");
        boolean migrateFiles = Boolean.parseBoolean(migrate);
        String userDir = WorkingDir.getWorkingDir(envProps, migrateFiles);
        File cf = new File(this._configFilename);
        if (!cf.isAbsolute()) {
            cf = new File(userDir, this._configFilename);
            this._configFilename = cf.getAbsolutePath();
        }
        this.readConfig();
        if (envProps == null) {
            envProps = new Properties();
        }
        envProps.putAll(this._config);
        if (envProps.getProperty("i2p.dir.config") == null) {
            envProps.setProperty("i2p.dir.config", userDir);
        }
        envProps.setProperty("i2p.systemTimeZone", originalTimeZoneID);
        List<RouterContext> contexts = RouterContext.getContexts();
        if (contexts.isEmpty()) {
            RouterContext.killGlobalContext();
        } else if (SystemVersion.isAndroid()) {
            System.err.println("Warning: Killing " + contexts.size() + " other routers in this JVM");
            contexts.clear();
            RouterContext.killGlobalContext();
        } else {
            System.err.println("Warning: " + contexts.size() + " other routers in this JVM");
        }
        this._context = new RouterContext(this, envProps);
        this._eventLog = new EventLog(this._context, new File(this._context.getRouterDir(), EVENTLOG));
        if (!this.isOnlyRouterRunning()) {
            this._eventLog.addEvent("aborted", "Another router running");
            System.err.println("ERROR: There appears to be another router already running!");
            System.err.println("       Please make sure to shut down old instances before starting up");
            System.err.println("       a new one.  If you are positive that no other instance is running,");
            System.err.println("       please delete the file " + this.getPingFile().getAbsolutePath());
            System.exit(-1);
        }
        if (this._config.get("router.firstVersion") == null) {
            this._config.put("router.firstVersion", "0.9.4");
            String now = Long.toString(System.currentTimeMillis());
            this._config.put("router.firstInstalled", now);
            this._config.put("router.updateLastInstalled", now);
            this._config.put("router.previousVersion", "0.9.4");
            this.saveConfig();
        }
    }

    private void startupStuff() {
        if (!SystemVersion.isAndroid()) {
            this.beginMarkingLiveliness();
        }
        System.setProperty("router.version", "0.9.4");
        this._context.initAll();
        if (this._context.hasWrapper()) {
            File f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
            if (!f.exists()) {
                f = new File(this._context.getBaseDir(), "wrapper.log");
            }
            if (f.exists()) {
                SecureFileOutputStream.setPerms((File)f);
            }
        }
        this._routerInfo = null;
        this._higherVersionSeen = false;
        this._log = this._context.logManager().getLog(Router.class);
        this._log.info("New router created with config file " + this._configFilename);
        this._killVMOnEnd = true;
        this._oomListener = new OOMListener(this._context);
        this._shutdownHook = new ShutdownHook(this._context);
        this._gracefulShutdownDetector = new I2PAppThread((Runnable)new GracefulShutdown(this._context), "Graceful shutdown hook", true);
        this._gracefulShutdownDetector.setPriority(6);
        this._gracefulShutdownDetector.start();
        this._watchdog = new RouterWatchdog(this._context);
        this._watchdogThread = new I2PAppThread((Runnable)this._watchdog, "RouterWatchdog", true);
        this._watchdogThread.setPriority(6);
        this._watchdogThread.start();
    }

    public static final void clearCaches() {
        ByteCache.clearAll();
        SimpleByteCache.clearAll();
    }

    public void setKillVMOnEnd(boolean shouldDie) {
        this._killVMOnEnd = shouldDie;
    }

    public boolean getKillVMOnEnd() {
        return this._killVMOnEnd;
    }

    public String getConfigFilename() {
        return this._configFilename;
    }

    public void setConfigFilename(String filename) {
        this._configFilename = filename;
    }

    public String getConfigSetting(String name) {
        return this._config.get(name);
    }

    public void setConfigSetting(String name, String value) {
        this._config.put(name, value);
    }

    public void removeConfigSetting(String name) {
        this._config.remove(name);
        this._context.removeProperty(name);
    }

    public Set<String> getConfigSettings() {
        return Collections.unmodifiableSet(this._config.keySet());
    }

    public Map<String, String> getConfigMap() {
        return Collections.unmodifiableMap(this._config);
    }

    public RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    public void setRouterInfo(RouterInfo info) {
        this._routerInfo = info;
        if (this._log.shouldLog(20)) {
            this._log.info("setRouterInfo() : " + info, (Throwable)new Exception("I did it"));
        }
        if (info != null) {
            this._context.jobQueue().addJob(new PersistRouterInfoJob(this._context));
        }
    }

    public boolean getHigherVersionSeen() {
        return this._higherVersionSeen;
    }

    public void setHigherVersionSeen(boolean seen) {
        this._higherVersionSeen = seen;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getUptime() {
        if (this._context == null || this._context.clock() == null) {
            return 1L;
        }
        return Math.max(1L, this._context.clock().now() - this._context.clock().getOffset() - this._started);
    }

    public RouterContext getContext() {
        return this._context;
    }

    public synchronized void runRouter() {
        if (this._isAlive) {
            throw new IllegalStateException();
        }
        String last = this._config.get("router.previousFullVersion");
        if (last != null) {
            this._eventLog.addEvent("updated", "from " + last + " to " + "0.9.4-0");
            this.saveConfig("router.previousFullVersion", null);
        }
        this._eventLog.addEvent("started", "0.9.4-0");
        this.startupStuff();
        this._isAlive = true;
        this._started = this._context.clock().now();
        try {
            Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        }
        catch (IllegalStateException ise) {
            // empty catch block
        }
        I2PThread.addOOMEventListener((I2PThread.OOMEventListener)this._oomListener);
        this._context.keyManager().startup();
        this.setupHandlers();
        this._context.messageValidator().startup();
        this._context.tunnelDispatcher().startup();
        this._context.inNetMessagePool().startup();
        this.startupQueue();
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new CoalesceStatsEvent(this._context), 50000L);
        this._context.jobQueue().addJob(new UpdateRoutingKeyModifierJob(this._context));
        this.warmupCrypto();
        this._context.blocklist().startup();
        long before = System.currentTimeMillis();
        this._context.clock().getTimestamper().waitForInitialization();
        long waited = System.currentTimeMillis() - before;
        if (this._log.shouldLog(20)) {
            this._log.info("Waited " + waited + "ms to initialize");
        }
        this._context.jobQueue().addJob(new StartupJob(this._context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig() {
        Object object = this._configFileLock;
        synchronized (object) {
            String f = this.getConfigFilename();
            Properties config = Router.getConfig(this._context, f);
            Map<String, String> foo = this._config;
            foo.putAll(config);
        }
    }

    private static Properties getConfig(RouterContext ctx, String filename) {
        Log log = null;
        if (ctx != null && (log = ctx.logManager().getLog(Router.class)).shouldLog(10)) {
            log.debug("Config file: " + filename, (Throwable)new Exception("location"));
        }
        Properties props = new Properties();
        try {
            File f = new File(filename);
            if (f.canRead()) {
                DataHelper.loadProps((Properties)props, (File)f);
                props.remove(PROP_SHUTDOWN_IN_PROGRESS);
            } else if (log != null) {
                log.warn("Configuration file " + filename + " does not exist");
            }
        }
        catch (Exception ioe) {
            if (log != null) {
                log.error("Error loading the router configuration from " + filename, (Throwable)ioe);
            }
            System.err.println("Error loading the router configuration from " + filename + ": " + ioe);
        }
        return props;
    }

    public boolean isAlive() {
        return this._isAlive;
    }

    public void rebuildRouterInfo() {
        this.rebuildRouterInfo(false);
    }

    public void rebuildRouterInfo(boolean blockingRebuild) {
        if (this._log.shouldLog(20)) {
            this._log.info("Rebuilding new routerInfo");
        }
        RouterInfo ri = null;
        ri = this._routerInfo != null ? new RouterInfo(this._routerInfo) : new RouterInfo();
        try {
            ri.setPublished(this._context.clock().now());
            Properties stats = this._context.statPublisher().publishStatistics();
            stats.setProperty("netId", "2");
            ri.setOptions(stats);
            ri.setAddresses(this._context.commSystem().createAddresses());
            this.addCapabilities(ri);
            SigningPrivateKey key = this._context.keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known?  wtf");
                return;
            }
            ri.sign(key);
            this.setRouterInfo(ri);
            if (!ri.isValid()) {
                throw new DataFormatException("Our RouterInfo has a bad signature");
            }
            Republish r = new Republish(this._context);
            if (blockingRebuild) {
                r.timeReached();
            } else {
                this._context.simpleScheduler().addEvent((SimpleTimer.TimedEvent)r, 0L);
            }
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Internal error - unable to sign our own address?!", (Throwable)dfe);
        }
    }

    public void addCapabilities(RouterInfo ri) {
        String force;
        int bwLim = Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
        bwLim = (int)((double)bwLim * this.getSharePercentage());
        if (this._log.shouldLog(20)) {
            this._log.info("Adding capabilities w/ bw limit @ " + bwLim, (Throwable)new Exception("caps"));
        }
        if ((force = this._context.getProperty(PROP_FORCE_BWCLASS)) != null && force.length() > 0) {
            ri.addCapability(force.charAt(0));
        } else if (bwLim < 12) {
            ri.addCapability('K');
        } else if (bwLim <= 32) {
            ri.addCapability('L');
        } else if (bwLim <= 64) {
            ri.addCapability('M');
        } else if (bwLim <= 128) {
            ri.addCapability('N');
        } else {
            ri.addCapability('O');
        }
        if (FloodfillNetworkDatabaseFacade.floodfillEnabled(this._context) && !this._context.getBooleanProperty("router.hideFloodfillParticipant")) {
            ri.addCapability('f');
        }
        if (this._context.getBooleanProperty(PROP_HIDDEN)) {
            ri.addCapability('H');
        }
        if (this._context.getBooleanProperty(PROP_FORCE_UNREACHABLE)) {
            ri.addCapability('U');
            return;
        }
        switch (this._context.commSystem().getReachabilityStatus()) {
            case 0: {
                ri.addCapability('R');
                break;
            }
            case 1: 
            case 2: {
                ri.addCapability('U');
                break;
            }
        }
    }

    public boolean isHidden() {
        RouterInfo ri = this._routerInfo;
        if (ri != null && ri.isHidden()) {
            return true;
        }
        String h = this._context.getProperty(PROP_HIDDEN_HIDDEN);
        if (h != null) {
            return Boolean.parseBoolean(h);
        }
        return this._context.commSystem().isInBadCountry();
    }

    public Certificate createCertificate() {
        if (this._context.getBooleanProperty(PROP_HIDDEN)) {
            return new Certificate(2, null);
        }
        return Certificate.NULL_CERT;
    }

    public EventLog eventLog() {
        return this._eventLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killKeys() {
        int remCount = 0;
        for (int i = 0; i < _rebuildFiles.length; ++i) {
            File f = new File(this._context.getRouterDir(), _rebuildFiles[i]);
            if (!f.exists()) continue;
            boolean removed = f.delete();
            if (removed) {
                System.out.println("INFO:  Removing old identity file: " + _rebuildFiles[i]);
                ++remCount;
                continue;
            }
            System.out.println("ERROR: Could not remove old identity file: " + _rebuildFiles[i]);
        }
        Router router = this;
        synchronized (router) {
            this.removeConfigSetting("i2np.udp.internalPort");
            this.removeConfigSetting("i2np.udp.port");
            this.saveConfig();
        }
        if (remCount > 0) {
            this._eventLog.addEvent("rekeyed");
        }
    }

    public synchronized void rebuildNewIdentity() {
        if (this._shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException ise) {
                // empty catch block
            }
        }
        this.killKeys();
        for (Runnable task : this._context.getShutdownTasks()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running shutdown task " + task.getClass());
            }
            try {
                task.run();
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        this._context.removeShutdownTasks();
        if (this._context.hasWrapper()) {
            this._log.log(50, "Restarting with new router identity");
        } else {
            this._log.log(50, "Shutting down because old router identity was invalid - restart I2P");
        }
        this.finalShutdown(4);
    }

    private void warmupCrypto() {
        this._context.random().nextBoolean();
        this._context.elGamalEngine();
    }

    private void startupQueue() {
        this._context.jobQueue().runQueue(1);
    }

    private void setupHandlers() {
        this._context.inNetMessagePool().registerHandlerJobBuilder(11, new GarlicMessageHandler(this._context));
    }

    public synchronized void shutdown(int exitCode) {
        if (this._shutdownInProgress) {
            return;
        }
        this._shutdownInProgress = true;
        this._context.throttle().setShutdownStatus();
        if (this._shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.shutdown2(exitCode);
    }

    public synchronized void shutdown2(int exitCode) {
        int priority = exitCode == 10 ? 9 : 7;
        Thread.currentThread().setPriority(priority);
        this._shutdownInProgress = true;
        this._log.log(50, "Starting final shutdown(" + exitCode + ')');
        if (this._killVMOnEnd) {
            try {
                new Spinner().start();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        ((RouterClock)this._context.clock()).removeShiftListener(this);
        this._isAlive = false;
        this._context.random().saveSeed();
        I2PThread.removeOOMEventListener((I2PThread.OOMEventListener)this._oomListener);
        for (Runnable task : this._context.getShutdownTasks()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running shutdown task " + task.getClass());
            }
            try {
                Thread t = new Thread(task, "Shutdown task " + task.getClass().getName());
                t.setDaemon(true);
                t.start();
                try {
                    t.join(10000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                if (!t.isAlive()) continue;
                this._log.logAlways(30, "Shutdown task took more than 10 seconds to run: " + task.getClass());
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        if (!"0.9.4".equals(this._config.get("router.previousVersion"))) {
            this.saveConfig("router.previousVersion", "0.9.4");
        }
        this._context.removeShutdownTasks();
        try {
            this._context.clientManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the client manager", t);
        }
        try {
            this._context.namingService().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the naming service", t);
        }
        try {
            this._context.jobQueue().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the job queue", t);
        }
        try {
            this._context.statPublisher().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the stats publisher", t);
        }
        try {
            this._context.tunnelManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the tunnel manager", t);
        }
        try {
            this._context.tunnelDispatcher().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the tunnel dispatcher", t);
        }
        try {
            this._context.netDb().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the networkDb", t);
        }
        try {
            this._context.commSystem().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the comm system", t);
        }
        try {
            this._context.bandwidthLimiter().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the comm system", t);
        }
        try {
            this._context.peerManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the peer manager", t);
        }
        try {
            this._context.messageRegistry().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message registry", t);
        }
        try {
            this._context.messageValidator().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message validator", t);
        }
        try {
            this._context.inNetMessagePool().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the inbound net pool", t);
        }
        try {
            this._context.clientMessagePool().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the client msg pool", t);
        }
        try {
            this._context.sessionKeyManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the session key manager", t);
        }
        try {
            this._context.messageHistory().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message history logger", t);
        }
        try {
            this._context.statManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the stats manager", t);
        }
        this._context.deleteTempDir();
        List<RouterContext> contexts = RouterContext.getContexts();
        contexts.remove((Object)this._context);
        try {
            this._context.elGamalEngine().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting elGamal", t);
        }
        if (!contexts.isEmpty()) {
            this._log.logAlways(30, "Warning - " + contexts.size() + " routers remaining in this JVM, not releasing all resources");
        }
        try {
            ((FortunaRandomSource)this._context.random()).shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting random()", t);
        }
        this._watchdog.shutdown();
        this._watchdogThread.interrupt();
        this._eventLog.addEvent("stopped", Integer.toString(exitCode));
        this.finalShutdown(exitCode);
    }

    private synchronized void finalShutdown(int exitCode) {
        Router.clearCaches();
        this._log.log(50, "Shutdown(" + exitCode + ") complete");
        try {
            this._context.logManager().shutdown();
        }
        catch (Throwable t) {
            // empty catch block
        }
        File f = this.getPingFile();
        f.delete();
        if (RouterContext.getContexts().isEmpty()) {
            RouterContext.killGlobalContext();
        }
        for (Runnable task : this._context.getFinalShutdownTasks()) {
            try {
                task.run();
            }
            catch (Throwable t) {
                System.err.println("Running final shutdown task " + t);
            }
        }
        this._context.getFinalShutdownTasks().clear();
        if (this._killVMOnEnd) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().exit(exitCode);
        } else if (SystemVersion.isAndroid()) {
            Runtime.getRuntime().gc();
        }
    }

    public void shutdownGracefully() {
        this.shutdownGracefully(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownGracefully(int exitCode) {
        this._gracefulExitCode = exitCode;
        this._config.put(PROP_SHUTDOWN_IN_PROGRESS, "true");
        this._context.throttle().setShutdownStatus();
        I2PThread i2PThread = this._gracefulShutdownDetector;
        synchronized (i2PThread) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelGracefulShutdown() {
        this._gracefulExitCode = -1;
        this._config.remove(PROP_SHUTDOWN_IN_PROGRESS);
        this._context.throttle().cancelShutdownStatus();
        I2PThread i2PThread = this._gracefulShutdownDetector;
        synchronized (i2PThread) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    public int scheduledGracefulExitCode() {
        return this._gracefulExitCode;
    }

    public boolean gracefulShutdownInProgress() {
        return null != this._config.get(PROP_SHUTDOWN_IN_PROGRESS);
    }

    public boolean isFinalShutdownInProgress() {
        return this._shutdownInProgress;
    }

    public long getShutdownTimeRemaining() {
        if (this._gracefulExitCode <= 0) {
            return -1L;
        }
        if (this._gracefulExitCode == 3 || this._gracefulExitCode == 4) {
            return 0L;
        }
        long exp = this._context.tunnelManager().getLastParticipatingExpiration();
        if (exp < 0L) {
            return -1L;
        }
        return exp + 120000L - this._context.clock().now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig() {
        try {
            OrderedProperties ordered = new OrderedProperties();
            Object object = this._configFileLock;
            synchronized (object) {
                ordered.putAll(this._config);
                DataHelper.storeProps((Properties)ordered, (File)new File(this._configFilename));
            }
        }
        catch (Exception ioe) {
            if (this._log != null) {
                this._log.error("Error saving the config to " + this._configFilename, (Throwable)ioe);
            } else {
                System.err.println("Error saving the config to " + this._configFilename + ": " + ioe);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig(String name, String value) {
        Object object = this._configFileLock;
        synchronized (object) {
            if (value != null) {
                this._config.put(name, value);
            } else {
                this.removeConfigSetting(name);
            }
            return this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig(Map toAdd, Collection<String> toRemove) {
        Object object = this._configFileLock;
        synchronized (object) {
            if (toAdd != null) {
                this._config.putAll(toAdd);
            }
            if (toRemove != null) {
                for (String s : toRemove) {
                    this.removeConfigSetting(s);
                }
            }
            return this.saveConfig();
        }
    }

    @Override
    public void clockShift(long delta) {
        if (this.gracefulShutdownInProgress() || !this._isAlive) {
            return;
        }
        if (delta > -60000L && delta < 60000L) {
            return;
        }
        this._eventLog.addEvent("clockShift", Long.toString(delta));
        this._context.routingKeyGenerator().generateDateBasedModData();
        if (this._context.commSystem().countActivePeers() <= 0) {
            return;
        }
        if (delta > 0L) {
            this._log.error("Restarting after large clock shift forward by " + DataHelper.formatDuration((long)delta));
        } else {
            this._log.error("Restarting after large clock shift backward by " + DataHelper.formatDuration((long)(0L - delta)));
        }
        this.restart();
    }

    public synchronized void restart() {
        if (this.gracefulShutdownInProgress() || !this._isAlive) {
            return;
        }
        ((RouterClock)this._context.clock()).removeShiftListener(this);
        this._isAlive = false;
        this._started = this._context.clock().now();
        Thread t = new Thread((Runnable)new Restarter(this._context), "Router Restart");
        t.setPriority(6);
        t.start();
    }

    public void setIsAlive() {
        this._isAlive = true;
    }

    public static void main(String[] args) {
        System.out.println("Starting I2P 0.9.4-0");
        Router r = new Router();
        if (args != null && args.length == 1 && "rebuild".equals(args[0])) {
            r.rebuildNewIdentity();
        } else {
            r.installUpdates();
            r.runRouter();
        }
    }

    private void installUpdates() {
        File updateFile = new File(this._context.getRouterDir(), UPDATE_FILE);
        boolean exists = updateFile.exists();
        if (!exists) {
            updateFile = new File(this._context.getBaseDir(), UPDATE_FILE);
            exists = updateFile.exists();
        }
        if (exists) {
            File test = new File(this._context.getBaseDir(), "history.txt");
            if (test.exists() && !test.canWrite() || !this._context.getBaseDir().canWrite()) {
                System.out.println("ERROR: No write permissions on " + this._context.getBaseDir() + " to extract software update file");
                return;
            }
            System.out.println("INFO: Update file exists [i2pupdate.zip] - installing");
            boolean ok = FileUtil.verifyZip((File)updateFile);
            if (ok) {
                this._config.put("router.updateLastInstalled", "" + System.currentTimeMillis());
                this._config.put("router.previousVersion", "0.9.4");
                this._config.put("router.previousFullVersion", "0.9.4-0");
                this.saveConfig();
                ok = FileUtil.extractZip((File)updateFile, (File)this._context.getBaseDir());
            }
            try {
                boolean deleted;
                if (ok) {
                    this.deleteListedFiles();
                    System.out.println("INFO: Update installed");
                } else {
                    System.out.println("ERROR: Update failed!");
                }
                if (!ok) {
                    File bad = new File(this._context.getRouterDir(), "BAD-i2pupdate.zip");
                    boolean renamed = updateFile.renameTo(bad);
                    if (renamed) {
                        System.out.println("Moved update file to " + bad.getAbsolutePath());
                    } else {
                        System.out.println("Deleting file " + updateFile.getAbsolutePath());
                        ok = true;
                    }
                }
                if (ok && !(deleted = updateFile.delete())) {
                    System.out.println("ERROR: Unable to delete the update file!");
                    updateFile.deleteOnExit();
                }
                if (this._context.hasWrapper()) {
                    System.out.println("INFO: Restarting after update");
                } else {
                    System.out.println("WARNING: Exiting after update, restart I2P");
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            System.exit(4);
        } else {
            this.deleteJbigiFiles();
            this.deleteListedFiles();
        }
    }

    private void deleteJbigiFiles() {
        String osArch = System.getProperty("os.arch");
        boolean isX86 = osArch.contains("86") || osArch.equals("amd64");
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean isWin = SystemVersion.isWindows();
        boolean isMac = SystemVersion.isMac();
        boolean goodOS = isWin || isMac || osName.contains("linux") || osName.contains("freebsd");
        File jbigiJar = new File(this._context.getBaseDir(), "lib/jbigi.jar");
        if (isX86 && goodOS && jbigiJar.exists()) {
            boolean success2;
            String path;
            boolean success;
            File jbigiLib;
            boolean success22;
            String path2;
            boolean success3;
            String libPrefix;
            String string = libPrefix = isWin ? "" : "lib";
            String libSuffix = isWin ? ".dll" : (isMac ? ".jnilib" : ".so");
            File jcpuidLib = new File(this._context.getBaseDir(), libPrefix + "jcpuid" + libSuffix);
            if (jcpuidLib.canWrite() && jbigiJar.lastModified() > jcpuidLib.lastModified() && (success3 = FileUtil.copy((String)(path2 = jcpuidLib.getAbsolutePath()), (String)(path2 + ".bak"), (boolean)true, (boolean)true)) && (success22 = jcpuidLib.delete())) {
                System.out.println("New jbigi.jar detected, moved jcpuid library to " + path2 + ".bak");
                System.out.println("Check logs for successful installation of new library");
            }
            if ((jbigiLib = new File(this._context.getBaseDir(), libPrefix + "jbigi" + libSuffix)).canWrite() && jbigiJar.lastModified() > jbigiLib.lastModified() && (success = FileUtil.copy((String)(path = jbigiLib.getAbsolutePath()), (String)(path + ".bak"), (boolean)true, (boolean)true)) && (success2 = jbigiLib.delete())) {
                System.out.println("New jbigi.jar detected, moved jbigi library to " + path + ".bak");
                System.out.println("Check logs for successful installation of new library");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteListedFiles() {
        File deleteFile = new File(this._context.getBaseDir(), DELETE_FILE);
        if (!deleteFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        try {
            String line;
            fis = new FileInputStream(deleteFile);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = in.readLine()) != null) {
                File df;
                String fl = line.trim();
                if (fl.startsWith("..") || fl.startsWith("#") || fl.length() == 0 || (df = new File(fl)).isAbsolute() || !(df = new File(this._context.getBaseDir(), fl)).exists() || df.isDirectory() || !df.delete()) continue;
                System.out.println("INFO: File [" + fl + "] deleted");
            }
            fis.close();
            fis = null;
            if (deleteFile.delete()) {
                System.out.println("INFO: File [deletelist.txt] deleted");
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private File getPingFile() {
        String s = this._context.getProperty("router.pingFile", "router.ping");
        File f = new File(s);
        if (!f.isAbsolute()) {
            f = new File(this._context.getPIDDir(), s);
        }
        return f;
    }

    private boolean isOnlyRouterRunning() {
        File f = this.getPingFile();
        if (f.exists()) {
            long lastWritten = f.lastModified();
            if (System.currentTimeMillis() - lastWritten > 60000L) {
                System.err.println("WARN: Old router was not shut down gracefully, deleting router.ping");
                f.delete();
            } else {
                return false;
            }
        }
        return true;
    }

    private void beginMarkingLiveliness() {
        File f = this.getPingFile();
        this._context.simpleScheduler().addPeriodicEvent((SimpleTimer.TimedEvent)new MarkLiveliness(this, f), 0L, 55000L);
    }

    public double getSharePercentage() {
        block4: {
            String pct = this._context.getProperty(PROP_BANDWIDTH_SHARE_PERCENTAGE);
            if (pct != null) {
                try {
                    double d = Double.parseDouble(pct);
                    if (d > 1.0) {
                        return d / 100.0;
                    }
                    return d;
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(20)) break block4;
                    this._log.info("Unable to get the share percentage");
                }
            }
        }
        return 0.8;
    }

    public int get1sRate() {
        return this.get1sRate(false);
    }

    public int get1sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        int out = (int)bw.getSendBps();
        if (outboundOnly) {
            return out;
        }
        return (int)Math.max((float)out, bw.getReceiveBps());
    }

    public int get1sRateIn() {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        return (int)bw.getReceiveBps();
    }

    public int get15sRate() {
        return this.get15sRate(false);
    }

    public int get15sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        int out = (int)bw.getSendBps15s();
        if (outboundOnly) {
            return out;
        }
        return (int)Math.max((float)out, bw.getReceiveBps15s());
    }

    public int get15sRateIn() {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        return (int)bw.getReceiveBps15s();
    }

    public int get1mRate() {
        return this.get1mRate(false);
    }

    public int get1mRate(boolean outboundOnly) {
        int send = 0;
        StatManager mgr = this._context.statManager();
        RateStat rs = mgr.getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(60000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = mgr.getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    public int get1mRateIn() {
        StatManager mgr = this._context.statManager();
        RateStat rs = mgr.getRate("bw.recvRate");
        int recv = 0;
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return recv;
    }

    public int get5mRate() {
        return this.get5mRate(false);
    }

    public int get5mRate(boolean outboundOnly) {
        int send = 0;
        RateStat rs = this._context.statManager().getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(300000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = this._context.statManager().getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(300000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    static {
        System.setProperty("sun.net.inetaddr.ttl", DNS_CACHE_TIME);
        System.setProperty("sun.net.inetaddr.negative.ttl", DNS_CACHE_TIME);
        System.setProperty("networkaddress.cache.ttl", DNS_CACHE_TIME);
        System.setProperty("networkaddress.cache.negative.ttl", DNS_CACHE_TIME);
        System.setProperty("http.agent", "I2P");
        System.setProperty("http.keepAlive", "false");
        originalTimeZoneID = TimeZone.getDefault().getID();
        System.setProperty("user.timezone", "GMT");
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        System.setProperty("org.mortbay.util.FileResource.checkAliases", "true");
        _rebuildFiles = new String[]{PROP_INFO_FILENAME_DEFAULT, PROP_KEYS_FILENAME_DEFAULT, "netDb/my.info", "connectionTag.keys", "keyBackup/privateEncryption.key", "keyBackup/privateSigning.key", "keyBackup/publicEncryption.key", "keyBackup/publicSigning.key", "sessionKeys.dat"};
    }
}

