/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSession;
import net.i2p.client.streaming.I2PSocketException;
import net.i2p.client.streaming.impl.ConnectionDataReceiver;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.ConnectionPacketHandler;
import net.i2p.client.streaming.impl.I2PSocketFull;
import net.i2p.client.streaming.impl.MessageInputStream;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.client.streaming.impl.PacketQueue;
import net.i2p.client.streaming.impl.SchedulerChooser;
import net.i2p.client.streaming.impl.TaskScheduler;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;

class Connection {
    private final I2PAppContext _context;
    private final Log _log;
    private final ConnectionManager _connectionManager;
    private final I2PSession _session;
    private Destination _remotePeer;
    private SigningPublicKey _transientSPK;
    private final AtomicLong _sendStreamId = new AtomicLong();
    private final AtomicLong _receiveStreamId = new AtomicLong();
    private volatile long _lastSendTime;
    private final AtomicLong _lastSendId;
    private final AtomicBoolean _resetReceived = new AtomicBoolean();
    private final AtomicLong _resetSentOn = new AtomicLong();
    private final AtomicBoolean _connected = new AtomicBoolean(true);
    private final AtomicBoolean _finalDisconnect = new AtomicBoolean();
    private boolean _hardDisconnected;
    private final MessageInputStream _inputStream;
    private final MessageOutputStream _outputStream;
    private final SchedulerChooser _chooser;
    private long _nextSendTime;
    private final AtomicLong _ackedPackets = new AtomicLong();
    private final long _createdOn;
    private final AtomicLong _closeSentOn = new AtomicLong();
    private final AtomicLong _closeReceivedOn = new AtomicLong();
    private final AtomicInteger _unackedPacketsReceived = new AtomicInteger();
    private long _congestionWindowEnd;
    private volatile long _highestAckedThrough;
    private final boolean _isInbound;
    private boolean _updatedShareOpts;
    private final Map<Long, PacketLocal> _outboundPackets;
    private final PacketQueue _outboundQueue;
    private final ConnectionPacketHandler _handler;
    private ConnectionOptions _options;
    private final ConnectionDataReceiver _receiver;
    private I2PSocketFull _socket;
    private String _connectionError;
    private final AtomicLong _disconnectScheduledOn = new AtomicLong();
    private long _lastReceivedOn;
    private final ActivityTimer _activityTimer;
    private int _lastCongestionSeenAt;
    private long _lastCongestionTime;
    private volatile long _lastCongestionHighestUnacked;
    private volatile boolean _isChoked;
    private volatile boolean _isChoking;
    private final AtomicInteger _unchokesToSend = new AtomicInteger();
    private final AtomicBoolean _ackSinceCongestion;
    private final Object _connectLock;
    private final Object _nextSendLock;
    private final AtomicInteger _activeResends = new AtomicInteger();
    private final ConEvent _connectionEvent;
    private final int _randomWait;
    private final int _localPort;
    private final int _remotePort;
    private final SimpleTimer2 _timer;
    private final AtomicLong _lifetimeBytesSent = new AtomicLong();
    private long _lowestBytesAckedThrough;
    private final AtomicLong _lifetimeBytesReceived = new AtomicLong();
    private final AtomicLong _lifetimeDupMessageSent = new AtomicLong();
    private final AtomicLong _lifetimeDupMessageReceived = new AtomicLong();
    public static final long MAX_RESEND_DELAY = 45000L;
    public static final long MIN_RESEND_DELAY = 100L;
    public static final int DISCONNECT_TIMEOUT = 300000;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static final long MAX_CONNECT_TIMEOUT = 120000L;
    public static final int MAX_WINDOW_SIZE = 128;
    private static final int UNCHOKES_TO_SEND = 8;
    static final int FAST_RETRANSMIT_THRESHOLD = 3;

    public Connection(I2PAppContext ctx, ConnectionManager manager, I2PSession session, SchedulerChooser chooser, SimpleTimer2 timer, PacketQueue queue, ConnectionPacketHandler handler, ConnectionOptions opts, boolean isInbound) {
        this._context = ctx;
        this._connectionManager = manager;
        this._session = session;
        this._chooser = chooser;
        this._outboundQueue = queue;
        this._handler = handler;
        this._isInbound = isInbound;
        this._log = this._context.logManager().getLog(Connection.class);
        this._receiver = new ConnectionDataReceiver(this._context, this);
        this._options = opts != null ? opts : new ConnectionOptions();
        this._inputStream = new MessageInputStream(this._context, this._options.getMaxMessageSize(), this._options.getMaxWindowSize(), this._options.getInboundBufferSize());
        this._outputStream = new MessageOutputStream(this._context, timer, this._receiver, this._options.getMaxMessageSize());
        this._timer = timer;
        this._outboundPackets = new TreeMap<Long, PacketLocal>();
        if (opts != null) {
            this._localPort = opts.getLocalPort();
            this._remotePort = opts.getPort();
        } else {
            this._localPort = 0;
            this._remotePort = 0;
        }
        this._outputStream.setWriteTimeout((int)this._options.getWriteTimeout());
        this._inputStream.setReadTimeout((int)this._options.getReadTimeout());
        this._lastSendId = new AtomicLong(-1L);
        this._nextSendTime = -1L;
        this._createdOn = this._context.clock().now();
        this._congestionWindowEnd = this._options.getWindowSize() - 1;
        this._highestAckedThrough = -1L;
        this._lastCongestionSeenAt = 256;
        this._lastCongestionTime = -1L;
        this._lastCongestionHighestUnacked = -1L;
        this._lastReceivedOn = -1L;
        this._activityTimer = new ActivityTimer();
        this._ackSinceCongestion = new AtomicBoolean(true);
        this._connectLock = new Object();
        this._nextSendLock = new Object();
        this._connectionEvent = new ConEvent();
        this._randomWait = this._context.random().nextInt(10000);
        if (this._log.shouldLog(20)) {
            this._log.info("New connection created with options: " + this._options);
        }
    }

    public long getNextOutboundPacketNum() {
        return this._lastSendId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean packetSendChoke(long timeoutMs) throws IOException, InterruptedException {
        long start = this._context.clock().now();
        long writeExpire = start + timeoutMs;
        boolean started = false;
        while (true) {
            long timeLeft = writeExpire - this._context.clock().now();
            Map<Long, PacketLocal> map = this._outboundPackets;
            synchronized (map) {
                if (!started) {
                    this._context.statManager().addRateData("stream.chokeSizeBegin", (long)this._outboundPackets.size());
                }
                if (start + 300000L < this._context.clock().now()) {
                    return false;
                }
                if (!this._connected.get()) {
                    if (this.getResetReceived()) {
                        throw new I2PSocketException(512);
                    }
                    throw new IOException("Socket closed");
                }
                if (this._outputStream.getClosed()) {
                    throw new IOException("Output stream closed");
                }
                started = true;
                int unacked = this._outboundPackets.size();
                int wsz = this._options.getWindowSize();
                if (this._isChoked || unacked >= wsz || this._activeResends.get() >= (wsz + 1) / 2 || this._lastSendId.get() - this._highestAckedThrough >= (long)Math.max(128, 2 * wsz)) {
                    if (timeoutMs > 0L) {
                        if (timeLeft <= 0L) {
                            if (this._log.shouldLog(20)) {
                                this._log.info("Outbound window is full (choked? " + this._isChoked + ' ' + unacked + " unacked with " + this._activeResends + " active resends and we've waited too long (" + (0L - (timeLeft - timeoutMs)) + "ms): " + this.toString());
                            }
                            return false;
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Outbound window is full (choked? " + this._isChoked + ' ' + unacked + '/' + wsz + '/' + this._activeResends + "), waiting " + timeLeft);
                        }
                        try {
                            this._outboundPackets.wait(Math.min(timeLeft, 250L));
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            throw ie;
                        }
                    } else {
                        try {
                            this._outboundPackets.wait(250L);
                        }
                        catch (InterruptedException ie) {
                            if (this._log.shouldLog(10)) {
                                this._log.debug("InterruptedException while Outbound window is full (" + this._outboundPackets.size() + "/" + this._activeResends + ")");
                            }
                            throw ie;
                        }
                    }
                } else {
                    this._context.statManager().addRateData("stream.chokeSizeEnd", (long)this._outboundPackets.size());
                    return true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void windowAdjusted() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            this._outboundPackets.notifyAll();
        }
    }

    void ackImmediately() {
        PacketLocal packet = this._receiver.send(null, 0, 0);
        if (this._log.shouldLog(10)) {
            this._log.debug("sending new ack: " + packet);
        }
    }

    private void sendReset() {
        long now = this._context.clock().now();
        if (this._resetSentOn.get() + 10000L > now) {
            return;
        }
        if (this._resetReceived.get()) {
            return;
        }
        this._resetSentOn.set(now);
        if (this._remotePeer == null || this._sendStreamId.get() <= 0L) {
            return;
        }
        PacketLocal reply = new PacketLocal(this._context, this._remotePeer, this);
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setSendStreamId(this._sendStreamId.get());
        reply.setReceiveStreamId(this._receiveStreamId.get());
        reply.setLocalPort(this._localPort);
        reply.setRemotePort(this._remotePort);
        if (this._outboundQueue.enqueue(reply)) {
            this._unackedPacketsReceived.set(0);
            this._lastSendTime = this._context.clock().now();
            this.resetActivityTimer();
        }
    }

    void sendAvailable() {
        block2: {
            try {
                this._outputStream.flushAvailable(this._receiver, false);
            }
            catch (IOException ioe) {
                if (!this._log.shouldLog(40)) break block2;
                this._log.error("Error flushing available", (Throwable)ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPacket(PacketLocal packet) {
        if (packet == null) {
            return;
        }
        this.setNextSendTime(-1L);
        if (this._options.getRequireFullySigned()) {
            packet.setFlag(8);
            packet.setFlag(16);
        }
        if (packet.getSequenceNum() == 0L && !packet.isFlagSet(1)) {
            if (this._isChoking) {
                packet.setOptionalDelay(61000);
                packet.setFlag(64);
            } else if (this._unchokesToSend.decrementAndGet() > 0) {
                packet.setOptionalDelay(0);
                packet.setFlag(64);
            }
        } else {
            int remaining;
            int windowSize;
            Map<Long, PacketLocal> map = this._outboundPackets;
            synchronized (map) {
                this._outboundPackets.put(packet.getSequenceNum(), packet);
                windowSize = this._options.getWindowSize();
                remaining = windowSize - this._outboundPackets.size();
                this._outboundPackets.notifyAll();
            }
            if (this._isChoking) {
                packet.setOptionalDelay(61000);
                packet.setFlag(64);
            } else if (packet.isFlagSet(2) || this._unchokesToSend.decrementAndGet() > 0 || remaining < 3 || remaining < (windowSize + 2) / 3) {
                packet.setOptionalDelay(0);
                packet.setFlag(64);
            }
            long timeout = this._options.getRTO();
            if (timeout > 45000L) {
                timeout = 45000L;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Resend in " + timeout + " for " + packet);
            }
            new ResendPacketEvent(packet, timeout);
        }
        if (this._outboundQueue.enqueue(packet)) {
            this._unackedPacketsReceived.set(0);
            this._lastSendTime = this._context.clock().now();
            this.resetActivityTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PacketLocal> ackPackets(long ackThrough, long[] nacks) {
        if (ackThrough >= this._highestAckedThrough) {
            if (nacks == null) {
                this._highestAckedThrough = ackThrough;
            } else {
                long lowest = -1L;
                for (int i = 0; i < nacks.length; ++i) {
                    if (lowest >= 0L && nacks[i] >= lowest) continue;
                    lowest = nacks[i];
                }
                if (lowest - 1L > this._highestAckedThrough) {
                    this._highestAckedThrough = lowest - 1L;
                }
            }
        }
        ArrayList<PacketLocal> acked = null;
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            if (!this._outboundPackets.isEmpty()) {
                Map.Entry<Long, PacketLocal> e;
                long id;
                Iterator<Map.Entry<Long, PacketLocal>> iter = this._outboundPackets.entrySet().iterator();
                while (iter.hasNext() && (id = (e = iter.next()).getKey().longValue()) <= ackThrough) {
                    boolean nacked = false;
                    if (nacks != null) {
                        for (int i = 0; i < nacks.length; ++i) {
                            if (nacks[i] != id) continue;
                            nacked = true;
                            PacketLocal nackedPacket = e.getValue();
                            nackedPacket.incrementNACKs();
                            break;
                        }
                    }
                    if (nacked) continue;
                    if (acked == null) {
                        acked = new ArrayList<PacketLocal>(8);
                    }
                    PacketLocal ackedPacket = e.getValue();
                    ackedPacket.ackReceived();
                    acked.add(ackedPacket);
                    iter.remove();
                }
            }
            if (acked != null) {
                this._ackedPackets.addAndGet(acked.size());
                for (int i = 0; i < acked.size(); ++i) {
                    PacketLocal p = (PacketLocal)acked.get(i);
                    if (p.getNumSends() <= 1) continue;
                    this._activeResends.decrementAndGet();
                    if (!this._log.shouldLog(10)) continue;
                    this._log.debug("Active resend of " + p + " successful, # active left: " + this._activeResends);
                }
            }
            if (this._outboundPackets.isEmpty() && this._activeResends.get() != 0) {
                if (this._log.shouldLog(20)) {
                    this._log.info("All outbound packets acked, clearing " + this._activeResends);
                }
                this._activeResends.set(0);
            }
            this._outboundPackets.notifyAll();
        }
        if (acked != null && !acked.isEmpty()) {
            this._ackSinceCongestion.set(true);
        }
        return acked;
    }

    void eventOccurred() {
        TaskScheduler sched = this._chooser.getScheduler(this);
        long before = System.currentTimeMillis();
        sched.eventOccurred(this);
        long elapsed = System.currentTimeMillis() - before;
        if (elapsed > 250L && this._log.shouldLog(30)) {
            this._log.warn("Took " + elapsed + "ms to pump through " + sched + " on " + this.toString());
        }
    }

    public void notifyCloseSent() {
        if (!this._closeSentOn.compareAndSet(0L, this._context.clock().now()) && this._log.shouldLog(10)) {
            this._log.debug("Sent more than one CLOSE: " + this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReceived() {
        if (this._closeReceivedOn.compareAndSet(0L, this._context.clock().now())) {
            this._inputStream.closeReceived();
            if (this._closeSentOn.get() > 0L) {
                this.disconnect(true);
            } else {
                Object object = this._connectLock;
                synchronized (object) {
                    this._connectLock.notifyAll();
                }
            }
        }
    }

    public void notifyLastPacketAcked() {
        long cso = this._closeSentOn.get();
        if (cso <= 0L) {
            throw new IllegalStateException();
        }
        long cro = this._closeReceivedOn.get();
        if (cro > 0L && cro < cso) {
            this.disconnect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetReceived() {
        if (!this._resetReceived.compareAndSet(false, true)) {
            return;
        }
        I2PSocketException ioe = new I2PSocketException(512);
        this._outputStream.streamErrorOccurred((IOException)ioe);
        this._inputStream.streamErrorOccurred((IOException)ioe);
        this._connectionError = "Connection reset";
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
        this.disconnectComplete();
    }

    public boolean getResetReceived() {
        return this._resetReceived.get();
    }

    public boolean isInbound() {
        return this._isInbound;
    }

    public boolean getIsConnected() {
        return this._connected.get();
    }

    public boolean getHardDisconnected() {
        return this._hardDisconnected;
    }

    public boolean getResetSent() {
        return this._resetSentOn.get() > 0L;
    }

    public long getResetSentOn() {
        return this._resetSentOn.get();
    }

    public long getDisconnectScheduledOn() {
        return this._disconnectScheduledOn.get();
    }

    public void disconnect(boolean cleanDisconnect) {
        this.disconnect(cleanDisconnect, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(boolean cleanDisconnect, boolean removeFromConMgr) {
        if (!this._connected.compareAndSet(true, false)) {
            return;
        }
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
        if (this._closeReceivedOn.get() <= 0L) {
            this._inputStream.closeReceived();
        }
        if (cleanDisconnect) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Clean disconnecting, remove? " + removeFromConMgr + ": " + this.toString(), (Throwable)new Exception("discon"));
            }
            this._outputStream.closeInternal();
        } else {
            this._hardDisconnected = true;
            if (this._inputStream.getHighestBlockId() >= 0L && !this.getResetReceived()) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Hard disconnecting and sending reset, remove? " + removeFromConMgr + " on " + this.toString(), (Throwable)new Exception("cause"));
                }
                this.sendReset();
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Hard disconnecting, remove? " + removeFromConMgr + " on " + this.toString(), (Throwable)new Exception("cause"));
            }
            this._outputStream.streamErrorOccurred(new IOException("Hard disconnect"));
        }
        if (removeFromConMgr) {
            if (!cleanDisconnect) {
                this.disconnectComplete();
            } else {
                long cro = this._closeReceivedOn.get();
                long cso = this._closeSentOn.get();
                if (cro > 0L && cro < cso && this.getUnackedPacketsSent() <= 0) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Rcv close -> send close -> last acked, skip TIME-WAIT for " + this.toString());
                    }
                    this.disconnectComplete();
                } else {
                    this.scheduleDisconnectEvent();
                }
            }
        }
    }

    public void disconnectComplete() {
        if (!this._finalDisconnect.compareAndSet(false, true)) {
            return;
        }
        this._connected.set(false);
        I2PSocketFull s = this._socket;
        if (s != null) {
            s.destroy2();
            this._socket = null;
        }
        this._outputStream.destroy();
        this._receiver.destroy();
        this._activityTimer.cancel();
        this._inputStream.streamErrorOccurred(new IOException("Socket closed"));
        if (this._log.shouldLog(20)) {
            this._log.info("Connection disconnect complete: " + this.toString());
        }
        this._connectionManager.removeConnection(this);
        this.killOutstandingPackets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOutstandingPackets() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            if (this._outboundPackets.isEmpty()) {
                return;
            }
            for (PacketLocal pl : this._outboundPackets.values()) {
                pl.cancelled();
            }
            this._outboundPackets.clear();
            this._outboundPackets.notifyAll();
        }
    }

    private boolean scheduleDisconnectEvent() {
        if (!this._disconnectScheduledOn.compareAndSet(0L, this._context.clock().now())) {
            return false;
        }
        this.schedule(new DisconnectEvent(), 300000L);
        return true;
    }

    public void scheduleConnectionEvent(long msToWait) {
        this.schedule(this._connectionEvent, msToWait);
    }

    public void schedule(SimpleTimer.TimedEvent event, long msToWait) {
        this._timer.addEvent(event, msToWait);
    }

    public synchronized Destination getRemotePeer() {
        return this._remotePeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemotePeer(Destination peer) {
        if (peer == null) {
            throw new NullPointerException();
        }
        Connection connection = this;
        synchronized (connection) {
            if (this._remotePeer != null) {
                throw new RuntimeException("Remote peer already set [" + this._remotePeer + ", " + peer + "]");
            }
            this._remotePeer = peer;
        }
        this._connectionManager.updateOptsFromShare(this);
    }

    public synchronized SigningPublicKey getRemoteSPK() {
        if (this._transientSPK != null) {
            return this._transientSPK;
        }
        if (this._remotePeer != null) {
            return this._remotePeer.getSigningPublicKey();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemoteTransientSPK(SigningPublicKey transientSPK) {
        Connection connection = this;
        synchronized (connection) {
            if (this._transientSPK != null) {
                throw new RuntimeException("Remote SPK already set");
            }
            this._transientSPK = transientSPK;
        }
    }

    public long getSendStreamId() {
        return this._sendStreamId.get();
    }

    public void setSendStreamId(long id) {
        if (!this._sendStreamId.compareAndSet(0L, id)) {
            throw new IllegalStateException("Send stream ID already set [" + this._sendStreamId + ", " + id + "]");
        }
    }

    public long getReceiveStreamId() {
        return this._receiveStreamId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveStreamId(long id) {
        if (!this._receiveStreamId.compareAndSet(0L, id)) {
            throw new IllegalStateException("Receive stream ID already set [" + this._receiveStreamId + ", " + id + "]");
        }
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    public long getLastSendTime() {
        return this._lastSendTime;
    }

    public long getLastSendId() {
        return this._lastSendId.get();
    }

    public void setLastSendId(long id) {
        this._lastSendId.set(id);
    }

    public ConnectionOptions getOptions() {
        return this._options;
    }

    public void setOptions(ConnectionOptions opts) {
        this._options = opts;
    }

    public ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public I2PSocketFull getSocket() {
        return this._socket;
    }

    public void setSocket(I2PSocketFull socket) {
        this._socket = socket;
    }

    public int getPort() {
        return this._remotePort;
    }

    public int getLocalPort() {
        return this._localPort;
    }

    public String getConnectionError() {
        return this._connectionError;
    }

    public void setConnectionError(String err) {
        this._connectionError = err;
    }

    public long getLifetime() {
        long cso = this._closeSentOn.get();
        if (cso <= 0L) {
            return this._context.clock().now() - this._createdOn;
        }
        return cso - this._createdOn;
    }

    public ConnectionPacketHandler getPacketHandler() {
        return this._handler;
    }

    public long getLifetimeBytesSent() {
        return this._lifetimeBytesSent.get();
    }

    public long getLifetimeBytesReceived() {
        return this._lifetimeBytesReceived.get();
    }

    public long getLifetimeDupMessagesSent() {
        return this._lifetimeDupMessageSent.get();
    }

    public long getLifetimeDupMessagesReceived() {
        return this._lifetimeDupMessageReceived.get();
    }

    public void incrementBytesSent(int bytes) {
        this._lifetimeBytesSent.addAndGet(bytes);
    }

    public void incrementDupMessagesSent(int msgs) {
        this._lifetimeDupMessageSent.addAndGet(msgs);
    }

    public void incrementBytesReceived(int bytes) {
        this._lifetimeBytesReceived.addAndGet(bytes);
    }

    public void incrementDupMessagesReceived(int msgs) {
        this._lifetimeDupMessageReceived.addAndGet(msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSendTime() {
        Object object = this._nextSendLock;
        synchronized (object) {
            return this._nextSendTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNextSendTime(long when) {
        Object object = this._nextSendLock;
        synchronized (object) {
            long max;
            if (this._nextSendTime >= 0L) {
                if (when < this._nextSendTime) {
                    this._nextSendTime = when;
                }
            } else {
                this._nextSendTime = when;
            }
            if (this._nextSendTime >= 0L && (max = this._context.clock().now() + (long)this._options.getSendAckDelay()) < this._nextSendTime) {
                this._nextSendTime = max;
            }
        }
    }

    public void setChoking(boolean on) {
        if (on != this._isChoking) {
            this._isChoking = on;
            if (this._log.shouldWarn()) {
                this._log.warn("Choking changed to " + on + " on " + this);
            }
            if (!on) {
                this._unchokesToSend.set(8);
            }
            this.ackImmediately();
        } else if (on) {
            this.ackImmediately();
        }
    }

    public void setChoked(boolean on) {
        if (on != this._isChoked) {
            this._isChoked = on;
            if (this._log.shouldWarn()) {
                this._log.warn("Choked changed to " + on + " on " + this);
            }
        }
        if (on) {
            this.congestionOccurred();
            this.getOptions().setWindowSize(1);
        }
    }

    public boolean isChoked() {
        return this._isChoked;
    }

    public long getAckedPackets() {
        return this._ackedPackets.get();
    }

    public long getCreatedOn() {
        return this._createdOn;
    }

    public long getCloseSentOn() {
        return this._closeSentOn.get();
    }

    public long getCloseReceivedOn() {
        return this._closeReceivedOn.get();
    }

    public void updateShareOpts() {
        if (this._closeSentOn.get() > 0L && !this._updatedShareOpts) {
            this._connectionManager.updateShareOpts(this);
            this._updatedShareOpts = true;
        }
    }

    public void incrementUnackedPacketsReceived() {
        this._unackedPacketsReceived.incrementAndGet();
    }

    public int getUnackedPacketsReceived() {
        return this._unackedPacketsReceived.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnackedPacketsSent() {
        Map<Long, PacketLocal> map = this._outboundPackets;
        synchronized (map) {
            return this._outboundPackets.size();
        }
    }

    public long getCongestionWindowEnd() {
        return this._congestionWindowEnd;
    }

    public void setCongestionWindowEnd(long endMsg) {
        this._congestionWindowEnd = endMsg;
    }

    public long getHighestAckedThrough() {
        return this._highestAckedThrough;
    }

    public long getLastActivityOn() {
        return this._lastSendTime > this._lastReceivedOn ? this._lastSendTime : this._lastReceivedOn;
    }

    public int getLastCongestionSeenAt() {
        return this._lastCongestionSeenAt;
    }

    private void congestionOccurred() {
        if (this._ackSinceCongestion.compareAndSet(true, false)) {
            this._lastCongestionSeenAt = this._options.getWindowSize();
            this._lastCongestionTime = this._context.clock().now();
            this._lastCongestionHighestUnacked = this._lastSendId.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packetReceived() {
        this._lastReceivedOn = this._context.clock().now();
        this.resetActivityTimer();
        Object object = this._connectLock;
        synchronized (object) {
            this._connectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForConnect() {
        long expiration = this._context.clock().now() + this._options.getConnectTimeout();
        while (true) {
            if (this._connected.get() && this._receiveStreamId.get() > 0L && this._sendStreamId.get() > 0L) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): Connected and we have stream IDs");
                }
                return;
            }
            if (this._connectionError != null) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): connection error found: " + this._connectionError);
                }
                return;
            }
            if (!this._connected.get()) {
                this._connectionError = "Connection failed";
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): not connected");
                }
                return;
            }
            long timeLeft = expiration - this._context.clock().now();
            if (timeLeft <= 0L && this._options.getConnectTimeout() > 0L) {
                if (this._connectionError == null) {
                    this._connectionError = "Connection timed out";
                    this.disconnect(false);
                }
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): timed out: " + this._connectionError);
                }
                return;
            }
            if (timeLeft > 120000L) {
                timeLeft = 120000L;
            } else if (this._options.getConnectTimeout() <= 0L) {
                timeLeft = 60000L;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("waitForConnect(): wait " + timeLeft);
            }
            try {
                Object object = this._connectLock;
                synchronized (object) {
                    this._connectLock.wait(timeLeft);
                }
            }
            catch (InterruptedException ie) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("waitForConnect(): InterruptedException");
                }
                this._connectionError = "InterruptedException";
                return;
            }
        }
    }

    private void resetActivityTimer() {
        long howLong = this._options.getInactivityTimeout();
        if (howLong <= 0L) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Resetting the inactivity timer, but its gone!", (Throwable)new Exception("where did it go?"));
            }
            return;
        }
        this._activityTimer.reschedule(howLong += (long)this._randomWait, false);
    }

    public MessageInputStream getInputStream() {
        return this._inputStream;
    }

    public MessageOutputStream getOutputStream() {
        return this._outputStream;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[Connection ");
        long id = this._receiveStreamId.get();
        if (id > 0L) {
            buf.append(Packet.toId(id));
        } else {
            buf.append("unknown");
        }
        buf.append('/');
        id = this._sendStreamId.get();
        if (id > 0L) {
            buf.append(Packet.toId(id));
        } else {
            buf.append("unknown");
        }
        if (this._isInbound) {
            buf.append(" from ");
        } else {
            buf.append(" to ");
        }
        if (this._remotePeer != null) {
            buf.append(this._remotePeer.calculateHash().toBase64().substring(0, 4));
        } else {
            buf.append("unknown");
        }
        buf.append(" up ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this._createdOn)));
        buf.append(" wsize: ").append(this._options.getWindowSize());
        buf.append(" cwin: ").append(this._congestionWindowEnd - this._highestAckedThrough);
        buf.append(" rtt: ").append(this._options.getRTT());
        buf.append(" rto: ").append(this._options.getRTO());
        buf.append(" unacked out: ").append(this._outboundPackets.size()).append(" ");
        buf.append("unacked in: ").append(this.getUnackedPacketsReceived());
        int missing = 0;
        long[] nacks = this._inputStream.getNacks();
        if (nacks != null) {
            missing = nacks.length;
            buf.append(" [").append(missing).append(" missing]");
        }
        if (this.getResetSent()) {
            buf.append(" reset sent ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getResetSentOn()))).append(" ago");
        }
        if (this.getResetReceived()) {
            buf.append(" reset rcvd ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getDisconnectScheduledOn()))).append(" ago");
        }
        if (this.getCloseSentOn() > 0L) {
            buf.append(" close sent ");
            long timeSinceClose = this._context.clock().now() - this.getCloseSentOn();
            buf.append(DataHelper.formatDuration((long)timeSinceClose));
            buf.append(" ago");
        }
        if (this.getCloseReceivedOn() > 0L) {
            buf.append(" close rcvd ").append(DataHelper.formatDuration((long)(this._context.clock().now() - this.getCloseReceivedOn()))).append(" ago");
        }
        buf.append(" sent: ").append(1L + this._lastSendId.get());
        buf.append(" rcvd: ").append(1L + this._inputStream.getHighestBlockId() - (long)missing);
        buf.append(" ackThru ").append(this._highestAckedThrough);
        buf.append(" maxWin ").append(this.getOptions().getMaxWindowSize());
        buf.append(" MTU ").append(this.getOptions().getMaxMessageSize());
        buf.append("]");
        return buf.toString();
    }

    private class ActivityTimer
    extends SimpleTimer2.TimedEvent {
        public ActivityTimer() {
            super(Connection.this._timer);
            this.setFuzz(5000);
        }

        public void timeReached() {
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Fire inactivity timer on " + Connection.this.toString());
            }
            if (!Connection.this._connected.get()) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but we are already closed");
                }
                return;
            }
            long left = this.getTimeLeft();
            if (left > 0L) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is time left (" + left + ")");
                }
                this.schedule(left);
                return;
            }
            if (Connection.this.getUnackedPacketsSent() > 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there are unacked packets");
                }
                return;
            }
            if (Connection.this._options.getInactivityTimeout() <= 0) {
                if (Connection.this._log.shouldLog(10)) {
                    Connection.this._log.debug("Inactivity timeout reached, but there is no timer...");
                }
                return;
            }
            if (Connection.this._log.shouldLog(10)) {
                Connection.this._log.debug("Inactivity timeout reached, with action=" + Connection.this._options.getInactivityAction());
            }
            switch (Connection.this._options.getInactivityAction()) {
                case 0: {
                    if (!Connection.this._log.shouldLog(30)) break;
                    Connection.this._log.warn("Inactivity timer expired, not doing anything");
                    break;
                }
                case 2: {
                    if (Connection.this._closeSentOn.get() <= 0L && Connection.this._closeReceivedOn.get() <= 0L) {
                        if (Connection.this._log.shouldLog(30)) {
                            Connection.this._log.warn("Sending some data due to inactivity");
                        }
                        Connection.this._receiver.send(null, 0, 0, true);
                        break;
                    }
                }
                default: {
                    if (Connection.this._log.shouldLog(30)) {
                        Connection.this._log.warn("Closing (inactivity) " + ((Object)((Object)this)).toString());
                    }
                    if (Connection.this._log.shouldLog(10)) {
                        StringBuilder buf = new StringBuilder(128);
                        buf.append("last sent was: ").append(Connection.this._context.clock().now() - Connection.this._lastSendTime);
                        buf.append("ms ago, last received was: ").append(Connection.this._context.clock().now() - Connection.this._lastReceivedOn);
                        buf.append("ms ago, inactivity timeout is: ").append(Connection.this._options.getInactivityTimeout());
                        Connection.this._log.debug(buf.toString());
                    }
                    IOException ioe = new IOException("Inactivity timeout");
                    Connection.this._inputStream.streamErrorOccurred(ioe);
                    Connection.this._outputStream.streamErrorOccurred(ioe);
                    Connection.this.disconnect(Connection.this._disconnectScheduledOn.get() > 0L);
                }
            }
        }

        public final long getTimeLeft() {
            if (Connection.this.getLastActivityOn() > 0L) {
                return Connection.this.getLastActivityOn() + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
            }
            return Connection.this._createdOn + (long)Connection.this._options.getInactivityTimeout() - Connection.this._context.clock().now();
        }
    }

    class ConEvent
    implements SimpleTimer.TimedEvent {
        public void timeReached() {
            Connection.this.eventOccurred();
        }

        public String toString() {
            return "event on " + Connection.this.toString();
        }
    }

    private class DisconnectEvent
    implements SimpleTimer.TimedEvent {
        public DisconnectEvent() {
            if (Connection.this._log.shouldLog(20)) {
                Connection.this._log.info("Connection disconnect timer initiated: 5 minutes to drop " + Connection.this.toString(), (Throwable)new Exception());
            }
        }

        public void timeReached() {
            Connection.this.disconnectComplete();
        }
    }

    class ResendPacketEvent
    extends SimpleTimer2.TimedEvent {
        private final PacketLocal _packet;
        private long _nextSend;

        public ResendPacketEvent(PacketLocal packet, long delay) {
            super(Connection.this._timer);
            this._packet = packet;
            this._nextSend = delay + Connection.this._context.clock().now();
            packet.setResendPacketEvent(this);
            this.schedule(delay);
        }

        public long getNextSendTime() {
            return this._nextSend;
        }

        public void timeReached() {
            this.retransmit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean retransmit() {
            if (this._packet.getAckTime() > 0) {
                return false;
            }
            if (Connection.this._resetSentOn.get() > 0L || Connection.this._resetReceived.get() || Connection.this._finalDisconnect.get()) {
                this._packet.cancelled();
                return false;
            }
            boolean resend = false;
            boolean isLowest = false;
            Map map = Connection.this._outboundPackets;
            synchronized (map) {
                if (this._packet.getSequenceNum() == Connection.this._highestAckedThrough + 1L || this._packet.getNumSends() > 1 || Connection.this._activeResends.get() < Math.max(3, (Connection.this._options.getWindowSize() + 1) / 2)) {
                    isLowest = true;
                }
                if (Connection.this._outboundPackets.containsKey(this._packet.getSequenceNum())) {
                    resend = true;
                }
            }
            if (resend && this._packet.getAckTime() <= 0) {
                boolean fastRetransmit;
                boolean bl = fastRetransmit = this._packet.getNACKs() >= 3 && this._packet.getNumSends() == 1;
                if (!isLowest && !fastRetransmit) {
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Delaying resend of " + this._packet + " with " + Connection.this._activeResends + " active resend, " + Connection.this._outboundPackets.size() + " unacked, window size = " + Connection.this._options.getWindowSize());
                    }
                    this.forceReschedule(1333L);
                    this._nextSend = 1333L + Connection.this._context.clock().now();
                    return false;
                }
                if (fastRetransmit) {
                    Connection.this._context.statManager().addRateData("stream.fastRetransmit", this._packet.getLifetime(), this._packet.getLifetime());
                }
                if (Connection.this._isChoking) {
                    this._packet.setOptionalDelay(61000);
                    this._packet.setFlag(64);
                } else if (Connection.this._unchokesToSend.decrementAndGet() > 0) {
                    this._packet.setOptionalDelay(0);
                    this._packet.setFlag(64);
                } else {
                    this._packet.setFlag(64, false);
                }
                this._packet.setResendDelay(Connection.this.getOptions().getResendDelay() / 1000);
                if (this._packet.getReceiveStreamId() <= 0L) {
                    this._packet.setReceiveStreamId(Connection.this._receiveStreamId.get());
                }
                if (this._packet.getSendStreamId() <= 0L) {
                    this._packet.setSendStreamId(Connection.this._sendStreamId.get());
                }
                int newWindowSize = Connection.this.getOptions().getWindowSize();
                if (Connection.this._isChoked) {
                    Connection.this.congestionOccurred();
                    Connection.this.getOptions().setWindowSize(1);
                } else if (Connection.this._ackSinceCongestion.get() && this._packet.getSequenceNum() > Connection.this._lastCongestionHighestUnacked) {
                    Connection.this.congestionOccurred();
                    Connection.this._context.statManager().addRateData("stream.con.windowSizeAtCongestion", (long)newWindowSize, this._packet.getLifetime());
                    if ((newWindowSize /= 2) <= 0) {
                        newWindowSize = 1;
                    }
                    Connection.this.getOptions().doubleRTO();
                    Connection.this.getOptions().setWindowSize(newWindowSize);
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Congestion, resending packet " + this._packet.getSequenceNum() + " (new windowSize " + newWindowSize + "/" + Connection.this.getOptions().getWindowSize() + ") for " + Connection.this.toString());
                    }
                    Connection.this.windowAdjusted();
                }
                int numSends = this._packet.getNumSends() + 1;
                if (numSends - 1 > Connection.this._options.getMaxResends()) {
                    if (Connection.this._log.shouldLog(10)) {
                        Connection.this._log.debug("Disconnecting, too many resends of " + this._packet);
                    }
                    this._packet.cancelled();
                    Connection.this.disconnect(false);
                } else if (numSends >= 3 && this._packet.isFlagSet(2) && this._packet.getPayloadSize() <= 0 && Connection.this._outboundPackets.size() <= 1 && Connection.this.getCloseReceivedOn() > 0L) {
                    if (Connection.this._log.shouldLog(20)) {
                        Connection.this._log.info("Too many CLOSE resends, disconnecting: " + Connection.this.toString());
                    }
                    this._packet.cancelled();
                    Connection.this.disconnect(true);
                } else {
                    long timeout;
                    long rto = Connection.this._options.getRTO();
                    if (rto < 100L) {
                        rto = 100L;
                    }
                    if ((timeout = rto << numSends - 1) > 45000L || timeout <= 0L) {
                        timeout = 45000L;
                    }
                    this._nextSend = timeout + Connection.this._context.clock().now();
                    if (Connection.this._outboundQueue.enqueue(this._packet)) {
                        if (numSends == 2) {
                            Connection.this._activeResends.incrementAndGet();
                        }
                        if (Connection.this._log.shouldLog(20)) {
                            Connection.this._log.info("Resent packet " + (fastRetransmit ? "(fast) " : "(timeout) ") + this._packet + " next resend in " + timeout + "ms activeResends: " + Connection.this._activeResends + " (wsize " + newWindowSize + " lifetime " + (Connection.this._context.clock().now() - this._packet.getCreatedOn()) + "ms)");
                        }
                        Connection.this._unackedPacketsReceived.set(0);
                        Connection.this._lastSendTime = Connection.this._context.clock().now();
                        Connection.this.resetActivityTimer();
                    }
                    this.forceReschedule(timeout);
                }
                if (this._packet.getAckTime() > 0 && this._packet.getNumSends() > 1) {
                    Connection.this._activeResends.decrementAndGet();
                    Map map2 = Connection.this._outboundPackets;
                    synchronized (map2) {
                        Connection.this._outboundPackets.notifyAll();
                    }
                }
                return true;
            }
            return false;
        }
    }
}

