/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Addresses;
import net.i2p.util.EepGet;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.RFC822Date;
import net.i2p.util.SSLEepGet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DNSOverHTTPS
implements EepGet.StatusListener {
    private final I2PAppContext ctx;
    private final Log _log;
    private final JSONParser parser;
    private final ByteArrayOutputStream baos;
    private SSLEepGet.SSLState state;
    private long fetchStart;
    private int gotDate;
    private static final Map<String, Result> v4Cache = new LHMCache<String, Result>(32);
    private static final Map<String, Result> v6Cache = new LHMCache<String, Result>(32);
    private static final List<String> v4urls = new ArrayList<String>(4);
    private static final List<String> v6urls = new ArrayList<String>(4);
    private static final ObjectCounter<String> fails = new ObjectCounter();
    private static final List<String> locals = Arrays.asList("localhost", "in-addr.arpa", "ip6.arpa", "home.arpa", "i2p", "onion", "i2p.arpa", "onion.arpa", "corp", "home", "internal", "intranet", "lan", "local", "private", "test", "example", "invalid", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z");
    private static final long TIMEOUT = 3000L;
    private static final int MAX_TTL = 86400;
    private static final int MAX_FAILS = 3;
    private static final int V4_CODE = 1;
    private static final int CNAME_CODE = 5;
    private static final int V6_CODE = 28;
    private static final int MAX_DATE_SETS = 2;
    private static final int DEFAULT_STRATUM = 8;

    public DNSOverHTTPS(I2PAppContext context) {
        this(context, null);
    }

    public DNSOverHTTPS(I2PAppContext context, SSLEepGet.SSLState sslState) {
        this.ctx = context;
        this._log = this.ctx.logManager().getLog(DNSOverHTTPS.class);
        this.state = sslState;
        this.baos = new ByteArrayOutputStream(512);
        this.parser = new JSONParser();
    }

    public String lookup(String host) {
        return this.lookup(host, Type.V4_ONLY);
    }

    public String lookup(String host, Type type) {
        String rv;
        if (Addresses.isIPAddress(host)) {
            return host;
        }
        if (host.startsWith("[")) {
            return host;
        }
        if ((host = host.toLowerCase(Locale.US)).indexOf(46) < 0) {
            return null;
        }
        for (String local : locals) {
            if (!host.equals(local) && (!host.endsWith(local) || host.charAt(host.length() - local.length() - 1) != '.')) continue;
            return null;
        }
        if (host.equals("dns.google.com")) {
            return "8.8.8.8";
        }
        if ((type == Type.V4_ONLY || type == Type.V4_PREFERRED) && (rv = DNSOverHTTPS.lookup(host, v4Cache)) != null) {
            return rv;
        }
        if (type != Type.V4_ONLY && (rv = DNSOverHTTPS.lookup(host, v6Cache)) != null) {
            return rv;
        }
        if (type == Type.V6_PREFERRED && (rv = DNSOverHTTPS.lookup(host, v4Cache)) != null) {
            return rv;
        }
        return this.query(host, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Map<String, Result> map = v4Cache;
        synchronized (map) {
            v4Cache.clear();
        }
        map = v6Cache;
        synchronized (map) {
            v6Cache.clear();
        }
        fails.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String lookup(String host, Map<String, Result> cache) {
        Map<String, Result> map = cache;
        synchronized (map) {
            Result r = cache.get(host);
            if (r != null) {
                if (r.expires >= System.currentTimeMillis()) {
                    return r.ip;
                }
                cache.remove(host);
            }
        }
        return null;
    }

    private String query(String host, Type type) {
        String rv;
        ArrayList<String> toQuery = new ArrayList<String>(type == Type.V6_ONLY ? v6urls : v4urls);
        Collections.shuffle(toQuery);
        if ((type == Type.V4_ONLY || type == Type.V4_PREFERRED) && (rv = this.query(host, false, toQuery)) != null) {
            return rv;
        }
        if (type != Type.V4_ONLY && (rv = this.query(host, true, toQuery)) != null) {
            return rv;
        }
        if (type == Type.V6_PREFERRED && (rv = this.query(host, false, toQuery)) != null) {
            return rv;
        }
        return null;
    }

    private String query(String host, boolean isv6, List<String> toQuery) {
        for (String url : toQuery) {
            if (fails.count(url) > 3) continue;
            int tcode = isv6 ? 28 : 1;
            String furl = url + "name=" + host + "&type=" + tcode;
            this.log("Fetching " + furl);
            this.baos.reset();
            SSLEepGet eepget = new SSLEepGet(this.ctx, this.baos, furl, this.state);
            if (this.ctx.isRouterContext()) {
                eepget.addStatusListener(this);
            } else {
                this.fetchStart = System.currentTimeMillis();
            }
            String rv = this.fetch(eepget, host, isv6);
            if (rv != null) {
                fails.clear(url);
                return rv;
            }
            if (this.state == null) {
                this.state = eepget.getSSLState();
            }
            fails.increment(url);
            this.log("No result from " + furl);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String fetch(SSLEepGet eepget, String host, boolean isv6) {
        if (eepget.fetch(3000L, 3000L, 3000L) && eepget.getStatusCode() == 200 && this.baos.size() > 0) {
            long end = System.currentTimeMillis();
            this.log("Got response in " + (end - this.fetchStart) + "ms");
            byte[] b = this.baos.toByteArray();
            try {
                String s = new String(b, "ISO-8859-1");
                JSONObject map = (JSONObject)this.parser.parse(s);
                if (map == null) {
                    this.log("No map");
                    return null;
                }
                Number status = (Number)map.get("Status");
                if (status == null || status.intValue() != 0) {
                    this.log("Bad status: " + status);
                    return null;
                }
                JSONArray list = (JSONArray)map.get("Answer");
                if (list == null || list.isEmpty()) {
                    this.log("No answer");
                    return null;
                }
                this.log(list.size() + " answers");
                String hostAnswer = host + '.';
                for (Object o : list) {
                    try {
                        Map<String, Result> cache;
                        String name;
                        JSONObject a = (JSONObject)o;
                        String data = (String)a.get("data");
                        if (data == null) {
                            this.log("no data");
                            continue;
                        }
                        Number typ = (Number)a.get("type");
                        if (typ == null || (name = (String)a.get("name")) == null) continue;
                        if (typ.intValue() == 5) {
                            this.log("CNAME is: " + data);
                            hostAnswer = data;
                            continue;
                        }
                        if (isv6) {
                            if (typ.intValue() != 28) {
                                this.log("type mismatch: " + typ);
                                continue;
                            }
                            if (!Addresses.isIPv6Address(data)) {
                                this.log("bad addr: " + data);
                                continue;
                            }
                        } else {
                            if (typ.intValue() != 1) {
                                this.log("type mismatch: " + typ);
                                continue;
                            }
                            if (!Addresses.isIPv4Address(data)) {
                                this.log("bad addr: " + data);
                                continue;
                            }
                        }
                        if (!hostAnswer.equals(name)) {
                            this.log("name mismatch: " + name);
                            continue;
                        }
                        Number ttl = (Number)a.get("TTL");
                        int ittl = ttl != null ? Math.min(ttl.intValue(), 86400) : 3600;
                        long expires = end + (long)ittl * 1000L;
                        Map<String, Result> map2 = cache = isv6 ? v6Cache : v4Cache;
                        synchronized (map2) {
                            cache.put(host, new Result(data, expires));
                        }
                        this.log("Got answer: " + name + ' ' + typ + ' ' + ttl + ' ' + data + " in " + (end - this.fetchStart) + "ms");
                        return data;
                    }
                    catch (Exception e) {
                        this.log("Fail parsing", e);
                    }
                }
            }
            catch (Exception e) {
                this.log("Fail parsing", e);
            }
            this.log("Bad response:\n" + new String(b));
        } else {
            this.log("Fail fetching");
        }
        return null;
    }

    @Override
    public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }

    @Override
    public void attempting(String url) {
        if (this.gotDate < 2) {
            this.fetchStart = System.currentTimeMillis();
        }
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
        if (this.gotDate < 2 && "Date".equals(key)) {
            long timeRcvd = System.currentTimeMillis();
            long serverTime = RFC822Date.parse822Date(val);
            if (serverTime > 0L) {
                long now = serverTime + 500L + (timeRcvd - this.fetchStart) / 2L;
                long offset = now - this.ctx.clock().now();
                if (this.ctx.clock().getUpdatedSuccessfully()) {
                    if (this.gotDate > 0) {
                        this.ctx.clock().setNow(now, 4);
                    } else {
                        this.ctx.clock().setNow(now, 5);
                    }
                    this.log("DNSOverHTTPS adjusting clock by " + DataHelper.formatDuration(Math.abs(offset)));
                } else {
                    this.ctx.clock().setNow(now, 5);
                    this.log("DNSOverHTTPS setting initial clock skew to " + DataHelper.formatDuration(Math.abs(offset)));
                }
                ++this.gotDate;
            }
        }
    }

    private void log(String msg) {
        this.log(msg, null);
    }

    private void log(String msg, Throwable t) {
        int level = t != null ? 30 : 20;
        this._log.log(level, msg, t);
    }

    public static void main(String[] args) {
        Type type = Type.V4_PREFERRED;
        boolean error = false;
        Getopt g = new Getopt("dnsoverhttps", args, "46fs");
        try {
            int c;
            block8: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 52: {
                        type = Type.V4_ONLY;
                        continue block8;
                    }
                    case 54: {
                        type = Type.V6_ONLY;
                        continue block8;
                    }
                    case 102: {
                        type = Type.V4_PREFERRED;
                        continue block8;
                    }
                    case 115: {
                        type = Type.V6_PREFERRED;
                        continue block8;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            DNSOverHTTPS.usage();
            System.exit(1);
        }
        String url = args[g.getOptind()];
        String result = new DNSOverHTTPS(I2PAppContext.getGlobalContext()).lookup(url, type);
        if (result != null) {
            System.out.println((Object)((Object)type) + " lookup for " + url + " is " + result);
        } else {
            System.err.println((Object)((Object)type) + " lookup failed for " + url);
        }
    }

    private static void usage() {
        System.err.println("DNSOverHTTPS [-fs46] hostname\n             [-f] (IPv4 preferred) (default)\n             [-s] (IPv6 preferred)\n             [-4] (IPv4 only)\n             [-6] (IPv6 only)");
    }

    static {
        v4urls.add("https://dns.google.com/resolve?edns_client_subnet=0.0.0.0/0&");
        v6urls.add("https://dns.google.com/resolve?edns_client_subnet=0.0.0.0/0&");
        v4urls.add("https://1.1.1.1/dns-query?ct=application/dns-json&");
        v4urls.add("https://1.0.0.1/dns-query?ct=application/dns-json&");
        v6urls.add("https://[2606:4700:4700::1111]/dns-query?ct=application/dns-json&");
        v6urls.add("https://[2606:4700:4700::1001]/dns-query?ct=application/dns-json&");
    }

    private static class Result {
        public final String ip;
        public final long expires;

        public Result(String i, long e) {
            this.ip = i;
            this.expires = e;
        }
    }

    public static enum Type {
        V4_ONLY,
        V6_ONLY,
        V4_PREFERRED,
        V6_PREFERRED;

    }
}

