/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.Blinding;
import net.i2p.crypto.ChaCha20;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Clock;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class EncryptedLeaseSet
extends LeaseSet2 {
    private byte[] _encryptedData;
    private LeaseSet2 _decryptedLS2;
    private Hash __calculatedHash;
    private SigningPrivateKey _alpha;
    private String _secret;
    private final Log _log = I2PAppContext.getGlobalContext().logManager().getLog(EncryptedLeaseSet.class);
    private static final int MIN_ENCRYPTED_SIZE = 24;
    private static final int MAX_ENCRYPTED_SIZE = 4096;
    private static final int SALT_LEN = 32;
    private static final byte[] CREDENTIAL = DataHelper.getASCII("credential");
    private static final byte[] SUBCREDENTIAL = DataHelper.getASCII("subcredential");
    private static final String ELS2L1K = "ELS2_L1K";
    private static final String ELS2L2K = "ELS2_L2K";

    public LeaseSet2 getDecryptedLeaseSet() {
        return this._decryptedLS2;
    }

    public void setSecret(String secret) {
        this._secret = secret;
    }

    @Override
    public int getType() {
        return this._signature != null ? 5 : 3;
    }

    @Override
    public int getLeaseCount() {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLeaseCount() : 0;
    }

    @Override
    public Lease getLease(int index) {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLease(index) : null;
    }

    @Override
    public List<PublicKey> getEncryptionKeys() {
        if (this._decryptedLS2 != null) {
            return this._decryptedLS2.getEncryptionKeys();
        }
        return super.getEncryptionKeys();
    }

    @Override
    public void setDestination(Destination dest) {
        SigningPublicKey spk;
        SigType type;
        if (this._signature != null && this._destination != null) {
            if (!dest.equals(this._destination)) {
                throw new IllegalStateException();
            }
        } else {
            this._destination = dest;
        }
        if ((type = (spk = dest.getSigningPublicKey()).getType()) != SigType.EdDSA_SHA512_Ed25519 && type != SigType.RedDSA_SHA512_Ed25519) {
            throw new IllegalArgumentException();
        }
        SigningPublicKey bpk = this.blind();
        if (this._signingKey == null) {
            this._signingKey = bpk;
        } else if (!this._signingKey.equals(bpk)) {
            throw new IllegalArgumentException("blinded pubkey mismatch:\nas received:   " + this._signingKey + "\nas calculated: " + bpk);
        }
    }

    private SigningPublicKey blind() {
        SigningPublicKey spk = this._destination.getSigningPublicKey();
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        this._alpha = this._published <= 0L ? Blinding.generateAlpha(ctx, this._destination.getSigningPublicKey(), this._secret) : Blinding.generateAlpha(ctx, this._destination.getSigningPublicKey(), this._secret, this._published);
        SigningPublicKey rv = Blinding.blind(spk, this._alpha);
        if (this._log.shouldDebug()) {
            this._log.debug("Blind:\norig:    " + spk + "\nalpha:   " + this._alpha + "\nblinded: " + rv);
        }
        return rv;
    }

    @Override
    protected SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this.readHeader(in);
        int encryptedSize = (int)DataHelper.readLong(in, 2);
        if (encryptedSize < 24 || encryptedSize > 4096) {
            throw new DataFormatException("bad LS size: " + encryptedSize);
        }
        this._encryptedData = new byte[encryptedSize];
        DataHelper.read(in, this._encryptedData);
        SigType type = this.isOffline() ? this._transientSigningPublicKey.getType() : this._signingKey.getType();
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    protected void writeBytesWithoutSig(OutputStream out) throws DataFormatException, IOException {
        if (this._signingKey == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        if (this._encryptedData == null) {
            super.writeHeader(out);
            this.writeBody(out);
        } else {
            this.writeHeader(out);
            DataHelper.writeLong(out, 2, this._encryptedData.length);
            out.write(this._encryptedData);
        }
    }

    @Override
    public boolean verifyOfflineSignature() {
        return this.verifyOfflineSignature(this._signingKey);
    }

    @Override
    protected void readHeader(InputStream in) throws DataFormatException, IOException {
        int stype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(stype);
        if (type == null) {
            throw new DataFormatException("unknown key type " + stype);
        }
        this._signingKey = new SigningPublicKey(type);
        this._signingKey.readBytes(in);
        this._published = DataHelper.readLong(in, 4) * 1000L;
        this._expires = this._published + DataHelper.readLong(in, 2) * 1000L;
        this._flags = (int)DataHelper.readLong(in, 2);
        if (this.isOffline()) {
            this.readOfflineBytes(in);
        }
    }

    @Override
    protected void writeHeader(OutputStream out) throws DataFormatException, IOException {
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._signingKey.writeBytes(out);
        if (this._published <= 0L) {
            this._published = Clock.getInstance().now();
        }
        DataHelper.writeLong(out, 4, this._published / 1000L);
        DataHelper.writeLong(out, 2, (this._expires - this._published) / 1000L);
        DataHelper.writeLong(out, 2, this._flags);
        if (this.isOffline()) {
            this.writeOfflineBytes(out);
        }
    }

    @Override
    protected void readOfflineBytes(InputStream in) throws DataFormatException, IOException {
        this._transientExpires = DataHelper.readLong(in, 4) * 1000L;
        int itype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(itype);
        if (type == null) {
            throw new DataFormatException("Unknown sig type " + itype);
        }
        this._transientSigningPublicKey = new SigningPublicKey(type);
        this._transientSigningPublicKey.readBytes(in);
        SigType stype = this._signingKey.getType();
        this._offlineSignature = new Signature(stype);
        this._offlineSignature.readBytes(in);
    }

    @Override
    protected void writeOfflineBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._transientSigningPublicKey == null || this._offlineSignature == null) {
            throw new DataFormatException("No offline key/sig");
        }
        DataHelper.writeLong(out, 4, this._transientExpires / 1000L);
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._transientSigningPublicKey.writeBytes(out);
        this._offlineSignature.writeBytes(out);
    }

    @Override
    public int size() {
        int rv = this._signingKey.length() + 12;
        rv = this._encryptedData != null ? (rv += this._encryptedData.length) : (rv += 99);
        if (this.isOffline()) {
            rv += 6 + this._transientSigningPublicKey.length() + this._offlineSignature.length();
        }
        return rv;
    }

    @Override
    public Hash getHash() {
        if (this.__calculatedHash == null) {
            if (this._signingKey == null) {
                throw new IllegalStateException();
            }
            int len = this._signingKey.length();
            byte[] b = new byte[2 + len];
            DataHelper.toLong(b, 0, 2, this._signingKey.getType().getCode());
            System.arraycopy(this._signingKey.getData(), 0, b, 2, len);
            this.__calculatedHash = SHA256Generator.getInstance().calculateHash(b);
        }
        return this.__calculatedHash;
    }

    @Override
    public void encrypt(SessionKey skey) {
        if (this._encryptedData != null) {
            throw new IllegalStateException("already encrypted");
        }
        if (this._signature == null) {
            throw new IllegalStateException("not signed");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int saveFlags = this._flags;
        this.setUnpublished();
        try {
            baos.write(3);
            super.writeHeader(baos);
            this.writeBody(baos);
            this._signature.writeBytes(baos);
        }
        catch (DataFormatException dfe) {
            throw new IllegalStateException("Error encrypting LS2", dfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error encrypting LS2", ioe);
        }
        finally {
            this._flags = saveFlags;
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] input = this.getHKDFInput(ctx);
        byte[] salt = new byte[32];
        ctx.random().nextBytes(salt);
        HKDF hkdf = new HKDF(ctx);
        byte[] key = new byte[32];
        byte[] iv = new byte[32];
        hkdf.calculate(salt, input, ELS2L2K, key, iv, 0);
        byte[] plaintext = baos.toByteArray();
        byte[] ciphertext = new byte[33 + plaintext.length];
        ciphertext[0] = 0;
        System.arraycopy(salt, 0, ciphertext, 1, 32);
        ChaCha20.encrypt(key, iv, plaintext, 0, ciphertext, 33, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: inner plaintext:\n" + HexDump.dump(plaintext));
            this._log.debug("Encrypt: inner ciphertext:\n" + HexDump.dump(ciphertext));
        }
        ctx.random().nextBytes(salt);
        hkdf.calculate(salt, input, ELS2L1K, key, iv, 0);
        plaintext = ciphertext;
        ciphertext = new byte[32 + plaintext.length];
        System.arraycopy(salt, 0, ciphertext, 0, 32);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: chacha20 key:\n" + HexDump.dump(key));
            this._log.debug("Encrypt: chacha20 IV:\n" + HexDump.dump(iv));
        }
        ChaCha20.encrypt(key, iv, plaintext, 0, ciphertext, 32, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Encrypt: outer ciphertext:\n" + HexDump.dump(ciphertext));
        }
        this._encryptedData = ciphertext;
    }

    private void decrypt() throws DataFormatException, IOException {
        LeaseSet2 innerLS2;
        ByteArrayInputStream bais;
        int type;
        boolean perClient;
        if (this._encryptedData == null) {
            throw new IllegalStateException("not encrypted");
        }
        if (this._decryptedLS2 != null) {
            return;
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] input = this.getHKDFInput(ctx);
        HKDF hkdf = new HKDF(ctx);
        byte[] key = new byte[32];
        byte[] iv = new byte[32];
        byte[] ciphertext = this._encryptedData;
        byte[] plaintext = new byte[ciphertext.length - 32];
        hkdf.calculate(ciphertext, input, ELS2L1K, key, iv, 0);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: chacha20 key:\n" + HexDump.dump(key));
            this._log.debug("Decrypt: chacha20 IV:\n" + HexDump.dump(iv));
        }
        ChaCha20.decrypt(key, iv, ciphertext, 32, plaintext, 0, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: outer ciphertext:\n" + HexDump.dump(ciphertext));
            this._log.debug("Decrypt: outer plaintext:\n" + HexDump.dump(plaintext));
        }
        boolean bl = perClient = (plaintext[0] & 1) != 0;
        if (perClient) {
            int authScheme = (plaintext[0] & 0xE) >> 1;
            throw new DataFormatException("Per client auth unsupported, scheme: " + authScheme);
        }
        ciphertext = plaintext;
        plaintext = new byte[ciphertext.length - 33];
        byte[] salt = new byte[32];
        System.arraycopy(ciphertext, 1, salt, 0, 32);
        hkdf.calculate(salt, input, ELS2L2K, key, iv, 0);
        ChaCha20.decrypt(key, iv, ciphertext, 33, plaintext, 0, plaintext.length);
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypt: inner plaintext:\n" + HexDump.dump(plaintext));
        }
        if ((type = (bais = new ByteArrayInputStream(plaintext)).read()) == 3) {
            innerLS2 = new LeaseSet2();
        } else if (type == 7) {
            innerLS2 = new MetaLeaseSet();
        } else {
            throw new DataFormatException("Unsupported LS type: " + type);
        }
        innerLS2.readBytes(bais);
        this._decryptedLS2 = innerLS2;
    }

    private byte[] getHKDFInput(I2PAppContext ctx) {
        byte[] subcredential = this.getSubcredential(ctx);
        byte[] rv = new byte[subcredential.length + 4];
        System.arraycopy(subcredential, 0, rv, 0, subcredential.length);
        DataHelper.toLong(rv, subcredential.length, 4, this._published / 1000L);
        return rv;
    }

    private byte[] getSubcredential(I2PAppContext ctx) {
        if (this._destination == null) {
            throw new IllegalStateException("no known destination to decrypt with");
        }
        SigningPublicKey destspk = this._destination.getSigningPublicKey();
        int spklen = destspk.length();
        byte[] in = new byte[spklen + 4];
        System.arraycopy(destspk.getData(), 0, in, 0, spklen);
        DataHelper.toLong(in, spklen, 2, destspk.getType().getCode());
        DataHelper.toLong(in, spklen + 2, 2, SigType.RedDSA_SHA512_Ed25519.getCode());
        byte[] credential = EncryptedLeaseSet.hash(ctx, CREDENTIAL, in);
        byte[] spk = this._signingKey.getData();
        byte[] tmp = new byte[credential.length + spk.length];
        System.arraycopy(credential, 0, tmp, 0, credential.length);
        System.arraycopy(spk, 0, tmp, credential.length, spk.length);
        return EncryptedLeaseSet.hash(ctx, SUBCREDENTIAL, tmp);
    }

    private static byte[] hash(I2PAppContext ctx, byte[] p, byte[] d) {
        byte[] data = new byte[p.length + d.length];
        System.arraycopy(p, 0, data, 0, p.length);
        System.arraycopy(d, 0, data, p.length, d.length);
        byte[] rv = new byte[32];
        ctx.sha().calculateHash(data, 0, data.length, rv, 0);
        return rv;
    }

    @Override
    public void sign(SigningPrivateKey key) throws DataFormatException {
        int saveFlags = this._flags;
        this.setUnpublished();
        super.sign(key);
        this._flags = saveFlags;
        if (this._log.shouldDebug()) {
            this._log.debug("Sign inner with key: " + (Object)((Object)key.getType()) + ' ' + key.toBase64());
            this._log.debug("Corresponding pubkey: " + key.toPublic());
            this._log.debug("Inner sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
        this.encrypt(null);
        SigningPrivateKey bkey = Blinding.blind(key, this._alpha);
        int len = this.size();
        ByteArrayOutputStream out = new ByteArrayOutputStream(1 + len);
        try {
            out.write(this.getType());
            this.writeBytesWithoutSig(out);
        }
        catch (IOException ioe) {
            throw new DataFormatException("Signature failed", ioe);
        }
        byte[] data = out.toByteArray();
        this._signature = DSAEngine.getInstance().sign(data, bkey);
        if (this._signature == null) {
            throw new DataFormatException("Signature failed with " + (Object)((Object)key.getType()) + " key");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sign outer with key: " + (Object)((Object)bkey.getType()) + ' ' + bkey.toBase64());
            this._log.debug("Corresponding pubkey: " + bkey.toPublic());
            this._log.debug("Outer sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
    }

    @Override
    public boolean verifySignature() {
        boolean rv;
        if (this._decryptedLS2 != null) {
            return this._decryptedLS2.verifySignature();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Sig verify outer with key: " + (Object)((Object)this._signingKey.getType()) + ' ' + this._signingKey.toBase64());
            this._log.debug("Outer sig: " + (Object)((Object)this._signature.getType()) + ' ' + this._signature.toBase64());
        }
        if (!super.verifySignature()) {
            this._log.warn("ELS2 outer sig verify fail");
            return false;
        }
        this._log.info("ELS2 outer sig verify success");
        if (this._destination == null) {
            this._log.warn("ELS2 no dest to decrypt with");
            return true;
        }
        try {
            this.decrypt();
        }
        catch (DataFormatException dfe) {
            this._log.warn("ELS2 decrypt fail", dfe);
            return false;
        }
        catch (IOException ioe) {
            this._log.warn("ELS2 decrypt fail", ioe);
            return false;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Decrypted inner LS2:\n" + this._decryptedLS2);
            this._log.debug("Sig verify inner with key: " + (Object)((Object)this._decryptedLS2.getDestination().getSigningPublicKey().getType()) + ' ' + this._decryptedLS2.getDestination().getSigningPublicKey().toBase64());
            this._log.debug("Inner sig: " + (Object)((Object)this._decryptedLS2.getSignature().getType()) + ' ' + this._decryptedLS2.getSignature().toBase64());
        }
        if (!(rv = this._decryptedLS2.verifySignature())) {
            this._log.warn("ELS2 inner sig verify fail");
        } else {
            this._log.info("ELS2 inner sig verify success");
        }
        return rv;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EncryptedLeaseSet)) {
            return false;
        }
        EncryptedLeaseSet ls = (EncryptedLeaseSet)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._signingKey, ls.getSigningKey());
    }

    @Override
    public int hashCode() {
        if (this._encryptionKey == null) {
            return 0;
        }
        return this._encryptionKey.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[EncryptedLeaseSet: ");
        if (this._signingKey != null) {
            buf.append("\n\tBlinded Key: ").append(this._signingKey);
            Hash h = this.getHash();
            buf.append("\n\tHash: ").append(h);
            buf.append("\n\tB32: ").append(h.toBase32());
        }
        if (this.isOffline()) {
            buf.append("\n\tTransient Key: ").append(this._transientSigningPublicKey);
            buf.append("\n\tTransient Expires: ").append(new Date(this._transientExpires));
            buf.append("\n\tOffline Signature: ").append(this._offlineSignature);
        }
        buf.append("\n\tUnpublished? ").append(this.isUnpublished());
        buf.append("\n\tLength: ").append(this._encryptedData.length);
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        buf.append("\n\tExpires: ").append(new Date(this._expires));
        if (this._decryptedLS2 != null) {
            buf.append("\n\tDecrypted LS:\n").append(this._decryptedLS2);
        } else if (this._destination != null) {
            buf.append("\n\tDestination: ").append(this._destination);
            buf.append("\n\tLeases: #").append(this.getLeaseCount());
            for (int i = 0; i < this.getLeaseCount(); ++i) {
                buf.append("\n\t\t").append(this.getLease(i));
            }
        } else {
            buf.append("\n\tNot decrypted");
        }
        buf.append("]");
        return buf.toString();
    }
}

