/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.SHA1;
import net.i2p.crypto.SHA1Hash;
import net.i2p.crypto.SelfSignedGenerator;
import net.i2p.crypto.SigType;
import net.i2p.crypto.provider.I2PProvider;
import net.i2p.data.Base32;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public final class KeyStoreUtil {
    private static boolean _blacklistLogged;
    public static final String DEFAULT_KEYSTORE_PASSWORD = "changeit";
    private static final String DEFAULT_KEY_ALGORITHM = "RSA";
    private static final int DEFAULT_KEY_SIZE = 2048;
    private static final String DEFAULT_CA_KEY_ALGORITHM = "EC";
    private static final int DEFAULT_CA_KEY_SIZE = 256;
    private static final int DEFAULT_KEY_VALID_DAYS = 3652;
    private static final String[] BLACKLIST_SHA1;
    private static final Set<SHA1Hash> _blacklist;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore createKeyStore(File ksFile, String password) throws GeneralSecurityException, IOException {
        boolean exists = ksFile != null && ksFile.exists();
        char[] pwchars = password != null ? password.toCharArray() : null;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (exists) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(ksFile);
                ks.load(fis, pwchars);
            }
            finally {
                if (fis != null) {
                    try {
                        ((InputStream)fis).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (ksFile != null && !exists) {
            OutputStream fos = null;
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                fos = new SecureFileOutputStream(ksFile);
                ks.store(fos, pwchars);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return ks;
    }

    public static KeyStore loadSystemKeyStore() {
        KeyStore ks;
        try {
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Key Store init error", gse);
            return null;
        }
        boolean success = false;
        String override = System.getProperty("javax.net.ssl.keyStore");
        if (override != null) {
            success = KeyStoreUtil.loadCerts(new File(override), ks);
        }
        if (!success) {
            if (SystemVersion.isAndroid()) {
                if (SystemVersion.getAndroidVersion() >= 14) {
                    try {
                        ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
                        success = KeyStoreUtil.addCerts(new File(System.getProperty("java.home"), "etc/security/cacerts"), ks) > 0;
                    }
                    catch (IOException iOException) {
                    }
                    catch (GeneralSecurityException generalSecurityException) {}
                } else {
                    success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "etc/security/cacerts.bks"), ks);
                }
            } else {
                success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/jssecacerts"), ks);
                if (!success) {
                    success = KeyStoreUtil.loadCerts(new File(System.getProperty("java.home"), "lib/security/cacerts"), ks);
                }
            }
        }
        if (success) {
            KeyStoreUtil.removeBlacklistedCerts(ks);
        } else {
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            KeyStoreUtil.error("All key store loads failed, will only load local certificates", null);
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean loadCerts(File file, KeyStore ks) {
        if (!file.exists()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ks.load(fis, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            KeyStoreUtil.info("Certs loaded from " + file);
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), gse);
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("KeyStore load error, no default keys: " + file.getAbsolutePath(), ioe);
            try {
                ks.load(null, DEFAULT_KEYSTORE_PASSWORD.toCharArray());
            }
            catch (IOException iOException) {
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    public static int countCerts(KeyStore ks) {
        int count = 0;
        try {
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias)) continue;
                ++count;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean logCertExpiration(File f, String ksPW, long expiresWithin) {
        String location = f.getAbsolutePath();
        InputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(f);
            ks.load(fis, ksPW.toCharArray());
            boolean bl = KeyStoreUtil.logCertExpiration(ks, location, expiresWithin);
            return bl;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Unable to check certificates in key store " + location, ioe);
            boolean bl = false;
            return bl;
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Unable to check certificates in key store " + location, gse);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean logCertExpiration(KeyStore ks, String location, long expiresWithin) {
        boolean rv = true;
        try {
            int count = 0;
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Certificate[] cs;
                String alias = e.nextElement();
                if (!ks.isKeyEntry(alias)) continue;
                try {
                    cs = ks.getCertificateChain(alias);
                }
                catch (KeyStoreException kse) {
                    KeyStoreUtil.error("Unable to check certificates for \"" + alias + "\" in key store " + location, kse);
                    rv = false;
                    continue;
                }
                for (Certificate c : cs) {
                    String subj;
                    if (c == null || !(c instanceof X509Certificate)) continue;
                    ++count;
                    X509Certificate cert = (X509Certificate)c;
                    try {
                        cert.checkValidity();
                        long expiresIn = cert.getNotAfter().getTime() - System.currentTimeMillis();
                        if (expiresIn >= expiresWithin) continue;
                        Log l = I2PAppContext.getGlobalContext().logManager().getLog(KeyStoreUtil.class);
                        String subj2 = cert.getIssuerX500Principal().toString();
                        l.logAlways(30, "Certificate \"" + subj2 + "\" in key store " + location + " will expire in " + DataHelper.formatDuration2(expiresIn).replace("&nbsp;", " ") + "\nYou should renew the certificate soon.\nFor a local self-signed certificate, you may delete the keystore and restart, or ask for help on how to renew.");
                    }
                    catch (CertificateExpiredException cee) {
                        subj = cert.getIssuerX500Principal().toString();
                        KeyStoreUtil.error("Expired certificate \"" + subj + "\" in key store " + location + "\nYou must renew the certificate.\nFor a local self-signed certificate, you may simply delete the keystore and restart,\nor ask for help on how to renew.", null);
                        rv = false;
                    }
                    catch (CertificateNotYetValidException cnyve) {
                        subj = cert.getIssuerX500Principal().toString();
                        KeyStoreUtil.error("Not yet valid certificate \"" + subj + "\" in key store " + location, null);
                        rv = false;
                    }
                }
            }
            if (count == 0) {
                KeyStoreUtil.error("No certificates found in key store " + location, null);
            }
        }
        catch (GeneralSecurityException e) {
            KeyStoreUtil.error("Unable to check certificates in key store " + location, e);
            rv = false;
        }
        return rv;
    }

    private static synchronized int removeBlacklistedCerts(KeyStore ks) {
        if (SystemVersion.isAndroid()) {
            return 0;
        }
        ArrayList<String> toRemove = new ArrayList<String>(4);
        try {
            MessageDigest md = SHA1.getInstance();
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                Certificate c;
                String alias = e.nextElement();
                if (!ks.isCertificateEntry(alias) || (c = ks.getCertificate(alias)) == null || !(c instanceof X509Certificate)) continue;
                byte[] enc = c.getEncoded();
                if (enc != null) {
                    byte[] h = md.digest(enc);
                    if (!_blacklist.contains(new SHA1Hash(h))) continue;
                    toRemove.add(alias);
                    if (_blacklistLogged) continue;
                    X509Certificate xc = (X509Certificate)c;
                    BigInteger serial = xc.getSerialNumber();
                    String cn = CertUtil.getIssuerValue(xc, "CN");
                    String ou = CertUtil.getIssuerValue(xc, "OU");
                    KeyStoreUtil.warn("Ignoring blacklisted certificate \"" + alias + "\" CN: \"" + cn + "\" OU: \"" + ou + "\" s/n: " + serial.toString(16), null);
                    continue;
                }
                KeyStoreUtil.info("null encoding!!!");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        if (!toRemove.isEmpty()) {
            _blacklistLogged = true;
            for (String alias : toRemove) {
                try {
                    ks.deleteEntry(alias);
                }
                catch (GeneralSecurityException generalSecurityException) {}
            }
        }
        return toRemove.size();
    }

    public static int addCerts(File dir, KeyStore ks) {
        File[] files;
        KeyStoreUtil.info("Looking for X509 Certificates in " + dir.getAbsolutePath());
        int added = 0;
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            CertStore cs = CertUtil.loadCRLs();
            for (int i = 0; i < files.length; ++i) {
                boolean success;
                File f = files[i];
                if (!f.isFile()) continue;
                String alias = f.getName().toLowerCase(Locale.US);
                if (alias.endsWith(".crt") || alias.endsWith(".pem") || alias.endsWith(".key") || alias.endsWith(".der") || alias.endsWith(".key") || alias.endsWith(".p7b") || alias.endsWith(".p7c") || alias.endsWith(".pfx") || alias.endsWith(".p12") || alias.endsWith(".cer")) {
                    alias = alias.substring(0, alias.length() - 4);
                }
                if (!(success = KeyStoreUtil.addCert(f, alias, ks, cs))) continue;
                ++added;
            }
        }
        return added;
    }

    public static boolean addCert(File file, String alias, KeyStore ks) {
        return KeyStoreUtil.addCert(file, alias, ks, null);
    }

    public static boolean addCert(File file, String alias, KeyStore ks, CertStore cs) {
        try {
            X509Certificate cert = CertUtil.loadCert(file);
            KeyStoreUtil.info("Read X509 Certificate from " + file.getAbsolutePath() + " Issuer: " + cert.getIssuerX500Principal() + " Serial: " + cert.getSerialNumber().toString(16) + "; Valid From: " + cert.getNotBefore() + " To: " + cert.getNotAfter());
            if (cs != null && CertUtil.isRevoked(cs, (Certificate)cert)) {
                KeyStoreUtil.error("Certificate is revoked: " + file, new Exception());
                return false;
            }
            ks.setCertificateEntry(alias, cert);
            KeyStoreUtil.info("Now trusting X509 Certificate, Issuer: " + cert.getIssuerX500Principal());
        }
        catch (CertificateExpiredException cee) {
            String s = "Rejecting expired X509 Certificate: " + file.getAbsolutePath();
            KeyStoreUtil.warn(s, cee);
            return false;
        }
        catch (CertificateNotYetValidException cnyve) {
            KeyStoreUtil.error("Rejecting X509 Certificate not yet valid: " + file.getAbsolutePath(), cnyve);
            return false;
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), gse);
            return false;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Error reading X509 Certificate: " + file.getAbsolutePath(), ioe);
            return false;
        }
        return true;
    }

    public static String randomString() {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        byte[] rand = new byte[30];
        ctx.random().nextBytes(rand);
        return Base32.encode(rand);
    }

    public static boolean createKeys(File ks, String alias, String cname, String ou, String keyPW) {
        boolean isCA = !cname.contains("@") && !cname.endsWith(".family.i2p.net") && SigType.ECDSA_SHA256_P256.isAvailable();
        String alg = isCA ? DEFAULT_CA_KEY_ALGORITHM : DEFAULT_KEY_ALGORITHM;
        int sz = isCA ? 256 : 2048;
        return KeyStoreUtil.createKeys(ks, DEFAULT_KEYSTORE_PASSWORD, alias, cname, null, ou, 3652, alg, sz, keyPW);
    }

    public static boolean createKeys(File ks, String alias, String cname, Set<String> altNames, String ou, String keyPW) {
        boolean isCA = !cname.contains("@") && !cname.endsWith(".family.i2p.net") && SigType.ECDSA_SHA256_P256.isAvailable();
        String alg = isCA ? DEFAULT_CA_KEY_ALGORITHM : DEFAULT_KEY_ALGORITHM;
        int sz = isCA ? 256 : 2048;
        return KeyStoreUtil.createKeys(ks, DEFAULT_KEYSTORE_PASSWORD, alias, cname, altNames, ou, 3652, alg, sz, keyPW);
    }

    public static boolean createKeys(File ks, String ksPW, String alias, String cname, String ou, int validDays, String keyAlg, int keySize, String keyPW) {
        return KeyStoreUtil.createKeys(ks, ksPW, alias, cname, null, ou, validDays, keyAlg, keySize, keyPW);
    }

    public static boolean createKeys(File ks, String ksPW, String alias, String cname, Set<String> altNames, String ou, int validDays, String keyAlg, int keySize, String keyPW) {
        boolean useKeytool = I2PAppContext.getGlobalContext().getBooleanProperty("crypto.useExternalKeytool");
        if (useKeytool) {
            if (altNames != null) {
                throw new IllegalArgumentException("can't do SAN in keytool");
            }
            return KeyStoreUtil.createKeysCLI(ks, ksPW, alias, cname, ou, validDays, keyAlg, keySize, keyPW);
        }
        try {
            KeyStoreUtil.createKeysAndCRL(ks, ksPW, alias, cname, altNames, ou, validDays, keyAlg, keySize, keyPW);
            return true;
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Create keys error", gse);
            return false;
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Create keys error", ioe);
            return false;
        }
    }

    public static Object[] createKeysAndCRL(File ks, String ksPW, String alias, String cname, String ou, int validDays, String keyAlg, int keySize, String keyPW) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.createKeysAndCRL(ks, ksPW, alias, cname, null, ou, validDays, keyAlg, keySize, keyPW);
    }

    public static Object[] createKeysAndCRL(File ks, String ksPW, String alias, String cname, Set<String> altNames, String ou, int validDays, String keyAlg, int keySize, String keyPW) throws GeneralSecurityException, IOException {
        String algoName = KeyStoreUtil.getSigAlg(keySize, keyAlg);
        SigType type = null;
        for (SigType t : EnumSet.allOf(SigType.class)) {
            if (!t.getAlgorithmName().equals(algoName)) continue;
            type = t;
            break;
        }
        if (type == null) {
            throw new GeneralSecurityException("Unsupported algorithm/size: " + keyAlg + '/' + keySize);
        }
        return KeyStoreUtil.createKeysAndCRL(ks, ksPW, alias, cname, altNames, ou, validDays, type, keyPW);
    }

    public static Object[] createKeysAndCRL(File ks, String ksPW, String alias, String cname, String ou, int validDays, SigType type, String keyPW) throws GeneralSecurityException, IOException {
        return KeyStoreUtil.createKeysAndCRL(ks, ksPW, alias, cname, null, ou, validDays, type, keyPW);
    }

    public static Object[] createKeysAndCRL(File ks, String ksPW, String alias, String cname, Set<String> altNames, String ou, int validDays, SigType type, String keyPW) throws GeneralSecurityException, IOException {
        SecureDirectory sdir;
        File dir = ks.getParentFile();
        if (dir != null && !dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdirs()) {
            throw new IOException("Can't create directory " + dir);
        }
        Object[] rv = SelfSignedGenerator.generate(cname, altNames, ou, "I2P", "I2P Anonymous Network", null, null, validDays, type);
        PrivateKey jpriv = (PrivateKey)rv[1];
        X509Certificate cert = (X509Certificate)rv[2];
        List<X509Certificate> certs = Collections.singletonList(cert);
        KeyStoreUtil.storePrivateKey(ks, ksPW, alias, keyPW, jpriv, certs);
        return rv;
    }

    private static boolean createKeysCLI(File ks, String ksPW, String alias, String cname, String ou, int validDays, String keyAlg, int keySize, String keyPW) {
        String[] args;
        boolean success;
        block17: {
            SecureDirectory sdir;
            if (ks.exists()) {
                try {
                    if (KeyStoreUtil.getCert(ks, ksPW, alias) != null) {
                        KeyStoreUtil.error("Not overwriting key " + alias + ", already exists in " + ks, null);
                        return false;
                    }
                    break block17;
                }
                catch (IOException e) {
                    KeyStoreUtil.error("Not overwriting key \"" + alias + "\", already exists in " + ks, e);
                    return false;
                }
                catch (GeneralSecurityException e) {
                    KeyStoreUtil.error("Not overwriting key \"" + alias + "\", already exists in " + ks, e);
                    return false;
                }
            }
            File dir = ks.getParentFile();
            if (dir != null && !dir.exists() && !((File)(sdir = new SecureDirectory(dir.getAbsolutePath()))).mkdir()) {
                KeyStoreUtil.error("Can't create directory " + dir, null);
                return false;
            }
        }
        String keytool = new File(System.getProperty("java.home"), "bin/keytool").getAbsolutePath();
        ArrayList<String> a = new ArrayList<String>(32);
        a.add(keytool);
        a.add("-genkey");
        a.add("-storetype");
        a.add(KeyStore.getDefaultType());
        a.add("-keystore");
        a.add(ks.getAbsolutePath());
        a.add("-storepass");
        a.add(ksPW);
        a.add("-alias");
        a.add(alias);
        a.add("-dname");
        a.add("CN=" + cname + ",OU=" + ou + ",O=I2P Anonymous Network,L=XX,ST=XX,C=XX");
        a.add("-validity");
        a.add(Integer.toString(validDays));
        a.add("-keyalg");
        a.add(keyAlg);
        a.add("-sigalg");
        a.add(KeyStoreUtil.getSigAlg(keySize, keyAlg));
        a.add("-keysize");
        a.add(Integer.toString(keySize));
        a.add("-keypass");
        a.add(keyPW);
        if (keyAlg.equals("Ed") || keyAlg.equals("EdDSA") || keyAlg.equals("ElGamal")) {
            File f = I2PAppContext.getGlobalContext().getBaseDir();
            f = new File(f, "lib");
            f = new File(f, "i2p.jar");
            a.add("-providerpath");
            a.add(f.getAbsolutePath());
            a.add("-providerclass");
            a.add("net.i2p.crypto.provider.I2PProvider");
        }
        if (success = new ShellCommand().executeSilentAndWaitTimed(args = a.toArray(new String[a.size()]), 240)) {
            success = ks.exists();
            if (success) {
                try {
                    boolean bl = success = KeyStoreUtil.getPrivateKey(ks, ksPW, alias, keyPW) != null;
                    if (!success) {
                        KeyStoreUtil.error("Key gen failed to get private key", null);
                    }
                }
                catch (IOException e) {
                    KeyStoreUtil.error("Key gen failed to get private key", e);
                    success = false;
                }
                catch (GeneralSecurityException e) {
                    KeyStoreUtil.error("Key gen failed to get private key", e);
                    success = false;
                }
            }
            if (!success) {
                KeyStoreUtil.error("Key gen failed for unknown reasons", null);
            }
        }
        if (success) {
            SecureFileOutputStream.setPerms(ks);
            KeyStoreUtil.info("Created self-signed certificate for " + cname + " in keystore: " + ks.getAbsolutePath());
        } else {
            StringBuilder buf = new StringBuilder(256);
            for (int i = 0; i < args.length; ++i) {
                buf.append('\"').append(args[i]).append("\" ");
            }
            KeyStoreUtil.error("Failed to generate keys using command line: " + buf, null);
        }
        return success;
    }

    private static String getSigAlg(int size, String keyalg) {
        if (keyalg.equals(DEFAULT_CA_KEY_ALGORITHM)) {
            keyalg = "ECDSA";
        } else if (keyalg.equals("Ed")) {
            keyalg = "EdDSA";
        }
        String hash = keyalg.equals("ECDSA") ? (size <= 256 ? "SHA256" : (size <= 384 ? "SHA384" : "SHA512")) : (keyalg.equals("EdDSA") ? "SHA512" : (size <= 1024 ? "SHA1" : (size <= 2048 ? "SHA256" : (size <= 3072 ? "SHA384" : "SHA512"))));
        return hash + "with" + keyalg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKey(File ks, String ksPW, String alias, String keyPW) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            char[] keypwchars = keyPW.toCharArray();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(alias, keypwchars);
            return privateKey;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportPrivateKey(File ks, String ksPW, String alias, String keyPW, OutputStream out) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            char[] keypwchars = keyPW.toCharArray();
            PrivateKey pk = (PrivateKey)keyStore.getKey(alias, keypwchars);
            if (pk == null) {
                throw new GeneralSecurityException("private key not found: " + alias);
            }
            Certificate[] certs = keyStore.getCertificateChain(alias);
            CertUtil.exportPrivateKey(pk, certs, out);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate renewPrivateKeyCertificate(File ks, String ksPW, String alias, String keyPW, int validDays) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        OutputStream fos = null;
        try {
            PrivateKey pk;
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            fis = null;
            char[] keypwchars = keyPW.toCharArray();
            if (alias == null) {
                Enumeration<String> e = keyStore.aliases();
                if (e.hasMoreElements()) {
                    alias = e.nextElement();
                }
                if (alias == null) {
                    throw new GeneralSecurityException("no private keys found");
                }
            }
            if ((pk = (PrivateKey)keyStore.getKey(alias, keypwchars)) == null) {
                throw new GeneralSecurityException("private key not found: " + alias);
            }
            Certificate[] certs = keyStore.getCertificateChain(alias);
            if (certs.length != 1) {
                throw new GeneralSecurityException("Bad cert chain length");
            }
            X509Certificate cert = (X509Certificate)certs[0];
            Object[] rv = SelfSignedGenerator.renew(cert, pk, validDays);
            cert = (X509Certificate)rv[2];
            certs[0] = cert;
            keyStore.setKeyEntry(alias, pk, keypwchars, certs);
            fos = new SecureFileOutputStream(ks);
            keyStore.store(fos, pwchars);
            X509Certificate x509Certificate = cert;
            return x509Certificate;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importPrivateKey(File ks, String ksPW, String alias, String keyPW, InputStream in) throws GeneralSecurityException, IOException {
        OutputStream fos = null;
        try {
            KeyStore keyStore = KeyStoreUtil.createKeyStore(ks, ksPW);
            PrivateKey pk = CertUtil.loadPrivateKey(in);
            List<X509Certificate> certs = CertUtil.loadCerts(in);
            if (alias == null) {
                alias = CertUtil.getSubjectValue(certs.get(0), "CN");
                if (alias == null) {
                    throw new GeneralSecurityException("no alias specified and no Subject CN in cert");
                }
                if (alias.endsWith(".family.i2p.net") && alias.length() > ".family.i2p.net".length()) {
                    alias = alias.substring(0, ".family.i2p.net".length());
                }
            }
            keyStore.setKeyEntry(alias, pk, keyPW.toCharArray(), certs.toArray(new Certificate[certs.size()]));
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            fos = new SecureFileOutputStream(ks);
            keyStore.store(fos, pwchars);
            String string = alias;
            return string;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePrivateKey(File ks, String ksPW, String alias, String keyPW, PrivateKey pk, List<X509Certificate> certs) throws GeneralSecurityException, IOException {
        OutputStream fos = null;
        try {
            KeyStore keyStore = KeyStoreUtil.createKeyStore(ks, ksPW);
            keyStore.setKeyEntry(alias, pk, keyPW.toCharArray(), certs.toArray(new Certificate[certs.size()]));
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            fos = new SecureFileOutputStream(ks);
            keyStore.store(fos, pwchars);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Certificate getCert(File ks, String ksPW, String alias) throws GeneralSecurityException, IOException {
        InputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            fis = new FileInputStream(ks);
            char[] pwchars = ksPW != null ? ksPW.toCharArray() : null;
            keyStore.load(fis, pwchars);
            Certificate certificate = keyStore.getCertificate(alias);
            return certificate;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean exportCert(File ks, String ksPW, String alias, File certFile) {
        Object fis = null;
        try {
            Certificate cert = KeyStoreUtil.getCert(ks, ksPW, alias);
            if (cert != null) {
                return CertUtil.saveCert(cert, certFile);
            }
        }
        catch (GeneralSecurityException gse) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", gse);
        }
        catch (IOException ioe) {
            KeyStoreUtil.error("Error saving ASCII SSL keys", ioe);
        }
        return false;
    }

    private static void info(String msg) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 20, msg, null);
    }

    private static void warn(String msg, Throwable t) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 30, msg, t);
    }

    private static void error(String msg, Throwable t) {
        KeyStoreUtil.log(I2PAppContext.getGlobalContext(), 40, msg, t);
    }

    private static void log(I2PAppContext ctx, int level, String msg, Throwable t) {
        if (level >= 30 && !ctx.isRouterContext()) {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace();
            }
        }
        Log l = ctx.logManager().getLog(KeyStoreUtil.class);
        l.log(level, msg, t);
    }

    static {
        I2PProvider.addProvider();
        BLACKLIST_SHA1 = new String[]{"8b:af:4c:9b:1d:f0:2a:92:f7:da:12:8e:b9:1b:ac:f4:98:60:4b:6f", "4f:99:aa:93:fb:2b:d1:37:26:a1:99:4a:ce:7f:f0:05:f2:93:5d:1e", "c8:64:48:48:69:d4:1d:2b:0d:32:31:9c:5a:62:f9:31:5a:af:2c:bd", "98:a0:4e:41:63:35:77:90:c4:a7:9e:6d:71:3f:f0:af:51:fe:69:27", "02:c2:d9:31:06:2d:7b:1d:c2:a5:c7:f5:f0:68:50:64:08:1f:b2:21", "a1:db:63:93:91:6f:17:e4:18:55:09:40:04:15:c7:02:40:b0:ae:6b", "74:2c:31:92:e6:07:e4:24:eb:45:49:54:2b:e1:bb:c5:3e:61:74:e2", "58:11:9f:0e:12:82:87:ea:50:fd:d9:87:45:6f:4f:78:dc:fa:d6:d4"};
        _blacklist = new HashSet<SHA1Hash>(16);
        for (int i = 0; i < BLACKLIST_SHA1.length; ++i) {
            String s = BLACKLIST_SHA1[i].replace(":", "");
            BigInteger bi = new BigInteger(s, 16);
            byte[] b = bi.toByteArray();
            if (b.length == 21) {
                byte[] b2 = new byte[20];
                System.arraycopy(b, 1, b2, 0, 20);
                b = b2;
            }
            SHA1Hash h = new SHA1Hash(b);
            _blacklist.add(h);
        }
    }
}

