/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import net.i2p.I2PAppContext;
import net.i2p.crypto.HKDF;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.eddsa.EdDSABlinding;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;

public final class Blinding {
    private static final SigType TYPE = SigType.EdDSA_SHA512_Ed25519;
    private static final SigType TYPER = SigType.RedDSA_SHA512_Ed25519;
    private static final String INFO = "i2pblinding1";
    private static final byte[] INFO_ALPHA = DataHelper.getASCII("I2PGenerateAlpha");
    private static final String FORMAT = "yyyyMMdd";
    private static final int LENGTH = "yyyyMMdd".length();
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("yyyyMMdd", Locale.US);

    private Blinding() {
    }

    public static SigningPublicKey blind(SigningPublicKey key, SigningPrivateKey alpha) {
        SigType type = key.getType();
        if (type != TYPE && type != TYPER || alpha.getType() != TYPER) {
            throw new UnsupportedOperationException();
        }
        try {
            EdDSAPublicKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPublicKey bjk = EdDSABlinding.blind(jk, ajk);
            return SigUtil.fromJavaKey(bjk, TYPER);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey blind(SigningPrivateKey key, SigningPrivateKey alpha) {
        SigType type = key.getType();
        if (type != TYPE && type != TYPER || alpha.getType() != TYPER) {
            throw new UnsupportedOperationException();
        }
        try {
            EdDSAPrivateKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPrivateKey bjk = EdDSABlinding.blind(jk, ajk);
            return SigUtil.fromJavaKey(bjk, TYPER);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey unblind(SigningPrivateKey key, SigningPrivateKey alpha) {
        if (key.getType() != TYPER || alpha.getType() != TYPER) {
            throw new UnsupportedOperationException();
        }
        try {
            EdDSAPrivateKey bjk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey ajk = SigUtil.toJavaEdDSAKey(alpha);
            EdDSAPrivateKey jk = EdDSABlinding.unblind(bjk, ajk);
            return SigUtil.fromJavaKey(jk, TYPE);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey generateAlpha(I2PAppContext ctx, SigningPublicKey destspk, String secret) {
        long now = ctx.clock().now();
        return Blinding.generateAlpha(ctx, destspk, secret, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SigningPrivateKey generateAlpha(I2PAppContext ctx, SigningPublicKey destspk, String secret, long now) {
        byte[] data;
        String modVal;
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            modVal = _fmt.format(now);
        }
        if (modVal.length() != LENGTH) {
            throw new IllegalStateException();
        }
        byte[] mod = DataHelper.getASCII(modVal);
        if (secret != null && secret.length() > 0) {
            byte[] sb = DataHelper.getUTF8(secret);
            data = new byte[LENGTH + sb.length];
            System.arraycopy(mod, 0, data, 0, LENGTH);
            System.arraycopy(sb, 0, data, LENGTH, sb.length);
        } else {
            data = mod;
        }
        HKDF hkdf = new HKDF(ctx);
        byte[] out = new byte[64];
        int stoff = INFO_ALPHA.length + destspk.length();
        byte[] in = new byte[stoff + 4];
        System.arraycopy(INFO_ALPHA, 0, in, 0, INFO_ALPHA.length);
        System.arraycopy(destspk.getData(), 0, in, INFO_ALPHA.length, destspk.length());
        DataHelper.toLong(in, stoff, 2, destspk.getType().getCode());
        DataHelper.toLong(in, stoff + 2, 2, TYPER.getCode());
        Hash salt = ctx.sha().calculateHash(in);
        hkdf.calculate(salt.getData(), data, INFO, out, out, 32);
        byte[] b = EdDSABlinding.reduce(out);
        return new SigningPrivateKey(TYPER, b);
    }

    static {
        _fmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

