/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.apps.systray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientApp;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.ShellCommand;
import net.i2p.util.SystemVersion;

public class UrlLauncher
implements ClientApp {
    private final ShellCommand _shellCommand;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private final I2PAppContext _context;
    private final ClientAppManager _mgr;
    private final String[] _args;
    private final Log _log;
    private static final int WAIT_TIME = 5000;
    private static final int MAX_WAIT_TIME = 300000;
    private static final int MAX_TRIES = 99;
    private static final String REGISTERED_NAME = "UrlLauncher";
    private static final String PROP_BROWSER = "routerconsole.browser";
    private static final String[] BROWSERS = new String[]{"sensible-browser", "xdg-open", "x-www-browser", "defaultbrowser", "opera -newpage", "firefox", "chromium-browser", "mozilla", "netscape", "konqueror", "galeon", "www-browser", "links", "lynx"};

    public UrlLauncher(I2PAppContext context, ClientAppManager mgr, String[] args) {
        this._context = context;
        this._log = this._context.logManager().getLog(UrlLauncher.class);
        this._mgr = mgr;
        if (args == null || args.length <= 0) {
            args = new String[]{context.portMapper().getConsoleURL()};
        }
        this._args = args;
        this._shellCommand = new ShellCommand();
        this._state = ClientAppState.INITIALIZED;
    }

    public UrlLauncher() {
        this._context = I2PAppContext.getGlobalContext();
        this._log = this._context.logManager().getLog(UrlLauncher.class);
        this._mgr = null;
        this._args = null;
        this._shellCommand = new ShellCommand();
        this._state = ClientAppState.INITIALIZED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean waitForServer(String urlString) {
        InetSocketAddress sa;
        URI url;
        try {
            url = new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0) {
            port = "https".equals(url.getScheme()) ? 443 : 80;
        }
        try {
            sa = new InetSocketAddress(host, port);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        long done = System.currentTimeMillis() + 300000L;
        for (int i = 0; i < 99; ++i) {
            try {
                Socket test = null;
                try {
                    test = new Socket();
                    test.connect(sa, 5000);
                }
                finally {
                    if (test != null) {
                        try {
                            test.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException iOException) {
                if (System.currentTimeMillis() > done) break;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean openUrl(String url) throws IOException {
        if (this._log.shouldDebug()) {
            this._log.debug("Waiting for server");
        }
        UrlLauncher.waitForServer(url);
        if (this._log.shouldDebug()) {
            this._log.debug("Done waiting for server");
        }
        if (UrlLauncher.validateUrlFormat(url)) {
            cbrowser = this._context.getProperty("routerconsole.browser");
            if (cbrowser != null) {
                return this.openUrl(url, cbrowser);
            }
            if (SystemVersion.isMac()) {
                osName = System.getProperty("os.name");
                if (osName.toLowerCase(Locale.US).startsWith("mac os x")) {
                    args = new String[]{"open", url};
                    if (this._log.shouldDebug()) {
                        this._log.debug("Execute: " + Arrays.toString(args));
                    }
                    if (this._shellCommand.executeSilentAndWaitTimed((String[])args, 5)) {
                        return true;
                    }
                } else {
                    return false;
                }
                args = new String[]{"iexplore", url};
                if (this._log.shouldDebug()) {
                    this._log.debug("Execute: " + Arrays.toString(args));
                }
                if (this._shellCommand.executeSilentAndWaitTimed((String[])args, 5)) {
                    return true;
                }
            } else if (SystemVersion.isWindows()) {
                browserString = new String[]{"C:\\Program Files\\Internet Explorer\\iexplore.exe", "-nohome", url};
                foo = new File(this._context.getTempDir(), "browser" + this._context.random().nextLong() + ".reg");
                args = new String[]{"regedit", "/E", foo.getAbsolutePath(), "HKEY_CLASSES_ROOT\\http\\shell\\open\\command"};
                if (this._log.shouldDebug()) {
                    this._log.debug("Execute: " + Arrays.toString(args));
                }
                if (ok = this._shellCommand.executeSilentAndWait((String[])args)) {
                    bufferedReader = null;
                    try {
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(foo), "UTF-16"));
                        while ((line = bufferedReader.readLine()) != null) {
                            if (!line.startsWith("@=")) continue;
                            if (this._log.shouldDebug()) {
                                this._log.debug("From RegEdit: " + line);
                            }
                            if ((line = line.substring(2).trim()).startsWith("\"") && line.endsWith("\"")) {
                                line = line.substring(1, line.length() - 1);
                            }
                            line = line.replace("\\\\", "\\");
                            line = line.replace("\\\"", "\"");
                            if (this._log.shouldDebug()) {
                                this._log.debug("Mod RegEdit: " + line);
                            }
                            if ((aarg = UrlLauncher.parseArgs(line, url)).length <= 0) continue;
                            browserString = aarg;
                        }
                    }
                    catch (IOException e) {
                        if (!this._log.shouldWarn()) ** GOTO lbl66
                        this._log.warn("Reading regedit output", (Throwable)e);
                    }
                    finally {
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (IOException var8_12) {}
                        }
                        foo.delete();
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Regedit Failed: " + Arrays.toString(args));
                }
lbl66:
                // 7 sources

                if (this._log.shouldDebug()) {
                    this._log.debug("Execute: " + Arrays.toString(browserString));
                }
                if (this._shellCommand.executeSilentAndWaitTimed((String[])browserString, 5)) {
                    return true;
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Failed: " + Arrays.toString(browserString));
                }
            }
            args = new String[2];
            args[1] = url;
            for (i = 0; i < UrlLauncher.BROWSERS.length; ++i) {
                args[0] = UrlLauncher.BROWSERS[i];
                if (this._log.shouldDebug()) {
                    this._log.debug("Execute: " + Arrays.toString(args));
                }
                if (this._shellCommand.executeSilentAndWaitTimed((String[])args, 5)) {
                    return true;
                }
                if (!this._log.shouldInfo()) continue;
                this._log.info("Failed: " + Arrays.toString(args));
            }
        }
        return false;
    }

    public boolean openUrl(String url, String browser) throws IOException {
        Object[] args;
        UrlLauncher.waitForServer(url);
        if (UrlLauncher.validateUrlFormat(url) && (args = UrlLauncher.parseArgs(browser, url)).length > 0) {
            if (this._log.shouldDebug()) {
                this._log.debug("Execute: " + Arrays.toString(args));
            }
            if (this._shellCommand.executeSilentAndWaitTimed((String[])args, 5)) {
                return true;
            }
        }
        return false;
    }

    private static String[] parseArgs(String args, String url) {
        String str;
        ArrayList<String> argList = new ArrayList<String>(4);
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        block4: for (int j = 0; j < args.length(); ++j) {
            char c = args.charAt(j);
            switch (c) {
                case '\"': 
                case '\'': {
                    String str2;
                    if (isQuoted) {
                        str2 = buf.toString().trim();
                        if (str2.length() > 0) {
                            argList.add(str2);
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (isQuoted) {
                        buf.append(c);
                        continue block4;
                    }
                    String str2 = buf.toString().trim();
                    if (str2.length() > 0) {
                        argList.add(str2);
                    }
                    buf.setLength(0);
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.length() > 0 && (str = buf.toString().trim()).length() > 0) {
            argList.add(str);
        }
        if (argList.isEmpty()) {
            return new String[0];
        }
        boolean foundpct = false;
        for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            if (!arg.contains("%1")) continue;
            argList.set(i, arg.replace("%1", url));
            foundpct = true;
        }
        if (!foundpct) {
            argList.add(url);
        }
        return argList.toArray(new String[argList.size()]);
    }

    private static boolean validateUrlFormat(String urlString) {
        try {
            new URI(urlString);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public void startup() {
        String url = this._args[0];
        if (!UrlLauncher.validateUrlFormat(url)) {
            this.changeState(ClientAppState.START_FAILED, new MalformedURLException("Bad url: " + url));
            return;
        }
        this.changeState(ClientAppState.STARTING);
        I2PAppThread t = new I2PAppThread((Runnable)new Runner(), REGISTERED_NAME, true);
        t.start();
    }

    public ClientAppState getState() {
        return this._state;
    }

    public String getName() {
        return REGISTERED_NAME;
    }

    public String getDisplayName() {
        return "UrlLauncher \"" + this._args[0] + '\"';
    }

    private void changeState(ClientAppState state) {
        this.changeState(state, null);
    }

    private synchronized void changeState(ClientAppState state, Exception e) {
        this._state = state;
        if (this._mgr != null) {
            this._mgr.notify((ClientApp)this, state, null, e);
        }
    }

    public void shutdown(String[] args) {
        this.changeState(ClientAppState.STOPPED);
    }

    public static void main(String[] args) {
        UrlLauncher launcher = new UrlLauncher();
        try {
            if (args.length > 0) {
                launcher.openUrl(args[0]);
            } else {
                launcher.openUrl(I2PAppContext.getGlobalContext().portMapper().getConsoleURL());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            UrlLauncher.this.changeState(ClientAppState.RUNNING);
            try {
                String url = UrlLauncher.this._args[0];
                UrlLauncher.this.openUrl(url);
                UrlLauncher.this.changeState(ClientAppState.STOPPED);
            }
            catch (IOException e) {
                UrlLauncher.this.changeState(ClientAppState.CRASHED, e);
            }
        }
    }
}

