/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.router.RouterContext;
import net.i2p.router.web.LocaleWebAppHandler;
import net.i2p.router.web.RouterConsoleRunner;
import net.i2p.router.web.WebAppConfiguration;
import net.i2p.util.FileUtil;
import net.i2p.util.SecureDirectory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebAppStarter {
    private static final Map<String, Long> warModTimes = new ConcurrentHashMap<String, Long>();
    static final Map<String, String> INIT_PARAMS = new HashMap<String, String>(4);

    public static void startWebApp(RouterContext ctx, ContextHandlerCollection server, String appName, String warPath) throws Exception {
        SecureDirectory tmpdir = new SecureDirectory(ctx.getTempDir(), "jetty-work-" + appName + ctx.random().nextInt());
        WebAppContext wac = WebAppStarter.addWebApp(ctx, server, appName, warPath, tmpdir);
        LocaleWebAppHandler.setInitParams(wac, INIT_PARAMS);
        wac.setThrowUnavailableOnStartupException(true);
        wac.start();
        int port = ctx.portMapper().getPort("console", 7657);
        String host = ctx.portMapper().getActualHost("console", "127.0.0.1");
        ctx.portMapper().register(appName, host, port);
    }

    static WebAppContext addWebApp(RouterContext ctx, ContextHandlerCollection server, String appName, String warPath, File tmpdir) throws IOException {
        try {
            WebAppStarter.stopWebApp(ctx, appName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        long newmod = new File(warPath).lastModified();
        if (newmod <= 0L) {
            throw new IOException("Web app " + warPath + " does not exist");
        }
        Long oldmod = warModTimes.get(warPath);
        if (oldmod == null) {
            warModTimes.put(warPath, newmod);
        } else if (oldmod < newmod) {
            SecureDirectory warTmpDir = new SecureDirectory(ctx.getTempDir(), "war-copy-" + appName + ctx.random().nextInt());
            ((File)warTmpDir).mkdir();
            String tmpPath = new File(warTmpDir, appName + ".war").getAbsolutePath();
            if (!FileUtil.copy(warPath, tmpPath, true)) {
                throw new IOException("Web app failed copy from " + warPath + " to " + tmpPath);
            }
            warPath = tmpPath;
        }
        WebAppContext wac = new WebAppContext(warPath, "/" + appName);
        tmpdir.mkdir();
        wac.setTempDirectory(tmpdir);
        wac.setExtractWAR(false);
        RouterConsoleRunner.initialize(ctx, wac);
        WebAppStarter.setWebAppConfiguration(wac);
        server.addHandler((Handler)wac);
        server.mapContexts();
        return wac;
    }

    static void setWebAppConfiguration(WebAppContext wac) {
        String[] classNames = wac.getConfigurationClasses();
        if (classNames.length == 0) {
            classNames = wac.getDefaultConfigurationClasses();
        }
        String[] newClassNames = new String[classNames.length + 1];
        for (int j = 0; j < classNames.length; ++j) {
            newClassNames[j] = classNames[j];
            wac.prependServerClass("-" + classNames[j]);
        }
        newClassNames[classNames.length] = WebAppConfiguration.class.getName();
        wac.setConfigurationClasses(newClassNames);
    }

    public static void stopWebApp(RouterContext ctx, String appName) {
        ContextHandler wac = WebAppStarter.getWebApp(ctx, appName);
        if (wac == null) {
            return;
        }
        ctx.portMapper().unregister(appName);
        try {
            wac.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ContextHandlerCollection server = WebAppStarter.getConsoleServer(ctx);
        if (server == null) {
            return;
        }
        try {
            server.removeHandler((Handler)wac);
            server.mapContexts();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static boolean isWebAppRunning(I2PAppContext ctx, String appName) {
        ContextHandler wac = WebAppStarter.getWebApp(ctx, appName);
        if (wac == null) {
            return false;
        }
        return wac.isStarted();
    }

    static ContextHandler getWebApp(I2PAppContext ctx, String appName) {
        ContextHandlerCollection server = WebAppStarter.getConsoleServer(ctx);
        if (server == null) {
            return null;
        }
        Handler[] handlers = server.getHandlers();
        if (handlers == null) {
            return null;
        }
        String path = '/' + appName;
        for (int i = 0; i < handlers.length; ++i) {
            ContextHandler ch;
            if (!(handlers[i] instanceof ContextHandler) || !path.equals((ch = (ContextHandler)handlers[i]).getContextPath())) continue;
            return ch;
        }
        return null;
    }

    public static ContextHandlerCollection getConsoleServer(I2PAppContext ctx) {
        Server s = RouterConsoleRunner.getConsoleServer(ctx);
        if (s == null) {
            return null;
        }
        Handler h = s.getChildHandlerByClass(ContextHandlerCollection.class);
        if (h == null) {
            return null;
        }
        return (ContextHandlerCollection)h;
    }

    static {
        String pfx = "org.eclipse.jetty.servlet.Default.";
        INIT_PARAMS.put(pfx + "cacheControl", "max-age=86400");
        INIT_PARAMS.put(pfx + "dirAllowed", "false");
    }
}

