/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.router.web.App;

public class NavHelper {
    private static final Map<String, String> _apps = new ConcurrentHashMap<String, String>(4);
    private static final Map<String, String> _tooltips = new ConcurrentHashMap<String, String>(4);
    private static final Map<String, String> _icons = new ConcurrentHashMap<String, String>(4);
    private static final Map<String, byte[]> _binary = new ConcurrentHashMap<String, byte[]>(4);

    public static void registerApp(String name, String path, String tooltip, String iconpath) {
        _apps.put(name, path);
        if (tooltip != null) {
            _tooltips.put(name, tooltip);
        }
        if (iconpath != null && iconpath.startsWith("/")) {
            _icons.put(name, iconpath);
        }
    }

    public static void unregisterApp(String name) {
        _apps.remove(name);
        _tooltips.remove(name);
        _icons.remove(name);
    }

    public static byte[] getBinary(String name) {
        if (name != null) {
            return _binary.get(name);
        }
        return null;
    }

    public static void setBinary(String name, byte[] arr) {
        _binary.put(name, arr);
    }

    public static String getClientAppLinks(I2PAppContext ctx) {
        if (_apps.isEmpty()) {
            return "";
        }
        StringBuilder buf = new StringBuilder(256);
        ArrayList<String> l = new ArrayList<String>(_apps.keySet());
        Collections.sort(l);
        for (String name : l) {
            String path = _apps.get(name);
            if (path == null) continue;
            buf.append(" <a target=\"_blank\" href=\"").append(path).append("\" ");
            String tip = _tooltips.get(name);
            if (tip != null) {
                buf.append("title=\"").append(tip).append("\" ");
            }
            buf.append('>').append(name.replace(" ", "&nbsp;")).append("</a>");
        }
        return buf.toString();
    }

    public static List<App> getClientApps(I2PAppContext ctx) {
        if (_apps.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<App> rv = new ArrayList<App>(_apps.size());
        for (Map.Entry<String, String> e : _apps.entrySet()) {
            String name = e.getKey();
            String path = e.getValue();
            if (path == null) continue;
            String tip = _tooltips.get(name);
            if (tip == null) {
                tip = "";
            }
            String icon = _icons.containsKey(name) ? _icons.get(name) : (path.equals("/i2pbote/index.jsp") ? "/themes/console/images/email.png" : "/themes/console/images/plugin.png");
            App app = new App(name, tip, path, icon);
            rv.add(app);
        }
        return rv;
    }
}

