/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.i2p.router.RouterContext;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.NewsFetcher;
import net.i2p.router.update.UpdateHandler;
import net.i2p.router.web.ConfigUpdateHelper;
import net.i2p.update.Checker;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateTask;
import net.i2p.update.UpdateType;

class NewsHandler
extends UpdateHandler
implements Checker {
    private static final String BACKUP_NEWS_URL = "http://ivk5a6wfjar6hjucjmnbcea5inwmwg5b3hsv72x77xwyhbeaajja.b32.i2p/news/news.xml";
    private static final String BACKUP_NEWS_URL_SU3 = "http://ivk5a6wfjar6hjucjmnbcea5inwmwg5b3hsv72x77xwyhbeaajja.b32.i2p/news/news.su3";

    public NewsHandler(RouterContext ctx, ConsoleUpdateManager mgr) {
        super(ctx, mgr);
    }

    @Override
    public UpdateTask check(UpdateType type, UpdateMethod method, String id, String currentVersion, long maxTime) {
        if (type != UpdateType.ROUTER_SIGNED && type != UpdateType.NEWS && type != UpdateType.NEWS_SU3 || method != UpdateMethod.HTTP) {
            return null;
        }
        ArrayList<URI> updateSources = new ArrayList<URI>(2);
        try {
            updateSources.add(new URI(ConfigUpdateHelper.getNewsURL(this._context)));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            updateSources.add(new URI(BACKUP_NEWS_URL_SU3));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        NewsFetcher update = new NewsFetcher(this._context, this._mgr, updateSources);
        return update;
    }
}

