/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.update;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.app.ClientAppManager;
import net.i2p.crypto.CertUtil;
import net.i2p.crypto.SU3File;
import net.i2p.crypto.TrustedUpdate;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.Banlist;
import net.i2p.router.Blocklist;
import net.i2p.router.RouterContext;
import net.i2p.router.news.BlocklistEntries;
import net.i2p.router.news.CRLEntry;
import net.i2p.router.news.NewsEntry;
import net.i2p.router.news.NewsManager;
import net.i2p.router.news.NewsMetadata;
import net.i2p.router.news.NewsXMLParser;
import net.i2p.router.update.ConsoleUpdateManager;
import net.i2p.router.update.UpdateRunner;
import net.i2p.router.web.ConfigUpdateHandler;
import net.i2p.router.web.NewsHelper;
import net.i2p.update.UpdateMethod;
import net.i2p.update.UpdateType;
import net.i2p.util.Addresses;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.RFC822Date;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;
import net.i2p.util.VersionComparator;
import org.cybergarage.xml.Node;

class NewsFetcher
extends UpdateRunner {
    private String _lastModified;
    private long _newLastModified;
    private final File _newsFile;
    private final File _tempFile;
    private boolean _isNewer;
    private boolean _success;
    private static final String TEMP_NEWS_FILE = "news.xml.temp";
    static final String PROP_BLOCKLIST_TIME = "router.blocklistVersion";
    private static final String BLOCKLIST_DIR = "docs/feed/blocklist";
    private static final String BLOCKLIST_FILE = "blocklist.txt";
    private static final String VERSION_PREFIX = "<i2p.release ";
    private static final String VERSION_KEY = "version";
    private static final String MIN_VERSION_KEY = "minversion";
    private static final String MIN_JAVA_VERSION_KEY = "minjavaversion";
    private static final String SUD_KEY = "sudtorrent";
    private static final String SU2_KEY = "su2torrent";
    private static final String SU3_KEY = "su3torrent";
    private static final String CLEARNET_SUD_KEY = "sudclearnet";
    private static final String CLEARNET_SU2_KEY = "su2clearnet";
    private static final String CLEARNET_HTTP_SU3_KEY = "su3clearnet";
    private static final String CLEARNET_HTTPS_SU3_KEY = "su3ssl";
    private static final String I2P_SUD_KEY = "sudi2p";
    private static final String I2P_SU2_KEY = "su2i2p";

    public NewsFetcher(RouterContext ctx, ConsoleUpdateManager mgr, List<URI> uris) {
        super(ctx, mgr, UpdateType.NEWS, uris);
        this._newsFile = new File(ctx.getRouterDir(), "docs/news.xml");
        this._tempFile = new File(ctx.getTempDir(), "tmp-" + ctx.random().nextLong() + TEMP_NEWS_FILE);
        long lastMod = NewsHelper.lastUpdated(ctx);
        if (lastMod > 0L) {
            this._lastModified = RFC822Date.to822Date(lastMod);
        }
    }

    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.fetchNews();
        }
        catch (Throwable t) {
            this._mgr.notifyTaskFailed(this, "", t);
        }
        finally {
            this._mgr.notifyCheckComplete(this, this._isNewer, this._success);
            this._isRunning = false;
        }
    }

    public void fetchNews() {
        boolean shouldProxy = this._context.getProperty("router.fetchNewsThroughProxy", true);
        String proxyHost = this._context.getProperty("router.updateProxyHost", "127.0.0.1");
        int proxyPort = ConfigUpdateHandler.proxyPort(this._context);
        if (shouldProxy && proxyPort == 4444 && proxyHost.equals("127.0.0.1") && this._context.portMapper().getPort("HTTP") < 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Cannot fetch news - HTTP client tunnel not running");
            }
            return;
        }
        if (shouldProxy && this._context.commSystem().isDummy()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Cannot fetch news - VM Comm system");
            }
            return;
        }
        for (URI uri : this._urls) {
            this._currentURI = this.addLang(uri);
            String newsURL = this._currentURI.toString();
            if (this._tempFile.exists()) {
                this._tempFile.delete();
            }
            try {
                int status;
                long start;
                EepGet get = shouldProxy ? new EepGet(this._context, true, proxyHost, proxyPort, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified) : ("https".equals(uri.getScheme()) ? new SSLEepGet((I2PAppContext)this._context, this._tempFile.getAbsolutePath(), newsURL) : new EepGet(this._context, false, null, 0, 0, this._tempFile.getAbsolutePath(), newsURL, true, null, this._lastModified));
                get.addStatusListener(this);
                this._newLastModified = start = this._context.clock().now();
                if (!get.fetch() || (status = get.getStatusCode()) != 200 && status != 304) continue;
                HashMap<String, String> opts = new HashMap<String, String>(2);
                opts.put("routerconsole.newsLastChecked", Long.toString(start));
                if (status == 200 && this._isNewer) {
                    opts.put("routerconsole.newsLastUpdated", Long.toString(this._newLastModified));
                }
                this._context.router().saveConfig(opts, null);
                return;
            }
            catch (Throwable t) {
                this._log.error("Error fetching the news", t);
            }
        }
    }

    private URI addLang(URI uri) {
        if (!this._context.getBooleanPropertyDefaultTrue("routerconsole.newsTranslate")) {
            return uri;
        }
        String lang = Translate.getLanguage(this._context);
        if (lang.equals("en")) {
            return uri;
        }
        String query = uri.getRawQuery();
        if (query != null && (query.startsWith("lang=") || query.contains("&lang="))) {
            return uri;
        }
        String url = uri.toString();
        StringBuilder buf = new StringBuilder();
        buf.append(url);
        if (query != null) {
            buf.append("&lang=");
        } else {
            buf.append("?lang=");
        }
        buf.append(lang);
        String co = Translate.getCountry(this._context);
        if (co.length() > 0) {
            buf.append('_').append(co);
        }
        try {
            return new URI(buf.toString());
        }
        catch (URISyntaxException use) {
            return uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkForUpdates() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this._newsFile);
            StringBuilder buf = new StringBuilder(128);
            while (DataHelper.readLine((InputStream)in, buf)) {
                int index = buf.indexOf(VERSION_PREFIX);
                if (index >= 0) {
                    Map<String, String> args = NewsFetcher.parseArgs(buf.substring(index + VERSION_PREFIX.length()));
                    String ver = args.get(VERSION_KEY);
                    if (ver != null) {
                        String ourJava;
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Found version: [" + ver + "]");
                        }
                        if (!TrustedUpdate.needsUpdate("0.9.39", ver)) {
                            if (!this._log.shouldLog(10)) return;
                            this._log.debug("Our version is current");
                            return;
                        }
                        if (NewsHelper.isUpdateDisabled(this._context)) {
                            String msg = this._mgr._t("In-network updates disabled. Check package manager.");
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        if (NewsHelper.isBaseReadonly(this._context)) {
                            String msg = this._mgr._t("No write permission for I2P install directory.");
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        if (!FileUtil.isPack200Supported()) {
                            String msg = this._mgr._t("No Pack200 support in Java runtime.");
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        if (!ConfigUpdateHandler.USE_SU3_UPDATE) {
                            String msg = this._mgr._t("No update certificates installed.");
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        String minRouter = args.get(MIN_VERSION_KEY);
                        if (minRouter != null && VersionComparator.comp("0.9.39", minRouter) < 0) {
                            String msg = this._mgr._t("You must first update to version {0}", minRouter);
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        String minJava = args.get(MIN_JAVA_VERSION_KEY);
                        if (minJava != null && VersionComparator.comp(ourJava = System.getProperty("java.version"), minJava) < 0) {
                            String msg = this._mgr._t("Requires Java version {0} but installed Java version is {1}", minJava, ourJava);
                            this._log.logAlways(30, "Cannot update to version " + ver + ": " + msg);
                            this._mgr.notifyVersionConstraint(this, this._currentURI, UpdateType.ROUTER_SIGNED, "", ver, msg);
                            return;
                        }
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Our version is out of date, update!");
                        }
                        HashMap<UpdateMethod, List<URI>> sourceMap = new HashMap<UpdateMethod, List<URI>>(4);
                        sourceMap.put(UpdateMethod.HTTP, this._mgr.getUpdateURLs(UpdateType.ROUTER_SIGNED_SU3, "", UpdateMethod.HTTP));
                        this.addMethod(UpdateMethod.TORRENT, args.get(SU3_KEY), sourceMap);
                        this.addMethod(UpdateMethod.HTTP_CLEARNET, args.get(CLEARNET_HTTP_SU3_KEY), sourceMap);
                        this.addMethod(UpdateMethod.HTTPS_CLEARNET, args.get(CLEARNET_HTTPS_SU3_KEY), sourceMap);
                        this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.ROUTER_SIGNED_SU3, "", sourceMap, ver, "");
                        sourceMap.clear();
                        return;
                    }
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No version in " + buf.toString());
                    }
                } else if (this._log.shouldLog(10)) {
                    this._log.debug("No match in " + buf.toString());
                }
                buf.setLength(0);
            }
        }
        catch (IOException ioe) {
            if (!this._log.shouldLog(30)) return;
            this._log.warn("Error checking the news for an update", ioe);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!this._log.shouldLog(30)) return;
        this._log.warn("No version found in news.xml file");
    }

    private static Map<String, String> parseArgs(String args) {
        HashMap<String, String> rv = new HashMap<String, String>(8);
        char[] data = args.toCharArray();
        StringBuilder buf = new StringBuilder(32);
        boolean isQuoted = false;
        String key = null;
        block5: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case '\"': 
                case '\'': {
                    if (isQuoted) {
                        if (key != null) {
                            rv.put(key, buf.toString().trim());
                            key = null;
                        }
                        buf.setLength(0);
                    }
                    isQuoted = !isQuoted;
                    continue block5;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    if (key != null) {
                        rv.put(key, buf.toString().trim());
                        key = null;
                    }
                    buf.setLength(0);
                    continue block5;
                }
                case '=': {
                    if (isQuoted) {
                        buf.append(data[i]);
                        continue block5;
                    }
                    key = buf.toString().trim().toLowerCase(Locale.US);
                    buf.setLength(0);
                    continue block5;
                }
                default: {
                    buf.append(data[i]);
                }
            }
        }
        if (key != null) {
            rv.put(key, buf.toString().trim());
        }
        return rv;
    }

    private static List<URI> tokenize(String URLs) {
        StringTokenizer tok = new StringTokenizer(URLs, " ,\r\n");
        ArrayList<URI> rv = new ArrayList<URI>();
        while (tok.hasMoreTokens()) {
            try {
                rv.add(new URI(tok.nextToken().trim()));
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return rv;
    }

    private void addMethod(UpdateMethod method, String urls, Map<UpdateMethod, List<URI>> map) {
        List<URI> uris;
        if (urls != null && !(uris = NewsFetcher.tokenize(urls)).isEmpty()) {
            Collections.shuffle(uris, this._context.random());
            map.put(method, uris);
        }
    }

    @Override
    public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
    }

    @Override
    public void headerReceived(String url, int attemptNum, String key, String val) {
        long lm;
        if ("Last-Modified".equals(key) && (lm = RFC822Date.parse822Date(val)) > 0L && lm < this._newLastModified) {
            this._newLastModified = lm;
        }
    }

    @Override
    public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        if (this._log.shouldLog(20)) {
            this._log.info("News fetched from " + url + " with " + (alreadyTransferred + bytesTransferred));
        }
        if (this._tempFile.exists() && this._tempFile.length() > 0L) {
            File from;
            try {
                from = this.processSU3();
            }
            catch (IOException ioe) {
                this._log.error("Failed to extract the news file", ioe);
                this._tempFile.delete();
                return;
            }
            boolean copied = FileUtil.rename(from, this._newsFile);
            this._tempFile.delete();
            if (copied) {
                String newVer = Long.toString(this._newLastModified);
                this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.NEWS, "", UpdateMethod.HTTP, null, newVer, "");
                this._isNewer = true;
                this.checkForUpdates();
            } else if (this._log.shouldLog(40)) {
                this._log.error("Failed to copy the news file!");
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("Transfer complete, but no file? - probably 304 Not Modified");
        }
        this._success = true;
    }

    @Override
    public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File processSU3() throws IOException {
        SU3File su3 = new SU3File(this._context, this._tempFile);
        File to1 = new File(this._context.getTempDir(), "tmp-" + this._context.random().nextInt() + ".xml");
        File to2 = new File(this._context.getTempDir(), "tmp2-" + this._context.random().nextInt() + ".xml");
        try {
            List<CRLEntry> crlEntries;
            NewsManager nmgr;
            File xml;
            su3.verifyAndMigrate(to1);
            int type = su3.getFileType();
            if (su3.getContentType() != 4) {
                throw new IOException("bad content type: " + su3.getContentType());
            }
            if (type == 2) {
                File file = to1;
                return file;
            }
            if (type != 1 && type != 3) {
                throw new IOException("bad file type: " + type);
            }
            if (type == 3) {
                NewsFetcher.gunzip(to1, to2);
                xml = to2;
                to1.delete();
            } else {
                xml = to1;
            }
            NewsXMLParser parser = new NewsXMLParser(this._context);
            Node root = parser.parse(xml);
            xml.delete();
            NewsMetadata data = parser.getMetadata();
            List<NewsEntry> entries = parser.getEntries();
            ClientAppManager cmgr = this._context.clientAppManager();
            if (cmgr != null && (nmgr = (NewsManager)cmgr.getRegisteredApp("news")) != null) {
                nmgr.addEntries(entries);
                List<Node> nodes = NewsXMLParser.getNodes(root, "entry");
                nmgr.storeEntries(nodes);
            }
            if ((crlEntries = parser.getCRLEntries()) != null) {
                this.persistCRLEntries(crlEntries);
            } else {
                this._log.info("No CRL entries found in news feed");
            }
            BlocklistEntries ble = parser.getBlocklistEntries();
            if (ble != null && ble.isVerified()) {
                this.processBlocklistEntries(ble);
            } else {
                this._log.info("No blocklist entries found in news feed");
            }
            String sudVersion = su3.getVersionString();
            String signingKeyName = su3.getSignerString();
            File to3 = new File(this._context.getTempDir(), "tmp3-" + this._context.random().nextInt() + ".xml");
            this.outputOldNewsXML(data, entries, sudVersion, signingKeyName, to3);
            File file = to3;
            return file;
        }
        finally {
            to2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gunzip(File from, File to) throws IOException {
        ReusableGZIPInputStream in = ReusableGZIPInputStream.acquire();
        OutputStream out = null;
        try {
            in.initialize(new FileInputStream(from));
            out = new SecureFileOutputStream(to);
            DataHelper.copy(in, out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            ReusableGZIPInputStream.release(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCRLEntries(List<CRLEntry> entries) {
        SecureFile dir = new SecureFile(this._context.getConfigDir(), "certificates");
        if (!dir.exists() && !((File)dir).mkdir()) {
            this._log.error("Failed to create CRL directory " + dir);
            return;
        }
        if (!(dir = new SecureFile(dir, "revocations")).exists() && !((File)dir).mkdir()) {
            this._log.error("Failed to create CRL directory " + dir);
            return;
        }
        int i = 0;
        for (CRLEntry e : entries) {
            if (e.id == null || e.data == null) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Bad CRL entry received");
                continue;
            }
            byte[] bid = DataHelper.getUTF8(e.id);
            byte[] hash = new byte[32];
            this._context.sha().calculateHash(bid, 0, bid.length, hash, 0);
            String name = "crl-" + Base64.encode(hash) + ".crl";
            File f = new File(dir, name);
            if (f.exists() && f.lastModified() >= e.updated) continue;
            OutputStream out = null;
            try {
                byte[] data = DataHelper.getUTF8(e.data);
                CertUtil.loadCRL(new ByteArrayInputStream(data));
                out = new SecureFileOutputStream(f);
                out.write(data);
            }
            catch (GeneralSecurityException gse) {
                this._log.error("Bad CRL", gse);
            }
            catch (IOException ioe) {
                this._log.error("Failed to write CRL", ioe);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException gse) {}
                }
            }
            f.setLastModified(e.updated);
            ++i;
        }
        if (i > 0) {
            this._log.logAlways(30, "Stored " + i + " new CRL " + (i > 1 ? "entries" : "entry"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlocklistEntries(BlocklistEntries ble) {
        byte[] ip;
        Object h;
        byte[] b;
        long oldTime = this._context.getProperty(PROP_BLOCKLIST_TIME, 0L);
        if (ble.updated <= oldTime) {
            if (this._log.shouldWarn()) {
                this._log.warn("Not processing blocklist " + new Date(ble.updated) + ", already have " + new Date(oldTime));
            }
            return;
        }
        Blocklist bl = this._context.blocklist();
        Banlist ban = this._context.banlist();
        DateFormat fmt = DateFormat.getDateInstance(3);
        fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
        String reason = "Blocklist feed " + new Date(ble.updated);
        int banned = 0;
        Iterator<String> iter = ble.entries.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (s.length() == 44) {
                b = Base64.decode(s);
                if (b == null || b.length != 32) {
                    iter.remove();
                    continue;
                }
                h = Hash.create(b);
                if (!ban.isBanlistedForever((Hash)h)) {
                    ban.banlistRouterForever((Hash)h, reason);
                }
            } else {
                ip = Addresses.getIP(s);
                if (ip == null) {
                    iter.remove();
                    continue;
                }
                if (!bl.isBlocklisted(ip)) {
                    bl.add(ip);
                }
            }
            if (++banned < 2000) continue;
            break;
        }
        for (String s : ble.removes) {
            if (s.length() == 44) {
                b = Base64.decode(s);
                if (b == null || b.length != 32 || !ban.isBanlistedForever((Hash)(h = Hash.create(b)))) continue;
                ban.unbanlistRouter((Hash)h);
                continue;
            }
            ip = Addresses.getIP(s);
            if (ip == null || !bl.isBlocklisted(ip)) continue;
            bl.remove(ip);
        }
        File f = new SecureFile(this._context.getConfigDir(), BLOCKLIST_DIR);
        f.mkdirs();
        f = new File(f, BLOCKLIST_FILE);
        boolean fail = false;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(f), "UTF-8"));
            out.write("# ");
            out.write(ble.supdated);
            out.newLine();
            banned = 0;
            for (String s : ble.entries) {
                s = s.replace(':', ';');
                out.write(reason);
                out.write(58);
                out.write(s);
                out.newLine();
                if (++banned < 2000) continue;
                break;
            }
        }
        catch (IOException ioe) {
            this._log.error("Error writing blocklist", ioe);
            fail = true;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe) {}
            }
        }
        if (!fail) {
            f.setLastModified(ble.updated);
            String upd = Long.toString(ble.updated);
            this._context.router().saveConfig(PROP_BLOCKLIST_TIME, upd);
            this._mgr.notifyVersionAvailable(this, this._currentURI, UpdateType.BLOCKLIST, "", UpdateMethod.HTTP, null, upd, "");
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Processed " + ble.entries.size() + " blocks and " + ble.removes.size() + " unblocks from news feed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputOldNewsXML(NewsMetadata data, List<NewsEntry> entries, String sudVersion, String signingKeyName, File to) throws IOException {
        NewsMetadata.Release latestRelease = data.releases.get(0);
        Writer out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(to), "UTF-8"));
            out.write("<!--\n");
            out.write(VERSION_PREFIX);
            if (latestRelease.i2pVersion != null) {
                out.write(" version=\"" + latestRelease.i2pVersion + '\"');
            }
            if (latestRelease.minVersion != null) {
                out.write(" minVersion=\"" + latestRelease.minVersion + '\"');
            }
            if (latestRelease.minJavaVersion != null) {
                out.write(" minJavaVersion=\"" + latestRelease.minJavaVersion + '\"');
            }
            String su3Torrent = "";
            String su2Torrent = "";
            for (NewsMetadata.Update update : latestRelease.updates) {
                if (update.torrent == null) continue;
                if ("su3".equals(update.type)) {
                    su3Torrent = update.torrent;
                    continue;
                }
                if (!"su2".equals(update.type)) continue;
                su2Torrent = update.torrent;
            }
            if (!su2Torrent.isEmpty()) {
                out.write(" su2Torrent=\"" + su2Torrent + '\"');
            }
            if (!su3Torrent.isEmpty()) {
                out.write(" su3Torrent=\"" + su3Torrent + '\"');
            }
            out.write("/>\n");
            out.write("** News version:\t" + DataHelper.stripHTML(sudVersion) + '\n');
            out.write("** Signed by:\t" + signingKeyName + '\n');
            out.write("** Feed:\t" + DataHelper.stripHTML(data.feedTitle) + '\n');
            out.write("** Feed ID:\t" + DataHelper.stripHTML(data.feedID) + '\n');
            out.write("** Feed Date:\t" + new Date(data.feedUpdated) + '\n');
            out.write("-->\n");
            if (entries == null) {
                return;
            }
            DateFormat fmt = DateFormat.getDateInstance(3);
            fmt.setTimeZone(SystemVersion.getSystemTimeZone(this._context));
            for (NewsEntry e : entries) {
                if (e.title == null || e.content == null) continue;
                Date date = new Date(e.updated);
                out.write("<!-- Entry Date: " + date + " -->\n");
                out.write("<h3>");
                out.write(fmt.format(date));
                out.write(": ");
                out.write(e.title);
                out.write("</h3>\n");
                out.write(e.content);
                out.write("\n\n");
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

