/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.bencode;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.data.DataHelper;
import org.klomp.snark.bencode.BEValue;

public class BEncoder {
    public static byte[] bencode(Object o) throws IllegalArgumentException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(o, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Object o, OutputStream out) throws IOException, IllegalArgumentException {
        if (o == null) {
            throw new NullPointerException("Cannot bencode null");
        }
        if (o instanceof String) {
            BEncoder.bencode((String)o, out);
        } else if (o instanceof byte[]) {
            BEncoder.bencode((byte[])o, out);
        } else if (o instanceof Number) {
            BEncoder.bencode((Number)o, out);
        } else if (o instanceof List) {
            BEncoder.bencode((List)o, out);
        } else if (o instanceof Map) {
            BEncoder.bencode((Map)o, out);
        } else if (o instanceof BEValue) {
            BEncoder.bencode(((BEValue)o).getValue(), out);
        } else {
            throw new IllegalArgumentException("Cannot bencode: " + o.getClass());
        }
    }

    public static byte[] bencode(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(s, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(String s, OutputStream out) throws IOException {
        byte[] bs = s.getBytes("UTF-8");
        BEncoder.bencode(bs, out);
    }

    public static byte[] bencode(Number n) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(n, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Number n, OutputStream out) throws IOException {
        out.write(105);
        String s = n.toString();
        out.write(s.getBytes("UTF-8"));
        out.write(101);
    }

    public static byte[] bencode(List<?> l) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(l, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(List<?> l, OutputStream out) throws IOException {
        out.write(108);
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            BEncoder.bencode(it.next(), out);
        }
        out.write(101);
    }

    public static byte[] bencode(byte[] bs) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(bs, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(byte[] bs, OutputStream out) throws IOException {
        String l = Integer.toString(bs.length);
        out.write(l.getBytes("UTF-8"));
        out.write(58);
        out.write(bs);
    }

    public static byte[] bencode(Map<?, ?> m) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BEncoder.bencode(m, (OutputStream)baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe.toString());
        }
    }

    public static void bencode(Map<?, ?> m, OutputStream out) throws IOException, IllegalArgumentException {
        out.write(100);
        Set<?> s = m.keySet();
        ArrayList<String> l = null;
        ArrayList<byte[]> b = null;
        try {
            for (Object obj : s) {
                if (l != null) {
                    l.add((String)obj);
                    continue;
                }
                if (b != null) {
                    b.add((byte[])obj);
                    continue;
                }
                if (String.class.isAssignableFrom(obj.getClass())) {
                    l = new ArrayList<String>(s.size());
                    l.add((String)obj);
                    continue;
                }
                if (byte[].class.isAssignableFrom(obj.getClass())) {
                    b = new ArrayList<byte[]>(s.size());
                    b.add((byte[])obj);
                    continue;
                }
                throw new IllegalArgumentException("Cannot bencode map: contains key of type " + obj.getClass());
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Cannot bencode map: mixed keys", cce);
        }
        if (l != null) {
            Collections.sort(l);
            for (String string : l) {
                BEncoder.bencode(string, out);
                BEncoder.bencode(m.get(string), out);
            }
        } else if (b != null) {
            Collections.sort(b, new BAComparator());
            for (byte[] byArray : b) {
                BEncoder.bencode(byArray, out);
                BEncoder.bencode(m.get(byArray), out);
            }
        }
        out.write(101);
    }

    private static class BAComparator
    implements Comparator<byte[]>,
    Serializable {
        private BAComparator() {
        }

        @Override
        public int compare(byte[] l, byte[] r) {
            return DataHelper.compareTo(l, r);
        }
    }
}

