/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import net.i2p.data.ByteArray;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.TrivialPreprocessor;
import net.i2p.router.tunnel.TunnelGateway;

class BatchedPreprocessor
extends TrivialPreprocessor {
    private long _pendingSince;
    private final String _name;
    private static final boolean DEBUG = false;
    private static final int FULL_SIZE = 1003;
    static long DEFAULT_DELAY = 100L;
    private static final int FORCE_BATCH_FLUSH = 5;
    private static final int FULL_ENOUGH_SIZE = 802;

    public BatchedPreprocessor(RouterContext ctx, String name) {
        super(ctx);
        this._name = name;
    }

    protected long getSendDelay() {
        return DEFAULT_DELAY;
    }

    @Override
    public long getDelayAmount() {
        return this.getDelayAmount(true);
    }

    private long getDelayAmount(boolean shouldStat) {
        long rv = -1L;
        long defaultAmount = this.getSendDelay();
        if (this._pendingSince > 0L) {
            rv = this._pendingSince + defaultAmount - this._context.clock().now();
        }
        if (rv > defaultAmount) {
            rv = defaultAmount;
        }
        if (shouldStat) {
            this._context.statManager().addRateData("tunnel.batchDelayAmount", rv);
        }
        return rv;
    }

    @Override
    public boolean preprocessQueue(List<PendingGatewayMessage> pending, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        if (this._log.shouldLog(20)) {
            this.display(0L, pending, "Starting");
        }
        StringBuilder timingBuf = null;
        if (this._log.shouldLog(10)) {
            this._log.debug("Preprocess queue with " + pending.size() + " to send");
            timingBuf = new StringBuilder(128);
            timingBuf.append("Preprocess with " + pending.size() + " to send. ");
        }
        long start = System.currentTimeMillis();
        int batchCount = 0;
        int beforeLooping = pending.size();
        while (!pending.isEmpty()) {
            int allocated = 0;
            long beforePendingLoop = System.currentTimeMillis();
            for (int i = 0; i < pending.size(); ++i) {
                long pendingStart = System.currentTimeMillis();
                PendingGatewayMessage msg = pending.get(i);
                int instructionsSize = BatchedPreprocessor.getInstructionsSize(msg);
                instructionsSize += BatchedPreprocessor.getInstructionAugmentationSize(msg, allocated, instructionsSize);
                int curWanted = msg.getData().length - msg.getOffset() + instructionsSize;
                if (this._log.shouldLog(10)) {
                    this._log.debug("pending " + i + "/" + pending.size() + " (" + msg.getMessageId() + ") curWanted=" + curWanted + " instructionSize=" + instructionsSize + " allocated=" + allocated);
                }
                if ((allocated += curWanted) >= 1003) {
                    if (allocated - curWanted + instructionsSize >= 1003) {
                        msg = pending.get(--i);
                        allocated -= curWanted;
                        if (this._log.shouldLog(10)) {
                            this._log.debug("Pushback of " + curWanted + " (message " + (i + 1) + " in " + pending + ")");
                        }
                    }
                    if (this._pendingSince > 0L) {
                        long waited = this._context.clock().now() - this._pendingSince;
                        this._context.statManager().addRateData("tunnel.batchDelaySent", pending.size(), waited);
                    }
                    long beforeSend = System.currentTimeMillis();
                    this._pendingSince = 0L;
                    this.send(pending, 0, i, sender, rec);
                    this._context.statManager().addRateData("tunnel.batchFullFragments", 1L);
                    long afterSend = System.currentTimeMillis();
                    if (this._log.shouldLog(20)) {
                        this.display(allocated, pending, "Sent the message with " + (i + 1));
                    }
                    for (int j = 0; j < i; ++j) {
                        PendingGatewayMessage cur = pending.remove(0);
                        if (cur.getOffset() < cur.getData().length) {
                            throw new IllegalArgumentException("i=" + i + " j=" + j + " off=" + cur.getOffset() + " len=" + cur.getData().length + " alloc=" + allocated);
                        }
                        if (timingBuf != null) {
                            timingBuf.append(" sent " + cur);
                        }
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (msg.getOffset() >= msg.getData().length) {
                        PendingGatewayMessage cur = pending.remove(0);
                        if (timingBuf != null) {
                            timingBuf.append(" sent perfect fit " + cur).append(".");
                        }
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (i > 0) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", i + 1);
                    }
                    allocated = 0;
                    ++batchCount;
                    long pendingEnd = System.currentTimeMillis();
                    if (timingBuf == null) break;
                    timingBuf.append(" After sending " + (i + 1) + "/" + pending.size() + " in " + (afterSend - beforeSend) + " after " + (beforeSend - pendingStart) + " since " + (beforeSend - beforePendingLoop) + "/" + (beforeSend - start) + " pending current " + (pendingEnd - pendingStart)).append(".");
                    break;
                }
                if (timingBuf == null) continue;
                timingBuf.append(" After pending loop " + (System.currentTimeMillis() - beforePendingLoop)).append(".");
            }
            if (this._log.shouldLog(20)) {
                this.display(allocated, pending, "after looping to clear " + (beforeLooping - pending.size()));
            }
            long afterDisplayed = System.currentTimeMillis();
            if (allocated > 0) {
                if (pending.size() > 5 || this._pendingSince > 0L && this.getDelayAmount() <= 0L || allocated >= 802) {
                    PendingGatewayMessage cur;
                    if (pending.size() > 1) {
                        this._context.statManager().addRateData("tunnel.batchMultipleCount", pending.size());
                    }
                    this._context.statManager().addRateData("tunnel.batchDelaySent", pending.size(), 0L);
                    this.send(pending, 0, pending.size() - 1, sender, rec);
                    this._context.statManager().addRateData("tunnel.batchSmallFragments", 1003 - allocated);
                    int beforeSize = pending.size();
                    for (int i = 0; i < beforeSize && (cur = pending.get(0)).getOffset() >= cur.getData().length; ++i) {
                        pending.remove(0);
                        this._context.statManager().addRateData("tunnel.batchFragmentation", cur.getFragmentNumber() + 1);
                        this._context.statManager().addRateData("tunnel.writeDelay", cur.getLifetime(), cur.getData().length);
                    }
                    if (!pending.isEmpty()) {
                        this._pendingSince = this._context.clock().now();
                        this._context.statManager().addRateData("tunnel.batchFlushRemaining", pending.size(), beforeSize);
                        if (this._log.shouldLog(20)) {
                            this.display(allocated, pending, "flushed, some remain");
                        }
                        if (timingBuf != null) {
                            timingBuf.append(" flushed, some remain (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                            timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                            this._log.debug(timingBuf.toString());
                        }
                        return true;
                    }
                    long delayAmount = 0L;
                    if (this._pendingSince > 0L) {
                        delayAmount = this._context.clock().now() - this._pendingSince;
                        this._pendingSince = 0L;
                    }
                    if (batchCount > 1) {
                        this._context.statManager().addRateData("tunnel.batchCount", batchCount);
                    }
                    if (this._log.shouldLog(20)) {
                        this.display(allocated, pending, "flushed " + beforeSize + ", no remaining after " + delayAmount + "ms");
                    }
                    if (timingBuf != null) {
                        timingBuf.append(" flushed, none remain (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                        timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                        this._log.debug(timingBuf.toString());
                    }
                    return false;
                }
                this._context.statManager().addRateData("tunnel.batchDelay", pending.size());
                if (this._pendingSince <= 0L) {
                    this._pendingSince = this._context.clock().now();
                }
                if (batchCount > 1) {
                    this._context.statManager().addRateData("tunnel.batchCount", batchCount);
                }
                if (this._log.shouldLog(20)) {
                    this.display(allocated, pending, "dont flush");
                }
                if (timingBuf != null) {
                    timingBuf.append(" dont flush (displayed to now: " + (System.currentTimeMillis() - afterDisplayed) + ")");
                    timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
                    this._log.debug(timingBuf.toString());
                }
                return true;
            }
            if (timingBuf == null) continue;
            timingBuf.append(" Keep looping");
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Sent everything on the list (pending=" + pending.size() + ")");
        }
        if (timingBuf != null) {
            timingBuf.append(" total time: " + (System.currentTimeMillis() - start));
        }
        if (timingBuf != null) {
            this._log.debug(timingBuf.toString());
        }
        return false;
    }

    private void display(long allocated, List<PendingGatewayMessage> pending, String title) {
        if (this._log.shouldLog(20)) {
            long highestDelay = 0L;
            StringBuilder buf = new StringBuilder(128);
            buf.append(this._name).append(": ");
            buf.append(title);
            buf.append(" - allocated: ").append(allocated);
            buf.append(" pending: ").append(pending.size());
            if (this._pendingSince > 0L) {
                buf.append(" delay: ").append(this.getDelayAmount(false));
            }
            for (int i = 0; i < pending.size(); ++i) {
                PendingGatewayMessage curPending = pending.get(i);
                buf.append(" [").append(i).append("]:");
                buf.append(curPending.getOffset()).append('/').append(curPending.getData().length).append('/');
                buf.append(curPending.getLifetime());
                if (curPending.getLifetime() <= highestDelay) continue;
                highestDelay = curPending.getLifetime();
            }
            this._log.info(buf.toString());
        }
    }

    protected void send(List<PendingGatewayMessage> pending, int startAt, int sendThrough, TunnelGateway.Sender sender, TunnelGateway.Receiver rec) {
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending " + startAt + ":" + sendThrough + " out of " + pending);
        }
        byte[] preprocessed = ((ByteArray)_dataCache.acquire()).getData();
        int offset = 0;
        if ((offset = this.writeFragments(pending, startAt, sendThrough, preprocessed, offset)) <= 0) {
            StringBuilder buf = new StringBuilder(128);
            buf.append("uh? written offset is ").append(offset);
            buf.append(" for ").append(startAt).append(" through ").append(sendThrough);
            for (int i = startAt; i <= sendThrough; ++i) {
                buf.append(" ").append(pending.get(i).toString());
            }
            this._log.log(50, buf.toString());
            return;
        }
        try {
            this.preprocess(preprocessed, offset);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error preprocessing the messages (offset=" + offset + " start=" + startAt + " through=" + sendThrough + " pending=" + pending.size() + " preproc=" + preprocessed.length);
            }
            return;
        }
        long msgId = sender.sendPreprocessed(preprocessed, rec);
        if (this._log.shouldLog(10)) {
            this._log.debug("Sent " + startAt + ":" + sendThrough + " out of " + pending + " in message " + msgId);
        }
    }

    private int writeFragments(List<PendingGatewayMessage> pending, int startAt, int sendThrough, byte[] target, int offset) {
        for (int i = startAt; i <= sendThrough; ++i) {
            PendingGatewayMessage msg = pending.get(i);
            int prevOffset = offset;
            if (msg.getOffset() == 0) {
                offset = this.writeFirstFragment(msg, target, offset);
                if (!this._log.shouldLog(10)) continue;
                this._log.debug("writing " + msg.getMessageId() + " fragment 0, ending at " + offset + " prev " + prevOffset + " leaving " + (msg.getData().length - msg.getOffset()) + " bytes for later");
                continue;
            }
            offset = this.writeSubsequentFragment(msg, target, offset);
            if (!this._log.shouldLog(10)) continue;
            int frag = msg.getFragmentNumber();
            int later = msg.getData().length - msg.getOffset();
            if (later > 0) {
                --frag;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("writing " + msg.getMessageId() + " fragment " + frag + ", ending at " + offset + " prev " + prevOffset + " leaving " + later + " bytes for later");
        }
        return offset;
    }
}

