/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Arrays;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.SessionKey;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.TryCache;

class UDPPacket
implements CDQEntry {
    private RouterContext _context;
    private final DatagramPacket _packet;
    private volatile short _priority;
    private volatile long _initializeTime;
    private final byte[] _data = new byte[1572];
    private final byte[] _validateBuf;
    private final byte[] _ivBuf;
    private volatile int _markedType;
    private RemoteHostId _remoteHost;
    private boolean _released;
    private long _enqueueTime;
    private long _receivedTime;
    private int _validateCount;
    private FIFOBandwidthLimiter.Request _bandwidthRequest;
    private static final TryCache<UDPPacket> _packetCache;
    private static final TryCache.ObjectFactory<UDPPacket> _packetFactory;
    private static final boolean CACHE = true;
    private static final int MIN_CACHE_SIZE = 64;
    private static final int MAX_CACHE_SIZE = 256;
    static final int MAX_PACKET_SIZE = 1572;
    public static final int IV_SIZE = 16;
    public static final int MAC_SIZE = 16;
    public static final int PAYLOAD_TYPE_SESSION_REQUEST = 0;
    public static final int PAYLOAD_TYPE_SESSION_CREATED = 1;
    public static final int PAYLOAD_TYPE_SESSION_CONFIRMED = 2;
    public static final int PAYLOAD_TYPE_RELAY_REQUEST = 3;
    public static final int PAYLOAD_TYPE_RELAY_RESPONSE = 4;
    public static final int PAYLOAD_TYPE_RELAY_INTRO = 5;
    public static final int PAYLOAD_TYPE_DATA = 6;
    public static final int PAYLOAD_TYPE_TEST = 7;
    public static final int PAYLOAD_TYPE_SESSION_DESTROY = 8;
    public static final int MAX_PAYLOAD_TYPE = 8;
    public static final byte HEADER_FLAG_REKEY = 8;
    public static final byte HEADER_FLAG_EXTENDED_OPTIONS = 4;
    public static final int SESS_REQ_MIN_EXT_OPTIONS_LENGTH = 2;
    public static final int SESS_REQ_EXT_FLAG_REQUEST_RELAY_TAG = 1;
    public static final byte DATA_FLAG_EXPLICIT_ACK = -128;
    public static final byte DATA_FLAG_ACK_BITFIELDS = 64;
    public static final byte DATA_FLAG_ECN = 16;
    public static final byte DATA_FLAG_WANT_ACKS = 8;
    public static final byte DATA_FLAG_WANT_REPLY = 4;
    public static final byte DATA_FLAG_EXTENDED = 2;
    public static final byte BITFIELD_CONTINUATION = -128;
    private static final int MAX_VALIDATE_SIZE = 1572;
    private int _messageType;
    private int _fragmentCount;

    private UDPPacket(RouterContext ctx) {
        this._packet = new DatagramPacket(this._data, 1572);
        this._validateBuf = new byte[1572];
        this._ivBuf = new byte[16];
        this.init(ctx);
    }

    private synchronized void init(RouterContext ctx) {
        this._context = ctx;
        Arrays.fill(this._data, (byte)0);
        this._packet.setData(this._data);
        this._initializeTime = this._context.clock().now();
        this._markedType = -1;
        this._validateCount = 0;
        this._remoteHost = null;
        this._released = false;
        this._messageType = -1;
        this._enqueueTime = 0L;
        this._receivedTime = 0L;
        this._fragmentCount = 0;
    }

    public synchronized DatagramPacket getPacket() {
        this.verifyNotReleased();
        return this._packet;
    }

    public synchronized short getPriority() {
        this.verifyNotReleased();
        return this._priority;
    }

    public synchronized long getBegin() {
        this.verifyNotReleased();
        return this._initializeTime;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._initializeTime;
    }

    public synchronized void resetBegin() {
        this._initializeTime = this._context.clock().now();
    }

    public synchronized void markType(int type) {
        this.verifyNotReleased();
        this._markedType = type;
    }

    public synchronized int getMarkedType() {
        this.verifyNotReleased();
        return this._markedType;
    }

    int getMessageType() {
        return this._messageType;
    }

    void setMessageType(int type) {
        this._messageType = type;
    }

    int getFragmentCount() {
        return this._fragmentCount;
    }

    void setFragmentCount(int count) {
        this._fragmentCount = count;
    }

    synchronized RemoteHostId getRemoteHost() {
        if (this._remoteHost == null) {
            InetAddress addr = this._packet.getAddress();
            byte[] ip = addr.getAddress();
            int port = this._packet.getPort();
            this._remoteHost = new RemoteHostId(ip, port);
        }
        return this._remoteHost;
    }

    public synchronized boolean validate(SessionKey macKey) {
        this.verifyNotReleased();
        boolean eq = false;
        Arrays.fill(this._validateBuf, (byte)0);
        int payloadLength = this._packet.getLength() - 16 - 16;
        if (payloadLength > 0) {
            Log log;
            int off = 0;
            System.arraycopy(this._data, this._packet.getOffset() + 16 + 16, this._validateBuf, off, payloadLength);
            System.arraycopy(this._data, this._packet.getOffset() + 16, this._validateBuf, off += payloadLength, 16);
            DataHelper.toLong(this._validateBuf, off += 16, 2, payloadLength);
            eq = this._context.hmac().verify(macKey, this._validateBuf, 0, off += 2, this._data, this._packet.getOffset(), 16);
            if (!eq && (log = this._context.logManager().getLog(UDPPacket.class)).shouldLog(20)) {
                byte[] calc = new byte[32];
                this._context.hmac().calculate(macKey, this._validateBuf, 0, off, calc, 0);
                StringBuilder str = new StringBuilder(512);
                str.append("Bad HMAC:\n\t");
                str.append(this._packet.getLength()).append(" byte pkt, ");
                str.append(payloadLength).append(" byte payload");
                str.append("\n\tFrom: ").append(this.getRemoteHost().toString());
                str.append("\n\tIV:   ").append(Base64.encode(this._validateBuf, payloadLength, 16));
                str.append("\n\tIV2:  ").append(Base64.encode(this._data, 16, 16));
                str.append("\n\tGiven Len: ").append(DataHelper.fromLong(this._validateBuf, payloadLength + 16, 2));
                str.append("\n\tCalc HMAC: ").append(Base64.encode(calc, 0, 16));
                str.append("\n\tRead HMAC: ").append(Base64.encode(this._data, this._packet.getOffset(), 16));
                str.append("\n\tUsing key: ").append(macKey.toBase64());
                if (DataHelper.eq(macKey.getData(), 0, this._context.routerHash().getData(), 0, 32)) {
                    str.append(" (Intro)");
                } else {
                    str.append(" (Session)");
                }
                str.append("\n\tRaw:       ").append(Base64.encode(this._data, this._packet.getOffset(), this._packet.getLength()));
                log.info(str.toString(), new Exception());
            }
        } else {
            Log log = this._context.logManager().getLog(UDPPacket.class);
            if (log.shouldLog(30)) {
                log.warn("Payload length is " + payloadLength + ", too short! From: " + this.getRemoteHost() + '\n' + HexDump.dump(this._data, this._packet.getOffset(), this._packet.getLength()));
            }
        }
        ++this._validateCount;
        return eq;
    }

    public synchronized void decrypt(SessionKey cipherKey) {
        this.verifyNotReleased();
        System.arraycopy(this._data, 16, this._ivBuf, 0, 16);
        int len = this._packet.getLength();
        int rem = len & 0xF;
        if (rem != 0) {
            len -= rem;
        }
        int off = this._packet.getOffset() + 16 + 16;
        this._context.aes().decrypt(this._data, off, this._data, off, cipherKey, this._ivBuf, len - 16 - 16);
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    synchronized void received() {
        this._receivedTime = this._context.clock().now();
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    synchronized long getTimeSinceReceived() {
        return this._receivedTime > 0L ? this._context.clock().now() - this._receivedTime : 0L;
    }

    @Deprecated
    public synchronized void requestInboundBandwidth() {
        this.verifyNotReleased();
        this._bandwidthRequest = this._context.bandwidthLimiter().requestInbound(this._packet.getLength(), "UDP receiver");
    }

    public synchronized void requestOutboundBandwidth() {
        this.verifyNotReleased();
        this._bandwidthRequest = this._context.bandwidthLimiter().requestOutbound(this._packet.getLength(), 0, "UDP sender");
    }

    public synchronized FIFOBandwidthLimiter.Request getBandwidthRequest() {
        this.verifyNotReleased();
        return this._bandwidthRequest;
    }

    public String toString() {
        this.verifyNotReleased();
        StringBuilder buf = new StringBuilder(256);
        buf.append(this._packet.getLength());
        buf.append(" byte pkt with ");
        buf.append(Addresses.toString(this._packet.getAddress().getAddress(), this._packet.getPort()));
        if (this._messageType >= 0) {
            buf.append(" msgType=").append(this._messageType);
        }
        if (this._markedType >= 0) {
            buf.append(" markType=").append(this._markedType);
        }
        if (this._fragmentCount > 0) {
            buf.append(" fragCount=").append(this._fragmentCount);
        }
        if (this._enqueueTime > 0L) {
            buf.append(" sinceEnqueued=").append(this._context.clock().now() - this._enqueueTime);
        }
        if (this._receivedTime > 0L) {
            buf.append(" sinceReceived=").append(this._context.clock().now() - this._receivedTime);
        }
        return buf.toString();
    }

    public static UDPPacket acquire(RouterContext ctx, boolean inbound) {
        PacketFactory.context = ctx;
        UDPPacket rv = _packetCache.acquire();
        rv.init(ctx);
        return rv;
    }

    @Override
    public void drop() {
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        this.verifyNotReleased();
        this._released = true;
        if (this._bandwidthRequest != null) {
            FIFOBandwidthLimiter.Request request = this._bandwidthRequest;
            synchronized (request) {
                if (this._bandwidthRequest.getPendingRequested() > 0) {
                    this._bandwidthRequest.abort();
                }
            }
            this._bandwidthRequest = null;
        }
        _packetCache.release(this);
    }

    public static void clearCache() {
        PacketFactory.context = null;
        _packetCache.clear();
    }

    private synchronized void verifyNotReleased() {
        if (this._released) {
            Log log = this._context.logManager().getLog(UDPPacket.class);
            log.error("Already released", new Exception());
        }
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        int csize = (int)Math.max(64L, Math.min(256L, maxMemory / 0x100000L));
        _packetFactory = new PacketFactory();
        _packetCache = new TryCache<UDPPacket>(_packetFactory, csize);
    }

    private static class PacketFactory
    implements TryCache.ObjectFactory<UDPPacket> {
        static RouterContext context;

        private PacketFactory() {
        }

        @Override
        public UDPPacket newInstance() {
            return new UDPPacket(context);
        }
    }
}

