/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.router.RouterInfo;
import net.i2p.util.HexDump;

class NTCP2Payload {
    public static final int BLOCK_HEADER_SIZE = 3;
    private static final int BLOCK_DATETIME = 0;
    private static final int BLOCK_OPTIONS = 1;
    private static final int BLOCK_ROUTERINFO = 2;
    private static final int BLOCK_I2NP = 3;
    private static final int BLOCK_TERMINATION = 4;
    private static final int BLOCK_PADDING = 254;

    NTCP2Payload() {
    }

    public static int processPayload(I2PAppContext ctx, PayloadCallback cb, byte[] payload, int off, int length, boolean isHandshake) throws IOException, DataFormatException, I2NPMessageException {
        int blocks = 0;
        boolean gotPadding = false;
        boolean gotTermination = false;
        int i = off;
        int end = off + length;
        while (i < end) {
            int len;
            int type = payload[i++] & 0xFF;
            if (gotPadding) {
                throw new IOException("Illegal block after padding: " + type);
            }
            if (gotTermination && type != 254) {
                throw new IOException("Illegal block after termination: " + type);
            }
            if (isHandshake && blocks == 0 && type != 2) {
                throw new IOException("Illegal first block in handshake: " + type);
            }
            if ((i += 2) + (len = (int)DataHelper.fromLong(payload, i, 2)) > end) {
                throw new IOException("Block " + blocks + " type " + type + " length " + len + " at offset " + (i - 3 - off) + " runs over frame of size " + length + '\n' + HexDump.dump(payload, off, length));
            }
            switch (type) {
                case 0: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len != 4) {
                        throw new IOException("Bad length for DATETIME: " + len);
                    }
                    long time = DataHelper.fromLong(payload, i, 4) * 1000L;
                    cb.gotDateTime(time);
                    break;
                }
                case 1: {
                    byte[] options = new byte[len];
                    System.arraycopy(payload, i, options, 0, len);
                    cb.gotOptions(options, isHandshake);
                    break;
                }
                case 2: {
                    int flag = payload[i] & 0xFF;
                    RouterInfo alice = new RouterInfo();
                    ByteArrayInputStream bais = new ByteArrayInputStream(payload, i + 1, len - 1);
                    alice.readBytes(bais, true);
                    cb.gotRI(alice, isHandshake, (flag & 1) != 0);
                    break;
                }
                case 3: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    I2NPMessage msg = I2NPMessageImpl.fromRawByteArrayNTCP2(ctx, payload, i, len, null);
                    cb.gotI2NP(msg);
                    break;
                }
                case 4: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    if (len < 9) {
                        throw new IOException("Bad length for TERMINATION: " + len);
                    }
                    long last = NTCP2Payload.fromLong8(payload, i);
                    int rsn = payload[i + 8] & 0xFF;
                    cb.gotTermination(rsn, last);
                    gotTermination = true;
                    break;
                }
                case 254: {
                    gotPadding = true;
                    cb.gotPadding(len, length);
                    break;
                }
                default: {
                    if (isHandshake) {
                        throw new IOException("Illegal block in handshake: " + type);
                    }
                    cb.gotUnknown(type, len);
                }
            }
            i += len;
            ++blocks;
        }
        if (isHandshake && blocks == 0) {
            throw new IOException("No blocks in handshake");
        }
        return blocks;
    }

    public static int writePayload(byte[] payload, int off, List<Block> blocks) {
        for (Block block : blocks) {
            off = block.write(payload, off);
        }
        return off;
    }

    private static long fromLong8(byte[] src, int offset) {
        long rv = 0L;
        int limit = offset + 8;
        for (int i = offset; i < limit; ++i) {
            rv <<= 8;
            rv |= (long)(src[i] & 0xFF);
        }
        return rv;
    }

    private static void toLong8(byte[] target, int offset, long value) {
        for (int i = offset + 7; i >= offset; --i) {
            target[i] = (byte)value;
            value >>= 8;
        }
    }

    public static abstract class Block {
        private final int type;

        public Block(int ttype) {
            this.type = ttype;
        }

        public int write(byte[] tgt, int off) {
            tgt[off++] = (byte)this.type;
            int rv = this.writeData(tgt, off + 2);
            DataHelper.toLong(tgt, off, 2, rv - (off + 2));
            return rv;
        }

        public int getTotalLength() {
            return 3 + this.getDataLength();
        }

        public abstract int getDataLength();

        public abstract int writeData(byte[] var1, int var2);

        public String toString() {
            return "Payload block type " + this.type + " length " + this.getDataLength();
        }
    }

    public static class DateTimeBlock
    extends Block {
        private final long now;

        public DateTimeBlock(I2PAppContext ctx) {
            super(0);
            this.now = ctx.clock().now();
        }

        @Override
        public int getDataLength() {
            return 4;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            DataHelper.toLong(tgt, off, 4, this.now / 1000L);
            return off + 4;
        }
    }

    public static class I2NPBlock
    extends Block {
        private final I2NPMessage m;

        public I2NPBlock(I2NPMessage msg) {
            super(3);
            this.m = msg;
        }

        @Override
        public int getDataLength() {
            return this.m.getMessageSize() - 7;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            return this.m.toRawByteArrayNTCP2(tgt, off);
        }
    }

    public static class OptionsBlock
    extends Block {
        private final byte[] opts;

        public OptionsBlock(byte[] options) {
            super(1);
            this.opts = options;
        }

        @Override
        public int getDataLength() {
            return this.opts.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            System.arraycopy(this.opts, 0, tgt, off, this.opts.length);
            return off + this.opts.length;
        }
    }

    public static class PaddingBlock
    extends Block {
        private final int sz;
        private final I2PAppContext ctx;

        public PaddingBlock(int size) {
            this(null, size);
        }

        public PaddingBlock(I2PAppContext context, int size) {
            super(254);
            this.sz = size;
            this.ctx = context;
        }

        @Override
        public int getDataLength() {
            return this.sz;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            if (this.ctx != null) {
                this.ctx.random().nextBytes(tgt, off, this.sz);
            } else {
                Arrays.fill(tgt, off, off + this.sz, (byte)0);
            }
            return off + this.sz;
        }
    }

    public static interface PayloadCallback {
        public void gotDateTime(long var1) throws DataFormatException;

        public void gotI2NP(I2NPMessage var1) throws I2NPMessageException;

        public void gotOptions(byte[] var1, boolean var2) throws DataFormatException;

        public void gotRI(RouterInfo var1, boolean var2, boolean var3) throws DataFormatException;

        public void gotTermination(int var1, long var2);

        public void gotPadding(int var1, int var2);

        public void gotUnknown(int var1, int var2);
    }

    public static class RIBlock
    extends Block {
        private final byte[] data;
        private final boolean f;

        public RIBlock(RouterInfo ri, boolean flood) {
            super(2);
            this.data = ri.toByteArray();
            this.f = flood;
        }

        @Override
        public int getDataLength() {
            return 1 + this.data.length;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            tgt[off++] = (byte)(this.f ? 1 : 0);
            System.arraycopy(this.data, 0, tgt, off, this.data.length);
            return off + this.data.length;
        }
    }

    public static class TerminationBlock
    extends Block {
        private final byte rsn;
        private final long rcvd;

        public TerminationBlock(int reason, long lastReceived) {
            super(4);
            this.rsn = (byte)reason;
            this.rcvd = lastReceived;
        }

        @Override
        public int getDataLength() {
            return 9;
        }

        @Override
        public int writeData(byte[] tgt, int off) {
            NTCP2Payload.toLong8(tgt, off, this.rcvd);
            tgt[off + 8] = this.rsn;
            return off + 9;
        }
    }
}

