/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.net.InetAddress;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.UPnP;
import net.i2p.util.Addresses;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.Translate;
import org.cybergarage.util.Debug;
import org.freenetproject.DetectedIP;
import org.freenetproject.ForwardPort;
import org.freenetproject.ForwardPortCallback;
import org.freenetproject.ForwardPortStatus;

class UPnPManager {
    private final Log _log;
    private final RouterContext _context;
    private final UPnP _upnp;
    private final UPnPCallback _upnpCallback;
    private volatile boolean _isRunning;
    private volatile boolean _shouldBeRunning;
    private volatile long _lastRescan;
    private boolean _errorLogged;
    private boolean _disconLogged;
    private InetAddress _detectedAddress;
    private final TransportManager _manager;
    private final SimpleTimer2.TimedEvent _rescanner;
    private static final String PROP_HTTP_PORT = "i2np.upnp.HTTPPort";
    private static final int DEFAULT_HTTP_PORT = 7652;
    private static final String PROP_SSDP_PORT = "i2np.upnp.SSDPPort";
    private static final int DEFAULT_SSDP_PORT = 7653;
    private static final long RESCAN_MIN_DELAY = 60000L;
    private static final long RESCAN_SHORT_DELAY = 120000L;
    private static final long RESCAN_LONG_DELAY = 840000L;
    private static final String TCP_PORT_NAME = "TCP";
    private static final String UDP_PORT_NAME = "UDP";
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    public UPnPManager(RouterContext context, TransportManager manager) {
        this._context = context;
        this._manager = manager;
        this._log = this._context.logManager().getLog(UPnPManager.class);
        org.cybergarage.upnp.UPnP.setEnable(9);
        Debug.initialize(context);
        this._upnp = new UPnP(context);
        this._upnpCallback = new UPnPCallback();
        this._rescanner = new Rescanner();
    }

    public synchronized void start() {
        block10: {
            this._shouldBeRunning = true;
            if (!this._isRunning && Addresses.isConnected()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("UPnP Start");
                }
                long b = this._context.clock().now();
                try {
                    this._upnp.setHTTPPort(this._context.getProperty(PROP_HTTP_PORT, 7652));
                    this._upnp.setSSDPPort(this._context.getProperty(PROP_SSDP_PORT, 7653));
                    this._isRunning = this._upnp.runPlugin();
                    if (this._log.shouldDebug()) {
                        this._log.info("UPnP runPlugin took " + (this._context.clock().now() - b));
                    }
                }
                catch (RuntimeException e) {
                    if (this._errorLogged) break block10;
                    this._log.error("UPnP error, please report", e);
                    this._errorLogged = true;
                }
            }
        }
        if (this._isRunning) {
            this._rescanner.schedule(840000L);
        } else {
            this._rescanner.schedule(120000L);
            if (!Addresses.isConnected()) {
                if (!this._disconLogged) {
                    this._log.logAlways(30, "UPnP start failed - no network connection?");
                    this._disconLogged = true;
                }
            } else {
                this._log.error("UPnP start failed - port conflict?");
            }
        }
    }

    public synchronized void stop() {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Stop");
        }
        this._shouldBeRunning = false;
        this._rescanner.cancel();
        if (this._isRunning) {
            this._upnp.terminate();
        }
        this._isRunning = false;
        this._detectedAddress = null;
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Stop Done");
        }
    }

    public synchronized boolean rescan() {
        if (!this._shouldBeRunning) {
            return false;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (this._lastRescan + 60000L > now) {
            return false;
        }
        this._lastRescan = now;
        if (this._isRunning) {
            if (this._log.shouldLog(10)) {
                this._log.debug("UPnP Rescan");
            }
            this._upnp.search();
        } else {
            this.start();
        }
        return true;
    }

    public void update(Set<TransportManager.Port> ports) {
        if (this._log.shouldLog(10)) {
            this._log.debug("UPnP Update with " + ports.size() + " ports", new Exception("I did it"));
        }
        if (!this._isRunning) {
            return;
        }
        HashSet<ForwardPort> forwards = new HashSet<ForwardPort>(ports.size());
        for (TransportManager.Port entry : ports) {
            String name;
            int protocol;
            String style = entry.style;
            int port = entry.port;
            if ("SSU".equals(style)) {
                protocol = 17;
                name = UDP_PORT_NAME;
            } else {
                if (!"NTCP".equals(style)) continue;
                protocol = 6;
                name = TCP_PORT_NAME;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug("Adding: " + style + " " + port);
            }
            ForwardPort fp = new ForwardPort(name, false, protocol, port);
            forwards.add(fp);
        }
        this._upnp.onChangePublicPorts(forwards, this._upnpCallback);
    }

    public String renderStatusHTML() {
        if (!this._isRunning) {
            return "<h3><a name=\"upnp\"></a>" + this._t("UPnP is not enabled") + "</h3>\n";
        }
        return this._upnp.renderStatusHTML();
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private class Rescanner
    extends SimpleTimer2.TimedEvent {
        public Rescanner() {
            super(UPnPManager.this._context.simpleTimer2());
        }

        @Override
        public void timeReached() {
            if (UPnPManager.this._shouldBeRunning) {
                UPnPManager.this.rescan();
                this.reschedule(UPnPManager.this._isRunning ? 840000L : 120000L);
            }
        }
    }

    private class UPnPCallback
    implements ForwardPortCallback {
        private UPnPCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void portForwardStatus(Map<ForwardPort, ForwardPortStatus> statuses) {
            if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("UPnP Callback: with " + statuses.size() + " statuses");
            }
            UPnPCallback uPnPCallback = this;
            synchronized (uPnPCallback) {
                this.locked_PFS(statuses);
            }
        }

        private void locked_PFS(Map<ForwardPort, ForwardPortStatus> statuses) {
            byte[] ipaddr = null;
            DetectedIP[] ips = UPnPManager.this._upnp.getAddress();
            if (ips != null && ips.length > 0) {
                for (DetectedIP ip : ips) {
                    if (TransportUtil.isPubliclyRoutable(ip.publicAddress.getAddress(), false)) {
                        if (UPnPManager.this._log.shouldLog(10)) {
                            UPnPManager.this._log.debug("External address: " + ip.publicAddress + " type: " + ip.natType);
                        }
                        if (!ip.publicAddress.equals(UPnPManager.this._detectedAddress)) {
                            UPnPManager.this._detectedAddress = ip.publicAddress;
                            UPnPManager.this._manager.externalAddressReceived(Transport.AddressSource.SOURCE_UPNP, UPnPManager.this._detectedAddress.getAddress(), 0);
                        }
                        ipaddr = ip.publicAddress.getAddress();
                        break;
                    }
                    if (!UPnPManager.this._log.shouldWarn()) continue;
                    UPnPManager.this._log.warn("Unusable external address: " + ip.publicAddress + " type: " + ip.natType);
                }
            } else if (UPnPManager.this._log.shouldLog(10)) {
                UPnPManager.this._log.debug("No external address returned");
            }
            if (statuses.isEmpty()) {
                if (UPnPManager.this._log.shouldWarn()) {
                    UPnPManager.this._log.warn("No statuses returned");
                }
                return;
            }
            for (Map.Entry entry : statuses.entrySet()) {
                String style;
                ForwardPort fp = (ForwardPort)entry.getKey();
                ForwardPortStatus fps = (ForwardPortStatus)entry.getValue();
                if (UPnPManager.this._log.shouldDebug()) {
                    UPnPManager.this._log.debug("FPS: " + fp.name + ' ' + fp.protocol + ' ' + fp.portNumber + " status: " + fps.status + " reason: " + fps.reasonString + " ext port: " + fps.externalPort);
                }
                if (fp.protocol == 17) {
                    style = "SSU";
                } else if (fp.protocol == 6) {
                    style = "NTCP";
                } else {
                    if (!UPnPManager.this._log.shouldWarn()) continue;
                    UPnPManager.this._log.debug("Unknown protocol " + fp.protocol);
                    continue;
                }
                boolean success = fps.status >= 1;
                UPnPManager.this._manager.forwardPortStatus(style, ipaddr, fp.portNumber, fps.externalPort, success, fps.reasonString);
            }
        }
    }
}

