/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.CipherStatePair;
import com.southernstorm.noise.protocol.DHState;
import com.southernstorm.noise.protocol.Destroyable;
import com.southernstorm.noise.protocol.Noise;
import java.io.UnsupportedEncodingException;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;
import net.i2p.data.Base64;

class SymmetricState
implements Destroyable {
    private static final byte[] INIT_HASH;
    private final CipherState cipher;
    private final MessageDigest hash;
    private final byte[] ck;
    private final byte[] h;
    private final byte[] prev_h;

    public SymmetricState(String cipherName, String hashName) throws NoSuchAlgorithmException {
        this.cipher = Noise.createCipher(cipherName);
        this.hash = Noise.createHash(hashName);
        int hashLength = this.hash.getDigestLength();
        this.ck = new byte[hashLength];
        this.h = new byte[hashLength];
        this.prev_h = new byte[hashLength];
        System.arraycopy(INIT_HASH, 0, this.h, 0, hashLength);
        System.arraycopy(this.h, 0, this.ck, 0, hashLength);
    }

    public String getProtocolName() {
        return "Noise_XKaesobfse+hs2+hs3_25519_ChaChaPoly_SHA256";
    }

    public int getMACLength() {
        return this.cipher.getMACLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mixKey(byte[] data, int offset, int length) {
        int keyLength = this.cipher.getKeyLength();
        byte[] tempKey = new byte[keyLength];
        try {
            this.hkdf(this.ck, 0, this.ck.length, data, offset, length, this.ck, 0, this.ck.length, tempKey, 0, keyLength);
            this.cipher.initializeKey(tempKey, 0);
        }
        finally {
            Noise.destroy(tempKey);
        }
    }

    public void mixHash(byte[] data, int offset, int length) {
        this.hashTwo(this.h, 0, this.h.length, data, offset, length, this.h, 0, this.h.length);
    }

    public void mixPreSharedKey(byte[] key) {
        byte[] temp = new byte[this.hash.getDigestLength()];
        try {
            this.hkdf(this.ck, 0, this.ck.length, key, 0, key.length, this.ck, 0, this.ck.length, temp, 0, temp.length);
            this.mixHash(temp, 0, temp.length);
        }
        finally {
            Noise.destroy(temp);
        }
    }

    public void mixPublicKey(DHState dh) {
        byte[] temp = new byte[dh.getPublicKeyLength()];
        try {
            dh.getPublicKey(temp, 0);
            this.mixHash(temp, 0, temp.length);
        }
        finally {
            Noise.destroy(temp);
        }
    }

    public void mixPublicKeyIntoCK(DHState dh) {
        byte[] temp = new byte[dh.getPublicKeyLength()];
        try {
            dh.getPublicKey(temp, 0);
            this.mixKey(temp, 0, temp.length);
        }
        finally {
            Noise.destroy(temp);
        }
    }

    public int encryptAndHash(byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) throws ShortBufferException {
        int ciphertextLength = this.cipher.encryptWithAd(this.h, plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
        this.mixHash(ciphertext, ciphertextOffset, ciphertextLength);
        return ciphertextLength;
    }

    public int decryptAndHash(byte[] ciphertext, int ciphertextOffset, byte[] plaintext, int plaintextOffset, int length) throws ShortBufferException, BadPaddingException {
        System.arraycopy(this.h, 0, this.prev_h, 0, this.h.length);
        this.mixHash(ciphertext, ciphertextOffset, length);
        return this.cipher.decryptWithAd(this.prev_h, ciphertext, ciphertextOffset, plaintext, plaintextOffset, length);
    }

    public CipherStatePair split() {
        return this.split(new byte[0], 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CipherStatePair split(byte[] secondaryKey, int offset, int length) {
        if (length != 0 && length != 32) {
            throw new IllegalArgumentException("Secondary keys must be 0 or 32 bytes in length");
        }
        int keyLength = this.cipher.getKeyLength();
        byte[] k1 = new byte[keyLength];
        byte[] k2 = new byte[keyLength];
        try {
            this.hkdf(this.ck, 0, this.ck.length, secondaryKey, offset, length, k1, 0, k1.length, k2, 0, k2.length);
            CipherState c1 = null;
            Destroyable c2 = null;
            CipherStatePair pair = null;
            try {
                c1 = this.cipher.fork(k1, 0);
                c2 = this.cipher.fork(k2, 0);
                pair = new CipherStatePair(c1, (CipherState)c2);
            }
            finally {
                if (c1 == null || c2 == null || pair == null) {
                    if (c1 != null) {
                        c1.destroy();
                    }
                    if (c2 != null) {
                        c2.destroy();
                    }
                    pair = null;
                }
            }
            CipherStatePair cipherStatePair = pair;
            return cipherStatePair;
        }
        finally {
            Noise.destroy(k1);
            Noise.destroy(k2);
        }
    }

    public byte[] getHandshakeHash() {
        return this.h;
    }

    @Override
    public void destroy() {
        this.cipher.destroy();
        this.hash.reset();
        Noise.destroy(this.ck);
        Noise.destroy(this.h);
        Noise.destroy(this.prev_h);
    }

    private void hashOne(byte[] data, int offset, int length, byte[] output, int outputOffset, int outputLength) {
        this.hash.reset();
        this.hash.update(data, offset, length);
        try {
            this.hash.digest(output, outputOffset, outputLength);
        }
        catch (DigestException e) {
            Arrays.fill(output, outputOffset, outputLength, (byte)0);
        }
    }

    private void hashTwo(byte[] data1, int offset1, int length1, byte[] data2, int offset2, int length2, byte[] output, int outputOffset, int outputLength) {
        this.hash.reset();
        this.hash.update(data1, offset1, length1);
        this.hash.update(data2, offset2, length2);
        try {
            this.hash.digest(output, outputOffset, outputLength);
        }
        catch (DigestException e) {
            Arrays.fill(output, outputOffset, outputLength, (byte)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hmac(byte[] key, int keyOffset, int keyLength, byte[] data, int dataOffset, int dataLength, byte[] output, int outputOffset, int outputLength) {
        int hashLength = this.hash.getDigestLength();
        int blockLength = hashLength * 2;
        byte[] block = new byte[blockLength];
        try {
            if (keyLength <= blockLength) {
                System.arraycopy(key, keyOffset, block, 0, keyLength);
                Arrays.fill(block, keyLength, blockLength, (byte)0);
            } else {
                this.hash.reset();
                this.hash.update(key, keyOffset, keyLength);
                this.hash.digest(block, 0, hashLength);
                Arrays.fill(block, hashLength, blockLength, (byte)0);
            }
            int index = 0;
            while (index < blockLength) {
                int n = index++;
                block[n] = (byte)(block[n] ^ 0x36);
            }
            this.hash.reset();
            this.hash.update(block, 0, blockLength);
            this.hash.update(data, dataOffset, dataLength);
            this.hash.digest(output, outputOffset, hashLength);
            index = 0;
            while (index < blockLength) {
                int n = index++;
                block[n] = (byte)(block[n] ^ 0x6A);
            }
            this.hash.reset();
            this.hash.update(block, 0, blockLength);
            this.hash.update(output, outputOffset, hashLength);
            this.hash.digest(output, outputOffset, outputLength);
        }
        catch (DigestException e) {
            Arrays.fill(output, outputOffset, outputLength, (byte)0);
        }
        finally {
            Noise.destroy(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hkdf(byte[] key, int keyOffset, int keyLength, byte[] data, int dataOffset, int dataLength, byte[] output1, int output1Offset, int output1Length, byte[] output2, int output2Offset, int output2Length) {
        int hashLength = this.hash.getDigestLength();
        byte[] tempKey = new byte[hashLength];
        byte[] tempHash = new byte[hashLength + 1];
        try {
            this.hmac(key, keyOffset, keyLength, data, dataOffset, dataLength, tempKey, 0, hashLength);
            tempHash[0] = 1;
            this.hmac(tempKey, 0, hashLength, tempHash, 0, 1, tempHash, 0, hashLength);
            System.arraycopy(tempHash, 0, output1, output1Offset, output1Length);
            tempHash[hashLength] = 2;
            this.hmac(tempKey, 0, hashLength, tempHash, 0, hashLength + 1, tempHash, 0, hashLength);
            System.arraycopy(tempHash, 0, output2, output2Offset, output2Length);
        }
        finally {
            Noise.destroy(tempKey);
            Noise.destroy(tempHash);
        }
    }

    public byte[] getChainingKey() {
        byte[] rv = new byte[this.ck.length];
        System.arraycopy(this.ck, 0, rv, 0, this.ck.length);
        return rv;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("  Symmetric State:\n    ck: ");
        buf.append(Base64.encode(this.ck));
        buf.append("\n    h:  ");
        buf.append(Base64.encode(this.h));
        buf.append('\n');
        buf.append(this.cipher.toString());
        return buf.toString();
    }

    static {
        byte[] protocolNameBytes;
        try {
            protocolNameBytes = "Noise_XKaesobfse+hs2+hs3_25519_ChaChaPoly_SHA256".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("UTF-8 encoding is not supported");
        }
        INIT_HASH = new byte[32];
        if (protocolNameBytes.length <= 32) {
            System.arraycopy(protocolNameBytes, 0, INIT_HASH, 0, protocolNameBytes.length);
            Arrays.fill(INIT_HASH, protocolNameBytes.length, 32, (byte)0);
        } else {
            try {
                MessageDigest hash = Noise.createHash("SHA256");
                hash.update(protocolNameBytes, 0, protocolNameBytes.length);
                hash.digest(INIT_HASH, 0, 32);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

