/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.NonBlockingThread;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class SelectorManager
extends AbstractLifeCycle
implements Dumpable {
    public static final String SUBMIT_KEY_UPDATES = "org.eclipse.jetty.io.SelectorManager.submitKeyUpdates";
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private static final boolean __submitKeyUpdates = Boolean.valueOf(System.getProperty("org.eclipse.jetty.io.SelectorManager.submitKeyUpdates", "true"));
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private long _connectTimeout = 15000L;
    private long _selectorIndex;
    private int _priorityDelta;

    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this(executor, scheduler, (Runtime.getRuntime().availableProcessors() + 1) / 2);
    }

    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        if (selectors <= 0) {
            throw new IllegalArgumentException("No selectors");
        }
        this.executor = executor;
        this.scheduler = scheduler;
        this._selectors = new ManagedSelector[selectors];
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(long milliseconds) {
        this._connectTimeout = milliseconds;
    }

    @ManagedAttribute(value="The priority delta to apply to selector threads")
    public int getSelectorPriorityDelta() {
        return this._priorityDelta;
    }

    public void setSelectorPriorityDelta(int selectorPriorityDelta) {
        int oldDelta = this._priorityDelta;
        this._priorityDelta = selectorPriorityDelta;
        if (oldDelta != selectorPriorityDelta && this.isStarted()) {
            for (ManagedSelector selector : this._selectors) {
                Thread thread = selector._thread;
                if (thread == null) continue;
                int deltaDiff = selectorPriorityDelta - oldDelta;
                thread.setPriority(Math.max(1, Math.min(10, thread.getPriority() - deltaDiff)));
            }
        }
    }

    protected void execute(Runnable task) {
        this.executor.execute(task);
    }

    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector() {
        long s = this._selectorIndex++;
        int index = (int)(s % (long)this.getSelectorCount());
        return this._selectors[index];
    }

    public void connect(SocketChannel channel, Object attachment) {
        ManagedSelector set;
        ManagedSelector managedSelector = set = this.chooseSelector();
        managedSelector.getClass();
        set.submit(managedSelector.new ManagedSelector.Connect(channel, attachment));
    }

    public void accept(SocketChannel channel) {
        this.accept(channel, null);
    }

    public void accept(SocketChannel channel, Object attachment) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        managedSelector.getClass();
        selector.submit(managedSelector.new ManagedSelector.Accept(channel, attachment));
    }

    public void acceptor(ServerSocketChannel server) {
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        managedSelector.getClass();
        selector.submit(managedSelector.new ManagedSelector.Acceptor(server));
    }

    protected void accepted(SocketChannel channel) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doStart() throws Exception {
        super.doStart();
        for (int i = 0; i < this._selectors.length; ++i) {
            ManagedSelector selector;
            this._selectors[i] = selector = this.newSelector(i);
            selector.start();
            this.execute((Runnable)new NonBlockingThread((Runnable)selector));
        }
    }

    protected ManagedSelector newSelector(int id) {
        return new ManagedSelector(id);
    }

    protected void doStop() throws Exception {
        for (ManagedSelector selector : this._selectors) {
            selector.stop();
        }
        super.doStop();
    }

    protected void endPointOpened(EndPoint endpoint) {
        endpoint.onOpen();
    }

    protected void endPointClosed(EndPoint endpoint) {
        endpoint.onClose();
    }

    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
        }
        catch (Throwable x) {
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x);
            } else {
                LOG.debug("Exception while notifying connection " + connection, x);
            }
            throw x;
        }
    }

    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
        }
        catch (Throwable x) {
            LOG.debug("Exception while notifying connection " + connection, x);
        }
    }

    protected boolean finishConnect(SocketChannel channel) throws IOException {
        return channel.finishConnect();
    }

    protected void connectionFailed(SocketChannel channel, Throwable ex, Object attachment) {
        LOG.warn(String.format("%s - %s", channel, attachment), ex);
    }

    protected abstract EndPoint newEndPoint(SocketChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SocketChannel var1, EndPoint var2, Object var3) throws IOException;

    public String dump() {
        return ContainerLifeCycle.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        ContainerLifeCycle.dumpObject((Appendable)out, (Object)((Object)this));
        ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])this._selectors)});
    }

    public class ManagedSelector
    extends AbstractLifeCycle
    implements Runnable,
    Dumpable {
        private final AtomicReference<State> _state = new AtomicReference<State>(State.PROCESS);
        private final Queue<Runnable> _changes = new ConcurrentArrayQueue();
        private final int _id;
        private Selector _selector;
        private volatile Thread _thread;

        public ManagedSelector(int id) {
            this._id = id;
            this.setStopTimeout(5000L);
        }

        protected void doStart() throws Exception {
            super.doStart();
            this._selector = Selector.open();
            this._state.set(State.PROCESS);
        }

        protected void doStop() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopping {}", new Object[]{this});
            }
            Stop stop = new Stop();
            this.submit(stop);
            stop.await(this.getStopTimeout());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopped {}", new Object[]{this});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateKey(Runnable update) {
            if (__submitKeyUpdates) {
                this.submit(update);
            } else {
                ManagedSelector managedSelector = this;
                synchronized (managedSelector) {
                    this.runChange(update);
                }
                if (this._state.compareAndSet(State.SELECT, State.WAKEUP)) {
                    this.wakeup();
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void submit(Runnable change) {
            this._changes.offer(change);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Queued change {}", new Object[]{change});
            }
            block7: while (true) {
                switch (this._state.get()) {
                    case SELECT: {
                        if (!this._state.compareAndSet(State.SELECT, State.WAKEUP)) continue block7;
                        this.wakeup();
                        return;
                    }
                    case CHANGES: {
                        if (this._state.compareAndSet(State.CHANGES, State.MORE_CHANGES)) return;
                        continue block7;
                    }
                    case WAKEUP: {
                        return;
                    }
                    case MORE_CHANGES: {
                        return;
                    }
                    case PROCESS: {
                        return;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                break;
            }
        }

        private void runChanges() {
            Runnable change;
            while ((change = this._changes.poll()) != null) {
                this.runChange(change);
            }
        }

        protected void runChange(Runnable change) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Running change {}", new Object[]{change});
                }
                change.run();
            }
            catch (Throwable x) {
                LOG.debug("Could not run change " + change, x);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._thread = Thread.currentThread();
            String name = this._thread.getName();
            int priority = this._thread.getPriority();
            try {
                if (SelectorManager.this._priorityDelta != 0) {
                    this._thread.setPriority(Math.max(1, Math.min(10, priority + SelectorManager.this._priorityDelta)));
                }
                this._thread.setName(String.format("%s-selector-%s@%h/%d", name, ((Object)((Object)SelectorManager.this)).getClass().getSimpleName(), ((Object)((Object)SelectorManager.this)).hashCode(), this._id));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Starting {} on {}", new Object[]{this._thread, this});
                }
                while (this.isRunning()) {
                    this.select();
                }
                while (this.isStopping()) {
                    this.runChanges();
                }
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stopped {} on {}", new Object[]{this._thread, this});
                }
                this._thread.setName(name);
                if (SelectorManager.this._priorityDelta != 0) {
                    this._thread.setPriority(priority);
                }
                throw throwable;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stopped {} on {}", new Object[]{this._thread, this});
            }
            this._thread.setName(name);
            if (SelectorManager.this._priorityDelta != 0) {
                this._thread.setPriority(priority);
            }
        }

        public void select() {
            boolean debug = LOG.isDebugEnabled();
            try {
                this._state.set(State.CHANGES);
                block6: while (true) {
                    switch (this._state.get()) {
                        case CHANGES: {
                            this.runChanges();
                            if (!this._state.compareAndSet(State.CHANGES, State.SELECT)) continue block6;
                            break block6;
                        }
                        case MORE_CHANGES: {
                            this.runChanges();
                            this._state.set(State.CHANGES);
                            continue block6;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    break;
                }
                assert (this._state.get() == State.SELECT || this._state.get() == State.WAKEUP);
                if (debug) {
                    LOG.debug("Selector loop waiting on select", new Object[0]);
                }
                int selected = this._selector.select();
                if (debug) {
                    LOG.debug("Selector loop woken up from select, {}/{} selected", new Object[]{selected, this._selector.keys().size()});
                }
                this._state.set(State.PROCESS);
                Set<SelectionKey> selectedKeys = this._selector.selectedKeys();
                for (SelectionKey key : selectedKeys) {
                    Object attachment;
                    if (key.isValid()) {
                        this.processKey(key);
                        continue;
                    }
                    if (debug) {
                        LOG.debug("Selector loop ignoring invalid key for channel {}", new Object[]{key.channel()});
                    }
                    if (!((attachment = key.attachment()) instanceof EndPoint)) continue;
                    ((EndPoint)attachment).close();
                }
                selectedKeys.clear();
            }
            catch (Throwable x) {
                if (this.isRunning()) {
                    LOG.warn(x);
                }
                LOG.ignore(x);
            }
        }

        private void processKey(SelectionKey key) {
            block7: {
                Object attachment = key.attachment();
                try {
                    if (attachment instanceof SelectableEndPoint) {
                        ((SelectableEndPoint)attachment).onSelected();
                        break block7;
                    }
                    if (key.isConnectable()) {
                        this.processConnect(key, (Connect)attachment);
                        break block7;
                    }
                    if (key.isAcceptable()) {
                        this.processAccept(key);
                        break block7;
                    }
                    throw new IllegalStateException();
                }
                catch (CancelledKeyException x) {
                    LOG.debug("Ignoring cancelled key for channel {}", new Object[]{key.channel()});
                    if (attachment instanceof EndPoint) {
                        this.closeNoExceptions((EndPoint)attachment);
                    }
                }
                catch (Throwable x) {
                    LOG.warn("Could not process key for channel " + key.channel(), x);
                    if (!(attachment instanceof EndPoint)) break block7;
                    this.closeNoExceptions((EndPoint)attachment);
                }
            }
        }

        private void processConnect(SelectionKey key, Connect connect) {
            SocketChannel channel = (SocketChannel)key.channel();
            try {
                key.attach(connect.attachment);
                boolean connected = SelectorManager.this.finishConnect(channel);
                if (connected) {
                    if (!connect.timeout.cancel()) {
                        throw new SocketTimeoutException("Concurrent Connect Timeout");
                    }
                } else {
                    throw new ConnectException();
                }
                key.interestOps(0);
                EndPoint endpoint = this.createEndPoint(channel, key);
                key.attach(endpoint);
            }
            catch (Throwable x) {
                connect.failed(x);
            }
        }

        private void processAccept(SelectionKey key) {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            SocketChannel channel = null;
            try {
                while ((channel = server.accept()) != null) {
                    SelectorManager.this.accepted(channel);
                }
            }
            catch (Throwable x) {
                this.closeNoExceptions(channel);
                LOG.warn("Accept failed for channel " + channel, x);
            }
        }

        private void closeNoExceptions(Closeable closeable) {
            try {
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable x) {
                LOG.ignore(x);
            }
        }

        public void wakeup() {
            this._selector.wakeup();
        }

        public boolean isSelectorThread() {
            return Thread.currentThread() == this._thread;
        }

        private EndPoint createEndPoint(SocketChannel channel, SelectionKey selectionKey) throws IOException {
            EndPoint endPoint = SelectorManager.this.newEndPoint(channel, this, selectionKey);
            SelectorManager.this.endPointOpened(endPoint);
            Connection connection = SelectorManager.this.newConnection(channel, endPoint, selectionKey.attachment());
            endPoint.setConnection(connection);
            SelectorManager.this.connectionOpened(connection);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created {}", new Object[]{endPoint});
            }
            return endPoint;
        }

        public void destroyEndPoint(EndPoint endPoint) {
            Connection connection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed {}", new Object[]{endPoint});
            }
            if ((connection = endPoint.getConnection()) != null) {
                SelectorManager.this.connectionClosed(connection);
            }
            SelectorManager.this.endPointClosed(endPoint);
        }

        public String dump() {
            return ContainerLifeCycle.dump((Dumpable)this);
        }

        public void dump(Appendable out, String indent) throws IOException {
            Selector selector;
            StackTraceElement[] trace;
            out.append(String.valueOf(this)).append(" id=").append(String.valueOf(this._id)).append("\n");
            Thread selecting = this._thread;
            Object where = "not selecting";
            StackTraceElement[] stackTraceElementArray = trace = selecting == null ? null : selecting.getStackTrace();
            if (trace != null) {
                for (StackTraceElement t : trace) {
                    if (!t.getClassName().startsWith("org.eclipse.jetty.")) continue;
                    where = t;
                    break;
                }
            }
            if ((selector = this._selector) != null && selector.isOpen()) {
                ArrayList<String> dump = new ArrayList<String>(selector.keys().size() * 2);
                dump.add((String)where);
                DumpKeys dumpKeys = new DumpKeys(dump);
                this.submit(dumpKeys);
                dumpKeys.await(5L, TimeUnit.SECONDS);
                ContainerLifeCycle.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{dump});
            }
        }

        public void dumpKeysState(List<Object> dumps) {
            Selector selector = this._selector;
            Set<SelectionKey> keys = selector.keys();
            dumps.add(selector + " keys=" + keys.size());
            for (SelectionKey key : keys) {
                if (key.isValid()) {
                    dumps.add(key.attachment() + " iOps=" + key.interestOps() + " rOps=" + key.readyOps());
                    continue;
                }
                dumps.add(key.attachment() + " iOps=-1 rOps=-1");
            }
        }

        public String toString() {
            Selector selector = this._selector;
            return String.format("%s keys=%d selected=%d", super.toString(), selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1);
        }

        private class Accept
        implements Runnable {
            private final SocketChannel channel;
            private final Object attachment;

            private Accept(SocketChannel channel, Object attachment) {
                this.channel = channel;
                this.attachment = attachment;
            }

            @Override
            public void run() {
                try {
                    SelectionKey key = this.channel.register(ManagedSelector.this._selector, 0, this.attachment);
                    EndPoint endpoint = ManagedSelector.this.createEndPoint(this.channel, key);
                    key.attach(endpoint);
                }
                catch (Throwable x) {
                    ManagedSelector.this.closeNoExceptions(this.channel);
                    LOG.debug(x);
                }
            }
        }

        private class Acceptor
        implements Runnable {
            private final ServerSocketChannel _channel;

            public Acceptor(ServerSocketChannel channel) {
                this._channel = channel;
            }

            @Override
            public void run() {
                try {
                    SelectionKey key = this._channel.register(ManagedSelector.this._selector, 16, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} acceptor={}", new Object[]{this, key});
                    }
                }
                catch (Throwable x) {
                    ManagedSelector.this.closeNoExceptions(this._channel);
                    LOG.warn(x);
                }
            }
        }

        private class Connect
        implements Runnable {
            private final AtomicBoolean failed = new AtomicBoolean();
            private final SocketChannel channel;
            private final Object attachment;
            private final Scheduler.Task timeout;

            private Connect(SocketChannel channel, Object attachment) {
                this.channel = channel;
                this.attachment = attachment;
                this.timeout = SelectorManager.this.scheduler.schedule((Runnable)new ConnectTimeout(this), SelectorManager.this.getConnectTimeout(), TimeUnit.MILLISECONDS);
            }

            @Override
            public void run() {
                try {
                    this.channel.register(ManagedSelector.this._selector, 8, this);
                }
                catch (Throwable x) {
                    this.failed(x);
                }
            }

            private void failed(Throwable failure) {
                if (this.failed.compareAndSet(false, true)) {
                    this.timeout.cancel();
                    ManagedSelector.this.closeNoExceptions(this.channel);
                    SelectorManager.this.connectionFailed(this.channel, failure, this.attachment);
                }
            }
        }

        private class ConnectTimeout
        implements Runnable {
            private final Connect connect;

            private ConnectTimeout(Connect connect) {
                this.connect = connect;
            }

            @Override
            public void run() {
                SocketChannel channel = this.connect.channel;
                if (channel.isConnectionPending()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Channel {} timed out while connecting, closing it", new Object[]{channel});
                    }
                    this.connect.failed(new SocketTimeoutException("Connect Timeout"));
                }
            }
        }

        private class DumpKeys
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final List<Object> _dumps;

            private DumpKeys(List<Object> dumps) {
                this._dumps = dumps;
            }

            @Override
            public void run() {
                ManagedSelector.this.dumpKeysState(this._dumps);
                this.latch.countDown();
            }

            public boolean await(long timeout, TimeUnit unit) {
                try {
                    return this.latch.await(timeout, unit);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }

        private class EndPointCloser
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);
            private final EndPoint endPoint;

            private EndPointCloser(EndPoint endPoint) {
                this.endPoint = endPoint;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ManagedSelector.this.closeNoExceptions(this.endPoint.getConnection());
                }
                finally {
                    this.latch.countDown();
                }
            }

            private boolean await(long timeout) {
                try {
                    return this.latch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }

        private class Stop
        implements Runnable {
            private final CountDownLatch latch = new CountDownLatch(1);

            private Stop() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    for (SelectionKey key : ManagedSelector.this._selector.keys()) {
                        Object attachment = key.attachment();
                        if (!(attachment instanceof EndPoint)) continue;
                        EndPointCloser closer = new EndPointCloser((EndPoint)attachment);
                        SelectorManager.this.execute(closer);
                        closer.await(ManagedSelector.this.getStopTimeout());
                    }
                    ManagedSelector.this.closeNoExceptions(ManagedSelector.this._selector);
                }
                finally {
                    this.latch.countDown();
                }
            }

            public boolean await(long timeout) {
                try {
                    return this.latch.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException x) {
                    return false;
                }
            }
        }
    }

    public static interface SelectableEndPoint
    extends EndPoint {
        public void onSelected();
    }

    private static enum State {
        CHANGES,
        MORE_CHANGES,
        SELECT,
        WAKEUP,
        PROCESS;

    }
}

