/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.SessionId;

public class CreateLeaseSet2Message
extends CreateLeaseSetMessage {
    public static final int MESSAGE_TYPE = 40;
    private List<PrivateKey> _privateKeys;

    public List<PrivateKey> getPrivateKeys() {
        if (this._privateKeys != null) {
            return this._privateKeys;
        }
        PrivateKey pk = this.getPrivateKey();
        if (pk != null) {
            return Collections.singletonList(pk);
        }
        return null;
    }

    public void addPrivateKey(PrivateKey key) {
        PrivateKey pk = this.getPrivateKey();
        if (pk == null) {
            this.setPrivateKey(key);
        } else {
            if (this._privateKeys == null) {
                this._privateKeys = new ArrayList<PrivateKey>(4);
                this._privateKeys.add(pk);
            }
            this._privateKeys.add(key);
        }
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int type = in.read();
            if (type == 1) {
                this._leaseSet = new LeaseSet();
            } else if (type == 3) {
                this._leaseSet = new LeaseSet2();
            } else if (type == 5) {
                this._leaseSet = new EncryptedLeaseSet();
            } else if (type == 7) {
                this._leaseSet = new MetaLeaseSet();
            } else {
                if (type == -1) {
                    throw new EOFException("EOF reading LS type");
                }
                throw new I2CPMessageException("Unsupported Leaseset type: " + type);
            }
            this._leaseSet.readBytes(in);
            if (type != 7) {
                SigType stype = this._leaseSet.getSignature().getType();
                if (stype == null) {
                    throw new I2CPMessageException("Unsupported sig type");
                }
                this._signingPrivateKey = new SigningPrivateKey(stype);
                this._signingPrivateKey.readBytes(in);
                if (type == 3 || type == 5) {
                    LeaseSet2 ls2 = (LeaseSet2)this._leaseSet;
                    List<PublicKey> pks = ls2.getEncryptionKeys();
                    if (pks == null) {
                        throw new I2CPMessageException("TODO decrypt");
                    }
                    for (PublicKey pk : pks) {
                        EncType etype = pk.getType();
                        if (etype == null) {
                            throw new I2CPMessageException("Unsupported encryption type");
                        }
                        PrivateKey priv = new PrivateKey(etype);
                        priv.readBytes(in);
                        this.addPrivateKey(priv);
                    }
                } else {
                    EncType etype = this._leaseSet.getEncryptionKey().getType();
                    if (etype == null) {
                        throw new I2CPMessageException("Unsupported encryption type");
                    }
                    this._privateKey = new PrivateKey(etype);
                    this._privateKey.readBytes(in);
                }
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error reading the CreateLeaseSetMessage", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._sessionId == null || this._leaseSet == null || this._leaseSet.getType() != 7 && (this._signingPrivateKey == null || this._privateKey == null)) {
            throw new I2CPMessageException("Unable to write out the message as there is not enough data");
        }
        int size = 5 + this._leaseSet.size() + this._signingPrivateKey.length() + this._privateKey.length();
        ByteArrayOutputStream os = new ByteArrayOutputStream(size);
        try {
            this._sessionId.writeBytes(os);
            os.write(this._leaseSet.getType());
            this._leaseSet.writeBytes(os);
            if (this._leaseSet.getType() != 7) {
                this._signingPrivateKey.writeBytes(os);
                this._privateKey.writeBytes(os);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("Error writing out the message data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 40;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[CreateLeaseSet2Message: ");
        buf.append("\n\tLeaseSet: ").append(this.getLeaseSet());
        buf.append("\n\tSigningPrivateKey: ").append(this.getSigningPrivateKey());
        buf.append("\n\tPrivateKey: ").append(this.getPrivateKey());
        buf.append("\n\tSessionId: ").append(this.getSessionId());
        buf.append("]");
        return buf.toString();
    }
}

