/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import com.nettgryppa.security.HashCash;
import gnu.getopt.Getopt;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.naming.HostTxtEntry;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SigType;
import net.i2p.data.Base32;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.VerifiedDestination;
import net.i2p.util.OrderedProperties;
import net.i2p.util.RandomSource;
import net.i2p.util.SecureFileOutputStream;

public class PrivateKeyFile {
    private static final int HASH_EFFORT = 20;
    protected final File file;
    private final I2PClient client;
    protected Destination dest;
    protected PrivateKey privKey;
    protected SigningPrivateKey signingPrivKey;
    private long _offlineExpiration;
    private Signature _offlineSignature;
    private SigningPrivateKey _transientSigningPrivKey;
    private SigningPublicKey _transientSigningPubKey;

    public static void main(String[] args) {
        int reqd;
        int c;
        int hashEffort = 20;
        String stype = null;
        String ttype = null;
        String hostname = null;
        String offline = null;
        int days = 365;
        int mode = 0;
        boolean error = false;
        Getopt g = new Getopt("pkf", args, "t:nuxhse:c:a:o:d:r:");
        block26: while ((c = g.getopt()) != -1) {
            switch (c) {
                case 99: {
                    stype = g.getOptarg();
                    continue block26;
                }
                case 116: {
                    stype = g.getOptarg();
                }
                case 104: 
                case 110: 
                case 115: 
                case 117: 
                case 120: {
                    if (mode == 0) {
                        mode = c;
                        continue block26;
                    }
                    error = true;
                    continue block26;
                }
                case 97: {
                    hostname = g.getOptarg();
                    if (mode == 0) {
                        mode = c;
                        continue block26;
                    }
                    error = true;
                    continue block26;
                }
                case 111: {
                    offline = g.getOptarg();
                    if (mode == 0) {
                        mode = c;
                        continue block26;
                    }
                    error = true;
                    continue block26;
                }
                case 101: {
                    hashEffort = Integer.parseInt(g.getOptarg());
                    continue block26;
                }
                case 100: {
                    days = Integer.parseInt(g.getOptarg());
                    continue block26;
                }
                case 114: {
                    ttype = g.getOptarg();
                    continue block26;
                }
            }
            error = true;
        }
        int remaining = args.length - g.getOptind();
        int n = reqd = mode == 115 ? 2 : 1;
        if (error || remaining != reqd) {
            PrivateKeyFile.usage();
            System.exit(1);
        }
        String filearg = args[g.getOptind()];
        I2PClient client = I2PClientFactory.createClient();
        try {
            Destination d;
            SigType type;
            String orig = offline != null ? offline : filearg;
            File f = new File(orig);
            boolean exists = f.exists();
            PrivateKeyFile pkf = new PrivateKeyFile(f, client);
            if (stype != null) {
                type = SigType.parseSigType(stype);
                if (type == null) {
                    throw new IllegalArgumentException("Signature type " + stype + " is not supported");
                }
                d = pkf.createIfAbsent(type);
            } else {
                d = pkf.createIfAbsent();
            }
            if (exists) {
                System.out.println("Original Destination:");
            } else {
                System.out.println("Created Destination:");
            }
            System.out.println(pkf);
            PrivateKeyFile.verifySignature(d);
            switch (mode) {
                case 0: {
                    break;
                }
                case 110: {
                    pkf.setCertType(0);
                    System.out.println("New destination with null cert is:");
                    break;
                }
                case 117: {
                    pkf.setCertType(99);
                    System.out.println("New destination with unknown cert is:");
                    break;
                }
                case 120: {
                    pkf.setCertType(2);
                    System.out.println("New destination with hidden cert is:");
                    break;
                }
                case 104: {
                    System.out.println("Estimating hashcash generation time, stand by...");
                    System.out.println(PrivateKeyFile.estimateHashCashTime(hashEffort));
                    pkf.setHashCashCert(hashEffort);
                    System.out.println("New destination with hashcash cert is:");
                    break;
                }
                case 115: {
                    PrivateKeyFile pkf2 = new PrivateKeyFile(args[g.getOptind() + 1]);
                    pkf.setSignedCert(pkf2);
                    System.out.println("New destination with signed cert is:");
                    break;
                }
                case 116: {
                    type = SigType.parseSigType(stype);
                    if (type == null) {
                        throw new IllegalArgumentException("Signature type " + stype + " is not supported");
                    }
                    pkf.setKeyCert(type);
                    System.out.println("New destination with key cert is:");
                    break;
                }
                case 97: {
                    OrderedProperties props = new OrderedProperties();
                    HostTxtEntry he = new HostTxtEntry(hostname, d.toBase64(), props);
                    he.sign(pkf.getSigningPrivKey());
                    System.out.println("Addressbook Authentication String:");
                    OutputStreamWriter out = new OutputStreamWriter(System.out);
                    he.write(out);
                    out.flush();
                    System.out.println("");
                    return;
                }
                case 111: {
                    SimpleDataStructure[] signingKeys;
                    File f3 = new File(filearg);
                    SigType type2 = pkf.getSigningPrivKey().getType();
                    byte[] dbytes = new byte[type2.getPrivkeyLen()];
                    SigningPrivateKey dummy = new SigningPrivateKey(type2, dbytes);
                    PrivateKeyFile pkf2 = new PrivateKeyFile(f3, pkf.getDestination(), pkf.getPrivKey(), dummy);
                    SigType tstype = SigType.EdDSA_SHA512_Ed25519;
                    if (ttype != null && (tstype = SigType.parseSigType(ttype)) == null) {
                        throw new I2PException("Bad or unsupported -r option: " + ttype);
                    }
                    try {
                        signingKeys = KeyGenerator.getInstance().generateSigningKeys(tstype);
                    }
                    catch (GeneralSecurityException gse) {
                        throw new RuntimeException("keygen fail", gse);
                    }
                    SigningPublicKey tSigningPubKey = (SigningPublicKey)signingKeys[0];
                    SigningPrivateKey tSigningPrivKey = (SigningPrivateKey)signingKeys[1];
                    long expires = System.currentTimeMillis() + (long)(days * 24 * 60 * 60) * 1000L;
                    byte[] data = new byte[6 + tSigningPubKey.length()];
                    DataHelper.toLong(data, 0, 4, expires / 1000L);
                    DataHelper.toLong(data, 4, 2, tstype.getCode());
                    System.arraycopy(tSigningPubKey.getData(), 0, data, 6, tSigningPubKey.length());
                    Signature sign = DSAEngine.getInstance().sign(data, pkf.getSigningPrivKey());
                    if (sign == null) {
                        throw new I2PException("Sig fail");
                    }
                    pkf2.setOfflineData(expires, tSigningPubKey, sign, tSigningPrivKey);
                    System.out.println("New destination with offline signature is:");
                    System.out.println(pkf2);
                    pkf2.write();
                    return;
                }
                default: {
                    PrivateKeyFile.usage();
                    return;
                }
            }
            if (mode != 0) {
                System.out.println(pkf);
                pkf.write();
                PrivateKeyFile.verifySignature(pkf.getDestination());
            }
        }
        catch (I2PException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: PrivateKeyFile filename (generates if nonexistent, then prints)\n   \ncertificate options:\n      -h                   (generates if nonexistent, adds hashcash cert)\n      -n                   (changes to null cert)\n      -s signwithdestfile  (generates if nonexistent, adds cert signed by 2nd dest)\n      -u                   (changes to unknown cert)\n      -x                   (changes to hidden cert)\n   \nother options:\n      -a example.i2p       (generate addressbook authentication string)\n      -d days              (specify expiration in days of offline sig, default 365)\n      -c sigtype           (specify sig type of destination)\n      -e effort            (specify HashCash effort instead of default 20)\n      -o offlinedestfile   (generate the online key file using the offline key file specified)\n      -r sigtype           (specify sig type of transient key, default Ed25519)\n      -t sigtype           (changes to KeyCertificate of the given sig type)\n");
    }

    public PrivateKeyFile(String file) {
        this(new File(file), I2PClientFactory.createClient());
    }

    public PrivateKeyFile(File file) {
        this(file, I2PClientFactory.createClient());
    }

    public PrivateKeyFile(File file, I2PClient client) {
        this.file = file;
        this.client = client;
    }

    public PrivateKeyFile(File file, I2PSession session) {
        this(file, session.getMyDestination(), session.getDecryptionKey(), session.getPrivateKey());
    }

    public PrivateKeyFile(File file, Destination dest, PrivateKey pk, SigningPrivateKey spk) {
        if (dest.getSigningPublicKey().getType() != spk.getType()) {
            throw new IllegalArgumentException("Signing key type mismatch");
        }
        this.file = file;
        this.client = null;
        this.dest = dest;
        this.privKey = pk;
        this.signingPrivKey = spk;
    }

    public PrivateKeyFile(File file, PublicKey pubkey, SigningPublicKey spubkey, Certificate cert, PrivateKey pk, SigningPrivateKey spk) {
        this(file, pubkey, spubkey, cert, pk, spk, null);
    }

    public PrivateKeyFile(File file, PublicKey pubkey, SigningPublicKey spubkey, Certificate cert, PrivateKey pk, SigningPrivateKey spk, byte[] padding) {
        if (spubkey.getType() != spk.getType()) {
            throw new IllegalArgumentException("Signing key type mismatch");
        }
        this.file = file;
        this.client = null;
        this.dest = new Destination();
        this.dest.setPublicKey(pubkey);
        this.dest.setSigningPublicKey(spubkey);
        this.dest.setCertificate(cert);
        if (padding != null) {
            this.dest.setPadding(padding);
        }
        this.privKey = pk;
        this.signingPrivKey = spk;
    }

    public PrivateKeyFile(InputStream in) throws I2PSessionException {
        this("/dev/null");
        I2PSession s = this.client.createSession(in, new Properties());
        this.dest = s.getMyDestination();
        this.privKey = s.getDecryptionKey();
        this.signingPrivKey = s.getPrivateKey();
    }

    public Destination createIfAbsent() throws I2PException, IOException, DataFormatException {
        return this.createIfAbsent(I2PClient.DEFAULT_SIGTYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination createIfAbsent(SigType type) throws I2PException, IOException, DataFormatException {
        if (!this.file.exists()) {
            SecureFileOutputStream out = null;
            try {
                out = new SecureFileOutputStream(this.file);
                if (this.client != null) {
                    this.client.createDestination((OutputStream)out, type);
                } else {
                    this.write();
                }
            }
            finally {
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.getDestination();
    }

    public Destination getDestination() throws I2PSessionException, IOException, DataFormatException {
        I2PSession s;
        if (this.dest == null && (s = this.open()) != null) {
            this.dest = new VerifiedDestination(s.getMyDestination());
            this.privKey = s.getDecryptionKey();
            this.signingPrivKey = s.getPrivateKey();
            if (s.isOffline()) {
                this._offlineExpiration = s.getOfflineExpiration();
                this._transientSigningPubKey = s.getTransientSigningPublicKey();
                this._offlineSignature = s.getOfflineSignature();
                this._transientSigningPrivKey = this.signingPrivKey;
                SigType type = this.dest.getSigningPublicKey().getType();
                byte[] dbytes = new byte[type.getPrivkeyLen()];
                this.signingPrivKey = new SigningPrivateKey(type, dbytes);
            }
        }
        return this.dest;
    }

    public void setDestination(Destination d) {
        this.dest = d;
    }

    public Certificate setCertType(int t) {
        if (this.dest == null) {
            throw new IllegalArgumentException("Dest is null");
        }
        Certificate c = new Certificate();
        c.setCertificateType(t);
        Destination newdest = new Destination();
        newdest.setPublicKey(this.dest.getPublicKey());
        newdest.setSigningPublicKey(this.dest.getSigningPublicKey());
        newdest.setCertificate(c);
        this.dest = newdest;
        return c;
    }

    public Certificate setKeyCert(SigType type) {
        SimpleDataStructure[] signingKeys;
        if (type == SigType.DSA_SHA1) {
            return this.setCertType(0);
        }
        if (this.dest == null) {
            throw new IllegalArgumentException("Dest is null");
        }
        KeyCertificate c = new KeyCertificate(type);
        try {
            signingKeys = KeyGenerator.getInstance().generateSigningKeys(type);
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("keygen fail", gse);
        }
        SigningPublicKey signingPubKey = (SigningPublicKey)signingKeys[0];
        this.signingPrivKey = (SigningPrivateKey)signingKeys[1];
        Destination newdest = new Destination();
        newdest.setPublicKey(this.dest.getPublicKey());
        newdest.setSigningPublicKey(signingPubKey);
        int len = type.getPubkeyLen();
        if (len < 128) {
            byte[] pad = new byte[128 - len];
            RandomSource.getInstance().nextBytes(pad);
            newdest.setPadding(pad);
        } else if (len > 128) {
            System.arraycopy(signingPubKey.getData(), 128, c.getPayload(), 4, len - 128);
        }
        newdest.setCertificate(c);
        this.dest = newdest;
        return c;
    }

    public Certificate setHashCashCert(int effort) {
        HashCash hc;
        Certificate c = this.setCertType(1);
        long begin = System.currentTimeMillis();
        System.out.println("Starting hashcash generation now...");
        String resource = this.dest.getPublicKey().toBase64() + this.dest.getSigningPublicKey().toBase64();
        try {
            hc = HashCash.mintCash(resource, effort);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        System.out.println("Generation took: " + DataHelper.formatDuration(System.currentTimeMillis() - begin));
        System.out.println("Full Hashcash is: " + hc);
        String hcs = hc.toString();
        int end1 = 0;
        for (int i = 0; i < 3; ++i) {
            if ((end1 = 1 + hcs.indexOf(58, end1)) >= 0) continue;
            System.out.println("Bad hashcash");
            return null;
        }
        int start2 = hcs.indexOf(58, end1);
        if (start2 < 0) {
            System.out.println("Bad hashcash");
            return null;
        }
        hcs = hcs.substring(0, end1) + hcs.substring(start2);
        System.out.println("Short Hashcash is: " + hcs);
        c.setPayload(DataHelper.getUTF8(hcs));
        return c;
    }

    public Certificate setSignedCert(PrivateKeyFile pkf2) {
        Destination d2;
        Certificate c = this.setCertType(3);
        try {
            d2 = pkf2.getDestination();
        }
        catch (I2PException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        if (d2 == null) {
            return null;
        }
        SigningPrivateKey spk2 = pkf2.getSigningPrivKey();
        System.out.println("Signing With Dest:");
        System.out.println(pkf2.toString());
        int len = PublicKey.KEYSIZE_BYTES + SigningPublicKey.KEYSIZE_BYTES;
        byte[] data = new byte[len];
        System.arraycopy(this.dest.getPublicKey().getData(), 0, data, 0, PublicKey.KEYSIZE_BYTES);
        System.arraycopy(this.dest.getSigningPublicKey().getData(), 0, data, PublicKey.KEYSIZE_BYTES, SigningPublicKey.KEYSIZE_BYTES);
        byte[] payload = new byte[32 + Signature.SIGNATURE_BYTES];
        Signature sign = DSAEngine.getInstance().sign(data, spk2);
        if (sign == null) {
            return null;
        }
        byte[] sig = sign.getData();
        System.arraycopy(sig, 0, payload, 0, Signature.SIGNATURE_BYTES);
        byte[] h2 = d2.calculateHash().getData();
        System.arraycopy(h2, 0, payload, Signature.SIGNATURE_BYTES, 32);
        c.setCertificateType(3);
        c.setPayload(payload);
        return c;
    }

    public PrivateKey getPrivKey() {
        try {
            this.getDestination();
        }
        catch (Exception e) {
            return null;
        }
        return this.privKey;
    }

    public SigningPrivateKey getSigningPrivKey() {
        try {
            this.getDestination();
        }
        catch (Exception e) {
            return null;
        }
        return this.signingPrivKey;
    }

    private static boolean isOffline(SigningPrivateKey spk) {
        byte b = 0;
        byte[] data = spk.getData();
        for (int i = 0; i < data.length; ++i) {
            b = (byte)(b | data[i]);
        }
        return b == 0;
    }

    public boolean isOffline() {
        return this._offlineSignature != null;
    }

    public void setOfflineData(long expires, SigningPublicKey transientPub, Signature sig, SigningPrivateKey transientPriv) {
        if (!PrivateKeyFile.isOffline(this.signingPrivKey)) {
            SigType type = this.getSigningPrivKey().getType();
            byte[] dbytes = new byte[type.getPrivkeyLen()];
            this.signingPrivKey = new SigningPrivateKey(type, dbytes);
        }
        this._offlineExpiration = expires;
        this._transientSigningPubKey = transientPub;
        this._offlineSignature = sig;
        this._transientSigningPrivKey = transientPriv;
    }

    public long getOfflineExpiration() {
        return this._offlineExpiration;
    }

    public Signature getOfflineSignature() {
        return this._offlineSignature;
    }

    public SigningPublicKey getTransientSigningPubKey() {
        try {
            this.getDestination();
        }
        catch (Exception e) {
            return null;
        }
        return this._transientSigningPubKey;
    }

    public SigningPrivateKey getTransientSigningPrivKey() {
        try {
            this.getDestination();
        }
        catch (Exception e) {
            return null;
        }
        return this._transientSigningPrivKey;
    }

    public I2PSession open() throws I2PSessionException, IOException {
        return this.open(new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public I2PSession open(Properties opts) throws I2PSessionException, IOException {
        InputStream in = null;
        try {
            I2PSession s;
            in = new BufferedInputStream(new FileInputStream(this.file));
            I2PSession i2PSession = s = this.client.createSession(in, opts);
            return i2PSession;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void write() throws IOException, DataFormatException {
        SecureFileOutputStream out = null;
        try {
            out = new SecureFileOutputStream(this.file);
            this.dest.writeBytes(out);
            this.privKey.writeBytes(out);
            this.signingPrivKey.writeBytes(out);
            if (this.isOffline()) {
                DataHelper.writeLong(out, 4, this._offlineExpiration / 1000L);
                DataHelper.writeLong(out, 2, this._transientSigningPubKey.getType().getCode());
                this._transientSigningPubKey.writeBytes(out);
                this._offlineSignature.writeBytes(out);
                this._transientSigningPrivKey.writeBytes(out);
            }
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean validateKeyPairs() {
        try {
            if (!this.dest.getPublicKey().equals(KeyGenerator.getPublicKey(this.privKey))) {
                return false;
            }
            return this.dest.getSigningPublicKey().equals(KeyGenerator.getSigningPublicKey(this.signingPrivKey));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder(128);
        s.append("Dest: ");
        s.append(this.dest != null ? this.dest.toBase64() : "null");
        s.append("\nB32: ");
        s.append(this.dest != null ? this.dest.toBase32() : "null");
        s.append("\nContains: ");
        s.append(this.dest);
        s.append("\nPrivate Key: ");
        s.append(this.privKey);
        s.append("\nSigining Private Key: ");
        if (this.isOffline()) {
            s.append("offline\nOffline Signature Expires: ");
            s.append(new Date(this.getOfflineExpiration()));
            s.append("\nTransient Signing Public Key: ");
            s.append(this._transientSigningPubKey);
            s.append("\nOffline Signature: ");
            s.append(this._offlineSignature);
            s.append("\nTransient Signing Private Key: ");
            s.append(this._transientSigningPrivKey);
        } else {
            s.append(this.signingPrivKey);
            s.append("\n");
        }
        return s.toString();
    }

    public static String estimateHashCashTime(int hashEffort) {
        if (hashEffort <= 0 || hashEffort > 160) {
            return "Bad HashCash value: " + hashEffort;
        }
        long low = Long.MAX_VALUE;
        try {
            low = HashCash.estimateTime(hashEffort);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return "It is estimated that generating a HashCash Certificate with value " + hashEffort + " for the Destination will take " + (low < 86400000000L ? "approximately " + DataHelper.formatDuration(low) + " to " + DataHelper.formatDuration(4L * low) : "longer than three years!");
    }

    public static boolean verifySignature(Destination d) {
        if (d.getCertificate().getCertificateType() != 3) {
            return false;
        }
        int len = PublicKey.KEYSIZE_BYTES + SigningPublicKey.KEYSIZE_BYTES;
        byte[] data = new byte[len];
        System.arraycopy(d.getPublicKey().getData(), 0, data, 0, PublicKey.KEYSIZE_BYTES);
        System.arraycopy(d.getSigningPublicKey().getData(), 0, data, PublicKey.KEYSIZE_BYTES, SigningPublicKey.KEYSIZE_BYTES);
        Signature sig = new Signature();
        byte[] payload = d.getCertificate().getPayload();
        Hash signerHash = null;
        if (payload == null) {
            System.out.println("Bad signed cert - no payload");
            return false;
        }
        if (payload.length == Signature.SIGNATURE_BYTES) {
            sig.setData(payload);
        } else if (payload.length == Certificate.CERTIFICATE_LENGTH_SIGNED_WITH_HASH) {
            byte[] pl = new byte[Signature.SIGNATURE_BYTES];
            System.arraycopy(payload, 0, pl, 0, Signature.SIGNATURE_BYTES);
            sig.setData(pl);
            byte[] hash = new byte[32];
            System.arraycopy(payload, Signature.SIGNATURE_BYTES, hash, 0, 32);
            signerHash = new Hash(hash);
            System.out.println("Destination is signed by " + Base32.encode(hash) + ".b32.i2p");
        } else {
            System.out.println("Bad signed cert - length = " + payload.length);
            return false;
        }
        String[] filenames = new String[]{"privatehosts.txt", "userhosts.txt", "hosts.txt"};
        int tried = 0;
        for (int i = 0; i < filenames.length; ++i) {
            Properties hosts = new Properties();
            try {
                File f = new File(filenames[i]);
                if (!f.exists() || !f.canRead()) continue;
                DataHelper.loadProps(hosts, f, true);
                int sz = hosts.size();
                if (sz > 0) {
                    tried += sz;
                    if (signerHash == null) {
                        System.out.println("Attempting to verify using " + sz + " hosts, this may take a while");
                    }
                }
                for (Map.Entry<Object, Object> entry : hosts.entrySet()) {
                    String s = (String)entry.getValue();
                    Destination signer = new Destination(s);
                    if (signerHash != null && !signer.calculateHash().equals(signerHash)) continue;
                    if (PrivateKeyFile.checkSignature(sig, data, signer.getSigningPublicKey())) {
                        System.out.println("Good signature from: " + entry.getKey());
                        return true;
                    }
                    if (signerHash == null) continue;
                    System.out.println("Bad signature from: " + entry.getKey());
                }
                continue;
            }
            catch (DataFormatException dataFormatException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (tried > 0) {
            System.out.println("No valid signer found");
        } else {
            System.out.println("No addressbooks found to valididate signer");
        }
        return false;
    }

    public static boolean checkSignature(Signature s, byte[] data, SigningPublicKey spk) {
        return DSAEngine.getInstance().verifySignature(s, data, spk);
    }
}

