/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.LeaseSet2;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.Clock;

public class EncryptedLeaseSet
extends LeaseSet2 {
    private byte[] _encryptedData;
    private LeaseSet2 _decryptedLS2;
    private Hash __calculatedHash;
    private static final int MIN_ENCRYPTED_SIZE = 24;
    private static final int MAX_ENCRYPTED_SIZE = 4096;

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public int getLeaseCount() {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLeaseCount() : 0;
    }

    @Override
    public Lease getLease(int index) {
        return this._decryptedLS2 != null ? this._decryptedLS2.getLease(index) : null;
    }

    @Override
    public void setDestination(Destination dest) {
        super.setDestination(dest);
        SigningPublicKey spk = dest.getSigningPublicKey();
        if (spk.getType() != SigType.EdDSA_SHA512_Ed25519) {
            throw new IllegalArgumentException();
        }
        this._signingKey = EncryptedLeaseSet.blind(spk, null);
    }

    private static SigningPublicKey blind(SigningPublicKey spk, SigningPrivateKey priv) {
        return spk;
    }

    @Override
    protected SigningPublicKey getSigningPublicKey() {
        return this._signingKey;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._signingKey != null) {
            throw new IllegalStateException();
        }
        this.readHeader(in);
        int encryptedSize = (int)DataHelper.readLong(in, 2);
        if (encryptedSize < 24 || encryptedSize > 4096) {
            throw new DataFormatException("bad LS size: " + encryptedSize);
        }
        this._encryptedData = new byte[encryptedSize];
        DataHelper.read(in, this._encryptedData);
        SigType type = this.isOffline() ? this._transientSigningPublicKey.getType() : this._signingKey.getType();
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    protected void writeBytesWithoutSig(OutputStream out) throws DataFormatException, IOException {
        if (this._signingKey == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this.writeHeader(out);
        if (this._encryptedData == null) {
            this.encrypt(null);
        }
        DataHelper.writeLong(out, 2, this._encryptedData.length);
        out.write(this._encryptedData);
    }

    @Override
    public boolean verifyOfflineSignature() {
        return this.verifyOfflineSignature(this._signingKey);
    }

    @Override
    protected void readHeader(InputStream in) throws DataFormatException, IOException {
        int stype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(stype);
        if (type == null) {
            throw new DataFormatException("unknown key type " + stype);
        }
        this._signingKey = new SigningPublicKey(type);
        this._signingKey.readBytes(in);
        this._published = DataHelper.readLong(in, 4) * 1000L;
        this._expires = this._published + DataHelper.readLong(in, 2) * 1000L;
        this._flags = (int)DataHelper.readLong(in, 2);
        if (this.isOffline()) {
            this.readOfflineBytes(in);
        }
    }

    @Override
    protected void writeHeader(OutputStream out) throws DataFormatException, IOException {
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._signingKey.writeBytes(out);
        if (this._published <= 0L) {
            this._published = Clock.getInstance().now();
        }
        DataHelper.writeLong(out, 4, this._published / 1000L);
        DataHelper.writeLong(out, 2, (this._expires - this._published) / 1000L);
        DataHelper.writeLong(out, 2, this._flags);
        if (this.isOffline()) {
            this.writeOfflineBytes(out);
        }
    }

    @Override
    protected void readOfflineBytes(InputStream in) throws DataFormatException, IOException {
        this._transientExpires = DataHelper.readLong(in, 4) * 1000L;
        int itype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(itype);
        if (type == null) {
            throw new DataFormatException("Unknown sig type " + itype);
        }
        this._transientSigningPublicKey = new SigningPublicKey(type);
        this._transientSigningPublicKey.readBytes(in);
        SigType stype = this._signingKey.getType();
        this._offlineSignature = new Signature(stype);
        this._offlineSignature.readBytes(in);
    }

    @Override
    protected void writeOfflineBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._transientSigningPublicKey == null || this._offlineSignature == null) {
            throw new DataFormatException("No offline key/sig");
        }
        DataHelper.writeLong(out, 4, this._transientExpires / 1000L);
        DataHelper.writeLong(out, 2, this._signingKey.getType().getCode());
        this._transientSigningPublicKey.writeBytes(out);
        this._offlineSignature.writeBytes(out);
    }

    @Override
    public int size() {
        int rv = this._signingKey.length() + 12;
        rv = this._encryptedData != null ? (rv += this._encryptedData.length) : (rv += 99);
        if (this.isOffline()) {
            rv += 6 + this._transientSigningPublicKey.length() + this._offlineSignature.length();
        }
        return rv;
    }

    @Override
    public Hash getHash() {
        if (this.__calculatedHash == null) {
            if (this._signingKey == null) {
                throw new IllegalStateException();
            }
            int len = this._signingKey.length();
            byte[] b = new byte[2 + len];
            DataHelper.toLong(b, 0, 2, this._signingKey.getType().getCode());
            System.arraycopy(this._signingKey.getData(), 0, b, 2, len);
            this.__calculatedHash = SHA256Generator.getInstance().calculateHash(b);
        }
        return this.__calculatedHash;
    }

    @Override
    public void encrypt(SessionKey key) {
        if (this._encryptedData != null) {
            throw new IllegalStateException();
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(0);
            baos.write(3);
            super.writeHeader(baos);
            this.writeBody(baos);
        }
        catch (DataFormatException dfe) {
            throw new IllegalStateException("Error encrypting LS2", dfe);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Error encrypting LS2", ioe);
        }
        this._encryptedData = baos.toByteArray();
        int i = 0;
        while (i < this._encryptedData.length) {
            int n = i++;
            this._encryptedData[n] = (byte)(this._encryptedData[n] ^ 0x5A);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EncryptedLeaseSet)) {
            return false;
        }
        EncryptedLeaseSet ls = (EncryptedLeaseSet)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._signingKey, ls.getSigningKey());
    }

    @Override
    public int hashCode() {
        if (this._encryptionKey == null) {
            return 0;
        }
        return this._encryptionKey.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[EncryptedLeaseSet: ");
        buf.append("\n\tBlinded Key: ").append(this._signingKey);
        if (this.isOffline()) {
            buf.append("\n\tTransient Key: ").append(this._transientSigningPublicKey);
            buf.append("\n\tTransient Expires: ").append(new Date(this._transientExpires));
            buf.append("\n\tOffline Signature: ").append(this._offlineSignature);
        }
        buf.append("\n\tUnpublished? ").append(this.isUnpublished());
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        buf.append("\n\tExpires: ").append(new Date(this._expires));
        buf.append("]");
        return buf.toString();
    }
}

