/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import com.southernstorm.noise.crypto.x25519.Curve25519;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPairGeneratorSpi;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.ECConstants;
import net.i2p.crypto.ECUtil;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.i2p.crypto.provider.I2PProvider;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

public final class KeyGenerator {
    private final I2PAppContext _context;
    private static final int PBE_ROUNDS = 1000;
    private static final int PUBKEY_EXPONENT_SIZE_FULL = 2048;
    private static final int PUBKEY_EXPONENT_SIZE_SHORT = 226;
    private static final boolean DEFAULT_USE_LONG_EXPONENT;
    @Deprecated
    public static final int PUBKEY_EXPONENT_SIZE;
    private static final String PROP_LONG_EXPONENT = "crypto.elGamal.useLongKey";

    public KeyGenerator(I2PAppContext context) {
        this._context = context;
    }

    public static KeyGenerator getInstance() {
        return I2PAppContext.getGlobalContext().keyGenerator();
    }

    public SessionKey generateSessionKey() {
        SessionKey key = new SessionKey();
        byte[] data = new byte[32];
        this._context.random().nextBytes(data);
        key.setData(data);
        return key;
    }

    public SessionKey generateSessionKey(byte[] salt, byte[] passphrase) {
        byte[] salted = new byte[16 + passphrase.length];
        System.arraycopy(salt, 0, salted, 0, Math.min(salt.length, 16));
        System.arraycopy(passphrase, 0, salted, 16, passphrase.length);
        byte[] h = this._context.sha().calculateHash(salted).getData();
        for (int i = 1; i < 1000; ++i) {
            this._context.sha().calculateHash(h, 0, 32, h, 0);
        }
        return new SessionKey(h);
    }

    public boolean useLongElGamalExponent() {
        return this._context.getProperty(PROP_LONG_EXPONENT, DEFAULT_USE_LONG_EXPONENT);
    }

    public int getElGamalExponentSize() {
        return this.useLongElGamalExponent() ? 2048 : 226;
    }

    public Object[] generatePKIKeypair() {
        return this.generatePKIKeys();
    }

    public SimpleDataStructure[] generatePKIKeys() {
        NativeBigInteger a = new NativeBigInteger(this.getElGamalExponentSize(), this._context.random());
        BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
        SimpleDataStructure[] keys = new SimpleDataStructure[]{new net.i2p.data.PublicKey(), new net.i2p.data.PrivateKey()};
        try {
            keys[0].setData(SigUtil.rectify(aalpha, net.i2p.data.PublicKey.KEYSIZE_BYTES));
            keys[1].setData(SigUtil.rectify(a, net.i2p.data.PrivateKey.KEYSIZE_BYTES));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException(ike);
        }
        return keys;
    }

    public KeyPair generatePKIKeys(EncType type) {
        net.i2p.data.PrivateKey priv;
        net.i2p.data.PublicKey pub;
        switch (type) {
            case ELGAMAL_2048: {
                SimpleDataStructure[] keys = this.generatePKIKeys();
                pub = (net.i2p.data.PublicKey)keys[0];
                priv = (net.i2p.data.PrivateKey)keys[1];
                break;
            }
            case ECIES_X25519: {
                byte[] bpriv = new byte[32];
                do {
                    this._context.random().nextBytes(bpriv);
                } while (bpriv[31] == 0);
                byte[] bpub = new byte[32];
                Curve25519.eval(bpub, 0, bpriv, null);
                pub = new net.i2p.data.PublicKey(type, bpub);
                priv = new net.i2p.data.PrivateKey(type, bpriv);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm");
            }
        }
        return new KeyPair(pub, priv);
    }

    public static net.i2p.data.PublicKey getPublicKey(net.i2p.data.PrivateKey priv) {
        byte[] data;
        EncType type = priv.getType();
        switch (type) {
            case ELGAMAL_2048: {
                NativeBigInteger a = new NativeBigInteger(1, priv.toByteArray());
                BigInteger aalpha = CryptoConstants.elgg.modPow(a, CryptoConstants.elgp);
                try {
                    data = SigUtil.rectify(aalpha, net.i2p.data.PublicKey.KEYSIZE_BYTES);
                    break;
                }
                catch (InvalidKeyException ike) {
                    throw new IllegalArgumentException(ike);
                }
            }
            case ECIES_X25519: {
                data = new byte[32];
                Curve25519.eval(data, 0, priv.getData(), null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported algorithm");
            }
        }
        net.i2p.data.PublicKey pub = new net.i2p.data.PublicKey(type, data);
        return pub;
    }

    public Object[] generateSigningKeypair() {
        return this.generateSigningKeys();
    }

    public SimpleDataStructure[] generateSigningKeys() {
        SimpleDataStructure[] keys = new SimpleDataStructure[2];
        NativeBigInteger x = null;
        while ((x = new NativeBigInteger(160, this._context.random())).compareTo(CryptoConstants.dsaq) >= 0 || ((BigInteger)x).equals(BigInteger.ZERO)) {
        }
        BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
        keys[0] = new SigningPublicKey();
        keys[1] = new SigningPrivateKey();
        try {
            keys[0].setData(SigUtil.rectify(y, SigningPublicKey.KEYSIZE_BYTES));
            keys[1].setData(SigUtil.rectify(x, SigningPrivateKey.KEYSIZE_BYTES));
        }
        catch (InvalidKeyException ike) {
            throw new IllegalStateException(ike);
        }
        return keys;
    }

    public SimpleDataStructure[] generateSigningKeys(SigType type) throws GeneralSecurityException {
        java.security.KeyPair kp;
        KeyPairGeneratorSpi kpg;
        if (type == SigType.DSA_SHA1) {
            return this.generateSigningKeys();
        }
        if (type.getBaseAlgorithm() == SigAlgo.EdDSA) {
            kpg = new KeyPairGenerator();
            ((KeyPairGenerator)kpg).initialize(type.getParams(), (SecureRandom)this._context.random());
            kp = ((KeyPairGenerator)kpg).generateKeyPair();
        } else {
            kpg = java.security.KeyPairGenerator.getInstance(type.getBaseAlgorithm().getName());
            try {
                ((java.security.KeyPairGenerator)kpg).initialize(type.getParams(), (SecureRandom)this._context.random());
                kp = ((java.security.KeyPairGenerator)kpg).generateKeyPair();
            }
            catch (ProviderException pe) {
                Log log = this._context.logManager().getLog(KeyGenerator.class);
                String pname = ((java.security.KeyPairGenerator)kpg).getProvider().getName();
                if ("BC".equals(pname)) {
                    if (log.shouldLog(30)) {
                        log.warn("BC KPG failed for " + (Object)((Object)type), pe);
                    }
                    throw new GeneralSecurityException("BC KPG for " + (Object)((Object)type), pe);
                }
                if (!ECConstants.isBCAvailable()) {
                    throw new GeneralSecurityException(pname + " KPG failed for " + (Object)((Object)type), pe);
                }
                if (log.shouldLog(30)) {
                    log.warn(pname + " KPG failed for " + (Object)((Object)type) + ", trying BC");
                }
                try {
                    kpg = java.security.KeyPairGenerator.getInstance(type.getBaseAlgorithm().getName(), "BC");
                    ((java.security.KeyPairGenerator)kpg).initialize(type.getParams(), (SecureRandom)this._context.random());
                    kp = ((java.security.KeyPairGenerator)kpg).generateKeyPair();
                }
                catch (ProviderException pe2) {
                    if (log.shouldLog(30)) {
                        log.warn("BC KPG failed for " + (Object)((Object)type) + " also", pe2);
                    }
                    throw new GeneralSecurityException(pname + " KPG for " + (Object)((Object)type), pe);
                }
                catch (GeneralSecurityException gse) {
                    if (log.shouldLog(30)) {
                        log.warn("BC KPG failed for " + (Object)((Object)type) + " also", gse);
                    }
                    throw new GeneralSecurityException(pname + " KPG for " + (Object)((Object)type), pe);
                }
            }
        }
        PublicKey pubkey = kp.getPublic();
        PrivateKey privkey = kp.getPrivate();
        SimpleDataStructure[] keys = new SimpleDataStructure[]{SigUtil.fromJavaKey(pubkey, type), SigUtil.fromJavaKey(privkey, type)};
        return keys;
    }

    public static SigningPublicKey getSigningPublicKey(SigningPrivateKey priv) {
        SigType type = priv.getType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown type");
        }
        try {
            switch (type.getBaseAlgorithm()) {
                case DSA: {
                    NativeBigInteger x = new NativeBigInteger(1, priv.toByteArray());
                    BigInteger y = CryptoConstants.dsag.modPow(x, CryptoConstants.dsap);
                    SigningPublicKey pub = new SigningPublicKey();
                    pub.setData(SigUtil.rectify(y, SigningPublicKey.KEYSIZE_BYTES));
                    return pub;
                }
                case EC: {
                    ECPrivateKey ecpriv = SigUtil.toJavaECKey(priv);
                    BigInteger s = ecpriv.getS();
                    ECParameterSpec spec = (ECParameterSpec)type.getParams();
                    EllipticCurve curve = spec.getCurve();
                    ECPoint g = spec.getGenerator();
                    ECPoint w = ECUtil.scalarMult(g, s, curve);
                    ECPublicKeySpec ecks = new ECPublicKeySpec(w, ecpriv.getParams());
                    KeyFactory eckf = KeyFactory.getInstance("EC");
                    ECPublicKey ecpub = (ECPublicKey)eckf.generatePublic(ecks);
                    return SigUtil.fromJavaKey(ecpub, type);
                }
                case RSA: {
                    RSAPrivateKey rsapriv = SigUtil.toJavaRSAKey(priv);
                    BigInteger exp = ((RSAKeyGenParameterSpec)type.getParams()).getPublicExponent();
                    RSAPublicKeySpec rsaks = new RSAPublicKeySpec(rsapriv.getModulus(), exp);
                    KeyFactory rsakf = KeyFactory.getInstance("RSA");
                    RSAPublicKey rsapub = (RSAPublicKey)rsakf.generatePublic(rsaks);
                    return SigUtil.fromJavaKey(rsapub, type);
                }
                case EdDSA: {
                    EdDSAPrivateKey epriv = SigUtil.toJavaEdDSAKey(priv);
                    EdDSAPublicKey epub = new EdDSAPublicKey(new EdDSAPublicKeySpec(epriv.getA(), epriv.getParams()));
                    return SigUtil.fromJavaKey(epub, type);
                }
            }
            throw new IllegalArgumentException("Unsupported algorithm");
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException("Conversion failed", gse);
        }
    }

    public static void main(String[] args) {
        try {
            KeyGenerator.main2(args);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    private static void main2(String[] args) {
        List<SigType> toTest;
        RandomSource.getInstance().nextBoolean();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int runs = 200;
        if (args.length > 0) {
            toTest = new ArrayList<SigType>();
            for (int i = 0; i < args.length; ++i) {
                SigType type = SigType.parseSigType(args[i]);
                if (type != null) {
                    toTest.add(type);
                    continue;
                }
                System.out.println("Unknown type: " + args[i]);
            }
            if (toTest.isEmpty()) {
                System.out.println("No types to test");
                return;
            }
        } else {
            toTest = Arrays.asList(SigType.values());
        }
        for (int j = 0; j < 2; ++j) {
            for (SigType type : toTest) {
                if (!type.isAvailable()) {
                    System.out.println("Skipping unavailable: " + (Object)((Object)type));
                    continue;
                }
                try {
                    System.out.println("Testing " + (Object)((Object)type));
                    KeyGenerator.testSig(type, runs);
                }
                catch (GeneralSecurityException e) {
                    System.out.println("error testing " + (Object)((Object)type));
                    e.printStackTrace();
                }
            }
            runs = 1000;
        }
    }

    private static void testSig(SigType type, int runs) throws GeneralSecurityException {
        byte[] src = new byte[512];
        double gtime = 0.0;
        long stime = 0L;
        long vtime = 0L;
        SimpleDataStructure[] keys = null;
        long st = System.nanoTime();
        int genruns = type.getBaseAlgorithm() == SigAlgo.RSA ? Math.min(runs, 5) : runs;
        for (int i = 0; i < genruns; ++i) {
            keys = KeyGenerator.getInstance().generateSigningKeys(type);
        }
        long en = System.nanoTime();
        gtime = (double)(en - st) / 1000000.0 / (double)genruns;
        System.out.println((Object)((Object)type) + " key gen " + genruns + " times: " + gtime + " ms each");
        SigningPublicKey pubkey = (SigningPublicKey)keys[0];
        SigningPrivateKey privkey = (SigningPrivateKey)keys[1];
        SigningPublicKey pubkey2 = KeyGenerator.getSigningPublicKey(privkey);
        if (pubkey.equals(pubkey2)) {
            System.out.println((Object)((Object)type) + " private-to-public test PASSED");
        } else {
            System.out.println((Object)((Object)type) + " private-to-public test FAILED");
        }
        MessageDigest md = type.getDigestInstance();
        for (int i = 0; i < runs; ++i) {
            RandomSource.getInstance().nextBytes(src);
            md.update(src);
            byte[] sha = md.digest();
            SimpleDataStructure hash = type.getHashInstance();
            hash.setData(sha);
            long start = System.nanoTime();
            Signature sig = DSAEngine.getInstance().sign(src, privkey);
            Signature sig2 = DSAEngine.getInstance().sign(hash, privkey);
            if (sig == null) {
                throw new GeneralSecurityException("signature generation failed");
            }
            if (sig2 == null) {
                throw new GeneralSecurityException("signature generation (H) failed");
            }
            long mid = System.nanoTime();
            boolean ok = DSAEngine.getInstance().verifySignature(sig, src, pubkey);
            boolean ok2 = DSAEngine.getInstance().verifySignature(sig2, hash, pubkey);
            long end = System.nanoTime();
            stime += mid - start;
            vtime += end - mid;
            if (!ok) {
                throw new GeneralSecurityException((Object)((Object)type) + " V(S(data)) fail");
            }
            if (ok2) continue;
            throw new GeneralSecurityException((Object)((Object)type) + " V(S(H(data))) fail");
        }
        System.out.println((Object)((Object)type) + " sign/verify " + runs + " times: " + ((vtime /= 1000000L) + (stime /= 1000000L)) + " ms = " + (double)stime / (double)runs + " each sign, " + (double)vtime / (double)runs + " each verify, " + (double)(stime + vtime) / (double)runs + " s+v");
    }

    static {
        I2PProvider.addProvider();
        DEFAULT_USE_LONG_EXPONENT = !SystemVersion.isSlow();
        PUBKEY_EXPONENT_SIZE = DEFAULT_USE_LONG_EXPONENT ? 2048 : 226;
    }
}

