/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto;

import java.security.GeneralSecurityException;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SigUtil;
import net.i2p.crypto.eddsa.EdDSABlinding;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;

public final class Blinding {
    private static final SigType TYPE = SigType.EdDSA_SHA512_Ed25519;

    private Blinding() {
    }

    public static SigningPublicKey blind(SigningPublicKey key, SimpleDataStructure h) {
        if (key.getType() != TYPE) {
            throw new UnsupportedOperationException();
        }
        if (h.length() != key.length()) {
            throw new IllegalArgumentException();
        }
        try {
            EdDSAPublicKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPublicKey bjk = EdDSABlinding.blind(jk, h.getData());
            return SigUtil.fromJavaKey(bjk, TYPE);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey blind(SigningPrivateKey key, SimpleDataStructure h) {
        if (key.getType() != TYPE) {
            throw new UnsupportedOperationException();
        }
        if (h.length() != key.length()) {
            throw new IllegalArgumentException();
        }
        try {
            EdDSAPrivateKey jk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey bjk = EdDSABlinding.blind(jk, h.getData());
            return SigUtil.fromJavaKey(bjk, TYPE);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }

    public static SigningPrivateKey unblind(SigningPrivateKey key, SimpleDataStructure h) {
        if (key.getType() != TYPE) {
            throw new UnsupportedOperationException();
        }
        if (h.length() != key.length()) {
            throw new IllegalArgumentException();
        }
        try {
            EdDSAPrivateKey bjk = SigUtil.toJavaEdDSAKey(key);
            EdDSAPrivateKey jk = EdDSABlinding.unblind(bjk, h.getData());
            return SigUtil.fromJavaKey(jk, TYPE);
        }
        catch (GeneralSecurityException gse) {
            throw new IllegalArgumentException(gse);
        }
    }
}

