/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.impl;

import java.io.EOFException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.client.I2PSessionException;
import net.i2p.client.impl.HandlerImpl;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.client.impl.SubSession;
import net.i2p.crypto.EncType;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.KeyPair;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.Lease2;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.MetaLease;
import net.i2p.data.MetaLeaseSet;
import net.i2p.data.PrivateKey;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.SimpleDataStructure;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.RequestLeaseSetMessage;

class RequestLeaseSetMessageHandler
extends HandlerImpl {
    private final Map<Destination, LeaseInfo> _existingLeaseSets = new ConcurrentHashMap<Destination, LeaseInfo>(4);
    protected int _ls2Type = 3;
    private static final String PROP_LS_ENCRYPT = "i2cp.encryptLeaseSet";
    private static final String PROP_LS_KEY = "i2cp.leaseSetKey";
    private static final String PROP_LS_PK = "i2cp.leaseSetPrivateKey";
    private static final String PROP_LS_SPK = "i2cp.leaseSetSigningPrivateKey";
    private static final String PROP_LS_TYPE = "i2cp.leaseSetType";
    private static final String PROP_LS_ENCTYPE = "i2cp.leaseSetEncType";

    public RequestLeaseSetMessageHandler(I2PAppContext context) {
        this(context, 21);
    }

    protected RequestLeaseSetMessageHandler(I2PAppContext context, int messageType) {
        super(context, messageType);
    }

    protected boolean requiresLS2(I2PSessionImpl session) {
        EncType type;
        if (!session.supportsLS2()) {
            return false;
        }
        if (session.isOffline()) {
            return true;
        }
        String s = session.getOptions().getProperty(PROP_LS_ENCTYPE);
        if (s != null && (type = EncType.parseEncType(s)) != null && type != EncType.ELGAMAL_2048 && type.isAvailable()) {
            return true;
        }
        s = session.getOptions().getProperty(PROP_LS_TYPE);
        if (s != null) {
            try {
                this._ls2Type = type = Integer.parseInt(s);
                if (type != 1) {
                    return true;
                }
            }
            catch (NumberFormatException nfe) {
                session.propogateError("Bad LS2 type", nfe);
                session.destroySession();
                return true;
            }
        }
        return false;
    }

    @Override
    public void handleMessage(I2CPMessage message, I2PSessionImpl session) {
        LeaseSet leaseSet;
        if (this._log.shouldLog(10)) {
            this._log.debug("Handle message " + message);
        }
        RequestLeaseSetMessage msg = (RequestLeaseSetMessage)message;
        boolean isLS2 = this.requiresLS2(session);
        if (isLS2) {
            if (this._ls2Type == 3) {
                leaseSet = new LeaseSet2();
            } else if (this._ls2Type == 5) {
                leaseSet = new EncryptedLeaseSet();
            } else if (this._ls2Type == 7) {
                leaseSet = new MetaLeaseSet();
            } else {
                session.propogateError("Unsupported LS2 type", new Exception());
                session.destroySession();
                return;
            }
            if (Boolean.parseBoolean(session.getOptions().getProperty("i2cp.dontPublishLeaseSet"))) {
                ((LeaseSet2)leaseSet).setUnpublished();
            }
        } else {
            leaseSet = new LeaseSet();
        }
        for (int i = 0; i < msg.getEndpoints(); ++i) {
            Lease lease;
            if (this._ls2Type == 7) {
                lease = new MetaLease();
            } else if (isLS2) {
                lease = new Lease2();
                lease.setTunnelId(msg.getTunnelId(i));
            } else {
                lease = new Lease();
                lease.setTunnelId(msg.getTunnelId(i));
            }
            lease.setGateway(msg.getRouter(i));
            lease.setEndDate(msg.getEndDate());
            leaseSet.addLease(lease);
        }
        this.signLeaseSet(leaseSet, session);
    }

    protected synchronized void signLeaseSet(LeaseSet leaseSet, I2PSessionImpl session) {
        LeaseSet2 ls2;
        boolean ok;
        Destination dest = session.getMyDestination();
        leaseSet.setDestination(dest);
        LeaseInfo li = this._existingLeaseSets.get(dest);
        if (li == null) {
            String spk = session.getOptions().getProperty(PROP_LS_PK);
            String sspk = session.getOptions().getProperty(PROP_LS_SPK);
            PrivateKey privKey = null;
            SigningPrivateKey signingPrivKey = null;
            if (spk != null && sspk != null) {
                boolean useOldKeys = true;
                int colon = sspk.indexOf(58);
                SigType type = dest.getSigType();
                if (colon > 0) {
                    String stype = sspk.substring(0, colon);
                    SigType t = SigType.parseSigType(stype);
                    if (t == type) {
                        sspk = sspk.substring(colon + 1);
                    } else {
                        useOldKeys = false;
                    }
                }
                if ((colon = spk.indexOf(58)) >= 0) {
                    spk = spk.substring(colon + 1);
                }
                if (useOldKeys) {
                    try {
                        signingPrivKey = new SigningPrivateKey(type);
                        signingPrivKey.fromBase64(sspk);
                    }
                    catch (DataFormatException iae) {
                        useOldKeys = false;
                        signingPrivKey = null;
                    }
                }
                if (useOldKeys) {
                    try {
                        privKey = new PrivateKey();
                        privKey.fromBase64(spk);
                    }
                    catch (DataFormatException iae) {
                        privKey = null;
                    }
                }
            }
            if (privKey == null && !this._existingLeaseSets.isEmpty()) {
                PublicKey pk = dest.getPublicKey();
                for (Map.Entry<Destination, LeaseInfo> e : this._existingLeaseSets.entrySet()) {
                    if (!pk.equals(e.getKey().getPublicKey())) continue;
                    privKey = e.getValue().getPrivateKey();
                    if (!this._log.shouldLog(10)) break;
                    this._log.debug("Creating new leaseInfo keys for " + dest + " with private key from " + e.getKey());
                    break;
                }
            }
            if (privKey != null) {
                if (signingPrivKey != null) {
                    li = new LeaseInfo(privKey, signingPrivKey);
                    if (this._log.shouldLog(10)) {
                        this._log.debug("Creating new leaseInfo keys for " + dest + " WITH configured private keys");
                    }
                } else {
                    li = new LeaseInfo(privKey, dest);
                }
            } else {
                EncType type = EncType.ELGAMAL_2048;
                String senc = session.getOptions().getProperty(PROP_LS_ENCTYPE);
                if (senc != null) {
                    EncType newtype = EncType.parseEncType(senc);
                    if (newtype != null) {
                        if (newtype.isAvailable()) {
                            type = newtype;
                            if (this._log.shouldDebug()) {
                                this._log.debug("Using crypto type: " + (Object)((Object)type));
                            }
                        } else {
                            this._log.error("Unsupported crypto.encType: " + (Object)((Object)newtype));
                        }
                    } else {
                        this._log.error("Bad crypto.encType: " + senc);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Using default crypto type");
                }
                li = new LeaseInfo(dest, type);
                if (this._log.shouldLog(10)) {
                    this._log.debug("Creating new leaseInfo keys for " + dest + " without configured private keys");
                }
            }
            this._existingLeaseSets.put(dest, li);
        } else if (this._log.shouldLog(10)) {
            this._log.debug("Caching the old leaseInfo keys for " + dest);
        }
        if (this._ls2Type != 7) {
            leaseSet.setEncryptionKey(li.getPublicKey());
        }
        leaseSet.setSigningKey(li.getSigningPublicKey());
        Properties opts = session instanceof SubSession ? ((SubSession)session).getPrimaryOptions() : session.getOptions();
        boolean encrypt = Boolean.parseBoolean(opts.getProperty(PROP_LS_ENCRYPT));
        String sk = opts.getProperty(PROP_LS_KEY);
        Hash h = dest.calculateHash();
        if (encrypt && sk != null) {
            SessionKey key = new SessionKey();
            try {
                key.fromBase64(sk);
                leaseSet.encrypt(key);
                this._context.keyRing().put(h, key);
            }
            catch (DataFormatException dfe) {
                this._log.error("Bad leaseset key: " + sk);
                this._context.keyRing().remove(h);
            }
        } else {
            this._context.keyRing().remove(h);
        }
        if (session.isOffline() && !(ok = (ls2 = (LeaseSet2)leaseSet).setOfflineSignature(session.getOfflineExpiration(), session.getTransientSigningPublicKey(), session.getOfflineSignature()))) {
            session.propogateError("Bad offline signature", new Exception());
            session.destroySession();
        }
        try {
            leaseSet.sign(session.getPrivateKey());
            SigningPrivateKey spk = li.getSigningPrivateKey();
            if (!this._context.isRouterContext() && spk.getType() != SigType.DSA_SHA1 && !(leaseSet instanceof LeaseSet2)) {
                byte[] dummy = new byte[SigningPrivateKey.KEYSIZE_BYTES];
                this._context.random().nextBytes(dummy);
                spk = new SigningPrivateKey(dummy);
            }
            session.getProducer().createLeaseSet(session, leaseSet, spk, li.getPrivateKey());
            session.setLeaseSet(leaseSet);
            if (this._log.shouldDebug()) {
                this._log.debug("Created and signed LeaseSet: " + leaseSet);
            }
        }
        catch (DataFormatException dfe) {
            session.propogateError("Error signing the leaseSet", dfe);
            session.destroySession();
        }
        catch (I2PSessionException ise) {
            if (session.isClosed()) {
                EOFException eof = new EOFException("Session closed while signing leaseset");
                eof.initCause(ise);
                session.propogateError("Session closed while signing leaseset", eof);
            }
            session.propogateError("Error sending the signed leaseSet", ise);
        }
    }

    private static class LeaseInfo {
        private final PublicKey _pubKey;
        private final PrivateKey _privKey;
        private final SigningPublicKey _signingPubKey;
        private final SigningPrivateKey _signingPrivKey;

        public LeaseInfo(Destination dest, EncType type) {
            SimpleDataStructure[] signKeys;
            KeyPair encKeys = KeyGenerator.getInstance().generatePKIKeys(type);
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._pubKey = encKeys.getPublic();
            this._privKey = encKeys.getPrivate();
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public LeaseInfo(PrivateKey privKey, SigningPrivateKey signingPrivKey) {
            this._pubKey = KeyGenerator.getPublicKey(privKey);
            this._privKey = privKey;
            this._signingPubKey = KeyGenerator.getSigningPublicKey(signingPrivKey);
            this._signingPrivKey = signingPrivKey;
        }

        public LeaseInfo(PrivateKey privKey, Destination dest) {
            SimpleDataStructure[] signKeys;
            try {
                signKeys = KeyGenerator.getInstance().generateSigningKeys(dest.getSigningPublicKey().getType());
            }
            catch (GeneralSecurityException gse) {
                throw new IllegalStateException(gse);
            }
            this._pubKey = KeyGenerator.getPublicKey(privKey);
            this._privKey = privKey;
            this._signingPubKey = (SigningPublicKey)signKeys[0];
            this._signingPrivKey = (SigningPrivateKey)signKeys[1];
        }

        public PublicKey getPublicKey() {
            return this._pubKey;
        }

        public PrivateKey getPrivateKey() {
            return this._privKey;
        }

        public SigningPublicKey getSigningPublicKey() {
            return this._signingPubKey;
        }

        public SigningPrivateKey getSigningPrivateKey() {
            return this._signingPrivKey;
        }

        public int hashCode() {
            return DataHelper.hashCode(this._pubKey) + 7 * DataHelper.hashCode(this._privKey) + 49 * DataHelper.hashCode(this._signingPubKey) + 343 * DataHelper.hashCode(this._signingPrivKey);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof LeaseInfo)) {
                return false;
            }
            LeaseInfo li = (LeaseInfo)obj;
            return DataHelper.eq(this._pubKey, li.getPublicKey()) && DataHelper.eq(this._privKey, li.getPrivateKey()) && DataHelper.eq(this._signingPubKey, li.getSigningPublicKey()) && DataHelper.eq(this._signingPrivKey, li.getSigningPrivateKey());
        }
    }
}

