/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionMuxedListener;
import net.i2p.client.streaming.impl.ConnThrottler;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionHandler;
import net.i2p.client.streaming.impl.ConnectionOptions;
import net.i2p.client.streaming.impl.ConnectionPacketHandler;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.MessageHandler;
import net.i2p.client.streaming.impl.MessageInputStream;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketHandler;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.client.streaming.impl.PacketQueue;
import net.i2p.client.streaming.impl.RetransmissionTimer;
import net.i2p.client.streaming.impl.SchedulerChooser;
import net.i2p.client.streaming.impl.TCBShare;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.ConvertToHash;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class ConnectionManager {
    private final I2PAppContext _context;
    private final Log _log;
    private final I2PSession _session;
    private final MessageHandler _messageHandler;
    private final PacketHandler _packetHandler;
    private final ConnectionHandler _connectionHandler;
    private final PacketQueue _outboundQueue;
    private final SchedulerChooser _schedulerChooser;
    private final ConnectionPacketHandler _conPacketHandler;
    private final TCBShare _tcbShare;
    private final ConcurrentHashMap<Long, Connection> _connectionByInboundId;
    private final ConcurrentHashMap<Long, PingRequest> _pendingPings;
    private volatile boolean _throttlersInitialized;
    private final ConnectionOptions _defaultOptions;
    private final AtomicInteger _numWaiting = new AtomicInteger();
    private long _soTimeout;
    private volatile ConnThrottler _minuteThrottler;
    private volatile ConnThrottler _hourThrottler;
    private volatile ConnThrottler _dayThrottler;
    private final SimpleTimer2 _timer;
    private final Map<Long, Object> _recentlyClosed;
    private static final Object DUMMY = new Object();
    private static volatile String _currentBlacklist = "";
    private static final Set<Hash> _globalBlacklist = new ConcurrentHashSet();
    public static final String PROP_BLACKLIST = "i2p.streaming.blacklist";
    private static final long MAX_PING_TIMEOUT = 300000L;
    private static final int MAX_PONG_PAYLOAD = 32;
    private static final int DROP_OVER_LIMIT = 3;
    private static final String LIMIT_HTTP_RESPONSE = "HTTP/1.1 429 Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-Control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><head><title>429 Denied</title></head><body><h3>429 Denied</h3><p>Denied due to excessive requests. Please try again later.</body></html>";
    private static final long DEFAULT_STREAM_DELAY_MAX = 10000L;

    public ConnectionManager(I2PAppContext context, I2PSession session, ConnectionOptions defaultOptions) {
        this._context = context;
        this._session = session;
        this._defaultOptions = defaultOptions;
        this._log = this._context.logManager().getLog(ConnectionManager.class);
        this._connectionByInboundId = new ConcurrentHashMap(32);
        this._pendingPings = new ConcurrentHashMap(4);
        this._messageHandler = new MessageHandler(this._context, this);
        this._packetHandler = new PacketHandler(this._context, this);
        this._schedulerChooser = new SchedulerChooser(this._context);
        this._conPacketHandler = new ConnectionPacketHandler(this._context);
        this._timer = new RetransmissionTimer(this._context, "Streaming Timer " + session.getMyDestination().calculateHash().toBase64().substring(0, 4));
        this._connectionHandler = new ConnectionHandler(this._context, this, this._timer);
        this._tcbShare = new TCBShare(this._context, this._timer);
        int protocol = defaultOptions.getEnforceProtocol() ? 6 : 0;
        this._session.addMuxedSessionListener((I2PSessionMuxedListener)this._messageHandler, protocol, defaultOptions.getLocalPort());
        this._outboundQueue = new PacketQueue(this._context, this._timer);
        this._recentlyClosed = new LHMCache(64);
        this._soTimeout = -1L;
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesSent", "How many messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeMessagesReceived", "How many messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesSent", "How many bytes do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeBytesReceived", "How many bytes do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesSent", "How many duplicate messages do we send on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeDupMessagesReceived", "How many duplicate messages do we receive on a stream?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeRTT", "What is the final RTT when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeCongestionSeenAt", "When was the last congestion seen at when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.lifetimeSendWindowSize", "What is the final send window size when a stream closes?", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.receiveActive", "How many streams are active when a new one is received (period being not yet dropped)", "Stream", new long[]{3600000L, 86400000L});
        this._context.statManager().createRateStat("stream.con.windowSizeAtCongestion", "How large was our send window when we send a dup?", "Stream", new long[]{3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeBegin", "How many messages were outstanding when we started to choke?", "Stream", new long[]{3600000L});
        this._context.statManager().createRateStat("stream.chokeSizeEnd", "How many messages were outstanding when we stopped being choked?", "Stream", new long[]{3600000L});
        this._context.statManager().createRateStat("stream.fastRetransmit", "How long a packet has been around for if it has been resent per the fast retransmit timer?", "Stream", new long[]{600000L});
        this._context.statManager().createRateStat("stream.con.sendMessageSize", "Size of a message sent on a connection", "Stream", new long[]{600000L, 3600000L});
        this._context.statManager().createRateStat("stream.con.sendDuplicateSize", "Size of a message resent on a connection", "Stream", new long[]{600000L, 3600000L});
    }

    Connection getConnectionByInboundId(long id) {
        return this._connectionByInboundId.get(id);
    }

    Connection getConnectionByOutboundId(long id) {
        for (Connection con : this._connectionByInboundId.values()) {
            if (con.getSendStreamId() != id) continue;
            return con;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRecentlyClosed(long inboundID) {
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            return this._recentlyClosed.get(inboundID) != null;
        }
    }

    public void setSoTimeout(long x) {
        this._soTimeout = x;
    }

    public long getSoTimeout() {
        return this._soTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowIncomingConnections(boolean allow) {
        this._connectionHandler.setActive(allow);
        if (allow) {
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!this._throttlersInitialized) {
                    this.updateOptions();
                    this._throttlersInitialized = true;
                }
            }
        }
    }

    public synchronized void updateOptions() {
        if ((this._defaultOptions.getMaxConnsPerMinute() > 0 || this._defaultOptions.getMaxTotalConnsPerMinute() > 0) && this._minuteThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledMinute", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._minuteThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerMinute(), this._defaultOptions.getMaxTotalConnsPerMinute(), 60000L, this._timer);
        } else if (this._minuteThrottler != null) {
            this._minuteThrottler.updateLimits(this._defaultOptions.getMaxConnsPerMinute(), this._defaultOptions.getMaxTotalConnsPerMinute());
        }
        if ((this._defaultOptions.getMaxConnsPerHour() > 0 || this._defaultOptions.getMaxTotalConnsPerHour() > 0) && this._hourThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledHour", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._hourThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerHour(), this._defaultOptions.getMaxTotalConnsPerHour(), 3600000L, this._timer);
        } else if (this._hourThrottler != null) {
            this._hourThrottler.updateLimits(this._defaultOptions.getMaxConnsPerHour(), this._defaultOptions.getMaxTotalConnsPerHour());
        }
        if ((this._defaultOptions.getMaxConnsPerDay() > 0 || this._defaultOptions.getMaxTotalConnsPerDay() > 0) && this._dayThrottler == null) {
            this._context.statManager().createRateStat("stream.con.throttledDay", "Dropped for conn limit", "Stream", new long[]{300000L});
            this._dayThrottler = new ConnThrottler(this._defaultOptions.getMaxConnsPerDay(), this._defaultOptions.getMaxTotalConnsPerDay(), 86400000L, this._timer);
        } else if (this._dayThrottler != null) {
            this._dayThrottler.updateLimits(this._defaultOptions.getMaxConnsPerDay(), this._defaultOptions.getMaxTotalConnsPerDay());
        }
    }

    public boolean getAllowIncomingConnections() {
        return this._connectionHandler.getActive();
    }

    public Connection receiveConnection(Packet synPacket) {
        ConnectionOptions opts = new ConnectionOptions(this._defaultOptions);
        opts.setPort(synPacket.getRemotePort());
        opts.setLocalPort(synPacket.getLocalPort());
        boolean reject = false;
        int active = 0;
        int total = 0;
        if (this.locked_tooManyStreams()) {
            if (!this._defaultOptions.getDisableRejectLogging() || this._log.shouldLog(30)) {
                this._log.logAlways(30, "Refusing connection since we have exceeded our max of " + this._defaultOptions.getMaxConns() + " connections");
            }
            reject = true;
        } else {
            String why = this.shouldRejectConnection(synPacket);
            if (why != null) {
                if (!this._defaultOptions.getDisableRejectLogging() || this._log.shouldLog(30)) {
                    this._log.logAlways(30, "Refusing connection since peer is " + why + (synPacket.getOptionalFrom() == null ? "" : ": " + synPacket.getOptionalFrom().toBase32()));
                }
                reject = true;
            }
        }
        this._context.statManager().addRateData("stream.receiveActive", (long)active, (long)total);
        if (reject) {
            boolean custom;
            Destination from = synPacket.getOptionalFrom();
            if (from == null) {
                return null;
            }
            String resp = this._defaultOptions.getLimitAction();
            if ("drop".equals(resp)) {
                return null;
            }
            Hash h = from.calculateHash();
            if (_globalBlacklist.contains(h) || this._defaultOptions.isAccessListEnabled() && !this._defaultOptions.getAccessList().contains(h) || this._defaultOptions.isBlacklistEnabled() && this._defaultOptions.getBlacklist().contains(h)) {
                return null;
            }
            if (this._minuteThrottler != null && this._minuteThrottler.isOverBy(h, 3) || this._hourThrottler != null && this._hourThrottler.isOverBy(h, 3) || this._dayThrottler != null && this._dayThrottler.isOverBy(h, 3)) {
                if (this._log.shouldLog(20)) {
                    this._log.info("Dropping limit response to " + from.toBase32());
                }
                return null;
            }
            boolean reset = resp == null || resp.equals("reset") || resp.length() <= 0 || synPacket.getLocalPort() == 443;
            boolean http = !reset && "http".equals(resp);
            boolean bl = custom = !reset && !http;
            String sendResponse = http ? LIMIT_HTTP_RESPONSE : (custom ? resp.replace("\\r", "\r").replace("\\n", "\n") : null);
            PacketLocal reply = new PacketLocal(this._context, from, synPacket.getSession());
            if (sendResponse != null) {
                reply.setFlag(11);
                reply.setSequenceNum(0L);
                ByteArray payload = new ByteArray(DataHelper.getUTF8((String)sendResponse));
                reply.setPayload(payload);
            } else {
                reply.setFlag(12);
            }
            reply.setAckThrough(synPacket.getSequenceNum());
            reply.setSendStreamId(synPacket.getReceiveStreamId());
            long rcvStreamId = this.assignRejectId();
            reply.setReceiveStreamId(rcvStreamId);
            reply.setOptionalFrom();
            reply.setLocalPort(synPacket.getLocalPort());
            reply.setRemotePort(synPacket.getRemotePort());
            if (this._log.shouldInfo()) {
                this._log.info("Over limit, sending " + reply + " to " + from.toBase32());
            }
            this._outboundQueue.enqueue(reply);
            return null;
        }
        Connection con = new Connection(this._context, this, synPacket.getSession(), this._schedulerChooser, this._timer, this._outboundQueue, this._conPacketHandler, opts, true);
        this._tcbShare.updateOptsFromShare(con);
        this.assignReceiveStreamId(con);
        if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
            synPacket.logTCPDump(con);
        }
        try {
            con.getPacketHandler().receivePacket(synPacket, con);
        }
        catch (I2PException ie) {
            this._connectionByInboundId.remove(con.getReceiveStreamId());
            return null;
        }
        this._context.statManager().addRateData("stream.connectionReceived", 1L);
        return con;
    }

    public boolean receivePing(Connection con, Packet ping) {
        Destination dest = ping.getOptionalFrom();
        if (dest == null) {
            return false;
        }
        if (con == null) {
            String why = this.shouldRejectConnection(ping);
            if (why != null) {
                if (!this._defaultOptions.getDisableRejectLogging() || this._log.shouldLog(30)) {
                    this._log.logAlways(30, "Dropping ping since peer is " + why + ": " + dest.calculateHash());
                }
                return false;
            }
        } else if (!dest.equals((Object)con.getRemotePeer())) {
            this._log.logAlways(30, "Dropping ping from " + con.getRemotePeer().calculateHash() + " to " + dest.calculateHash());
            return false;
        }
        PacketLocal pong = new PacketLocal(this._context, dest, ping.getSession());
        pong.setFlag(1536);
        pong.setReceiveStreamId(ping.getSendStreamId());
        pong.setLocalPort(ping.getLocalPort());
        pong.setRemotePort(ping.getRemotePort());
        ByteArray payload = ping.getPayload();
        if (payload != null) {
            if (payload.getValid() > 32) {
                payload.setValid(32);
            }
            pong.setPayload(payload);
        }
        this._outboundQueue.enqueue(pong);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignReceiveStreamId(Connection con) {
        long receiveId;
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            Long rcvID;
            while (this._recentlyClosed.containsKey(rcvID = Long.valueOf(receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L)) || this._pendingPings.containsKey(rcvID) || this._connectionByInboundId.putIfAbsent(rcvID, con) != null) {
            }
        }
        con.setReceiveStreamId(receiveId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long assignPingId(PingRequest req) {
        long receiveId;
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            Long rcvID;
            while (this._recentlyClosed.containsKey(rcvID = Long.valueOf(receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L)) || this._connectionByInboundId.containsKey(rcvID) || this._pendingPings.putIfAbsent(rcvID, req) != null) {
            }
        }
        return receiveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long assignRejectId() {
        long receiveId;
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            Long rcvID;
            while (this._recentlyClosed.containsKey(rcvID = Long.valueOf(receiveId = this._context.random().nextLong(0xFFFFFFFEL) + 1L)) || this._connectionByInboundId.containsKey(rcvID)) {
            }
            this._recentlyClosed.put(rcvID, DUMMY);
        }
        return receiveId;
    }

    public Connection connect(Destination peer, ConnectionOptions opts, I2PSession session) {
        int n;
        if (peer == null) {
            throw new NullPointerException();
        }
        Connection con = null;
        long expiration = this._context.clock().now();
        long tmout = opts.getConnectTimeout();
        expiration = tmout <= 0L ? (expiration += 10000L) : (expiration += tmout);
        this._numWaiting.incrementAndGet();
        while (true) {
            long remaining;
            if ((remaining = expiration - this._context.clock().now()) <= 0L) {
                this._log.logAlways(30, "Refusing to connect since we have exceeded our max of " + this._defaultOptions.getMaxConns() + " connections");
                this._numWaiting.decrementAndGet();
                return null;
            }
            if (!this.locked_tooManyStreams()) break;
            int max = this._defaultOptions.getMaxConns();
            if (this._numWaiting.get() > max) {
                this._log.logAlways(30, "Refusing connection since we have exceeded our max of " + max + " and there are " + this._numWaiting + " waiting already");
                this._numWaiting.decrementAndGet();
                return null;
            }
            try {
                Thread.sleep(remaining / 4L);
            }
            catch (InterruptedException interruptedException) {}
        }
        con = new Connection(this._context, this, session, this._schedulerChooser, this._timer, this._outboundQueue, this._conPacketHandler, opts, false);
        con.setRemotePeer(peer);
        this.assignReceiveStreamId(con);
        con.eventOccurred();
        if (this._log.shouldLog(10)) {
            this._log.debug("Connect() conDelay = " + opts.getConnectDelay());
        }
        if (opts.getConnectDelay() <= 0) {
            con.waitForConnect();
        }
        while ((n = this._numWaiting.get()) > 0 && !this._numWaiting.compareAndSet(n, n - 1)) {
        }
        this._context.statManager().addRateData("stream.connectionCreated", 1L);
        return con;
    }

    private boolean locked_tooManyStreams() {
        int max = this._defaultOptions.getMaxConns();
        if (max <= 0) {
            return false;
        }
        int size = this._connectionByInboundId.size();
        if (size < max) {
            return false;
        }
        int active = 0;
        int inactive = 0;
        int maxInactive = size - max;
        for (Connection con : this._connectionByInboundId.values()) {
            if (con.getIsConnected() && (con.getCloseSentOn() <= 0L || con.getCloseReceivedOn() <= 0L)) {
                if (++active < max) continue;
                return true;
            }
            if (++inactive <= maxInactive) continue;
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String shouldRejectConnection(Packet syn) {
        Destination from = syn.getOptionalFrom();
        if (from == null) {
            return "null";
        }
        Hash h = from.calculateHash();
        String hashes = this._context.getProperty(PROP_BLACKLIST, "");
        if (!_currentBlacklist.equals(hashes)) {
            Set<Hash> set = _globalBlacklist;
            synchronized (set) {
                if (hashes.length() > 0) {
                    HashSet<Hash> newSet = new HashSet<Hash>();
                    StringTokenizer tok = new StringTokenizer(hashes, ",; ");
                    while (tok.hasMoreTokens()) {
                        String hashstr = tok.nextToken();
                        Hash hh = ConvertToHash.getHash((String)hashstr);
                        if (hh != null) {
                            newSet.add(hh);
                            continue;
                        }
                        this._log.error("Bad blacklist entry: " + hashstr);
                    }
                    _globalBlacklist.addAll(newSet);
                    _globalBlacklist.retainAll(newSet);
                    _currentBlacklist = hashes;
                } else {
                    _globalBlacklist.clear();
                    _currentBlacklist = "";
                }
            }
        }
        if (hashes.length() > 0 && _globalBlacklist.contains(h)) {
            return "blacklisted globally";
        }
        if (this._defaultOptions.isAccessListEnabled() && !this._defaultOptions.getAccessList().contains(h)) {
            return "not whitelisted";
        }
        if (this._defaultOptions.isBlacklistEnabled() && this._defaultOptions.getBlacklist().contains(h)) {
            return "blacklisted";
        }
        if (this._dayThrottler != null && this._dayThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledDay", 1L);
            if (this._defaultOptions.getMaxConnsPerDay() <= 0) {
                return "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerDay() + " per day";
            }
            if (this._defaultOptions.getMaxTotalConnsPerDay() <= 0) {
                return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerDay() + " per day";
            }
            return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerDay() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerDay() + " per day";
        }
        if (this._hourThrottler != null && this._hourThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledHour", 1L);
            if (this._defaultOptions.getMaxConnsPerHour() <= 0) {
                return "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerHour() + " per hour";
            }
            if (this._defaultOptions.getMaxTotalConnsPerHour() <= 0) {
                return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerHour() + " per hour";
            }
            return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerHour() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerHour() + " per hour";
        }
        if (this._minuteThrottler != null && this._minuteThrottler.shouldThrottle(h)) {
            this._context.statManager().addRateData("stream.con.throttledMinute", 1L);
            if (this._defaultOptions.getMaxConnsPerMinute() <= 0) {
                return "throttled by total limit of " + this._defaultOptions.getMaxTotalConnsPerMinute() + " per minute";
            }
            if (this._defaultOptions.getMaxTotalConnsPerMinute() <= 0) {
                return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerMinute() + " per minute";
            }
            return "throttled by per-peer limit of " + this._defaultOptions.getMaxConnsPerMinute() + " or total limit of " + this._defaultOptions.getMaxTotalConnsPerMinute() + " per minute";
        }
        return null;
    }

    public MessageHandler getMessageHandler() {
        return this._messageHandler;
    }

    public PacketHandler getPacketHandler() {
        return this._packetHandler;
    }

    public I2PSession getSession() {
        return this._session;
    }

    public void updateOptsFromShare(Connection con) {
        this._tcbShare.updateOptsFromShare(con);
    }

    public void updateShareOpts(Connection con) {
        this._tcbShare.updateShareOpts(con);
    }

    public ConnectionHandler getConnectionHandler() {
        return this._connectionHandler;
    }

    public PacketQueue getPacketQueue() {
        return this._outboundQueue;
    }

    public boolean answerPings() {
        return this._defaultOptions.getAnswerPings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectAllHard() {
        Iterator<Connection> iter = this._connectionByInboundId.values().iterator();
        while (iter.hasNext()) {
            Connection con = iter.next();
            con.disconnect(false, false);
            iter.remove();
        }
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            this._recentlyClosed.clear();
        }
        this._pendingPings.clear();
    }

    public void shutdown() {
        this.disconnectAllHard();
        this._tcbShare.stop();
        this._timer.stop();
        this._outboundQueue.close();
        this._connectionHandler.setActive(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection con) {
        boolean removed;
        Long rcvID = con.getReceiveStreamId();
        Map<Long, Object> map = this._recentlyClosed;
        synchronized (map) {
            this._recentlyClosed.put(rcvID, DUMMY);
        }
        Connection o = this._connectionByInboundId.remove(con.getReceiveStreamId());
        boolean bl = removed = o == con;
        if (this._log.shouldLog(10)) {
            this._log.debug("Connection removed? " + removed + " remaining: " + this._connectionByInboundId.size() + ": " + con);
        }
        if (!removed && this._log.shouldLog(10)) {
            this._log.debug("Failed to remove " + con + "\n" + this._connectionByInboundId.values());
        }
        if (removed) {
            this._context.statManager().addRateData("stream.con.lifetimeMessagesSent", 1L + con.getLastSendId(), con.getLifetime());
            MessageInputStream stream = con.getInputStream();
            long rcvd = 1L + stream.getHighestBlockId();
            long[] nacks = stream.getNacks();
            if (nacks != null) {
                rcvd -= (long)nacks.length;
            }
            this._context.statManager().addRateData("stream.con.lifetimeMessagesReceived", rcvd, con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeBytesSent", con.getLifetimeBytesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeBytesReceived", con.getLifetimeBytesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesSent", con.getLifetimeDupMessagesSent(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeDupMessagesReceived", con.getLifetimeDupMessagesReceived(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeRTT", (long)con.getOptions().getRTT(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeCongestionSeenAt", (long)con.getLastCongestionSeenAt(), con.getLifetime());
            this._context.statManager().addRateData("stream.con.lifetimeSendWindowSize", (long)con.getOptions().getWindowSize(), con.getLifetime());
            if (I2PSocketManagerFull.pcapWriter != null) {
                I2PSocketManagerFull.pcapWriter.flush();
            }
        }
    }

    public Set<Connection> listConnections() {
        return new HashSet<Connection>(this._connectionByInboundId.values());
    }

    public boolean ping(Destination peer, long timeoutMs) {
        return this.ping(peer, 0, 0, timeoutMs, true, null);
    }

    public boolean ping(Destination peer, int fromPort, int toPort, long timeoutMs) {
        return this.ping(peer, fromPort, toPort, timeoutMs, true, null);
    }

    public boolean ping(Destination peer, int fromPort, int toPort, long timeoutMs, boolean blocking) {
        return this.ping(peer, fromPort, toPort, timeoutMs, blocking, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ping(Destination peer, int fromPort, int toPort, long timeoutMs, boolean blocking, PingNotifier notifier) {
        PingRequest req = new PingRequest(notifier);
        long id = this.assignPingId(req);
        PacketLocal packet = new PacketLocal(this._context, peer, this._session);
        packet.setSendStreamId(id);
        packet.setFlag(1544);
        packet.setOptionalFrom();
        packet.setLocalPort(fromPort);
        packet.setRemotePort(toPort);
        if (timeoutMs > 300000L) {
            timeoutMs = 300000L;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(String.format("about to ping %s port %d from port %d timeout=%d blocking=%b", peer.calculateHash().toString(), toPort, fromPort, timeoutMs, blocking));
        }
        this._outboundQueue.enqueue(packet);
        packet.releasePayload();
        if (blocking) {
            PingRequest pingRequest = req;
            synchronized (pingRequest) {
                if (!req.pongReceived()) {
                    try {
                        req.wait(timeoutMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this._pendingPings.remove(id);
        } else {
            PingFailed pf = new PingFailed(id, notifier);
            pf.schedule(timeoutMs);
        }
        boolean ok = req.pongReceived();
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] ping(Destination peer, int fromPort, int toPort, long timeoutMs, byte[] payload) {
        PingRequest req = new PingRequest(null);
        long id = this.assignPingId(req);
        PacketLocal packet = new PacketLocal(this._context, peer, this._session);
        packet.setSendStreamId(id);
        packet.setFlag(1544);
        packet.setOptionalFrom();
        packet.setLocalPort(fromPort);
        packet.setRemotePort(toPort);
        packet.setPayload(new ByteArray(payload));
        if (timeoutMs > 300000L) {
            timeoutMs = 300000L;
        }
        if (this._log.shouldLog(20)) {
            this._log.info(String.format("about to ping %s port %d from port %d timeout=%d payload=%d", peer.calculateHash().toString(), toPort, fromPort, timeoutMs, payload.length));
        }
        this._outboundQueue.enqueue(packet);
        packet.releasePayload();
        PingRequest pingRequest = req;
        synchronized (pingRequest) {
            if (!req.pongReceived()) {
                try {
                    req.wait(timeoutMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this._pendingPings.remove(id);
        boolean ok = req.pongReceived();
        if (!ok) {
            return null;
        }
        ByteArray ba = req.getPayload();
        if (ba == null) {
            return new byte[0];
        }
        byte[] rv = new byte[ba.getValid()];
        System.arraycopy(ba, ba.getOffset(), rv, 0, ba.getValid());
        return rv;
    }

    void receivePong(long pingId, ByteArray payload) {
        PingRequest req = this._pendingPings.remove(pingId);
        if (req != null) {
            req.pong(payload);
        }
    }

    public String toString() {
        return "ConnectionManager for " + this._session;
    }

    private class PingFailed
    extends SimpleTimer2.TimedEvent {
        private final Long _id;
        private final PingNotifier _notifier;

        public PingFailed(Long id, PingNotifier notifier) {
            super(ConnectionManager.this._timer);
            this._id = id;
            this._notifier = notifier;
        }

        public void timeReached() {
            PingRequest pr = (PingRequest)ConnectionManager.this._pendingPings.remove(this._id);
            if (pr != null) {
                if (this._notifier != null) {
                    this._notifier.pingComplete(false);
                }
                if (ConnectionManager.this._log.shouldLog(20)) {
                    ConnectionManager.this._log.info("Ping failed");
                }
            }
        }
    }

    public static interface PingNotifier {
        public void pingComplete(boolean var1);
    }

    private static class PingRequest {
        private boolean _ponged;
        private ByteArray _payload;
        private final PingNotifier _notifier;

        public PingRequest(PingNotifier notifier) {
            this._notifier = notifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pong(ByteArray payload) {
            PingRequest pingRequest = this;
            synchronized (pingRequest) {
                this._ponged = true;
                this._payload = payload;
                this.notifyAll();
            }
            if (this._notifier != null) {
                this._notifier.pingComplete(true);
            }
        }

        public synchronized boolean pongReceived() {
            return this._ponged;
        }

        public synchronized ByteArray getPayload() {
            return this._payload;
        }
    }
}

