/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.nio.ByteBuffer;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.crypto.DHSessionKeyBuilder;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.util.Log;
import net.i2p.util.SimpleByteCache;

abstract class EstablishBase
implements EstablishState {
    public static final VerifiedEstablishState VERIFIED = new VerifiedEstablishState();
    public static final FailedEstablishState FAILED = new FailedEstablishState();
    protected final RouterContext _context;
    protected final Log _log;
    protected final byte[] _X;
    protected final byte[] _hX_xor_bobIdentHash;
    protected final byte[] _Y;
    protected final byte[] _e_hXY_tsB;
    protected transient long _tsB;
    protected transient long _tsA;
    protected transient long _peerSkew;
    protected transient byte[] _e_bobSig;
    protected byte[] _prevEncrypted;
    protected final byte[] _curDecrypted;
    protected int _received;
    protected final DHSessionKeyBuilder _dh;
    protected final NTCPTransport _transport;
    protected final NTCPConnection _con;
    protected static final int MIN_RI_SIZE = 387;
    protected static final int MAX_RI_SIZE = 3072;
    protected static final int AES_SIZE = 16;
    protected static final int XY_SIZE = 256;
    protected static final int HXY_SIZE = 32;
    protected static final int HXY_TSB_PAD_SIZE = 48;
    protected final Object _stateLock = new Object();
    protected volatile State _state;

    private EstablishBase() {
        this._context = null;
        this._log = null;
        this._X = null;
        this._Y = null;
        this._hX_xor_bobIdentHash = null;
        this._curDecrypted = null;
        this._dh = null;
        this._transport = null;
        this._con = null;
        this._e_hXY_tsB = null;
    }

    protected EstablishBase(RouterContext ctx, NTCPTransport transport, NTCPConnection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._con = con;
        this._dh = this._transport.getDHBuilder();
        this._hX_xor_bobIdentHash = SimpleByteCache.acquire(32);
        if (this._con.isInbound()) {
            this._X = SimpleByteCache.acquire(256);
            this._Y = this._dh.getMyPublicValueBytes();
        } else {
            this._X = this._dh.getMyPublicValueBytes();
            this._Y = SimpleByteCache.acquire(256);
        }
        this._e_hXY_tsB = new byte[48];
        this._curDecrypted = SimpleByteCache.acquire(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeState(State state) {
        Object object = this._stateLock;
        synchronized (object) {
            this._state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void receive(ByteBuffer src) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.VERIFIED || this._state == State.CORRUPT) {
                throw new IllegalStateException(this.prefix() + "received unexpected data on " + this._con);
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug(this.prefix() + "Receiving: " + src.remaining() + " Received: " + this._received);
        }
    }

    @Override
    public void prepareOutbound() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupt() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.CORRUPT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isComplete() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.VERIFIED;
        }
    }

    @Override
    public abstract int getVersion();

    @Override
    public synchronized void close(String reason, Exception e) {
        this.fail(reason, e);
    }

    protected void fail(String reason) {
        this.fail(reason, null);
    }

    protected void fail(String reason, Exception e) {
        this.fail(reason, e, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fail(String reason, Exception e, boolean bySkew) {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.CORRUPT || this._state == State.VERIFIED) {
                return;
            }
            this.changeState(State.CORRUPT);
        }
        if (this._log.shouldLog(30)) {
            this._log.warn(this.prefix() + "Failed to establish: " + reason, e);
        }
        if (!bySkew) {
            this._context.statManager().addRateData("ntcp.receiveCorruptEstablishment", 1L);
        }
        this.releaseBufs(false);
    }

    protected void releaseBufs(boolean isVerified) {
        if (this._prevEncrypted != null && this._prevEncrypted.length == 16) {
            SimpleByteCache.release(this._prevEncrypted);
        }
        SimpleByteCache.release(this._curDecrypted);
        SimpleByteCache.release(this._hX_xor_bobIdentHash);
        if (this._dh.getPeerPublicValue() == null) {
            this._transport.returnUnused(this._dh);
        }
    }

    protected static void xor32(byte[] a, byte[] b) {
        for (int i = 0; i < 32; ++i) {
            int n = i;
            b[n] = (byte)(b[n] ^ a[i]);
        }
    }

    protected String prefix() {
        return this.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        if (this._con.isInbound()) {
            buf.append("IBES ");
        } else {
            buf.append("OBES ");
        }
        buf.append(this._con.toString());
        buf.append(' ').append((Object)this._state);
        if (this._con.isEstablished()) {
            buf.append(" established");
        }
        buf.append(": ");
        return buf.toString();
    }

    protected static final String _x(String s) {
        return s;
    }

    private static class FailedEstablishState
    extends EstablishBase {
        public FailedEstablishState() {
            this._state = State.CORRUPT;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public void receive(ByteBuffer src) {
            throw new IllegalStateException("receive() " + src.remaining() + " on failed state, doing nothing!");
        }

        @Override
        public void prepareOutbound() {
            throw new IllegalStateException("prepareOutbound() on failed state, doing nothing!");
        }

        @Override
        public String toString() {
            return "FailedEstablishState: ";
        }
    }

    protected static enum State {
        OB_INIT,
        OB_SENT_X,
        OB_GOT_Y,
        OB_GOT_HXY,
        OB_SENT_RI,
        OB_GOT_SIG,
        IB_INIT,
        IB_GOT_X,
        IB_GOT_HX,
        IB_SENT_Y,
        IB_GOT_RI_SIZE,
        IB_GOT_RI,
        IB_NTCP2_INIT,
        IB_NTCP2_GOT_X,
        IB_NTCP2_GOT_PADDING,
        IB_NTCP2_SENT_Y,
        IB_NTCP2_GOT_RI,
        IB_NTCP2_READ_RANDOM,
        VERIFIED,
        CORRUPT;

    }

    private static class VerifiedEstablishState
    extends EstablishBase {
        public VerifiedEstablishState() {
            this._state = State.VERIFIED;
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public void receive(ByteBuffer src) {
            throw new IllegalStateException("receive() " + src.remaining() + " on verified state, doing nothing!");
        }

        @Override
        public void prepareOutbound() {
            throw new IllegalStateException("prepareOutbound() on verified state, doing nothing!");
        }

        @Override
        public String toString() {
            return "VerifiedEstablishState: ";
        }
    }
}

