/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.ExploreJob;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class StartExplorersJob
extends JobImpl {
    private final Log _log;
    private final KademliaNetworkDatabaseFacade _facade;
    private static final int MAX_PER_RUN = 1;
    private static final int MIN_RERUN_DELAY_MS = 99000;
    private static final int MAX_RERUN_DELAY_MS = 900000;
    private static final int STARTUP_TIME = 3600000;
    private static final int LOW_ROUTERS = 125;
    private static final int MIN_ROUTERS = 250;
    private static final int MAX_ROUTERS = 800;
    private static final long MAX_LAG = 100L;
    private static final long MAX_MSG_DELAY = 1500L;

    public StartExplorersJob(RouterContext context, KademliaNetworkDatabaseFacade facade) {
        super(context);
        this._log = context.logManager().getLog(StartExplorersJob.class);
        this._facade = facade;
    }

    @Override
    public String getName() {
        return "Start Explorers Job";
    }

    @Override
    public void runJob() {
        if (!this._facade.floodfillEnabled() && this.getContext().jobQueue().getMaxLag() <= 100L && this.getContext().throttle().getMessageDelay() <= 1500L && !this.getContext().router().gracefulShutdownInProgress()) {
            int num = 1;
            if (this._facade.getDataStore().size() < 125) {
                num *= 3;
            }
            if (this.getContext().router().getUptime() < 3600000L) {
                num *= 3;
            }
            Set<Hash> toExplore = this.selectKeysToExplore(num);
            if (this._log.shouldLog(10)) {
                this._log.debug("Keys to explore during this run: " + toExplore);
            }
            this._facade.removeFromExploreKeys(toExplore);
            long delay = 0L;
            for (Hash key : toExplore) {
                ExploreJob j = new ExploreJob(this.getContext(), this._facade, key);
                if (delay > 0L) {
                    j.getTiming().setStartAfter(this.getContext().clock().now() + delay);
                }
                this.getContext().jobQueue().addJob(j);
                delay += 200L;
            }
        }
        long delay = this.getNextRunDelay();
        if (this._log.shouldLog(10)) {
            this._log.debug("Reenqueueing the exploration with a delay of " + delay);
        }
        this.requeue(delay);
    }

    public void updateExploreSchedule() {
    }

    private long getNextRunDelay() {
        if (this._facade.floodfillEnabled()) {
            return 900000L;
        }
        if (this.getContext().router().getUptime() < 3600000L || this._facade.getDataStore().size() < 250 || this.getContext().router().isHidden()) {
            return 99000L;
        }
        RouterInfo ri = this.getContext().router().getRouterInfo();
        if (ri != null && ri.getCapabilities().contains("K")) {
            return 99000L;
        }
        if (this._facade.getDataStore().size() > 800) {
            return 900000L;
        }
        long delay = this.getContext().clock().now() - this._facade.getLastExploreNewDate();
        if (delay < 99000L) {
            return 99000L;
        }
        if (delay > 900000L) {
            return 900000L;
        }
        return delay;
    }

    private Set<Hash> selectKeysToExplore(int num) {
        Set<Hash> queued = this._facade.getExploreKeys();
        if (this._log.shouldLog(10)) {
            this._log.debug("Keys waiting for exploration: " + queued.size());
        }
        HashSet<Hash> rv = new HashSet<Hash>(num);
        for (Hash key : queued) {
            if (rv.size() >= num) break;
            rv.add(key);
        }
        for (int i = rv.size(); i < num; ++i) {
            byte[] hash = new byte[32];
            this.getContext().random().nextBytes(hash);
            Hash key = new Hash(hash);
            rv.add(key);
        }
        return rv;
    }
}

