/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.Job;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.IterativeLookupSelector;
import net.i2p.router.networkdb.kademlia.IterativeTimeoutJob;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class IterativeSearchJob
extends FloodSearchJob {
    private final SortedSet<Hash> _toTry;
    private final Set<Hash> _unheardFrom;
    private final Set<Hash> _failedPeers;
    private final Map<Hash, Long> _sentTime;
    private final Hash _rkey;
    private OutNetMessage _out;
    private final Hash _fromLocalDest;
    private static Hash _alwaysQueryHash;
    private final int _totalSearchLimit;
    private final MaskedIPSet _ipSet;
    private final Set<Hash> _skippedPeers;
    private static final int MAX_NON_FF = 3;
    private static final int TOTAL_SEARCH_LIMIT = 5;
    private static final int TOTAL_SEARCH_LIMIT_WHEN_FF = 3;
    private static final int EXTRA_PEERS = 1;
    private static final int IP_CLOSE_BYTES = 3;
    private static final int MAX_SEARCH_TIME = 30000;
    private final long _singleSearchTime;
    private static final long SINGLE_SEARCH_TIME = 3000L;
    private static final long SINGLE_SEARCH_MSG_TIME = 10000L;
    private final int _maxConcurrent;
    private static final int MAX_CONCURRENT = 1;
    public static final String PROP_ENCRYPT_RI = "router.encryptRouterLookups";
    public static final boolean DEFAULT_ENCRYPT_RI;
    private static final String MIN_QUERY_VERSION = "0.9.28";

    public IterativeSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        this(ctx, facade, key, onFind, onFailed, timeoutMs, isLease, null);
    }

    public IterativeSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease, Hash fromLocalDest) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        this._timeoutMs = Math.min(timeoutMs, 30000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._rkey = ctx.routingKeyGenerator().getRoutingKey(key);
        this._toTry = new TreeSet<Hash>(new XORComparator<Hash>(this._rkey));
        int totalSearchLimit = facade.floodfillEnabled() && ctx.router().getUptime() > 1800000L ? 3 : 5;
        this._totalSearchLimit = ctx.getProperty("netdb.searchLimit", totalSearchLimit);
        this._ipSet = new MaskedIPSet(2 * (this._totalSearchLimit + 1));
        this._singleSearchTime = ctx.getProperty("netdb.singleSearchTime", 3000L);
        this._maxConcurrent = ctx.getProperty("netdb.maxConcurrent", 1);
        this._unheardFrom = new HashSet<Hash>(2);
        this._failedPeers = new HashSet<Hash>(this._totalSearchLimit);
        this._skippedPeers = new HashSet<Hash>(4);
        this._sentTime = new ConcurrentHashMap<Hash, Long>(this._totalSearchLimit);
        this._fromLocalDest = fromLocalDest;
        if (fromLocalDest != null && !isLease && this._log.shouldLog(30)) {
            this._log.warn("Search for RI " + key + " down client tunnel " + fromLocalDest, new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        boolean empty;
        byte[] b;
        if (this._facade.isNegativeCached(this._key)) {
            if (this._log.shouldInfo()) {
                this._log.info("Negative cached, not searching: " + this._key);
            }
            this.failed();
            return;
        }
        KBucketSet<Hash> ks = this._facade.getKBuckets();
        List<Object> floodfillPeers = ks != null ? ((FloodfillPeerSelector)this._facade.getPeerSelector()).selectFloodfillParticipants(this._rkey, this._totalSearchLimit + 1, ks) : new ArrayList(this._totalSearchLimit);
        String alwaysQuery = this.getContext().getProperty("netDb.alwaysQuery");
        if (alwaysQuery != null && _alwaysQueryHash == null && (b = Base64.decode(alwaysQuery)) != null && b.length == 32) {
            _alwaysQueryHash = Hash.create(b);
        }
        if (floodfillPeers.isEmpty()) {
            ArrayList<Hash> all;
            if (this._log.shouldLog(30)) {
                this._log.warn("Running netDb searches against the floodfill peers, but we don't know any");
            }
            if ((all = new ArrayList<Hash>(this._facade.getAllRouters())).isEmpty()) {
                if (this._log.shouldLog(40)) {
                    this._log.error("We don't know any peers at all");
                }
                this.failed();
                return;
            }
            RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
            for (int i = 0; iter.hasNext() && i < 3; ++i) {
                floodfillPeers.add(iter.next());
            }
        }
        Hash us = this.getContext().routerHash();
        IterativeSearchJob i = this;
        synchronized (i) {
            this._toTry.addAll(floodfillPeers);
            this._toTry.remove(us);
            this._toTry.remove(this._key);
            empty = this._toTry.isEmpty();
        }
        if (empty) {
            if (this._log.shouldLog(30)) {
                this._log.warn(this.getJobId() + ": ISJ for " + this._key + " had no peers to send to");
            }
            this.failed();
            return;
        }
        IterativeLookupSelector replySelector = new IterativeLookupSelector(this.getContext(), this);
        FloodOnlyLookupMatchJob onReply = new FloodOnlyLookupMatchJob(this.getContext(), this);
        FloodOnlyLookupTimeoutJob onTimeout = new FloodOnlyLookupTimeoutJob(this.getContext(), this);
        this._out = this.getContext().messageRegistry().registerPending(replySelector, onReply, onTimeout);
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": New ISJ for " + (this._isLease ? "LS " : "RI ") + this._key + " (rkey " + this._rkey + ") timeout " + DataHelper.formatDuration(this._timeoutMs) + " toTry: " + DataHelper.toString(this._toTry));
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        long now = this.getContext().clock().now();
        if (this._expiration < now) {
            this.failed();
            return;
        }
        if (this._expiration - 500L < now) {
            return;
        }
        while (true) {
            int done;
            int pend;
            Hash peer = null;
            IterativeSearchJob iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                if (this._dead) {
                    return;
                }
                pend = this._unheardFrom.size();
                if (pend >= this._maxConcurrent) {
                    return;
                }
                done = this._failedPeers.size();
            }
            if (done >= this._totalSearchLimit) {
                this.failed();
                return;
            }
            if (done + pend >= this._totalSearchLimit) {
                return;
            }
            iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                if (_alwaysQueryHash != null && !this._unheardFrom.contains(_alwaysQueryHash) && !this._failedPeers.contains(_alwaysQueryHash)) {
                    peer = _alwaysQueryHash;
                } else {
                    if (this._toTry.isEmpty()) {
                        return;
                    }
                    Iterator iter = this._toTry.iterator();
                    while (iter.hasNext()) {
                        Hash h = (Hash)iter.next();
                        iter.remove();
                        MaskedIPSet peerIPs = new MaskedIPSet(this.getContext(), h, 3);
                        if (!this._ipSet.containsAny(peerIPs)) {
                            this._ipSet.addAll(peerIPs);
                            peer = h;
                            break;
                        }
                        if (this._log.shouldLog(20)) {
                            this._log.info(this.getJobId() + ": Skipping query w/ router too close to others " + h);
                        }
                        this._skippedPeers.add(h);
                    }
                    if (peer == null) {
                        return;
                    }
                }
                this._unheardFrom.add(peer);
            }
            this.sendQuery(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(Hash peer) {
        boolean isDirect;
        TunnelInfo replyTunnel;
        boolean isClientReplyTunnel;
        TunnelInfo outTunnel;
        String since;
        String v;
        TunnelManagerFacade tm = this.getContext().tunnelManager();
        RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
        if (ri != null && VersionComparator.comp(v = ri.getVersion(), since = MIN_QUERY_VERSION) < 0) {
            this.failed(peer, false);
            if (this._log.shouldInfo()) {
                this._log.info(this.getJobId() + ": not sending query to old version " + v + ": " + peer);
            }
            return;
        }
        if (this._fromLocalDest != null) {
            outTunnel = tm.selectOutboundTunnel(this._fromLocalDest, peer);
            if (outTunnel == null) {
                outTunnel = tm.selectOutboundExploratoryTunnel(peer);
            }
            boolean bl = isClientReplyTunnel = (replyTunnel = tm.selectInboundTunnel(this._fromLocalDest, peer)) != null;
            if (!isClientReplyTunnel) {
                replyTunnel = tm.selectInboundExploratoryTunnel(peer);
            }
            isDirect = false;
        } else if (!this._isLease && ri != null && this.getContext().commSystem().isEstablished(peer)) {
            outTunnel = null;
            replyTunnel = null;
            isClientReplyTunnel = false;
            isDirect = true;
            this.getContext().statManager().addRateData("netDb.RILookupDirect", 1L);
        } else {
            outTunnel = tm.selectOutboundExploratoryTunnel(peer);
            replyTunnel = tm.selectInboundExploratoryTunnel(peer);
            isClientReplyTunnel = false;
            isDirect = false;
            this.getContext().statManager().addRateData("netDb.RILookupDirect", 0L);
        }
        if (!(isDirect || replyTunnel != null && outTunnel != null)) {
            this.failed();
            return;
        }
        if (outTunnel != null && outTunnel.getLength() <= 1) {
            if (peer.equals(this._key)) {
                this.failed(peer, false);
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": not doing zero-hop self-lookup of " + peer);
                }
                return;
            }
            if (this._facade.lookupLocallyWithoutValidation(peer) == null) {
                this.failed(peer, false);
                if (this._log.shouldLog(30)) {
                    this._log.warn(this.getJobId() + ": not doing zero-hop lookup to unknown " + peer);
                }
                return;
            }
        }
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
        if (isDirect) {
            dlm.setFrom(this.getContext().routerHash());
        } else {
            dlm.setFrom(replyTunnel.getPeer(0));
            dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
        }
        dlm.setMessageExpiration(this.getContext().clock().now() + 10000L);
        dlm.setSearchKey(this._key);
        dlm.setSearchType(this._isLease ? DatabaseLookupMessage.Type.LS : DatabaseLookupMessage.Type.RI);
        if (this._log.shouldLog(20)) {
            int tries;
            IterativeSearchJob iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                tries = this._unheardFrom.size() + this._failedPeers.size();
            }
            this._log.info(this.getJobId() + ": ISJ try " + tries + " for " + (this._isLease ? "LS " : "RI ") + this._key + " to " + peer + " direct? " + isDirect + " reply via client tunnel? " + isClientReplyTunnel);
        }
        long now = this.getContext().clock().now();
        this._sentTime.put(peer, now);
        FastI2NPMessageImpl outMsg = null;
        if (!isDirect && (this._isLease || this.getContext().getProperty(PROP_ENCRYPT_RI, DEFAULT_ENCRYPT_RI) && this.getContext().jobQueue().getMaxLag() < 300L) && ri != null) {
            MessageWrapper.OneTimeSession sess = isClientReplyTunnel ? MessageWrapper.generateSession(this.getContext(), this._fromLocalDest) : MessageWrapper.generateSession(this.getContext());
            if (sess != null) {
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": Requesting encrypted reply from " + peer + ' ' + sess.key + ' ' + sess.tag);
                }
                dlm.setReplySession(sess.key, sess.tag);
            }
            outMsg = MessageWrapper.wrap(this.getContext(), (I2NPMessage)dlm, ri);
            if (this._dead) {
                if (this._log.shouldLog(10)) {
                    this._log.debug(this.getJobId() + ": aborting send, finished while wrapping msg to " + peer);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getJobId() + ": Encrypted DLM for " + this._key + " to " + peer);
            }
        }
        if (outMsg == null) {
            outMsg = dlm;
        }
        if (isDirect) {
            OutNetMessage m = new OutNetMessage(this.getContext(), outMsg, outMsg.getMessageExpiration(), 500, ri);
            this.getContext().commSystem().processMessage(m);
        } else {
            this.getContext().tunnelDispatcher().dispatchOutbound(outMsg, outTunnel.getSendTunnelId(0), peer);
        }
        IterativeTimeoutJob j = new IterativeTimeoutJob(this.getContext(), peer, this);
        long expire = Math.min(this._expiration, now + this._singleSearchTime);
        j.getTiming().setStartAfter(expire);
        this.getContext().jobQueue().addJob(j);
    }

    @Override
    public String getName() {
        return "Iterative search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Hash peer, boolean timedOut) {
        boolean isNewFail;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._unheardFrom.remove(peer);
            isNewFail = this._failedPeers.add(peer);
        }
        if (isNewFail) {
            if (timedOut) {
                this.getContext().profileManager().dbLookupFailed(peer);
                if (this._log.shouldLog(20)) {
                    this._log.info(this.getJobId() + ": search timed out to " + peer);
                }
            } else if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": search failed to " + peer);
            }
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newPeerToTry(Hash peer) {
        if (peer.equals(this.getContext().routerHash()) || peer.equals(this._key)) {
            return;
        }
        if (this.getContext().banlist().isBanlistedForever(peer)) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": banlisted peer from DSRM " + peer);
            }
            return;
        }
        RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
        if (ri != null && !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getJobId() + ": non-ff peer from DSRM " + peer);
            }
            return;
        }
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._failedPeers.contains(peer) || this._unheardFrom.contains(peer) || this._skippedPeers.contains(peer)) {
                return;
            }
            if (!this._toTry.add(peer)) {
                return;
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": new peer from DSRM: known? " + (ri != null) + ' ' + peer);
        }
        this.retry();
    }

    public Hash getFromHash() {
        return this._fromLocalDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasQueried(Hash peer) {
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            return this._unheardFrom.contains(peer) || this._failedPeers.contains(peer);
        }
    }

    long timeSent(Hash peer) {
        Long rv = this._sentTime.get(peer);
        return rv == null ? -1L : rv;
    }

    @Override
    public void dropped() {
        this.failed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void failed() {
        ArrayList<Hash> unheard;
        int tries;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this._facade.complete(this._key);
        if (this.getContext().commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED) {
            this._facade.lookupFailed(this._key);
        }
        this.getContext().messageRegistry().unregisterPending(this._out);
        IterativeSearchJob iterativeSearchJob2 = this;
        synchronized (iterativeSearchJob2) {
            tries = this._unheardFrom.size() + this._failedPeers.size();
            unheard = new ArrayList<Hash>(this._unheardFrom);
        }
        for (Hash h : unheard) {
            this.getContext().profileManager().dbLookupFailed(h);
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldLog(20)) {
            long timeRemaining = this._expiration - this.getContext().clock().now();
            this._log.info(this.getJobId() + ": ISJ for " + this._key + " failed with " + timeRemaining + " remaining after " + time + ", peers queried: " + tries);
        }
        if (tries > 0) {
            this.getContext().statManager().addRateData("netDb.failedTime", time);
            this.getContext().statManager().addRateData("netDb.failedRetries", tries - 1);
        }
        for (Job j : this._onFailed) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFailed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void success() {
        Long timeSent;
        int tries;
        Hash peer = null;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
            this._success = true;
            tries = this._unheardFrom.size() + this._failedPeers.size();
            if (this._unheardFrom.size() == 1) {
                peer = this._unheardFrom.iterator().next();
                this._unheardFrom.clear();
            }
        }
        this._facade.complete(this._key);
        if (peer != null && (timeSent = this._sentTime.get(peer)) != null) {
            this.getContext().profileManager().dbLookupSuccessful(peer, this.getContext().clock().now() - timeSent);
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldLog(20)) {
            this._log.info(this.getJobId() + ": ISJ for " + this._key + " successful after " + time + ", peers queried: " + tries);
        }
        this.getContext().statManager().addRateData("netDb.successTime", time);
        this.getContext().statManager().addRateData("netDb.successRetries", tries - 1);
        for (Job j : this._onFind) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFind.clear();
    }

    static {
        DEFAULT_ENCRYPT_RI = SystemVersion.isX86() && !SystemVersion.isApache() && !SystemVersion.isGNU() && NativeBigInteger.isNative();
    }
}

