/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.DatabaseEntry;
import net.i2p.data.LeaseSet;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.util.Log;

class FloodOnlyLookupMatchJob
extends JobImpl
implements ReplyJob {
    private final Log _log;
    private final FloodSearchJob _search;

    public FloodOnlyLookupMatchJob(RouterContext ctx, FloodSearchJob job) {
        super(ctx);
        this._log = ctx.logManager().getLog(this.getClass());
        this._search = job;
    }

    @Override
    public void runJob() {
        if (this.getContext().netDb().lookupLocally(this._search.getKey()) != null) {
            if (this._log.shouldLog(20)) {
                this._log.info(this._search.getJobId() + ": search match and found locally");
            }
            this._search.success();
        } else {
            this._search.failed();
        }
    }

    @Override
    public String getName() {
        return "NetDb flood search match";
    }

    @Override
    public void setMessage(I2NPMessage message) {
        block10: {
            if (message instanceof DatabaseSearchReplyMessage) {
                this._search.failed();
                return;
            }
            try {
                DatabaseEntry entry;
                int type;
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                if (this._log.shouldLog(20)) {
                    this._log.info(this._search.getJobId() + ": got a DSM for " + dsm.getKey().toBase64());
                }
                if (DatabaseEntry.isLeaseSet(type = (entry = dsm.getEntry()).getType())) {
                    LeaseSet ls = (LeaseSet)dsm.getEntry();
                    ls.setReceivedAsReply();
                    this.getContext().netDb().store(dsm.getKey(), ls);
                } else if (type == 0) {
                    this.getContext().netDb().store(dsm.getKey(), (RouterInfo)dsm.getEntry());
                } else if (this._log.shouldWarn()) {
                    this._log.warn(this._search.getJobId() + ": got a DSM of unknown type " + type + " for " + dsm.getKey().toBase64());
                }
            }
            catch (UnsupportedCryptoException uce) {
                this._search.failed();
                return;
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldLog(30)) break block10;
                this._log.warn(this._search.getJobId() + ": Received an invalid store reply", iae);
            }
        }
    }
}

