/*
 * Decompiled with CFR 0.152.
 */
package com.southernstorm.noise.protocol;

import com.southernstorm.noise.crypto.ChaChaCore;
import com.southernstorm.noise.crypto.Poly1305;
import com.southernstorm.noise.protocol.CipherState;
import com.southernstorm.noise.protocol.Noise;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.ShortBufferException;
import net.i2p.data.Base64;

public class ChaChaPolyCipherState
implements CipherState {
    private final Poly1305 poly = new Poly1305();
    private final int[] input = new int[16];
    private final int[] output = new int[16];
    private final byte[] polyKey = new byte[32];
    private long n = 0L;
    private boolean haskey = false;

    @Override
    public void destroy() {
        this.poly.destroy();
        Arrays.fill(this.input, 0);
        Arrays.fill(this.output, 0);
        Noise.destroy(this.polyKey);
    }

    @Override
    public String getCipherName() {
        return "ChaChaPoly";
    }

    @Override
    public int getKeyLength() {
        return 32;
    }

    @Override
    public int getMACLength() {
        return this.haskey ? 16 : 0;
    }

    @Override
    public void initializeKey(byte[] key, int offset) {
        ChaChaCore.initKey256(this.input, key, offset);
        this.n = 0L;
        this.haskey = true;
    }

    @Override
    public boolean hasKey() {
        return this.haskey;
    }

    private static void xorBlock(byte[] input, int inputOffset, byte[] output, int outputOffset, int length, int[] block) {
        int value;
        int posn = 0;
        while (length >= 4) {
            value = block[posn++];
            output[outputOffset] = (byte)(input[inputOffset] ^ value);
            output[outputOffset + 1] = (byte)(input[inputOffset + 1] ^ value >> 8);
            output[outputOffset + 2] = (byte)(input[inputOffset + 2] ^ value >> 16);
            output[outputOffset + 3] = (byte)(input[inputOffset + 3] ^ value >> 24);
            inputOffset += 4;
            outputOffset += 4;
            length -= 4;
        }
        if (length == 3) {
            value = block[posn];
            output[outputOffset] = (byte)(input[inputOffset] ^ value);
            output[outputOffset + 1] = (byte)(input[inputOffset + 1] ^ value >> 8);
            output[outputOffset + 2] = (byte)(input[inputOffset + 2] ^ value >> 16);
        } else if (length == 2) {
            value = block[posn];
            output[outputOffset] = (byte)(input[inputOffset] ^ value);
            output[outputOffset + 1] = (byte)(input[inputOffset + 1] ^ value >> 8);
        } else if (length == 1) {
            value = block[posn];
            output[outputOffset] = (byte)(input[inputOffset] ^ value);
        }
    }

    private void setup(byte[] ad) {
        if (this.n == -1L) {
            throw new IllegalStateException("Nonce has wrapped around");
        }
        ChaChaCore.initIV(this.input, this.n++);
        ChaChaCore.hash(this.output, this.input);
        Arrays.fill(this.polyKey, (byte)0);
        ChaChaPolyCipherState.xorBlock(this.polyKey, 0, this.polyKey, 0, 32, this.output);
        this.poly.reset(this.polyKey, 0);
        if (ad != null) {
            this.poly.update(ad, 0, ad.length);
            this.poly.pad();
        }
        if ((this.input[12] = this.input[12] + 1) == 0) {
            this.input[13] = this.input[13] + 1;
        }
    }

    private static void putLittleEndian64(byte[] output, int offset, long value) {
        output[offset] = (byte)value;
        output[offset + 1] = (byte)(value >> 8);
        output[offset + 2] = (byte)(value >> 16);
        output[offset + 3] = (byte)(value >> 24);
        output[offset + 4] = (byte)(value >> 32);
        output[offset + 5] = (byte)(value >> 40);
        output[offset + 6] = (byte)(value >> 48);
        output[offset + 7] = (byte)(value >> 56);
    }

    private void finish(byte[] ad, int length) {
        this.poly.pad();
        ChaChaPolyCipherState.putLittleEndian64(this.polyKey, 0, ad != null ? (long)ad.length : 0L);
        ChaChaPolyCipherState.putLittleEndian64(this.polyKey, 8, length);
        this.poly.update(this.polyKey, 0, 16);
        this.poly.finish(this.polyKey, 0);
    }

    private void encrypt(byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) {
        while (length > 0) {
            int tempLen = 64;
            if (tempLen > length) {
                tempLen = length;
            }
            ChaChaCore.hash(this.output, this.input);
            ChaChaPolyCipherState.xorBlock(plaintext, plaintextOffset, ciphertext, ciphertextOffset, tempLen, this.output);
            this.input[12] = this.input[12] + 1;
            if (this.input[12] == 0) {
                this.input[13] = this.input[13] + 1;
            }
            plaintextOffset += tempLen;
            ciphertextOffset += tempLen;
            length -= tempLen;
        }
    }

    @Override
    public int encryptWithAd(byte[] ad, byte[] plaintext, int plaintextOffset, byte[] ciphertext, int ciphertextOffset, int length) throws ShortBufferException {
        int space = ciphertextOffset > ciphertext.length ? 0 : ciphertext.length - ciphertextOffset;
        if (!this.haskey) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
            }
            return length;
        }
        if (space < 16 || length > space - 16) {
            throw new ShortBufferException();
        }
        this.setup(ad);
        this.encrypt(plaintext, plaintextOffset, ciphertext, ciphertextOffset, length);
        this.poly.update(ciphertext, ciphertextOffset, length);
        this.finish(ad, length);
        System.arraycopy(this.polyKey, 0, ciphertext, ciphertextOffset + length, 16);
        return length + 16;
    }

    @Override
    public int decryptWithAd(byte[] ad, byte[] ciphertext, int ciphertextOffset, byte[] plaintext, int plaintextOffset, int length) throws ShortBufferException, BadPaddingException {
        int dataLen;
        int space = ciphertextOffset > ciphertext.length ? 0 : ciphertext.length - ciphertextOffset;
        if (length > space) {
            throw new ShortBufferException();
        }
        space = plaintextOffset > plaintext.length ? 0 : plaintext.length - plaintextOffset;
        if (!this.haskey) {
            if (length > space) {
                throw new ShortBufferException();
            }
            if (plaintext != ciphertext || plaintextOffset != ciphertextOffset) {
                System.arraycopy(ciphertext, ciphertextOffset, plaintext, plaintextOffset, length);
            }
            return length;
        }
        if (length < 16) {
            Noise.throwBadTagException();
        }
        if ((dataLen = length - 16) > space) {
            throw new ShortBufferException();
        }
        this.setup(ad);
        this.poly.update(ciphertext, ciphertextOffset, dataLen);
        this.finish(ad, dataLen);
        int temp = 0;
        for (int index = 0; index < 16; ++index) {
            temp |= this.polyKey[index] ^ ciphertext[ciphertextOffset + dataLen + index];
        }
        if ((temp & 0xFF) != 0) {
            Noise.throwBadTagException();
        }
        this.encrypt(ciphertext, ciphertextOffset, plaintext, plaintextOffset, dataLen);
        return dataLen;
    }

    @Override
    public CipherState fork(byte[] key, int offset) {
        ChaChaPolyCipherState cipher = new ChaChaPolyCipherState();
        cipher.initializeKey(key, offset);
        return cipher;
    }

    @Override
    public void setNonce(long nonce) {
        this.n = nonce;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("  Cipher State:\n    nonce: ");
        buf.append(this.n);
        buf.append("\n    poly key: ");
        if (this.haskey) {
            buf.append(Base64.encode(this.polyKey));
        } else {
            buf.append("null");
        }
        buf.append('\n');
        return buf.toString();
    }
}

