/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jrobin.core.RrdFileBackend;

public class RrdNioByteBufferBackend
extends RrdFileBackend {
    private ByteBuffer m_byteBuffer;
    private FileChannel m_ch;
    private static final ReadWriteLock m_readWritelock = new ReentrantReadWriteLock();
    private static final Lock m_readLock = m_readWritelock.readLock();
    private static final Lock m_writeLock = m_readWritelock.writeLock();

    protected RrdNioByteBufferBackend(String path, boolean readOnly) throws IOException, IllegalStateException {
        super(path, readOnly);
        if (this.file == null) {
            throw new IllegalStateException("File in base class is null.");
        }
        this.m_ch = this.file.getChannel();
        this.m_byteBuffer = ByteBuffer.allocate((int)this.m_ch.size());
        this.m_ch.read(this.m_byteBuffer, 0L);
    }

    @Override
    protected void setLength(long newLength) throws IOException {
        m_writeLock.lock();
        try {
            super.setLength(newLength);
            this.m_ch = this.file.getChannel();
            this.m_byteBuffer = ByteBuffer.allocate((int)newLength);
            this.m_ch.read(this.m_byteBuffer, 0L);
            this.m_byteBuffer.position(0);
        }
        finally {
            m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(long offset, byte[] b) {
        m_writeLock.lock();
        try {
            this.m_byteBuffer.position((int)offset);
            this.m_byteBuffer.put(b);
        }
        finally {
            m_writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void read(long offset, byte[] b) {
        m_readLock.lock();
        try {
            this.m_byteBuffer.position((int)offset);
            this.m_byteBuffer.get(b);
        }
        finally {
            m_readLock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        m_writeLock.lock();
        try {
            this.m_byteBuffer.position(0);
            if (!this.isReadOnly()) {
                this.m_ch.write(this.m_byteBuffer, 0L);
            }
            super.close();
        }
        finally {
            m_writeLock.unlock();
        }
    }
}

