/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.Base32;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class I2PSocketEepGet
extends EepGet {
    private final I2PSocketManager _socketManager;
    private I2PSocket _socket;
    private static final String PROP_CONNECT_DELAY = "i2p.streaming.connectDelay";
    private static final String CONNECT_DELAY = "500";

    public I2PSocketEepGet(I2PAppContext ctx, I2PSocketManager mgr, int numRetries, String outputFile, String url) {
        this(ctx, mgr, numRetries, -1L, -1L, outputFile, null, url);
    }

    public I2PSocketEepGet(I2PAppContext ctx, I2PSocketManager mgr, int numRetries, long minSize, long maxSize, String outputFile, OutputStream outputStream, String url) {
        super(ctx, false, null, -1, numRetries, minSize, maxSize, outputFile, outputStream, url, true, null, null);
        this._socketManager = mgr;
    }

    public boolean fetch(long fetchHeaderTimeout, long totalTimeout, long inactivityTimeout) {
        boolean rv = super.fetch(fetchHeaderTimeout, totalTimeout, inactivityTimeout);
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return rv;
    }

    protected void readHeaders() throws IOException {
        try {
            super.readHeaders();
        }
        finally {
            this._isGzippedResponse = false;
        }
    }

    protected void sendRequest(SocketTimeout timeout) throws IOException {
        File outFile2;
        if (this._outputStream == null && (outFile2 = new File(this._outputFile)).exists()) {
            this._alreadyTransferred = outFile2.length();
        }
        if (this._proxyIn != null) {
            try {
                this._proxyIn.close();
            }
            catch (IOException outFile2) {
                // empty catch block
            }
        }
        if (this._proxyOut != null) {
            try {
                this._proxyOut.close();
            }
            catch (IOException outFile2) {
                // empty catch block
            }
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException outFile2) {
                // empty catch block
            }
        }
        try {
            Destination dest;
            int port;
            URI url = new URI(this._actualURL);
            if ("http".equals(url.getScheme())) {
                String host;
                block29: {
                    I2PSession sess;
                    host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("no hostname: " + this._actualURL);
                    }
                    port = url.getPort();
                    if (port <= 0 || port > 65535) {
                        port = 80;
                    }
                    if ("i2p".equals(host)) {
                        String file = url.getRawPath();
                        try {
                            int slash = 1 + file.substring(1).indexOf(47);
                            host = file.substring(1, slash);
                            this._actualURL = "http://" + host + file.substring(slash);
                            String query = url.getRawQuery();
                            if (query != null) {
                                this._actualURL = this._actualURL + '?' + query;
                            }
                        }
                        catch (IndexOutOfBoundsException ioobe) {
                            throw new MalformedURLException("Bad /i2p/ format: " + this._actualURL);
                        }
                    }
                    if ((sess = this._socketManager.getSession()) != null && !sess.isClosed()) {
                        try {
                            if (host.length() == 60 && host.endsWith(".b32.i2p")) {
                                byte[] b = Base32.decode((String)host.substring(0, 52));
                                if (b != null) {
                                    Hash h = Hash.create((byte[])b);
                                    dest = sess.lookupDest(h, 20000L);
                                } else {
                                    dest = null;
                                }
                                break block29;
                            }
                            dest = sess.lookupDest(host, 20000L);
                        }
                        catch (I2PSessionException ise) {
                            dest = null;
                        }
                    } else {
                        dest = this._context.namingService().lookup(host);
                    }
                }
                if (dest == null) {
                    throw new UnknownHostException("Unknown or non-i2p host: " + host);
                }
            } else {
                throw new MalformedURLException("Unsupported protocol: " + this._actualURL);
            }
            Properties props = new Properties();
            props.setProperty("i2p.streaming.connectTimeout", "45000");
            props.setProperty("i2p.streaming.readTimeout", "60000");
            props.setProperty(PROP_CONNECT_DELAY, CONNECT_DELAY);
            I2PSocketOptions opts = this._socketManager.buildOptions(props);
            opts.setPort(port);
            this._socket = this._socketManager.connect(dest, opts);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Bad URL");
            ioe.initCause(use);
            throw ioe;
        }
        catch (I2PException ie) {
            throw new IOException("I2P error", ie);
        }
        this._proxyIn = this._socket.getInputStream();
        this._proxyOut = this._socket.getOutputStream();
        String req = this.getRequest();
        this._proxyOut.write(DataHelper.getUTF8((String)req));
        this._proxyOut.flush();
    }

    protected String getRequest() throws IOException {
        URI url;
        StringBuilder buf = new StringBuilder(2048);
        try {
            url = new URI(this._actualURL);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Bad URL");
            ioe.initCause(use);
            throw ioe;
        }
        String path = url.getRawPath();
        String query = url.getRawQuery();
        if (query != null) {
            path = path + '?' + query;
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        buf.append("GET ").append(path).append(" HTTP/1.1\r\nHost: ").append(url.getHost()).append("\r\n");
        if (this._alreadyTransferred > 0L) {
            buf.append("Range: bytes=");
            buf.append(this._alreadyTransferred);
            buf.append("-\r\n");
        }
        buf.append("Accept-Encoding: \r\nCache-Control: no-cache\r\nPragma: no-cache\r\nConnection: close\r\n");
        boolean uaOverridden = false;
        if (this._extraHeaders != null) {
            for (String hdr : this._extraHeaders) {
                if (hdr.toLowerCase(Locale.US).startsWith("user-agent: ")) {
                    uaOverridden = true;
                }
                buf.append(hdr).append("\r\n");
            }
        }
        if (!uaOverridden) {
            buf.append("User-Agent: Wget/1.11.4\r\n");
        }
        buf.append("\r\n");
        if (this._log.shouldDebug()) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }
}

