/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark.comments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.i2p.util.SecureFileOutputStream;
import org.klomp.snark.comments.Comment;

public class CommentSet
extends AbstractSet<Comment> {
    private final HashMap<Integer, List<Comment>> map;
    private int size;
    private int realSize;
    private int myRating;
    private int totalRating;
    private int ratingSize;
    private int totalTextSize;
    private long latestCommentTime;
    private boolean modified;
    public static final int MAX_SIZE = 256;
    private static final int MAX_TOTAL_TEXT_LEN = 4096;

    public CommentSet() {
        this.map = new HashMap(4);
    }

    public CommentSet(Collection<Comment> coll) {
        this.map = new HashMap(coll.size());
        this.addAll(coll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommentSet(File file) throws IOException {
        this();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(file)), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                Comment c = Comment.fromPersistentString(line);
                if (c == null) continue;
                this.add(c);
            }
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.modified = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        try (PrintWriter out = null;){
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new SecureFileOutputStream(file)), "UTF-8"));
            for (List<Comment> l : this.map.values()) {
                for (Comment c : l) {
                    out.println(c.toPersistentString());
                }
            }
            if (out.checkError()) {
                throw new IOException("Failed write to " + file);
            }
            this.modified = false;
        }
    }

    @Override
    public boolean add(Comment c) {
        if (this.realSize >= 256 && !c.isMine()) {
            return false;
        }
        String s = c.getText();
        if (s != null && this.totalTextSize + s.length() > 4096) {
            return false;
        }
        if (c.isMine() && c.getText() == null && c.getRating() == this.myRating) {
            return false;
        }
        Integer hc = c.hashCode();
        List<Comment> list = this.map.get(hc);
        if (list == null) {
            list = Collections.singletonList(c);
            this.map.put(hc, list);
            this.addStats(c);
            return true;
        }
        if (list.contains(c)) {
            return false;
        }
        if (list.size() == 1) {
            ArrayList<Comment> nlist = new ArrayList<Comment>(2);
            nlist.add(list.get(0));
            this.map.put(hc, nlist);
            list = nlist;
        }
        list.add(c);
        if (c.isMine() && c.getText() == null) {
            this.removeMyOldRatings(c.getID());
        }
        this.addStats(c);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Comment cc;
        if (o == null || !(o instanceof Comment)) {
            return false;
        }
        Comment c = (Comment)o;
        Integer hc = c.hashCode();
        List<Comment> list = this.map.get(hc);
        if (list == null) {
            return false;
        }
        int i = list.indexOf(c);
        if (i >= 0 && !(cc = list.get(i)).isHidden()) {
            this.removeStats(cc);
            cc.setHidden();
            return true;
        }
        return false;
    }

    public boolean remove(int id) {
        for (List<Comment> l : this.map.values()) {
            for (Comment c : l) {
                if (c.getID() != id) continue;
                return this.remove(c);
            }
        }
        return false;
    }

    private void removeMyOldRatings(int exceptID) {
        for (List<Comment> l : this.map.values()) {
            for (Comment c : l) {
                if (!c.isMine() || c.getText() != null || c.getID() == exceptID || c.isHidden()) continue;
                this.removeStats(c);
                c.setHidden();
            }
        }
    }

    private void addStats(Comment c) {
        String t;
        ++this.realSize;
        if (!c.isHidden()) {
            long time;
            ++this.size;
            int r = c.getRating();
            if (r > 0) {
                if (c.isMine()) {
                    this.myRating = r;
                } else {
                    this.totalRating += r;
                    ++this.ratingSize;
                }
            }
            if ((time = c.getTime()) > this.latestCommentTime) {
                this.latestCommentTime = time;
            }
        }
        if ((t = c.getText()) != null) {
            this.totalTextSize += t.length();
        }
        this.modified = true;
    }

    private void removeStats(Comment c) {
        if (!c.isHidden()) {
            --this.size;
            int r = c.getRating();
            if (r > 0) {
                if (c.isMine()) {
                    if (this.myRating == r) {
                        this.myRating = 0;
                    }
                } else {
                    this.totalRating -= r;
                    --this.ratingSize;
                }
            }
            this.modified = true;
        }
    }

    public long getLatestCommentTime() {
        return this.latestCommentTime;
    }

    public boolean isModified() {
        return this.modified;
    }

    public int getMyRating() {
        return this.myRating;
    }

    public int getRatingCount() {
        return this.ratingSize;
    }

    public double getAverageRating() {
        if (this.ratingSize <= 0) {
            return 0.0;
        }
        return (double)this.totalRating / (double)this.ratingSize;
    }

    @Override
    public void clear() {
        if (this.realSize > 0) {
            this.modified = true;
            this.realSize = 0;
            this.map.clear();
            this.size = 0;
            this.myRating = 0;
            this.totalRating = 0;
            this.ratingSize = 0;
            this.totalTextSize = 0;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Comment> iterator() {
        if (this.size <= 0) {
            return Collections.emptyList().iterator();
        }
        ArrayList<Comment> list = new ArrayList<Comment>(this.size);
        for (List<Comment> l : this.map.values()) {
            int hc = l.get(0).hashCode();
            List<Comment> prevList = this.map.get(hc - 1);
            for (Comment c : l) {
                if (c.isHidden()) continue;
                if (prevList != null) {
                    boolean dup = false;
                    for (Comment pc : prevList) {
                        if (!c.equalsIgnoreTimestamp(pc)) continue;
                        dup = true;
                        break;
                    }
                    if (dup) continue;
                }
                list.add(c);
            }
        }
        Collections.sort(list);
        return list.iterator();
    }
}

