/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.client.streaming.impl.I2PSocketOptionsImpl;
import net.i2p.data.Hash;
import net.i2p.util.ConvertToHash;
import net.i2p.util.Log;

class ConnectionOptions
extends I2PSocketOptionsImpl {
    private int _connectDelay;
    private boolean _fullySigned;
    private boolean _answerPings;
    private boolean _enforceProto;
    private volatile int _windowSize;
    private int _receiveWindow;
    private int _profile;
    private int _rtt;
    private int _rttDev;
    private int _rto = 9000;
    private int _resendDelay;
    private int _sendAckDelay;
    private int _maxMessageSize;
    private int _maxResends;
    private int _inactivityTimeout;
    private int _inactivityAction;
    private int _inboundBufferSize;
    private int _maxWindowSize;
    private int _congestionAvoidanceGrowthRateFactor;
    private int _slowStartGrowthRateFactor;
    private boolean _accessListEnabled;
    private boolean _blackListEnabled;
    private Set<Hash> _accessList;
    private Set<Hash> _blackList;
    private int _maxConnsPerMinute;
    private int _maxConnsPerHour;
    private int _maxConnsPerDay;
    private int _maxTotalConnsPerMinute;
    private int _maxTotalConnsPerHour;
    private int _maxTotalConnsPerDay;
    private int _maxConns;
    private boolean _disableRejectLog;
    private String _limitAction;
    private int _tagsToSend;
    private int _tagThreshold;
    private AckInit _initState = AckInit.INIT;
    public static final int PROFILE_BULK = 1;
    public static final int PROFILE_INTERACTIVE = 2;
    public static final int INACTIVITY_ACTION_NOOP = 0;
    public static final int INACTIVITY_ACTION_DISCONNECT = 1;
    public static final int INACTIVITY_ACTION_SEND = 2;
    private static final double TCP_ALPHA = 0.125;
    private static final double TCP_BETA = 0.25;
    private static final double TCP_KAPPA = 4.0;
    private static final String PROP_INITIAL_RTO = "i2p.streaming.initialRTO";
    private static final int INITIAL_RTO = 9000;
    public static final String PROP_CONNECT_DELAY = "i2p.streaming.connectDelay";
    public static final String PROP_PROFILE = "i2p.streaming.profile";
    public static final String PROP_MAX_MESSAGE_SIZE = "i2p.streaming.maxMessageSize";
    public static final String PROP_MAX_RESENDS = "i2p.streaming.maxResends";
    public static final String PROP_INITIAL_RESEND_DELAY = "i2p.streaming.initialResendDelay";
    public static final String PROP_INITIAL_ACK_DELAY = "i2p.streaming.initialAckDelay";
    public static final String PROP_INITIAL_WINDOW_SIZE = "i2p.streaming.initialWindowSize";
    public static final String PROP_INITIAL_RECEIVE_WINDOW = "i2p.streaming.initialReceiveWindow";
    public static final String PROP_INACTIVITY_TIMEOUT = "i2p.streaming.inactivityTimeout";
    public static final String PROP_INACTIVITY_ACTION = "i2p.streaming.inactivityAction";
    public static final String PROP_MAX_WINDOW_SIZE = "i2p.streaming.maxWindowSize";
    public static final String PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR = "i2p.streaming.congestionAvoidanceGrowthRateFactor";
    public static final String PROP_SLOW_START_GROWTH_RATE_FACTOR = "i2p.streaming.slowStartGrowthRateFactor";
    public static final String PROP_ANSWER_PINGS = "i2p.streaming.answerPings";
    public static final String PROP_ENABLE_ACCESS_LIST = "i2cp.enableAccessList";
    public static final String PROP_ENABLE_BLACKLIST = "i2cp.enableBlackList";
    public static final String PROP_ACCESS_LIST = "i2cp.accessList";
    public static final String PROP_MAX_CONNS_MIN = "i2p.streaming.maxConnsPerMinute";
    public static final String PROP_MAX_CONNS_HOUR = "i2p.streaming.maxConnsPerHour";
    public static final String PROP_MAX_CONNS_DAY = "i2p.streaming.maxConnsPerDay";
    public static final String PROP_MAX_TOTAL_CONNS_MIN = "i2p.streaming.maxTotalConnsPerMinute";
    public static final String PROP_MAX_TOTAL_CONNS_HOUR = "i2p.streaming.maxTotalConnsPerHour";
    public static final String PROP_MAX_TOTAL_CONNS_DAY = "i2p.streaming.maxTotalConnsPerDay";
    public static final String PROP_ENFORCE_PROTO = "i2p.streaming.enforceProtocol";
    public static final String PROP_MAX_STREAMS = "i2p.streaming.maxConcurrentStreams";
    public static final String PROP_DISABLE_REJ_LOG = "i2p.streaming.disableRejectLogging";
    public static final String PROP_LIMIT_ACTION = "i2p.streaming.limitAction";
    public static final String PROP_TAGS_TO_SEND = "crypto.tagsToSend";
    public static final String PROP_TAG_THRESHOLD = "crypto.lowTagThreshold";
    private static final int TREND_COUNT = 3;
    static final int INITIAL_WINDOW_SIZE = 6;
    static final int DEFAULT_MAX_SENDS = 8;
    public static final int DEFAULT_INITIAL_RTT = 8000;
    private static final int MAX_RTT = 60000;
    private static final int DEFAULT_INITIAL_ACK_DELAY = 750;
    static final int MIN_WINDOW_SIZE = 1;
    private static final boolean DEFAULT_ANSWER_PINGS = true;
    private static final int DEFAULT_INACTIVITY_TIMEOUT = 90000;
    private static final int DEFAULT_INACTIVITY_ACTION = 2;
    private static final int DEFAULT_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR = 1;
    private static final int DEFAULT_SLOW_START_GROWTH_RATE_FACTOR = 1;
    private static final String DEFAULT_LIMIT_ACTION = "reset";
    public static final int DEFAULT_TAGS_TO_SEND = 40;
    public static final int DEFAULT_TAG_THRESHOLD = 30;
    private static final boolean DEFAULT_ENFORCE_PROTO = false;
    private final int[] _trend = new int[3];
    public static final int DEFAULT_MAX_MESSAGE_SIZE = 1730;
    public static final int MIN_MESSAGE_SIZE = 512;

    public ConnectionOptions() {
        this.cinit(System.getProperties());
    }

    public ConnectionOptions(Properties opts) {
        super(opts);
        this.cinit(opts);
    }

    public ConnectionOptions(I2PSocketOptions opts) {
        super(opts);
        this.cinit(System.getProperties());
    }

    public ConnectionOptions(ConnectionOptions opts) {
        super(opts);
        this.cinit(System.getProperties());
        if (opts != null) {
            this.update(opts);
        }
    }

    public void updateAll(ConnectionOptions opts) {
        this.setConnectTimeout(opts.getConnectTimeout());
        this.setReadTimeout(opts.getReadTimeout());
        this.setWriteTimeout(opts.getWriteTimeout());
        this.setMaxBufferSize(opts.getMaxBufferSize());
        this.setLocalPort(opts.getLocalPort());
        this.setPort(opts.getPort());
        this.update(opts);
    }

    private void update(ConnectionOptions opts) {
        this.setMaxWindowSize(opts.getMaxWindowSize());
        this.setConnectDelay(opts.getConnectDelay());
        this.setProfile(opts.getProfile());
        this.setRTTDev(opts.getRTTDev());
        this.setRTT(opts.getRTT());
        this.setRequireFullySigned(opts.getRequireFullySigned());
        this.setWindowSize(opts.getWindowSize());
        this.setResendDelay(opts.getResendDelay());
        this.setMaxMessageSize(opts.getMaxMessageSize());
        this.setMaxResends(opts.getMaxResends());
        this.setInactivityTimeout(opts.getInactivityTimeout());
        this.setInactivityAction(opts.getInactivityAction());
        this.setInboundBufferSize(opts.getInboundBufferSize());
        this.setCongestionAvoidanceGrowthRateFactor(opts.getCongestionAvoidanceGrowthRateFactor());
        this.setSlowStartGrowthRateFactor(opts.getSlowStartGrowthRateFactor());
        this.setAnswerPings(opts.getAnswerPings());
        this.setEnforceProtocol(opts.getEnforceProtocol());
        this.setDisableRejectLogging(opts.getDisableRejectLogging());
        this.initLists(opts);
        this._maxConnsPerMinute = opts.getMaxConnsPerMinute();
        this._maxConnsPerHour = opts.getMaxConnsPerHour();
        this._maxConnsPerDay = opts.getMaxConnsPerDay();
        this._maxTotalConnsPerMinute = opts.getMaxTotalConnsPerMinute();
        this._maxTotalConnsPerHour = opts.getMaxTotalConnsPerHour();
        this._maxTotalConnsPerDay = opts.getMaxTotalConnsPerDay();
        this._maxConns = opts.getMaxConns();
        this._limitAction = opts.getLimitAction();
        this._tagsToSend = opts.getTagsToSend();
        this._tagThreshold = opts.getTagThreshold();
    }

    private void cinit(Properties opts) {
        this.setMaxWindowSize(ConnectionOptions.getInt(opts, PROP_MAX_WINDOW_SIZE, 128));
        this.setConnectDelay(ConnectionOptions.getInt(opts, PROP_CONNECT_DELAY, -1));
        this.setProfile(ConnectionOptions.getInt(opts, PROP_PROFILE, 1));
        this.setMaxMessageSize(ConnectionOptions.getInt(opts, PROP_MAX_MESSAGE_SIZE, 1730));
        this.setReceiveWindow(ConnectionOptions.getInt(opts, PROP_INITIAL_RECEIVE_WINDOW, 1));
        this.setResendDelay(ConnectionOptions.getInt(opts, PROP_INITIAL_RESEND_DELAY, 1000));
        this.setSendAckDelay(ConnectionOptions.getInt(opts, PROP_INITIAL_ACK_DELAY, 750));
        this.setWindowSize(ConnectionOptions.getInt(opts, PROP_INITIAL_WINDOW_SIZE, 6));
        this.setMaxResends(ConnectionOptions.getInt(opts, PROP_MAX_RESENDS, 8));
        this.setInactivityTimeout(ConnectionOptions.getInt(opts, PROP_INACTIVITY_TIMEOUT, 90000));
        this.setInactivityAction(ConnectionOptions.getInt(opts, PROP_INACTIVITY_ACTION, 2));
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        this.setCongestionAvoidanceGrowthRateFactor(ConnectionOptions.getInt(opts, PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, 1));
        this.setSlowStartGrowthRateFactor(ConnectionOptions.getInt(opts, PROP_SLOW_START_GROWTH_RATE_FACTOR, 1));
        this.setAnswerPings(ConnectionOptions.getBool(opts, PROP_ANSWER_PINGS, true));
        this.setEnforceProtocol(ConnectionOptions.getBool(opts, PROP_ENFORCE_PROTO, false));
        this.setDisableRejectLogging(ConnectionOptions.getBool(opts, PROP_DISABLE_REJ_LOG, false));
        this.initLists(opts);
        this._maxConnsPerMinute = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_MIN, 0);
        this._maxConnsPerHour = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_HOUR, 0);
        this._maxConnsPerDay = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_DAY, 0);
        this._maxTotalConnsPerMinute = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_MIN, 0);
        this._maxTotalConnsPerHour = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_HOUR, 0);
        this._maxTotalConnsPerDay = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_DAY, 0);
        this._maxConns = ConnectionOptions.getInt(opts, PROP_MAX_STREAMS, 0);
        this._limitAction = opts != null ? opts.getProperty(PROP_LIMIT_ACTION, DEFAULT_LIMIT_ACTION) : DEFAULT_LIMIT_ACTION;
        this._rto = ConnectionOptions.getInt(opts, PROP_INITIAL_RTO, 9000);
        this._tagsToSend = ConnectionOptions.getInt(opts, PROP_TAGS_TO_SEND, 40);
        this._tagsToSend = ConnectionOptions.getInt(opts, PROP_TAG_THRESHOLD, 30);
    }

    @Override
    public void setProperties(Properties opts) {
        super.setProperties(opts);
        if (opts == null) {
            return;
        }
        if (opts.getProperty(PROP_MAX_WINDOW_SIZE) != null) {
            this.setMaxWindowSize(ConnectionOptions.getInt(opts, PROP_MAX_WINDOW_SIZE, 128));
        }
        if (opts.getProperty(PROP_CONNECT_DELAY) != null) {
            this.setConnectDelay(ConnectionOptions.getInt(opts, PROP_CONNECT_DELAY, -1));
        }
        if (opts.getProperty(PROP_PROFILE) != null) {
            this.setProfile(ConnectionOptions.getInt(opts, PROP_PROFILE, 1));
        }
        if (opts.getProperty(PROP_MAX_MESSAGE_SIZE) != null) {
            this.setMaxMessageSize(ConnectionOptions.getInt(opts, PROP_MAX_MESSAGE_SIZE, 32768));
        }
        if (opts.getProperty(PROP_INITIAL_RECEIVE_WINDOW) != null) {
            this.setReceiveWindow(ConnectionOptions.getInt(opts, PROP_INITIAL_RECEIVE_WINDOW, 1));
        }
        if (opts.getProperty(PROP_INITIAL_RESEND_DELAY) != null) {
            this.setResendDelay(ConnectionOptions.getInt(opts, PROP_INITIAL_RESEND_DELAY, 1000));
        }
        if (opts.getProperty(PROP_INITIAL_ACK_DELAY) != null) {
            this.setSendAckDelay(ConnectionOptions.getInt(opts, PROP_INITIAL_ACK_DELAY, 750));
        }
        if (opts.getProperty(PROP_INITIAL_WINDOW_SIZE) != null) {
            this.setWindowSize(ConnectionOptions.getInt(opts, PROP_INITIAL_WINDOW_SIZE, 6));
        }
        if (opts.getProperty(PROP_MAX_RESENDS) != null) {
            this.setMaxResends(ConnectionOptions.getInt(opts, PROP_MAX_RESENDS, 8));
        }
        if (opts.getProperty(PROP_INACTIVITY_TIMEOUT) != null) {
            this.setInactivityTimeout(ConnectionOptions.getInt(opts, PROP_INACTIVITY_TIMEOUT, 90000));
        }
        if (opts.getProperty(PROP_INACTIVITY_ACTION) != null) {
            this.setInactivityAction(ConnectionOptions.getInt(opts, PROP_INACTIVITY_ACTION, 2));
        }
        this.setInboundBufferSize(this.getMaxMessageSize() * 130);
        if (opts.getProperty(PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR) != null) {
            this.setCongestionAvoidanceGrowthRateFactor(ConnectionOptions.getInt(opts, PROP_CONGESTION_AVOIDANCE_GROWTH_RATE_FACTOR, 1));
        }
        if (opts.getProperty(PROP_SLOW_START_GROWTH_RATE_FACTOR) != null) {
            this.setSlowStartGrowthRateFactor(ConnectionOptions.getInt(opts, PROP_SLOW_START_GROWTH_RATE_FACTOR, 1));
        }
        if (opts.getProperty("i2p.streaming.connectTimeout") != null) {
            this.setConnectTimeout(ConnectionOptions.getInt(opts, "i2p.streaming.connectTimeout", 60000));
        }
        if (opts.getProperty(PROP_ANSWER_PINGS) != null) {
            this.setAnswerPings(ConnectionOptions.getBool(opts, PROP_ANSWER_PINGS, true));
        }
        if (opts.getProperty(PROP_ENFORCE_PROTO) != null) {
            this.setEnforceProtocol(ConnectionOptions.getBool(opts, PROP_ENFORCE_PROTO, false));
        }
        if (opts.getProperty(PROP_DISABLE_REJ_LOG) != null) {
            this.setDisableRejectLogging(ConnectionOptions.getBool(opts, PROP_DISABLE_REJ_LOG, false));
        }
        this.initLists(opts);
        if (opts.getProperty(PROP_MAX_CONNS_MIN) != null) {
            this._maxConnsPerMinute = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_MIN, 0);
        }
        if (opts.getProperty(PROP_MAX_CONNS_HOUR) != null) {
            this._maxConnsPerHour = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_HOUR, 0);
        }
        if (opts.getProperty(PROP_MAX_CONNS_DAY) != null) {
            this._maxConnsPerDay = ConnectionOptions.getInt(opts, PROP_MAX_CONNS_DAY, 0);
        }
        if (opts.getProperty(PROP_MAX_TOTAL_CONNS_MIN) != null) {
            this._maxTotalConnsPerMinute = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_MIN, 0);
        }
        if (opts.getProperty(PROP_MAX_TOTAL_CONNS_HOUR) != null) {
            this._maxTotalConnsPerHour = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_HOUR, 0);
        }
        if (opts.getProperty(PROP_MAX_TOTAL_CONNS_DAY) != null) {
            this._maxTotalConnsPerDay = ConnectionOptions.getInt(opts, PROP_MAX_TOTAL_CONNS_DAY, 0);
        }
        if (opts.getProperty(PROP_MAX_STREAMS) != null) {
            this._maxConns = ConnectionOptions.getInt(opts, PROP_MAX_STREAMS, 0);
        }
        if (opts.getProperty(PROP_LIMIT_ACTION) != null) {
            this._limitAction = opts.getProperty(PROP_LIMIT_ACTION);
        }
        if (opts.getProperty(PROP_TAGS_TO_SEND) != null) {
            this._maxConns = ConnectionOptions.getInt(opts, PROP_TAGS_TO_SEND, 40);
        }
        if (opts.getProperty(PROP_TAG_THRESHOLD) != null) {
            this._maxConns = ConnectionOptions.getInt(opts, PROP_TAG_THRESHOLD, 30);
        }
        this._rto = ConnectionOptions.getInt(opts, PROP_INITIAL_RTO, 9000);
    }

    public int getConnectDelay() {
        return this._connectDelay;
    }

    public void setConnectDelay(int delayMs) {
        this._connectDelay = delayMs;
    }

    public boolean getRequireFullySigned() {
        return this._fullySigned;
    }

    public void setRequireFullySigned(boolean sign) {
        this._fullySigned = sign;
    }

    public boolean getAnswerPings() {
        return this._answerPings;
    }

    public void setAnswerPings(boolean yes) {
        this._answerPings = yes;
    }

    public boolean getEnforceProtocol() {
        return this._enforceProto;
    }

    public void setEnforceProtocol(boolean yes) {
        this._enforceProto = yes;
    }

    public boolean getDisableRejectLogging() {
        return this._disableRejectLog;
    }

    public void setDisableRejectLogging(boolean yes) {
        this._disableRejectLog = yes;
    }

    public int getWindowSize() {
        return this._windowSize;
    }

    public void setWindowSize(int numMsgs) {
        if (numMsgs <= 0) {
            numMsgs = 1;
        }
        if (numMsgs < 1) {
            numMsgs = 1;
        }
        if (numMsgs > this._maxWindowSize) {
            numMsgs = this._maxWindowSize;
        }
        this._windowSize = numMsgs;
    }

    @Deprecated
    public int getReceiveWindow() {
        return this._receiveWindow;
    }

    public void setReceiveWindow(int numMsgs) {
        this._receiveWindow = numMsgs;
    }

    public synchronized int getRTT() {
        return this._rtt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRTT(int ms) {
        Object object = this._trend;
        synchronized (this._trend) {
            this._trend[0] = this._trend[1];
            this._trend[1] = this._trend[2];
            this._trend[2] = ms > this._rtt ? 1 : (ms < this._rtt ? -1 : 0);
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            ConnectionOptions connectionOptions = this;
            object = connectionOptions;
            synchronized (connectionOptions) {
                this._rtt = ms;
                if (this._rtt > 60000) {
                    this._rtt = 60000;
                }
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return;
            }
        }
    }

    public synchronized int getRTO() {
        return this._rto;
    }

    synchronized int getRTTDev() {
        return this._rttDev;
    }

    private synchronized void setRTTDev(int rttDev) {
        this._rttDev = rttDev;
    }

    synchronized void loadFromCache(int rtt, int rttDev, int wdw) {
        this._initState = AckInit.STEADY;
        this.setRTT(rtt);
        this.setRTTDev(rttDev);
        this.setWindowSize(wdw);
        this.computeRTO();
    }

    private synchronized void computeRTO() {
        switch (this._initState) {
            case INIT: {
                throw new IllegalStateException();
            }
            case FIRST: {
                this._rto = this._rtt + this._rtt / 2;
                break;
            }
            case STEADY: {
                this._rto = this._rtt + (int)((double)this._rttDev * 4.0);
            }
        }
        if ((long)this._rto < 100L) {
            this._rto = 100;
        } else if ((long)this._rto > 45000L) {
            this._rto = 45000;
        }
    }

    synchronized void doubleRTO() {
        this._rto *= 2;
        if ((long)this._rto > 45000L) {
            this._rto = 45000;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRTTTrend() {
        int[] nArray = this._trend;
        synchronized (this._trend) {
            for (int i = 0; i < 2; ++i) {
                if (this._trend[i] == this._trend[i + 1]) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this._trend[0];
        }
    }

    public synchronized void updateRTT(int measuredValue) {
        switch (this._initState) {
            case INIT: {
                this._initState = AckInit.FIRST;
                this.setRTT(measuredValue);
                this._rttDev = this._rtt / 2;
                break;
            }
            case FIRST: {
                this._initState = AckInit.STEADY;
            }
            case STEADY: {
                this._rttDev = (int)(0.75 * (double)this._rttDev + 0.25 * (double)Math.abs(measuredValue - this._rtt));
                int smoothed = (int)(0.875 * (double)this._rtt + 0.125 * (double)measuredValue);
                this.setRTT(smoothed);
            }
        }
        this.computeRTO();
    }

    public synchronized boolean receivedAck() {
        return this._initState != AckInit.INIT;
    }

    public int getResendDelay() {
        return this._resendDelay;
    }

    public void setResendDelay(int ms) {
        this._resendDelay = ms;
    }

    public int getSendAckDelay() {
        return this._sendAckDelay;
    }

    public void setSendAckDelay(int delayMs) {
        this._sendAckDelay = delayMs;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public void setMaxMessageSize(int bytes) {
        this._maxMessageSize = Math.max(bytes, 512);
    }

    public int getProfile() {
        return this._profile;
    }

    public void setProfile(int profile) {
        if (profile != 1) {
            throw new IllegalArgumentException("Only bulk is supported so far");
        }
        this._profile = profile;
    }

    public int getMaxResends() {
        return this._maxResends;
    }

    public void setMaxResends(int numSends) {
        this._maxResends = Math.max(numSends, 0);
    }

    public int getInactivityTimeout() {
        return this._inactivityTimeout;
    }

    public void setInactivityTimeout(int timeout) {
        this._inactivityTimeout = timeout;
    }

    public int getInactivityAction() {
        return this._inactivityAction;
    }

    public void setInactivityAction(int action) {
        this._inactivityAction = action;
    }

    public int getMaxWindowSize() {
        return this._maxWindowSize;
    }

    public void setMaxWindowSize(int msgs) {
        this._maxWindowSize = msgs > 128 ? 128 : (msgs < 1 ? 1 : msgs);
    }

    public int getInboundBufferSize() {
        return this._inboundBufferSize;
    }

    public void setInboundBufferSize(int bytes) {
        this._inboundBufferSize = bytes;
    }

    public int getCongestionAvoidanceGrowthRateFactor() {
        return this._congestionAvoidanceGrowthRateFactor;
    }

    public void setCongestionAvoidanceGrowthRateFactor(int factor) {
        this._congestionAvoidanceGrowthRateFactor = factor;
    }

    public int getSlowStartGrowthRateFactor() {
        return this._slowStartGrowthRateFactor;
    }

    public void setSlowStartGrowthRateFactor(int factor) {
        this._slowStartGrowthRateFactor = factor;
    }

    public int getMaxConnsPerMinute() {
        return this._maxConnsPerMinute;
    }

    public int getMaxConnsPerHour() {
        return this._maxConnsPerHour;
    }

    public int getMaxConnsPerDay() {
        return this._maxConnsPerDay;
    }

    public int getMaxTotalConnsPerMinute() {
        return this._maxTotalConnsPerMinute;
    }

    public int getMaxTotalConnsPerHour() {
        return this._maxTotalConnsPerHour;
    }

    public int getMaxTotalConnsPerDay() {
        return this._maxTotalConnsPerDay;
    }

    public int getMaxConns() {
        return this._maxConns;
    }

    public boolean isAccessListEnabled() {
        return this._accessListEnabled;
    }

    public boolean isBlacklistEnabled() {
        return this._blackListEnabled;
    }

    public Set<Hash> getAccessList() {
        return this._accessList;
    }

    public Set<Hash> getBlacklist() {
        return this._blackList;
    }

    public String getLimitAction() {
        return this._limitAction;
    }

    public int getTagsToSend() {
        return this._tagsToSend;
    }

    public int getTagThreshold() {
        return this._tagThreshold;
    }

    private void initLists(ConnectionOptions opts) {
        this._accessList = opts.getAccessList();
        this._blackList = opts.getBlacklist();
        this._accessListEnabled = opts.isAccessListEnabled();
        this._blackListEnabled = opts.isBlacklistEnabled();
    }

    private void initLists(Properties opts) {
        boolean accessListEnabled = ConnectionOptions.getBool(opts, PROP_ENABLE_ACCESS_LIST, false);
        boolean blackListEnabled = ConnectionOptions.getBool(opts, PROP_ENABLE_BLACKLIST, false);
        Set accessList = accessListEnabled ? new HashSet() : Collections.emptySet();
        Set blackList = blackListEnabled ? new HashSet() : Collections.emptySet();
        if (accessListEnabled || blackListEnabled) {
            String hashes = opts.getProperty(PROP_ACCESS_LIST);
            if (hashes == null) {
                return;
            }
            StringTokenizer tok = new StringTokenizer(hashes, ",; ");
            while (tok.hasMoreTokens()) {
                String hashstr = tok.nextToken();
                Hash h = ConvertToHash.getHash((String)hashstr);
                if (h == null) {
                    ConnectionOptions.error("bad list hash: " + hashstr);
                    continue;
                }
                if (blackListEnabled) {
                    blackList.add(h);
                    continue;
                }
                accessList.add(h);
            }
        }
        this._accessList = accessList;
        this._blackList = blackList;
        this._accessListEnabled = accessListEnabled;
        this._blackListEnabled = blackListEnabled;
        if (this._accessListEnabled && this._accessList.isEmpty()) {
            ConnectionOptions.error("Connection access list enabled but no valid entries; no peers can connect");
        } else if (this._blackListEnabled && this._blackList.isEmpty()) {
            ConnectionOptions.error("Connection blacklist enabled but no valid entries; all peers can connect");
        }
    }

    private static void error(String s) {
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        Log log = ctx.logManager().getLog(ConnectionOptions.class);
        log.error(s);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("conDelay=").append(this._connectDelay);
        buf.append(" maxSize=").append(this._maxMessageSize);
        buf.append(" rtt=").append(this._rtt);
        buf.append(" rwin=").append(this._receiveWindow);
        buf.append(" resendDelay=").append(this._resendDelay);
        buf.append(" ackDelay=").append(this._sendAckDelay);
        buf.append(" cwin=").append(this._windowSize);
        buf.append(" maxResends=").append(this._maxResends);
        buf.append(" writeTimeout=").append(this.getWriteTimeout());
        buf.append(" readTimeout=").append(this.getReadTimeout());
        buf.append(" inactivityTimeout=").append(this._inactivityTimeout);
        buf.append(" inboundBuffer=").append(this._inboundBufferSize);
        buf.append(" maxWindowSize=").append(this._maxWindowSize);
        buf.append(" blacklistSize=").append(this._blackList.size());
        buf.append(" whitelistSize=").append(this._accessList.size());
        buf.append(" maxConns=").append(this._maxConnsPerMinute).append('/').append(this._maxConnsPerHour).append('/').append(this._maxConnsPerDay);
        buf.append(" maxTotalConns=").append(this._maxTotalConnsPerMinute).append('/').append(this._maxTotalConnsPerHour).append('/').append(this._maxTotalConnsPerDay);
        return buf.toString();
    }

    private static boolean getBool(Properties opts, String name, boolean defaultVal) {
        if (opts == null) {
            return defaultVal;
        }
        String val = opts.getProperty(name);
        if (val == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(val);
    }

    private static enum AckInit {
        INIT,
        FIRST,
        STEADY;

    }
}

