/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import freenet.support.CPUInformation.AMDCPUInfo;
import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.CPUInfo;
import freenet.support.CPUInformation.IntelCPUInfo;
import freenet.support.CPUInformation.UnknownCPUException;
import freenet.support.CPUInformation.VIACPUInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.i2p.I2PAppContext;
import net.i2p.crypto.CryptoConstants;
import net.i2p.data.DataHelper;
import net.i2p.util.FileUtil;
import net.i2p.util.RandomSource;
import net.i2p.util.SystemVersion;

public class NativeBigInteger
extends BigInteger {
    private static boolean _nativeOk;
    private static boolean _nativeOk3;
    private static boolean _nativeCTOk;
    private static int _jbigiVersion;
    private static String _libGMPVersion;
    private static String _loadStatus;
    private static String _cpuModel;
    private static String _extractedResource;
    private static boolean _doLog;
    private static final String JBIGI_OPTIMIZATION_K6 = "k6";
    private static final String JBIGI_OPTIMIZATION_K6_2 = "k62";
    private static final String JBIGI_OPTIMIZATION_K6_3 = "k63";
    private static final String JBIGI_OPTIMIZATION_ATHLON = "athlon";
    private static final String JBIGI_OPTIMIZATION_ATHLON64 = "athlon64";
    private static final String JBIGI_OPTIMIZATION_PENTIUM = "pentium";
    private static final String JBIGI_OPTIMIZATION_PENTIUMMMX = "pentiummmx";
    private static final String JBIGI_OPTIMIZATION_PENTIUM2 = "pentium2";
    private static final String JBIGI_OPTIMIZATION_PENTIUM3 = "pentium3";
    private static final String JBIGI_OPTIMIZATION_PENTIUM4 = "pentium4";
    private static final String JBIGI_OPTIMIZATION_VIAC3 = "viac3";
    private static final String JBIGI_OPTIMIZATION_ATOM = "atom";
    private static final String JBIGI_OPTIMIZATION_CORE2 = "core2";
    private static final String JBIGI_OPTIMIZATION_COREI = "corei";
    private static final String JBIGI_OPTIMIZATION_GEODE = "geode";
    private static final String JBIGI_OPTIMIZATION_NANO = "nano";
    private static final String JBIGI_OPTIMIZATION_PENTIUMM = "pentiumm";
    private static final String JBIGI_OPTIMIZATION_VIAC32 = "viac32";
    private static final String JBIGI_OPTIMIZATION_COREI_SBR = "coreisbr";
    private static final String JBIGI_OPTIMIZATION_COREI_HWL = "coreihwl";
    private static final String JBIGI_OPTIMIZATION_COREI_BWL = "coreibwl";
    private static final String JBIGI_OPTIMIZATION_K10 = "k10";
    private static final String JBIGI_OPTIMIZATION_BULLDOZER = "bulldozer";
    private static final String JBIGI_OPTIMIZATION_PILEDRIVER = "piledriver";
    private static final String JBIGI_OPTIMIZATION_STEAMROLLER = "steamroller";
    private static final String JBIGI_OPTIMIZATION_EXCAVATOR = "excavator";
    private static final String JBIGI_OPTIMIZATION_BOBCAT = "bobcat";
    private static final String JBIGI_OPTIMIZATION_JAGUAR = "jaguar";
    private static final String JBIGI_OPTIMIZATION_PPC = "ppc";
    private static final String JBIGI_OPTIMIZATION_ARM_ARMV5 = "armv5";
    private static final String JBIGI_OPTIMIZATION_ARM_ARMV6 = "armv6";
    private static final String JBIGI_OPTIMIZATION_ARM_ARMV7 = "armv7";
    private static final String JBIGI_OPTIMIZATION_ARM_CORTEX_A5 = "armcortexa5";
    private static final String JBIGI_OPTIMIZATION_ARM_CORTEX_A7 = "armcortexa7";
    private static final String JBIGI_OPTIMIZATION_ARM_CORTEX_A8 = "armcortexa8";
    private static final String JBIGI_OPTIMIZATION_ARM_CORTEX_A9 = "armcortexa9";
    private static final String JBIGI_OPTIMIZATION_ARM_CORTEX_A15 = "armcortexa15";
    private static final String JBIGI_OPTIMIZATION_X86 = "none";
    private static final String[] JBIGI_COMPAT_LIST_NONE;
    private static final String[] JBIGI_COMPAT_LIST_PPC;
    private static final String[] JBIGI_COMPAT_LIST_ARM;
    private static final String[] JBIGI_COMPAT_LIST_VIA;
    private static final String[] JBIGI_COMPAT_LIST_AMD_ATHLON;
    private static final String[] JBIGI_COMPAT_LIST_AMD_GEODE;
    private static final String[] JBIGI_COMPAT_LIST_AMD_APU;
    private static final String[] JBIGI_COMPAT_LIST_AMD_BULLDOZER;
    private static final String[] JBIGI_COMPAT_LIST_INTEL_ATOM;
    private static final String[] JBIGI_COMPAT_LIST_INTEL_PENTIUM;
    private static final String[] JBIGI_COMPAT_LIST_INTEL_CORE;
    private static final HashMap<String, String[]> JBIGI_COMPAT_MAP;
    private static final boolean _isWin;
    private static final boolean _isOS2;
    private static final boolean _isMac;
    private static final boolean _isLinux;
    private static final boolean _isKFreebsd;
    private static final boolean _isFreebsd;
    private static final boolean _isNetbsd;
    private static final boolean _isOpenbsd;
    private static final boolean _isSunos;
    private static final boolean _isAndroid;
    private static final boolean _is64;
    private static final boolean _isX86;
    private static final boolean _isArm;
    private static final boolean _isPPC;
    private static final String _libPrefix;
    private static final String _libSuffix;
    private static final String sCPUType;
    private byte[] cachedBa;

    private static String resolveCPUType() {
        if (_isX86) {
            try {
                CPUInfo c = CPUID.getInfo();
                try {
                    _cpuModel = c.getCPUModelString();
                }
                catch (UnknownCPUException unknownCPUException) {
                    // empty catch block
                }
                if (c instanceof VIACPUInfo) {
                    VIACPUInfo viacpu = (VIACPUInfo)c;
                    if (viacpu.IsNanoCompatible()) {
                        return JBIGI_OPTIMIZATION_NANO;
                    }
                    return JBIGI_OPTIMIZATION_VIAC3;
                }
                if (c instanceof AMDCPUInfo) {
                    AMDCPUInfo amdcpu = (AMDCPUInfo)c;
                    if (amdcpu.IsExcavatorCompatible()) {
                        return JBIGI_OPTIMIZATION_EXCAVATOR;
                    }
                    if (amdcpu.IsSteamrollerCompatible()) {
                        return JBIGI_OPTIMIZATION_STEAMROLLER;
                    }
                    if (amdcpu.IsPiledriverCompatible()) {
                        return JBIGI_OPTIMIZATION_PILEDRIVER;
                    }
                    if (amdcpu.IsBulldozerCompatible()) {
                        return JBIGI_OPTIMIZATION_BULLDOZER;
                    }
                    if (amdcpu.IsJaguarCompatible()) {
                        return JBIGI_OPTIMIZATION_JAGUAR;
                    }
                    if (amdcpu.IsBobcatCompatible()) {
                        return JBIGI_OPTIMIZATION_BOBCAT;
                    }
                    if (amdcpu.IsK10Compatible()) {
                        return JBIGI_OPTIMIZATION_K10;
                    }
                    if (amdcpu.IsAthlon64Compatible()) {
                        return JBIGI_OPTIMIZATION_ATHLON64;
                    }
                    if (amdcpu.IsAthlonCompatible()) {
                        return JBIGI_OPTIMIZATION_ATHLON;
                    }
                    if (amdcpu.IsGeodeCompatible()) {
                        return JBIGI_OPTIMIZATION_GEODE;
                    }
                    if (amdcpu.IsK6_3_Compatible()) {
                        return JBIGI_OPTIMIZATION_K6_3;
                    }
                    if (amdcpu.IsK6_2_Compatible()) {
                        return JBIGI_OPTIMIZATION_K6_2;
                    }
                    if (amdcpu.IsK6Compatible()) {
                        return JBIGI_OPTIMIZATION_K6;
                    }
                } else if (c instanceof IntelCPUInfo) {
                    IntelCPUInfo intelcpu = (IntelCPUInfo)c;
                    if (intelcpu.IsBroadwellCompatible()) {
                        return JBIGI_OPTIMIZATION_COREI_BWL;
                    }
                    if (intelcpu.IsHaswellCompatible()) {
                        return JBIGI_OPTIMIZATION_COREI_HWL;
                    }
                    if (intelcpu.IsSandyCompatible()) {
                        return JBIGI_OPTIMIZATION_COREI_SBR;
                    }
                    if (intelcpu.IsCoreiCompatible()) {
                        return JBIGI_OPTIMIZATION_COREI;
                    }
                    if (intelcpu.IsCore2Compatible()) {
                        return JBIGI_OPTIMIZATION_CORE2;
                    }
                    if (intelcpu.IsAtomCompatible()) {
                        return JBIGI_OPTIMIZATION_ATOM;
                    }
                    if (intelcpu.IsPentium4Compatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUM4;
                    }
                    if (intelcpu.IsPentiumMCompatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUMM;
                    }
                    if (intelcpu.IsPentium3Compatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUM3;
                    }
                    if (intelcpu.IsPentium2Compatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUM2;
                    }
                    if (intelcpu.IsPentiumMMXCompatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUMMMX;
                    }
                    if (intelcpu.IsPentiumCompatible()) {
                        return JBIGI_OPTIMIZATION_PENTIUM;
                    }
                }
            }
            catch (UnknownCPUException c) {
                // empty catch block
            }
            return JBIGI_OPTIMIZATION_X86;
        }
        if (_isArm) {
            if (_isWin) {
                return null;
            }
            Map<String, String> cpuinfo = NativeBigInteger.getCPUInfo();
            String implementer = cpuinfo.get("cpu implementer");
            String part = cpuinfo.get("cpu part");
            if (implementer != null && part != null && implementer.contains("0x41")) {
                if (part.contains("0xc0f")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A15;
                }
                if (part.contains("0xc0e")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A15;
                }
                if (part.contains("0xc0d")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A15;
                }
                if (part.contains("0xc09")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A9;
                }
                if (part.contains("0xc08")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A8;
                }
                if (part.contains("0xc07")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A7;
                }
                if (part.contains("0xc05")) {
                    return JBIGI_OPTIMIZATION_ARM_CORTEX_A5;
                }
            }
            String arch = cpuinfo.get("cpu architecture");
            String model = cpuinfo.get("model name");
            if (arch != null) {
                if (arch.startsWith("7")) {
                    if (model != null && model.contains("ARMv6")) {
                        return JBIGI_OPTIMIZATION_ARM_ARMV6;
                    }
                    return JBIGI_OPTIMIZATION_ARM_ARMV7;
                }
                if (arch.startsWith("6")) {
                    return JBIGI_OPTIMIZATION_ARM_ARMV6;
                }
                if (arch.startsWith("5")) {
                    return JBIGI_OPTIMIZATION_ARM_ARMV5;
                }
            }
            if (model != null) {
                if (model.contains("ARMv7")) {
                    return JBIGI_OPTIMIZATION_ARM_ARMV7;
                }
                if (model.contains("ARMv6")) {
                    return JBIGI_OPTIMIZATION_ARM_ARMV6;
                }
                if (model.contains("ARMv5")) {
                    return JBIGI_OPTIMIZATION_ARM_ARMV5;
                }
            }
            return null;
        }
        if (_isPPC && !_isMac) {
            return JBIGI_OPTIMIZATION_PPC;
        }
        return null;
    }

    private static native byte[] nativeModPow(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] nativeModPowCT(byte[] var0, byte[] var1, byte[] var2);

    private static native byte[] nativeModInverse(byte[] var0, byte[] var1);

    private static native int nativeJbigiVersion();

    private static native int nativeGMPMajorVersion();

    private static native int nativeGMPMinorVersion();

    private static native int nativeGMPPatchVersion();

    private static int fetchJbigiVersion() {
        if (!_nativeOk) {
            return 0;
        }
        try {
            return NativeBigInteger.nativeJbigiVersion();
        }
        catch (Throwable t) {
            return 2;
        }
    }

    private static void setVersions() {
        _jbigiVersion = NativeBigInteger.fetchJbigiVersion();
        boolean bl = _nativeOk3 = _jbigiVersion > 2;
        if (_nativeOk3) {
            try {
                int maj = NativeBigInteger.nativeGMPMajorVersion();
                int min = NativeBigInteger.nativeGMPMinorVersion();
                int pat = NativeBigInteger.nativeGMPPatchVersion();
                _libGMPVersion = maj + "." + min + "." + pat;
                _nativeCTOk = maj >= 5;
            }
            catch (Throwable t) {
                NativeBigInteger.warn("jbigi version " + _jbigiVersion + " but GMP version not available???", t);
            }
        }
    }

    public static int getJbigiVersion() {
        return _jbigiVersion;
    }

    public static String getLibGMPVersion() {
        return _libGMPVersion;
    }

    public NativeBigInteger(byte[] val) {
        super(val);
    }

    public NativeBigInteger(int signum, byte[] magnitude) {
        super(signum, magnitude);
    }

    public NativeBigInteger(int bitlen, int certainty, Random rnd) {
        super(bitlen, certainty, rnd);
    }

    public NativeBigInteger(int numbits, Random rnd) {
        super(numbits, rnd);
    }

    public NativeBigInteger(String val) {
        super(val);
    }

    public NativeBigInteger(String val, int radix) {
        super(val, radix);
    }

    public NativeBigInteger(BigInteger integer) {
        this(integer.toByteArray());
    }

    @Override
    public BigInteger modPow(BigInteger exponent, BigInteger m) {
        if (_nativeOk3 || _nativeOk && this.signum() >= 0 && exponent.signum() >= 0 && m.signum() > 0) {
            return new NativeBigInteger(NativeBigInteger.nativeModPow(this.toByteArray(), exponent.toByteArray(), m.toByteArray()));
        }
        return super.modPow(exponent, m);
    }

    public BigInteger modPowCT(BigInteger exponent, BigInteger m) {
        if (_nativeCTOk) {
            return new NativeBigInteger(NativeBigInteger.nativeModPowCT(this.toByteArray(), exponent.toByteArray(), m.toByteArray()));
        }
        return this.modPow(exponent, m);
    }

    @Override
    public BigInteger modInverse(BigInteger m) {
        if (_nativeOk3) {
            return new NativeBigInteger(NativeBigInteger.nativeModInverse(this.toByteArray(), m.toByteArray()));
        }
        return super.modInverse(m);
    }

    @Override
    public byte[] toByteArray() {
        if (this.cachedBa == null) {
            this.cachedBa = super.toByteArray();
        }
        return this.cachedBa;
    }

    public static boolean isNative() {
        return _nativeOk;
    }

    public static String loadStatus() {
        return _loadStatus;
    }

    public static String getLoadedResourceName() {
        return _extractedResource;
    }

    public static String cpuType() {
        if (sCPUType != null) {
            return sCPUType;
        }
        return "unrecognized";
    }

    public static String cpuModel() {
        return _cpuModel;
    }

    public static void main(String[] args) {
        boolean nativeOnly;
        _doLog = true;
        String path = System.getProperty("java.library.path");
        String name = _libPrefix + "jbigi" + _libSuffix;
        System.out.println("Native library search path: " + path);
        if (_nativeOk) {
            String[] paths;
            String sep = System.getProperty("path.separator");
            for (String p : paths = DataHelper.split(path, sep)) {
                File f = new File(p, name);
                if (!f.exists()) continue;
                System.out.println("Found native library: " + f);
                break;
            }
        } else {
            System.out.println("Failed to load native library. Please verify the existence of the " + name + " file in the library path, or set -Djava.library.path=. in the command line");
        }
        boolean bl = nativeOnly = args.length > 0 && args[0].equals("-n");
        if (nativeOnly && !_nativeOk) {
            System.exit(1);
        }
        if (_nativeOk) {
            System.out.println("JBigi Version: " + _jbigiVersion + " GMP Version: " + _libGMPVersion);
            if (_extractedResource != null) {
                System.out.println("Using native resource: " + _extractedResource);
            }
        }
        System.out.println("DEBUG: Warming up the random number generator...");
        RandomSource rand = RandomSource.getInstance();
        rand.nextBoolean();
        System.out.println("DEBUG: Random number generator warmed up");
        NativeBigInteger.runModPowTest(100, 1, nativeOnly);
        if (_nativeOk3) {
            System.out.println("ModPowCT test:");
            NativeBigInteger.runModPowTest(100, 2, nativeOnly);
            System.out.println("ModInverse test:");
            NativeBigInteger.runModPowTest(10000, 3, nativeOnly);
        }
    }

    private static void runModPowTest(int numRuns, int mode, boolean nativeOnly) {
        RandomSource rand = RandomSource.getInstance();
        byte[] sampleGenerator = CryptoConstants.elgg.toByteArray();
        byte[] samplePrime = CryptoConstants.elgp.toByteArray();
        BigInteger jg = new BigInteger(sampleGenerator);
        NativeBigInteger ng = CryptoConstants.elgg;
        BigInteger jp = new BigInteger(samplePrime);
        long totalTime = 0L;
        long javaTime = 0L;
        int runsProcessed = 0;
        for (int i = 0; i < 1000; ++i) {
            BigInteger bi;
            while ((bi = new BigInteger(16, rand)).signum() == 0) {
            }
            if (mode == 1) {
                jg.modPow(bi, jp);
                continue;
            }
            if (mode == 2) {
                ng.modPowCT(bi, jp);
                continue;
            }
            bi.modInverse(jp);
        }
        BigInteger myValue = null;
        NativeBigInteger g = CryptoConstants.elgg;
        NativeBigInteger p = CryptoConstants.elgp;
        int numBits = mode == 3 ? 1060 : 2048;
        for (runsProcessed = 0; runsProcessed < numRuns; ++runsProcessed) {
            BigInteger bi;
            while ((bi = new BigInteger(numBits, rand)).signum() == 0) {
            }
            NativeBigInteger k = new NativeBigInteger(1, bi.toByteArray());
            long beforeModPow = System.nanoTime();
            if (_nativeOk) {
                myValue = mode == 1 ? g.modPow(k, p) : (mode == 2 ? g.modPowCT(bi, jp) : k.modInverse(p));
            }
            long afterModPow = System.nanoTime();
            totalTime += afterModPow - beforeModPow;
            if (nativeOnly) continue;
            BigInteger jval = mode != 3 ? jg.modPow(bi, jp) : bi.modInverse(jp);
            long afterJavaModPow = System.nanoTime();
            javaTime += afterJavaModPow - afterModPow;
            if (!_nativeOk || myValue.equals(jval)) continue;
            System.err.println("ERROR: [" + runsProcessed + "]\tnative modPow != java modPow");
            System.err.println("ERROR: native modPow value: " + myValue.toString());
            System.err.println("ERROR: java modPow value: " + jval.toString());
            break;
        }
        double dtotal = (float)totalTime / 1000000.0f;
        double djava = (float)javaTime / 1000000.0f;
        if (_nativeOk) {
            System.out.println(String.format("INFO: run time: %.3f ms (%.3f ms each)", dtotal, dtotal / (double)(runsProcessed + 1)));
        }
        if (numRuns == runsProcessed) {
            System.out.println("INFO: " + runsProcessed + " runs complete without any errors");
        } else {
            System.out.println("ERROR: " + runsProcessed + " runs until we got an error");
        }
        if (_nativeOk) {
            System.out.println(String.format("Native run time: \t%9.3f ms (%7.3f ms each)", dtotal, dtotal / (double)(runsProcessed + 1)));
            if (!nativeOnly) {
                System.out.println(String.format("Java run time:   \t%9.3f ms (%7.3f ms each)", djava, djava / (double)(runsProcessed + 1)));
                System.out.println(String.format("Native = %.3f%% of pure Java time", dtotal * 100.0 / djava));
                if (dtotal < djava) {
                    System.out.println(String.format("Native is BETTER by a factor of %.3f -- YAY!", djava / dtotal));
                } else {
                    System.out.println(String.format("Native is WORSE by a factor of %.3f -- BOO!", dtotal / djava));
                }
            }
        } else {
            System.out.println(String.format("java run time: \t%.3f ms (%.3f ms each)", djava, djava / (double)(runsProcessed + 1)));
            System.out.println("However, we couldn't load the native library, so this doesn't test much");
        }
    }

    private static final void loadNative() {
        try {
            String wantedProp = System.getProperty("jbigi.enable", "true");
            boolean wantNative = Boolean.parseBoolean(wantedProp);
            if (wantNative) {
                NativeBigInteger.debug("trying loadGeneric");
                boolean loaded = NativeBigInteger.loadGeneric("jbigi");
                if (loaded) {
                    _nativeOk = true;
                    String s = I2PAppContext.getGlobalContext().getProperty("jbigi.loadedResource");
                    if (s != null) {
                        NativeBigInteger.info("Locally optimized library " + s + " loaded from file");
                    } else {
                        NativeBigInteger.info("Locally optimized native BigInteger library loaded from file");
                    }
                } else {
                    List<String> toTry = NativeBigInteger.getResourceList();
                    NativeBigInteger.debug("loadResource list to try is: " + toTry);
                    for (String s : toTry) {
                        NativeBigInteger.debug("Trying to load resource " + s);
                        if (!NativeBigInteger.loadFromResource(s)) continue;
                        _nativeOk = true;
                        _extractedResource = s;
                        NativeBigInteger.info("Native BigInteger library " + s + " loaded from resource");
                        break;
                    }
                }
            }
            if (!_nativeOk) {
                NativeBigInteger.warn("Native BigInteger library jbigi not loaded - using pure Java - poor performance may result - see http://i2p-projekt.i2p/jbigi for help");
            } else {
                NativeBigInteger.setVersions();
            }
        }
        catch (Exception e) {
            NativeBigInteger.warn("Native BigInteger library jbigi not loaded, using pure java", e);
        }
    }

    private static void debug(String s) {
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).debug(s);
    }

    private static void info(String s) {
        if (_doLog) {
            System.err.println("INFO: " + s);
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).info(s);
        _loadStatus = s;
    }

    private static void warn(String s) {
        NativeBigInteger.warn(s, null);
    }

    private static void warn(String s, Throwable t) {
        if (_doLog) {
            System.err.println("WARNING: " + s);
            if (t != null) {
                t.printStackTrace();
            }
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).warn(s, t);
        _loadStatus = t != null ? s + ' ' + t : s;
    }

    private static void error(String s) {
        NativeBigInteger.error(s, null);
    }

    private static void error(String s, Throwable t) {
        if (_doLog) {
            System.err.println("ERROR: " + s);
            if (t != null) {
                t.printStackTrace();
            }
        }
        I2PAppContext.getGlobalContext().logManager().getLog(NativeBigInteger.class).error(s, t);
        _loadStatus = t != null ? s + ' ' + t : s;
    }

    private static final boolean loadGeneric(String name) {
        try {
            if (name == null) {
                return false;
            }
            System.loadLibrary(name);
            return true;
        }
        catch (UnsatisfiedLinkError ule) {
            if (_isAndroid) {
                NativeBigInteger.warn("jbigi loadLibrary() fail", ule);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean loadFromResource(String resourceName) {
        if (resourceName == null) {
            return false;
        }
        URL resource = ClassLoader.getSystemResource(resourceName);
        if (resource == null) {
            NativeBigInteger.info("Resource name [" + resourceName + "] was not found");
            return false;
        }
        InputStream libStream = null;
        File outFile = null;
        FileOutputStream fos = null;
        String filename = _libPrefix + "jbigi" + _libSuffix;
        try {
            libStream = resource.openStream();
            outFile = new File(I2PAppContext.getGlobalContext().getTempDir(), filename);
            fos = new FileOutputStream(outFile);
            DataHelper.copy(libStream, fos);
            fos.close();
            fos = null;
            System.load(outFile.getAbsolutePath());
            NativeBigInteger.info("Loaded library: " + resource);
        }
        catch (UnsatisfiedLinkError ule) {
            NativeBigInteger.warn("Failed to load the resource " + resourceName + " - not a valid library for this platform");
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            NativeBigInteger.warn("Problem writing out the temporary native library data: " + ioe);
            if (outFile != null) {
                outFile.delete();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (libStream != null) {
                try {
                    libStream.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        File newFile = new File(I2PAppContext.getGlobalContext().getBaseDir(), filename);
        FileUtil.copy(outFile, newFile, false, true);
        return true;
    }

    private static List<String> getResourceList() {
        if (_isAndroid) {
            return Collections.emptyList();
        }
        ArrayList<String> rv = new ArrayList<String>(20);
        String primary = NativeBigInteger.getMiddleName2(true);
        Object[] compatList = JBIGI_COMPAT_MAP.get(primary);
        if (primary != null && compatList == null) {
            NativeBigInteger.error("A bug relating to how jbigi is loaded for \"" + primary + "\" has been spotted");
        }
        if (primary != null && compatList != null) {
            int i;
            for (i = 0; i < compatList.length && !compatList[i].equals(primary); ++i) {
            }
            while (i < compatList.length) {
                String middle = NativeBigInteger.getMiddleName1();
                if (_is64) {
                    rv.add(_libPrefix + middle + compatList[i] + "_64" + _libSuffix);
                }
                rv.add(_libPrefix + middle + compatList[i] + _libSuffix);
                ++i;
            }
            if (rv.isEmpty()) {
                NativeBigInteger.error("Couldn't find the arch \"" + primary + "\" in its compatibility map \"" + primary + ": " + Arrays.toString(compatList) + "\"");
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getCPUInfo() {
        HashMap<String, String> rv = new HashMap<String, String>(32);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/cpuinfo"), "ISO-8859-1"), 4096);
            String line = null;
            while ((line = in.readLine()) != null) {
                String key;
                String[] parts = DataHelper.split(line, ":", 2);
                if (parts.length < 2 || rv.containsKey(key = parts[0].trim().toLowerCase(Locale.US))) continue;
                rv.put(key, parts[1].trim());
            }
        }
        catch (IOException ioe) {
            NativeBigInteger.warn("Unable to read /proc/cpuinfo", ioe);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return rv;
    }

    private static final String getMiddleName2(boolean optimized) {
        String sAppend;
        if (optimized) {
            if (sCPUType == null) {
                return null;
            }
            sAppend = sCPUType.equals(JBIGI_OPTIMIZATION_K6_3) && !_isWin ? JBIGI_OPTIMIZATION_K6_2 : (sCPUType.equals(JBIGI_OPTIMIZATION_PENTIUM2) && _isSunos && _isX86 ? JBIGI_OPTIMIZATION_PENTIUM3 : (sCPUType.equals(JBIGI_OPTIMIZATION_VIAC32) ? JBIGI_OPTIMIZATION_PENTIUM3 : sCPUType));
        } else {
            sAppend = JBIGI_OPTIMIZATION_X86;
        }
        return sAppend;
    }

    private static final String getMiddleName1() {
        if (_isWin) {
            return "jbigi-windows-";
        }
        if (_isKFreebsd) {
            return "jbigi-kfreebsd-";
        }
        if (_isFreebsd) {
            return "jbigi-freebsd-";
        }
        if (_isNetbsd) {
            return "jbigi-netbsd-";
        }
        if (_isOpenbsd) {
            return "jbigi-openbsd-";
        }
        if (_isMac) {
            return "jbigi-osx-";
        }
        if (_isOS2) {
            return "jbigi-os2-";
        }
        if (_isSunos) {
            return "jbigi-solaris-";
        }
        return "jbigi-linux-";
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    static {
        _libGMPVersion = "unknown";
        _loadStatus = "uninitialized";
        _cpuModel = "uninitialized";
        _doLog = System.getProperty("jbigi.dontLog") == null && I2PAppContext.getCurrentContext() != null && I2PAppContext.getCurrentContext().isRouterContext();
        JBIGI_COMPAT_LIST_NONE = new String[]{JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_PPC = new String[]{JBIGI_OPTIMIZATION_PPC};
        JBIGI_COMPAT_LIST_ARM = new String[]{JBIGI_OPTIMIZATION_ARM_CORTEX_A15, JBIGI_OPTIMIZATION_ARM_CORTEX_A9, JBIGI_OPTIMIZATION_ARM_CORTEX_A8, JBIGI_OPTIMIZATION_ARM_CORTEX_A7, JBIGI_OPTIMIZATION_ARM_CORTEX_A5, JBIGI_OPTIMIZATION_ARM_ARMV7, JBIGI_OPTIMIZATION_ARM_ARMV6, JBIGI_OPTIMIZATION_ARM_ARMV5};
        JBIGI_COMPAT_LIST_VIA = new String[]{JBIGI_OPTIMIZATION_NANO, JBIGI_OPTIMIZATION_VIAC32, JBIGI_OPTIMIZATION_VIAC3, JBIGI_OPTIMIZATION_PENTIUM, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_AMD_ATHLON = new String[]{JBIGI_OPTIMIZATION_K10, JBIGI_OPTIMIZATION_ATHLON64, JBIGI_OPTIMIZATION_ATHLON, JBIGI_OPTIMIZATION_K6_3, JBIGI_OPTIMIZATION_K6_2, JBIGI_OPTIMIZATION_K6, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_AMD_GEODE = new String[]{JBIGI_OPTIMIZATION_GEODE, JBIGI_OPTIMIZATION_K6_3, JBIGI_OPTIMIZATION_K6_2, JBIGI_OPTIMIZATION_K6, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_AMD_APU = new String[]{JBIGI_OPTIMIZATION_JAGUAR, JBIGI_OPTIMIZATION_BOBCAT, JBIGI_OPTIMIZATION_ATHLON64};
        JBIGI_COMPAT_LIST_AMD_BULLDOZER = new String[]{JBIGI_OPTIMIZATION_EXCAVATOR, JBIGI_OPTIMIZATION_STEAMROLLER, JBIGI_OPTIMIZATION_PILEDRIVER, JBIGI_OPTIMIZATION_BULLDOZER, JBIGI_OPTIMIZATION_ATHLON64, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_INTEL_ATOM = new String[]{JBIGI_OPTIMIZATION_ATOM, JBIGI_OPTIMIZATION_PENTIUM3, JBIGI_OPTIMIZATION_PENTIUM2, JBIGI_OPTIMIZATION_PENTIUMMMX, JBIGI_OPTIMIZATION_PENTIUM, JBIGI_OPTIMIZATION_X86, JBIGI_OPTIMIZATION_PENTIUM4};
        JBIGI_COMPAT_LIST_INTEL_PENTIUM = new String[]{JBIGI_OPTIMIZATION_PENTIUM4, JBIGI_OPTIMIZATION_PENTIUMM, JBIGI_OPTIMIZATION_PENTIUM3, JBIGI_OPTIMIZATION_PENTIUM2, JBIGI_OPTIMIZATION_PENTIUMMMX, JBIGI_OPTIMIZATION_PENTIUM, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_LIST_INTEL_CORE = new String[]{JBIGI_OPTIMIZATION_COREI_BWL, JBIGI_OPTIMIZATION_COREI_HWL, JBIGI_OPTIMIZATION_COREI_SBR, JBIGI_OPTIMIZATION_COREI, JBIGI_OPTIMIZATION_CORE2, JBIGI_OPTIMIZATION_PENTIUMM, JBIGI_OPTIMIZATION_PENTIUM3, JBIGI_OPTIMIZATION_X86};
        JBIGI_COMPAT_MAP = new HashMap<String, String[]>(){
            {
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_X86, JBIGI_COMPAT_LIST_NONE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PPC, JBIGI_COMPAT_LIST_PPC);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_ARMV5, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_ARMV6, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_ARMV7, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_CORTEX_A5, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_CORTEX_A7, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_CORTEX_A8, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_CORTEX_A9, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ARM_CORTEX_A15, JBIGI_COMPAT_LIST_ARM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_VIAC3, JBIGI_COMPAT_LIST_VIA);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_VIAC32, JBIGI_COMPAT_LIST_VIA);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_NANO, JBIGI_COMPAT_LIST_VIA);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_K6, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_K6_2, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_K6_3, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ATHLON, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ATHLON64, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_K10, JBIGI_COMPAT_LIST_AMD_ATHLON);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_GEODE, JBIGI_COMPAT_LIST_AMD_GEODE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_BOBCAT, JBIGI_COMPAT_LIST_AMD_APU);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_JAGUAR, JBIGI_COMPAT_LIST_AMD_APU);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_BULLDOZER, JBIGI_COMPAT_LIST_AMD_BULLDOZER);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PILEDRIVER, JBIGI_COMPAT_LIST_AMD_BULLDOZER);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_STEAMROLLER, JBIGI_COMPAT_LIST_AMD_BULLDOZER);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_EXCAVATOR, JBIGI_COMPAT_LIST_AMD_BULLDOZER);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_ATOM, JBIGI_COMPAT_LIST_INTEL_ATOM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUM, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUMMMX, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUM2, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUM3, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUMM, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUM4, JBIGI_COMPAT_LIST_INTEL_PENTIUM);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUM3, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_PENTIUMM, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_CORE2, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_COREI, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_COREI_SBR, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_COREI_HWL, JBIGI_COMPAT_LIST_INTEL_CORE);
                this.put(NativeBigInteger.JBIGI_OPTIMIZATION_COREI_BWL, JBIGI_COMPAT_LIST_INTEL_CORE);
            }
        };
        _isWin = SystemVersion.isWindows();
        _isOS2 = System.getProperty("os.name").startsWith("OS/2");
        _isMac = SystemVersion.isMac();
        _isLinux = System.getProperty("os.name").toLowerCase(Locale.US).contains("linux");
        _isKFreebsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("kfreebsd");
        _isFreebsd = !_isKFreebsd && System.getProperty("os.name").toLowerCase(Locale.US).contains("freebsd");
        _isNetbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("netbsd");
        _isOpenbsd = System.getProperty("os.name").toLowerCase(Locale.US).contains("openbsd");
        _isSunos = System.getProperty("os.name").toLowerCase(Locale.US).contains("sunos");
        _isAndroid = SystemVersion.isAndroid();
        _is64 = SystemVersion.is64Bit();
        _isX86 = SystemVersion.isX86();
        _isArm = SystemVersion.isARM();
        _isPPC = System.getProperty("os.arch").contains(JBIGI_OPTIMIZATION_PPC);
        String string = _libPrefix = _isWin || _isOS2 ? "" : "lib";
        _libSuffix = _isWin || _isOS2 ? ".dll" : (_isMac ? ".jnilib" : ".so");
        sCPUType = NativeBigInteger.resolveCPUType();
        NativeBigInteger.loadNative();
    }
}

