/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.LHMCache;
import net.i2p.util.SystemVersion;
import org.apache.http.conn.util.InetAddressUtils;

public abstract class Addresses {
    private static final File IF_INET6_FILE;
    private static final long INET6_CACHE_EXPIRE = 600000L;
    private static final boolean INET6_CACHE_ENABLED;
    private static final int FLAG_PERMANENT = 128;
    private static final int FLAG_DEPRECATED = 32;
    private static final int FLAG_TEMPORARY = 1;
    private static long _ifCacheTime;
    private static final Map<Inet6Address, Inet6Addr> _ifCache;
    private static final Set<String> _macCache;
    private static final Map<String, byte[]> _IPAddress;
    private static final Map<String, Long> _negativeCache;
    private static final long NEG_CACHE_TIME = 3600000L;

    public static boolean isConnected() {
        return !Addresses.getAddresses(true, false, false).isEmpty();
    }

    public static boolean isConnectedIPv6() {
        for (String ip : Addresses.getAddresses(false, true)) {
            if (!ip.contains(":")) continue;
            return true;
        }
        return false;
    }

    public static String getAnyAddress() {
        SortedSet<String> a = Addresses.getAddresses();
        if (!a.isEmpty()) {
            return a.first();
        }
        return null;
    }

    public static SortedSet<String> getAddresses() {
        return Addresses.getAddresses(false, false);
    }

    public static SortedSet<String> getAllAddresses() {
        return Addresses.getAddresses(true, true);
    }

    public static SortedSet<String> getAddresses(boolean includeLocal, boolean includeIPv6) {
        return Addresses.getAddresses(includeLocal, includeLocal, includeIPv6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedSet<String> getAddresses(boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        TreeSet<String> rv;
        boolean haveIPv6;
        boolean haveIPv4;
        block22: {
            haveIPv4 = false;
            haveIPv6 = false;
            rv = new TreeSet<String>();
            boolean omitDeprecated = INET6_CACHE_ENABLED && !includeSiteLocal && includeIPv6;
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
                if (allMyIps != null) {
                    for (int i = 0; i < allMyIps.length; ++i) {
                        boolean isv4 = allMyIps[i] instanceof Inet4Address;
                        if (isv4) {
                            haveIPv4 = true;
                        } else {
                            haveIPv6 = true;
                        }
                        if (omitDeprecated && !isv4 && Addresses.isDeprecated((Inet6Address)allMyIps[i]) || !Addresses.shouldInclude(allMyIps[i], includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                        rv.add(Addresses.stripScope(allMyIps[i].getHostAddress()));
                    }
                }
            }
            catch (UnknownHostException localhost) {
                // empty catch block
            }
            try {
                Enumeration<NetworkInterface> ifcs = NetworkInterface.getNetworkInterfaces();
                if (ifcs == null) break block22;
                HashSet<String> newMacs = new HashSet<String>(8);
                while (ifcs.hasMoreElements()) {
                    NetworkInterface ifc = ifcs.nextElement();
                    if (!ifc.isUp()) continue;
                    try {
                        byte[] mac = ifc.getHardwareAddress();
                        if (mac != null && mac.length == 6) {
                            newMacs.add(DataHelper.toString(mac));
                        }
                    }
                    catch (SocketException mac) {
                        // empty catch block
                    }
                    Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        boolean isv4 = addr instanceof Inet4Address;
                        if (isv4) {
                            haveIPv4 = true;
                        } else {
                            haveIPv6 = true;
                        }
                        if (omitDeprecated && !isv4 && Addresses.isDeprecated((Inet6Address)addr) || !Addresses.shouldInclude(addr, includeSiteLocal, includeLoopbackAndWildcard, includeIPv6)) continue;
                        rv.add(Addresses.stripScope(addr.getHostAddress()));
                    }
                }
                if (newMacs.isEmpty()) break block22;
                Set<String> set = _macCache;
                synchronized (set) {
                    _macCache.clear();
                    _macCache.addAll(newMacs);
                }
            }
            catch (SocketException socketException) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (includeLoopbackAndWildcard) {
            if (haveIPv4) {
                rv.add("0.0.0.0");
            }
            if (includeIPv6 && haveIPv6) {
                rv.add("0:0:0:0:0:0:0:0");
            }
        }
        return rv;
    }

    private static String stripScope(String ip) {
        int pct = ip.indexOf(37);
        if (pct > 0) {
            ip = ip.substring(0, pct);
        }
        return ip;
    }

    private static boolean shouldInclude(InetAddress ia, boolean includeSiteLocal, boolean includeLoopbackAndWildcard, boolean includeIPv6) {
        return !(ia.isLinkLocalAddress() || ia.isMulticastAddress() || !includeLoopbackAndWildcard && (ia.isAnyLocalAddress() || ia.isLoopbackAddress()) || !includeSiteLocal && (ia.isSiteLocalAddress() || ia.getAddress().length == 16 && (ia.getAddress()[0] & 0xFE) == 252) || !includeIPv6 && !(ia instanceof Inet4Address));
    }

    public static String toString(byte[] addr) {
        if (addr == null) {
            return "null";
        }
        try {
            return InetAddress.getByAddress(addr).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return "bad IP length " + addr.length;
        }
    }

    public static String toString(byte[] addr, int port) {
        if (addr == null) {
            return "null:" + port;
        }
        try {
            String ip = InetAddress.getByAddress(addr).getHostAddress();
            if (addr.length != 16) {
                return ip + ':' + port;
            }
            return '[' + ip + "]:" + port;
        }
        catch (UnknownHostException uhe) {
            return "(bad IP length " + addr.length + "):" + port;
        }
    }

    public static int getPort(String port) {
        int rv = 0;
        if (port != null) {
            try {
                int iport = Integer.parseInt(port);
                if (iport > 0 && iport <= 65535) {
                    rv = iport;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(String host) {
        byte[] rv;
        block18: {
            if (host == null) {
                return null;
            }
            Map<String, Object> map = _IPAddress;
            synchronized (map) {
                rv = _IPAddress.get(host);
            }
            if (rv == null) {
                map = _negativeCache;
                synchronized (map) {
                    Long when = _negativeCache.get(host);
                    if (when != null) {
                        if (when > System.currentTimeMillis() - 3600000L) {
                            return null;
                        }
                        _negativeCache.remove(host);
                    }
                }
                try {
                    rv = InetAddress.getByName(host).getAddress();
                    if (!Addresses.isIPAddress(host)) break block18;
                    map = _IPAddress;
                    synchronized (map) {
                        _IPAddress.put(host, rv);
                    }
                }
                catch (UnknownHostException uhe) {
                    Map<String, Long> map2 = _negativeCache;
                    synchronized (map2) {
                        _negativeCache.put(host, System.currentTimeMillis());
                    }
                }
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIPOnly(String host) {
        byte[] rv;
        if (host == null) {
            return null;
        }
        Map<String, byte[]> map = _IPAddress;
        synchronized (map) {
            rv = _IPAddress.get(host);
        }
        if (rv == null && Addresses.isIPAddress(host)) {
            try {
                rv = InetAddress.getByName(host).getAddress();
                map = _IPAddress;
                synchronized (map) {
                    _IPAddress.put(host, rv);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getIP(String host, boolean preferIPv6) {
        if (host == null) {
            return null;
        }
        if (Addresses.isIPAddress(host)) {
            return Addresses.getIP(host);
        }
        Map<String, Long> map = _negativeCache;
        synchronized (map) {
            Long when = _negativeCache.get(host);
            if (when != null) {
                if (when > System.currentTimeMillis() - 3600000L) {
                    return null;
                }
                _negativeCache.remove(host);
            }
        }
        byte[] rv = null;
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            if (addrs == null || addrs.length == 0) {
                return null;
            }
            for (int i = 0; i < addrs.length; ++i) {
                rv = addrs[i].getAddress();
                if (!(preferIPv6 ? rv.length == 16 : rv.length == 4)) {
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException uhe) {
            Map<String, Long> map2 = _negativeCache;
            synchronized (map2) {
                _negativeCache.put(host, System.currentTimeMillis());
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<byte[]> getIPs(String host) {
        if (host == null) {
            return null;
        }
        if (Addresses.isIPAddress(host)) {
            byte[] brv = Addresses.getIP(host);
            if (brv == null) {
                return null;
            }
            return Collections.singletonList(brv);
        }
        Map<String, Long> brv = _negativeCache;
        synchronized (brv) {
            Long when = _negativeCache.get(host);
            if (when != null) {
                if (when > System.currentTimeMillis() - 3600000L) {
                    return null;
                }
                _negativeCache.remove(host);
            }
        }
        try {
            InetAddress[] addrs = InetAddress.getAllByName(host);
            if (addrs == null || addrs.length == 0) {
                return null;
            }
            ArrayList<byte[]> rv = new ArrayList<byte[]>(addrs.length);
            for (int i = 0; i < addrs.length; ++i) {
                rv.add(addrs[i].getAddress());
            }
            return rv;
        }
        catch (UnknownHostException uhe) {
            Map<String, Long> map = _negativeCache;
            synchronized (map) {
                _negativeCache.put(host, System.currentTimeMillis());
            }
            return null;
        }
    }

    public static boolean isIPv4Address(String host) {
        return InetAddressUtils.isIPv4Address(host);
    }

    public static boolean isIPv6Address(String host) {
        return InetAddressUtils.isIPv6Address(host);
    }

    public static boolean isIPAddress(String host) {
        return InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void refreshCache() {
        long now = System.currentTimeMillis();
        if (now - _ifCacheTime < 600000L) {
            return;
        }
        _ifCache.clear();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(IF_INET6_FILE), "ISO-8859-1"), 1024);
            String line = null;
            StringBuilder buf = new StringBuilder(40);
            while ((line = in.readLine()) != null) {
                Inet6Address addr;
                String as;
                String[] parts = DataHelper.split(line, " ", 6);
                if (parts.length < 5 || (as = parts[0]).length() != 32) continue;
                buf.setLength(0);
                int i = 0;
                while (true) {
                    buf.append(as.substring(i, i + 4));
                    if ((i += 4) >= 32) break;
                    buf.append(':');
                }
                try {
                    addr = (Inet6Address)InetAddress.getByName(buf.toString());
                }
                catch (UnknownHostException uhe) {
                    continue;
                }
                int flags = 128;
                try {
                    flags = Integer.parseInt(parts[4], 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Inet6Addr a = new Inet6Addr(addr, flags);
                _ifCache.put(addr, a);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        _ifCacheTime = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDynamic(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            return Addresses.isTemporary(addr);
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isDynamic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeprecated(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            return false;
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isDeprecated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTemporary(Inet6Address addr) {
        Inet6Addr a;
        if (!INET6_CACHE_ENABLED) {
            byte[] b = addr.getAddress();
            if (b.length != 16) {
                return false;
            }
            if (b[8] == 0 && b[9] == 0 && b[10] == 0 && b[11] == 0) {
                return false;
            }
            String last3 = DataHelper.toHexString(Arrays.copyOfRange(b, 13, 16));
            Set<String> set = _macCache;
            synchronized (set) {
                for (String m : _macCache) {
                    if (!m.endsWith(last3)) continue;
                    return false;
                }
            }
            if (!SystemVersion.isWindows()) {
                return (b[8] & 2) == 0;
            }
            return true;
        }
        Map<Inet6Address, Inet6Addr> map = _ifCache;
        synchronized (map) {
            Addresses.refreshCache();
            a = _ifCache.get(addr);
        }
        if (a == null) {
            return false;
        }
        return a.isTemporary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCaches() {
        Object object = _IPAddress;
        synchronized (object) {
            _IPAddress.clear();
        }
        object = _negativeCache;
        synchronized (object) {
            _negativeCache.clear();
        }
        if (_ifCache != null) {
            object = _ifCache;
            synchronized (object) {
                _ifCache.clear();
                _ifCacheTime = 0L;
            }
        }
        object = _macCache;
        synchronized (object) {
            _macCache.clear();
        }
    }

    public static void main(String[] args) {
        System.out.println("External IPv4 Addresses:");
        SortedSet<String> a = Addresses.getAddresses(false, false, false);
        Addresses.print(a);
        System.out.println("\nExternal and Local IPv4 Addresses:");
        a = Addresses.getAddresses(true, false, false);
        Addresses.print(a);
        System.out.println("\nAll External Addresses:");
        a = Addresses.getAddresses(false, false, true);
        Addresses.print(a);
        System.out.println("\nAll External and Local Addresses:");
        a = Addresses.getAddresses(true, false, true);
        Addresses.print(a);
        System.out.println("\nAll addresses:");
        long time = System.currentTimeMillis();
        a = Addresses.getAddresses(true, true, true);
        time = System.currentTimeMillis() - time;
        Addresses.print(a);
        System.out.println("\nIPv6 address flags:");
        for (String s : a) {
            if (!s.contains(":")) continue;
            StringBuilder buf = new StringBuilder(64);
            buf.append(s);
            try {
                Inet6Address addr = (Inet6Address)InetAddress.getByName(buf.toString());
                if (addr.isSiteLocalAddress()) {
                    buf.append(" host");
                } else if (addr.isLinkLocalAddress()) {
                    buf.append(" link");
                } else if (addr.isAnyLocalAddress()) {
                    buf.append(" wildcard");
                } else if (addr.isLoopbackAddress()) {
                    buf.append(" loopback");
                } else {
                    buf.append(" global");
                    if (Addresses.isTemporary(addr)) {
                        buf.append(" temporary");
                    }
                    if (Addresses.isDynamic(addr)) {
                        buf.append(" dynamic");
                    }
                    if (Addresses.isDeprecated(addr)) {
                        buf.append(" deprecated");
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            System.out.println(buf.toString());
        }
        System.out.println("\nMac addresses:");
        TreeSet<String> macs = new TreeSet<String>();
        StringBuilder buf = new StringBuilder(17);
        for (String m : _macCache) {
            buf.setLength(0);
            int i = 0;
            while (true) {
                buf.append(m.substring(i, i + 2));
                if ((i += 2) >= 12) break;
                buf.append(':');
            }
            macs.add(buf.toString());
        }
        Addresses.print(macs);
        System.out.println("\nIs connected? " + Addresses.isConnected() + "\nIs conn IPv6? " + Addresses.isConnectedIPv6());
        System.out.println("Has v6 flags? " + INET6_CACHE_ENABLED);
        System.out.println("Uses v6 temp? " + Addresses.getPrivacyStatus());
        System.out.println("scan time:    " + DataHelper.formatDuration(time));
    }

    private static void print(Set<String> a) {
        if (a.isEmpty()) {
            System.out.println("none");
        } else {
            for (String s : a) {
                System.out.println(s);
            }
        }
    }

    private static String getPrivacyStatus() {
        if (SystemVersion.isMac() || SystemVersion.isWindows()) {
            return "unknown";
        }
        long t = Addresses.getLong("/proc/sys/net/ipv6/conf/all/use_tempaddr");
        if (t < 0L) {
            return "unknown";
        }
        String rv = t == 0L ? "false" : (t == 2L ? "true" : "unknown");
        if (t == 2L) {
            long pref = Addresses.getLong("/proc/sys/net/ipv6/conf/all/temp_prefered_lft");
            if (pref > 0L) {
                rv = rv + ", preferred lifetime " + DataHelper.formatDuration(pref * 1000L);
            }
            long valid = Addresses.getLong("/proc/sys/net/ipv6/conf/all/temp_valid_lft");
            if (pref > 0L) {
                rv = rv + ", valid lifetime " + DataHelper.formatDuration(valid * 1000L);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getLong(String s) {
        File f = new File(s);
        long rv = -1L;
        if (f.exists()) {
            BufferedReader in = null;
            try {
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "ISO-8859-1"), 64);
                String line = in.readLine();
                if (line != null) {
                    try {
                        rv = Long.parseLong(line.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return rv;
    }

    static {
        int size;
        IF_INET6_FILE = new File("/proc/net/if_inet6");
        INET6_CACHE_ENABLED = !SystemVersion.isMac() && !SystemVersion.isWindows() && !SystemVersion.isAndroid() && IF_INET6_FILE.exists();
        _ifCache = INET6_CACHE_ENABLED ? new HashMap(8) : null;
        _macCache = new HashSet<String>();
        I2PAppContext ctx = I2PAppContext.getCurrentContext();
        if (ctx != null && ctx.isRouterContext()) {
            long maxMemory = SystemVersion.getMaxMemory();
            long min = 256L;
            long max = 4096L;
            size = (int)Math.max(min, Math.min(max, 1L + maxMemory / 65536L));
        } else {
            size = 32;
        }
        _IPAddress = new LHMCache<String, byte[]>(size);
        _negativeCache = new LHMCache<String, Long>(128);
    }

    private static class Inet6Addr {
        private final Inet6Address addr;
        private final boolean isDyn;
        private final boolean isDep;
        private final boolean isTemp;

        public Inet6Addr(Inet6Address a, int flags) {
            this.addr = a;
            this.isDyn = (flags & 0x80) == 0;
            this.isDep = (flags & 0x20) != 0;
            this.isTemp = (flags & 1) != 0;
        }

        public Inet6Address getAddress() {
            return this.addr;
        }

        public boolean isDynamic() {
            return this.isDyn;
        }

        public boolean isDeprecated() {
            return this.isDep;
        }

        public boolean isTemporary() {
            return this.isTemp;
        }
    }
}

