/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.time;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import net.i2p.I2PAppContext;
import net.i2p.util.SystemVersion;

public class BuildTime {
    private static final long _buildTime;
    private static final long _earliestTime;
    private static final long _latestTime;
    private static final long YEARS_25 = 788400000000L;
    private static final String EARLIEST = "2017-10-11 12:00:00 UTC";
    private static final long EARLIEST_LONG = 1507694400000L;

    public static long getBuildTime() {
        return _buildTime;
    }

    public static long getEarliestTime() {
        return _earliestTime;
    }

    public static long getLatestTime() {
        return _latestTime;
    }

    private BuildTime() {
    }

    private static long getBuildTime(SimpleDateFormat fmt, String jar) {
        if (SystemVersion.isAndroid()) {
            return 0L;
        }
        File f = new File(I2PAppContext.getGlobalContext().getBaseDir(), "lib");
        Attributes atts = BuildTime.attributes(f = new File(f, jar));
        if (atts == null) {
            return 0L;
        }
        String s = atts.getValue("Build-Date");
        if (s == null) {
            return 0L;
        }
        try {
            Date date = fmt.parse(s);
            if (date != null) {
                return date.getTime();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Attributes attributes(File f) {
        InputStream in = null;
        try {
            in = new URL("jar:file:" + f.getAbsolutePath() + "!/META-INF/MANIFEST.MF").openStream();
            Manifest man = new Manifest(in);
            Attributes attributes = man.getMainAttributes();
            return attributes;
        }
        catch (IOException ioe) {
            Attributes attributes = null;
            return attributes;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        long min;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z", Locale.US);
        TimeZone utc = TimeZone.getTimeZone("GMT");
        fmt.setTimeZone(utc);
        try {
            Date date = fmt.parse(EARLIEST);
            min = date == null ? 1507694400000L : date.getTime();
        }
        catch (ParseException pe) {
            System.out.println("BuildTime FAIL");
            min = 1507694400000L;
        }
        long max = min + 788400000000L;
        long build = BuildTime.getBuildTime(fmt, "i2p.jar");
        if (build > max) {
            System.out.println("Warning: Strange build time, contact packager: " + new Date(build));
            build = max;
        } else if (build < min) {
            if (build > 0L) {
                System.out.println("Warning: Strange build time, contact packager: " + new Date(build));
            }
            build = min;
        } else {
            min = build - 86400000L;
        }
        _earliestTime = min;
        _latestTime = max;
        _buildTime = build;
    }
}

