/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.tunnel.pool.ConnectChecker;
import net.i2p.router.util.HashDistance;

public abstract class TunnelPeerSelector
extends ConnectChecker {
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.outboundExploratoryExcludeUnreachable";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.outboundClientExcludeUnreachable";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.inboundExploratoryExcludeUnreachable";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.inboundClientExcludeUnreachable";
    private static final boolean DEFAULT_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = false;
    private static final boolean DEFAULT_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = false;
    private static final boolean DEFAULT_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = true;
    private static final boolean DEFAULT_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = true;
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.outboundExploratoryExcludeSlow";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW = "router.outboundClientExcludeSlow";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.inboundExploratoryExcludeSlow";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_SLOW = "router.inboundClientExcludeSlow";

    protected TunnelPeerSelector(RouterContext context) {
        super(context);
    }

    public abstract List<Hash> selectPeers(TunnelPoolSettings var1);

    protected int getLength(TunnelPoolSettings settings) {
        int length = settings.getLength();
        int override = settings.getLengthOverride();
        if (override >= 0) {
            length = override;
        } else if (settings.getLengthVariance() != 0) {
            int skew = settings.getLengthVariance();
            if (skew > 0) {
                length += this.ctx.random().nextInt(skew + 1);
            } else {
                skew = 1 - skew;
                int off = this.ctx.random().nextInt(skew);
                length = this.ctx.random().nextBoolean() ? (length += off) : (length -= off);
            }
        }
        if (length < 0) {
            length = 0;
        } else if (length > 7) {
            length = 7;
        }
        return length;
    }

    protected boolean shouldSelectExplicit(TunnelPoolSettings settings) {
        if (settings.isExploratory()) {
            return false;
        }
        Properties opts = settings.getUnknownOptions();
        if (opts != null) {
            String peers = opts.getProperty("explicitPeers");
            if (peers == null) {
                peers = this.ctx.getProperty("explicitPeers");
            }
            if (peers != null) {
                return true;
            }
        }
        return false;
    }

    protected List<Hash> selectExplicit(TunnelPoolSettings settings, int length) {
        String peers = null;
        Properties opts = settings.getUnknownOptions();
        if (opts != null) {
            peers = opts.getProperty("explicitPeers");
        }
        if (peers == null) {
            peers = this.ctx.getProperty("explicitPeers");
        }
        ArrayList<Hash> rv = new ArrayList<Hash>();
        StringTokenizer tok = new StringTokenizer(peers, ",");
        while (tok.hasMoreTokens()) {
            String peerStr = tok.nextToken();
            Hash peer = new Hash();
            try {
                peer.fromBase64(peerStr);
                if (this.ctx.profileOrganizer().isSelectable(peer)) {
                    rv.add(peer);
                    continue;
                }
                if (!this.log.shouldLog(10)) continue;
                this.log.debug("Explicit peer is not selectable: " + peerStr);
            }
            catch (DataFormatException dfe) {
                if (!this.log.shouldLog(40)) continue;
                this.log.error("Explicit peer is improperly formatted (" + peerStr + ")", dfe);
            }
        }
        int sz = rv.size();
        Collections.shuffle(rv, this.ctx.random());
        while (rv.size() > length) {
            rv.remove(0);
        }
        if (this.log.shouldLog(20)) {
            StringBuilder buf = new StringBuilder();
            if (settings.getDestinationNickname() != null) {
                buf.append("peers for ").append(settings.getDestinationNickname());
            } else if (settings.getDestination() != null) {
                buf.append("peers for ").append(settings.getDestination().toBase64());
            } else {
                buf.append("peers for exploratory ");
            }
            if (settings.isInbound()) {
                buf.append(" inbound");
            } else {
                buf.append(" outbound");
            }
            buf.append(" peers: ").append(rv);
            buf.append(", out of ").append(sz).append(" (not including self)");
            this.log.info(buf.toString());
        }
        if (settings.isInbound()) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        return rv;
    }

    public Set<Hash> getExclude(boolean isInbound, boolean isExploratory) {
        FloodfillNetworkDatabaseFacade fac;
        List<RouterInfo> known;
        char[] excl;
        HashSet<Hash> peers = new HashSet<Hash>(8);
        peers.addAll(this.ctx.profileOrganizer().selectPeersRecentlyRejecting());
        peers.addAll(this.ctx.tunnelManager().selectPeersInTooManyTunnels());
        if (this.filterUnreachable(isInbound, isExploratory)) {
            Collection<Hash> caps = this.ctx.peerManager().getPeersByCapability('U');
            if (caps != null) {
                peers.addAll(caps);
            }
            if ((caps = this.ctx.profileOrganizer().selectPeersLocallyUnreachable()) != null) {
                peers.addAll(caps);
            }
        }
        if (this.filterSlow(isInbound, isExploratory) && (excl = TunnelPeerSelector.getExcludeCaps(this.ctx)) != null && (known = (fac = (FloodfillNetworkDatabaseFacade)this.ctx.netDb()).getKnownRouterData()) != null) {
            for (int i = 0; i < known.size(); ++i) {
                RouterInfo peer = known.get(i);
                boolean shouldExclude = TunnelPeerSelector.shouldExclude(peer, excl);
                if (!shouldExclude) continue;
                peers.add(peer.getIdentity().calculateHash());
            }
        }
        return peers;
    }

    protected boolean isIPv6Only() {
        return TransportUtil.getIPv6Config(this.ctx, "SSU") == TransportUtil.IPv6Config.IPV6_ONLY;
    }

    private boolean allowAsOBEP(Hash h) {
        RouterInfo ri = this.ctx.netDb().lookupRouterInfoLocally(h);
        if (ri == null) {
            return true;
        }
        return this.canConnect(ri, 3);
    }

    private boolean allowAsIBGW(Hash h) {
        RouterInfo ri = this.ctx.netDb().lookupRouterInfoLocally(h);
        if (ri == null) {
            return true;
        }
        return this.canConnect(3, ri);
    }

    protected Set<Hash> getClosestHopExclude(boolean isInbound) {
        RouterInfo ri = this.ctx.router().getRouterInfo();
        if (ri == null) {
            return null;
        }
        int ourMask = isInbound ? this.getInboundMask(ri) : this.getOutboundMask(ri);
        Set<Hash> connected = this.ctx.commSystem().getEstablished();
        HashSet<Hash> rv = new HashSet<Hash>(256);
        FloodfillNetworkDatabaseFacade fac = (FloodfillNetworkDatabaseFacade)this.ctx.netDb();
        List<RouterInfo> known = fac.getKnownRouterData();
        if (known != null) {
            for (int i = 0; i < known.size(); ++i) {
                boolean canConnect;
                RouterInfo peer = known.get(i);
                Hash h = peer.getIdentity().calculateHash();
                if (connected.contains(h)) continue;
                boolean bl = canConnect = isInbound ? this.canConnect(peer, ourMask) : this.canConnect(ourMask, peer);
                if (canConnect) continue;
                rv.add(h);
            }
        }
        return rv;
    }

    public static boolean shouldExclude(RouterContext ctx, RouterInfo peer) {
        return TunnelPeerSelector.shouldExclude(peer, TunnelPeerSelector.getExcludeCaps(ctx));
    }

    private static char[] getExcludeCaps(RouterContext ctx) {
        String excludeCaps = ctx.getProperty("router.excludePeerCaps", String.valueOf('K'));
        if (excludeCaps != null) {
            char[] excl = excludeCaps.toCharArray();
            return excl;
        }
        return null;
    }

    private static boolean shouldExclude(RouterInfo peer, char[] excl) {
        String cap = peer.getCapabilities();
        for (int j = 0; j < excl.length; ++j) {
            if (cap.indexOf(excl[j]) < 0) continue;
            return true;
        }
        int maxLen = 0;
        if (cap.indexOf(102) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(82) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(85) >= 0) {
            ++maxLen;
        }
        return cap.length() <= maxLen;
    }

    protected boolean filterUnreachable(boolean isInbound, boolean isExploratory) {
        if (isExploratory) {
            if (isInbound) {
                return this.ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, true);
            }
            return this.ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, false);
        }
        if (isInbound) {
            return this.ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE, true);
        }
        return this.ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE, false);
    }

    protected boolean filterSlow(boolean isInbound, boolean isExploratory) {
        if (isExploratory) {
            if (isInbound) {
                return this.ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW, true);
            }
            return this.ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW, true);
        }
        if (isInbound) {
            return this.ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_SLOW, true);
        }
        return this.ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW, true);
    }

    protected void orderPeers(List<Hash> rv, Hash hash) {
        if (rv.size() > 1) {
            Collections.sort(rv, new HashComparator(hash));
        }
    }

    protected boolean checkTunnel(boolean isInbound, List<Hash> tunnel) {
        if (!this.checkTunnel(tunnel)) {
            return false;
        }
        if (isInbound) {
            Hash h = tunnel.get(tunnel.size() - 1);
            if (!this.allowAsIBGW(h)) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Picked IPv6-only or hidden peer for IBGW: " + h);
                }
                this.ctx.profileManager().tunnelTimedOut(h);
                return false;
            }
        } else {
            Hash h = tunnel.get(0);
            if (!this.allowAsOBEP(h)) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Picked IPv6-only peer for OBEP: " + h);
                }
                this.ctx.profileManager().tunnelTimedOut(h);
                return false;
            }
        }
        return true;
    }

    private boolean checkTunnel(List<Hash> tunnel) {
        boolean rv = true;
        for (int i = 0; i < tunnel.size() - 1; ++i) {
            Hash us;
            Hash ht;
            Hash hf = tunnel.get(i + 1);
            if (this.canConnect(hf, ht = tunnel.get(i))) continue;
            if (this.log.shouldWarn()) {
                this.log.warn("Connect check fail hop " + (i + 1) + " to " + i + " in tunnel (EP<-GW): " + DataHelper.toString(tunnel));
            }
            if (!hf.equals(us = this.ctx.routerHash())) {
                this.ctx.profileManager().tunnelTimedOut(hf);
            }
            if (!ht.equals(us)) {
                this.ctx.profileManager().tunnelTimedOut(ht);
            }
            rv = false;
            break;
        }
        return rv;
    }

    private static class HashComparator
    implements Comparator<Hash>,
    Serializable {
        private final Hash _hash;
        private final Hash tmp;
        private final byte[] data;

        private HashComparator(Hash h) {
            this._hash = h;
            this.tmp = new Hash(new byte[32]);
            this.data = new byte[64];
            System.arraycopy(this._hash.getData(), 0, this.data, 32, 32);
        }

        @Override
        public int compare(Hash l, Hash r) {
            System.arraycopy(l.getData(), 0, this.data, 0, 32);
            byte[] tb = this.tmp.getData();
            SHA256Generator.getInstance().calculateHash(this.data, 0, 64, tb, 0);
            BigInteger ll = HashDistance.getDistance(this._hash, this.tmp);
            System.arraycopy(r.getData(), 0, this.data, 0, 32);
            SHA256Generator.getInstance().calculateHash(this.data, 0, 64, tb, 0);
            BigInteger rr = HashDistance.getDistance(this._hash, this.tmp);
            return ll.compareTo(rr);
        }
    }
}

