/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Collection;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportManager;
import net.i2p.util.Log;

public class ConnectChecker {
    protected final RouterContext ctx;
    protected final Log log;
    private static final int NTCP_V4 = 1;
    private static final int SSU_V4 = 2;
    public static final int ANY_V4 = 3;
    private static final int NTCP_V6 = 4;
    private static final int SSU_V6 = 8;
    private static final int ANY_V6 = 12;
    private static final String[] IHOST = new String[]{"ihost0", "ihost1", "ihost2"};

    public ConnectChecker(RouterContext context) {
        this.ctx = context;
        this.log = this.ctx.logManager().getLog(this.getClass());
    }

    protected boolean isNTCPDisabled() {
        return !TransportManager.isNTCPEnabled(this.ctx);
    }

    protected boolean isSSUDisabled() {
        return !this.ctx.getBooleanPropertyDefaultTrue("i2np.udp.enable");
    }

    public boolean canConnect(Hash from, Hash to) {
        boolean rv;
        Collection<RouterAddress> a;
        int ct;
        Hash us = this.ctx.routerHash();
        if (us == null) {
            return true;
        }
        boolean usf = from.equals(us);
        if (usf && this.ctx.commSystem().isEstablished(to)) {
            return true;
        }
        boolean ust = to.equals(us);
        if (ust && this.ctx.commSystem().isEstablished(from)) {
            return true;
        }
        RouterInfo rt = this.ctx.netDb().lookupRouterInfoLocally(to);
        if (rt == null) {
            return true;
        }
        RouterInfo rf = this.ctx.netDb().lookupRouterInfoLocally(from);
        if (rf == null) {
            return true;
        }
        if (ust) {
            ct = this.getInboundMask(rt);
        } else {
            Collection<RouterAddress> at = rt.getAddresses();
            if (at.isEmpty()) {
                return false;
            }
            ct = ConnectChecker.getConnectMask(at);
        }
        int cf = usf ? this.getOutboundMask(rf) : ((a = rf.getAddresses()).isEmpty() ? 3 : ConnectChecker.getConnectMask(a));
        boolean bl = rv = (ct & cf) != 0;
        if (!rv && this.log.shouldWarn()) {
            this.log.warn("Cannot connect: " + (usf ? "us" : from.toString()) + " with mask " + cf + "\nto " + (ust ? "us" : to.toString()) + " with mask " + ct);
        }
        return rv;
    }

    public boolean canConnect(int ourMask, RouterInfo to) {
        Collection<RouterAddress> ra = to.getAddresses();
        if (ra.isEmpty()) {
            return false;
        }
        int ct = ConnectChecker.getConnectMask(ra);
        boolean rv = (ourMask & ct) != 0;
        return rv;
    }

    public boolean canConnect(RouterInfo from, int ourMask) {
        if (ourMask == 0) {
            return false;
        }
        Collection<RouterAddress> ra = from.getAddresses();
        int cf = ra.isEmpty() ? 3 : ConnectChecker.getConnectMask(ra);
        boolean rv = (cf & ourMask) != 0;
        return rv;
    }

    public int getInboundMask(RouterInfo us) {
        int ct = 0;
        CommSystemFacade.Status status = this.ctx.commSystem().getStatus();
        switch (status) {
            case OK: 
            case IPV4_UNKNOWN_IPV6_OK: 
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_SNAT_IPV6_OK: 
            case IPV4_SNAT_IPV6_UNKNOWN: 
            case IPV4_FIREWALLED_IPV6_UNKNOWN: 
            case IPV4_UNKNOWN_IPV6_FIREWALLED: 
            case IPV4_OK_IPV6_FIREWALLED: 
            case DIFFERENT: 
            case REJECT_UNSOLICITED: {
                Collection<RouterAddress> at = us.getAddresses();
                if (at.isEmpty()) {
                    return 0;
                }
                ct = ConnectChecker.getConnectMask(at);
                break;
            }
            case IPV4_DISABLED_IPV6_OK: 
            case IPV4_DISABLED_IPV6_UNKNOWN: 
            case IPV4_DISABLED_IPV6_FIREWALLED: {
                if (!this.isNTCPDisabled()) {
                    ct |= 4;
                }
                if (this.isSSUDisabled()) break;
                ct |= 8;
                break;
            }
            default: {
                if (!this.isNTCPDisabled()) {
                    ct |= 1;
                }
                if (this.isSSUDisabled()) break;
                ct |= 2;
            }
        }
        return ct;
    }

    public int getOutboundMask(RouterInfo us) {
        int cf = 0;
        CommSystemFacade.Status status = this.ctx.commSystem().getStatus();
        switch (status) {
            case OK: {
                Collection<RouterAddress> a = us.getAddresses();
                if (a.isEmpty()) {
                    if (!this.isNTCPDisabled()) {
                        cf |= 1;
                    }
                    if (this.isSSUDisabled()) break;
                    cf |= 2;
                    break;
                }
                cf = ConnectChecker.getConnectMask(a);
                break;
            }
            case IPV4_UNKNOWN_IPV6_OK: 
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_SNAT_IPV6_OK: 
            case IPV4_UNKNOWN_IPV6_FIREWALLED: 
            case IPV4_OK_IPV6_FIREWALLED: {
                if (!this.isNTCPDisabled()) {
                    cf |= 5;
                }
                if (this.isSSUDisabled()) break;
                cf |= 0xA;
                break;
            }
            case IPV4_DISABLED_IPV6_OK: 
            case IPV4_DISABLED_IPV6_UNKNOWN: 
            case IPV4_DISABLED_IPV6_FIREWALLED: {
                if (!this.isNTCPDisabled()) {
                    cf |= 4;
                }
                if (this.isSSUDisabled()) break;
                cf |= 8;
                break;
            }
            default: {
                if (!this.isNTCPDisabled()) {
                    cf |= 1;
                }
                if (this.isSSUDisabled()) break;
                cf |= 2;
            }
        }
        return cf;
    }

    private static int getConnectMask(Collection<RouterAddress> addrs) {
        int rv = 0;
        for (RouterAddress ra : addrs) {
            String style = ra.getTransportStyle();
            String host = ra.getHost();
            if ("NTCP".equals(style)) {
                if (host == null) continue;
                if (host.contains(":")) {
                    rv |= 4;
                    continue;
                }
                rv |= 1;
                continue;
            }
            if (!"SSU".equals(style)) continue;
            if (host == null) {
                String ihost;
                for (int i = 0; i < 2 && (ihost = ra.getOption(IHOST[i])) != null; ++i) {
                    if (ihost.contains(":")) {
                        rv |= 8;
                        continue;
                    }
                    rv |= 2;
                }
                continue;
            }
            if (host.contains(":")) {
                rv |= 8;
                continue;
            }
            rv |= 2;
        }
        return rv;
    }
}

