/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.File;
import net.i2p.data.DataHelper;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.IVValidator;
import net.i2p.router.util.DecayingBloomFilter;
import net.i2p.router.util.DecayingHashSet;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SystemVersion;

class BloomFilterIVValidator
implements IVValidator {
    private final RouterContext _context;
    private final DecayingBloomFilter _filter;
    private static final int HALFLIFE_MS = 600000;
    private static final int MIN_SHARE_KBPS_TO_USE_BLOOM = 64;
    private static final int MIN_SHARE_KBPS_FOR_BIG_BLOOM = 512;
    private static final int MIN_SHARE_KBPS_FOR_HUGE_BLOOM = 1536;
    private static final int MIN_SHARE_KBPS_FOR_HUGE2_BLOOM = 4096;
    private static final int MIN_SHARE_KBPS_FOR_HUGE3_BLOOM = 8192;
    private static final long MIN_MEM_TO_USE_BLOOM = 0x4000000L;
    private static final long MIN_MEM_FOR_BIG_BLOOM = 0x8000000L;
    private static final long MIN_MEM_FOR_HUGE_BLOOM = 0x10000000L;
    private static final long MIN_MEM_FOR_HUGE2_BLOOM = 0x18000000L;
    private static final long MIN_MEM_FOR_HUGE3_BLOOM = 0x20000000L;
    private static final String PROP_FORCE = "router.forceDecayingBloomFilter";
    private static final String PROP_DISABLE = "router.disableDecayingBloomFilter";

    public BloomFilterIVValidator(RouterContext ctx, int KBps) {
        this._context = ctx;
        long maxMemory = SystemVersion.getMaxMemory();
        if (this._context.getBooleanProperty(PROP_FORCE)) {
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV");
        } else if (this._context.getBooleanProperty(PROP_DISABLE)) {
            this._filter = null;
        } else if (KBps < 64 || maxMemory < 0x4000000L) {
            if (KBps >= 64) {
                this.warn(maxMemory, KBps, 0x4000000L, 64);
            }
            this._filter = new DecayingHashSet(ctx, 600000, 16, "TunnelIVV");
        } else if (KBps >= 8192 && maxMemory >= 0x20000000L) {
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 27);
        } else if (KBps >= 4096 && maxMemory >= 0x18000000L) {
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 26);
            if (KBps >= 8192) {
                this.warn(maxMemory, KBps, 0x20000000L, 8192);
            }
        } else if (KBps >= 1536 && maxMemory >= 0x10000000L) {
            if (KBps >= 4096) {
                this.warn(maxMemory, KBps, 0x18000000L, 4096);
            }
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 25);
        } else if (KBps >= 512 && maxMemory >= 0x8000000L) {
            if (KBps >= 1536) {
                this.warn(maxMemory, KBps, 0x10000000L, 1536);
            }
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV", 24);
        } else {
            if (KBps >= 512) {
                this.warn(maxMemory, KBps, 0x8000000L, 512);
            }
            this._filter = new DecayingBloomFilter(ctx, 600000, 16, "TunnelIVV");
        }
        ctx.statManager().createRateStat("tunnel.duplicateIV", "Note that a duplicate IV was received", "Tunnels", new long[]{3600000L});
    }

    @Override
    public boolean receiveIV(byte[] ivData, int ivOffset, byte[] payload, int payloadOffset) {
        if (this._filter == null) {
            return true;
        }
        byte[] buf = SimpleByteCache.acquire(16);
        DataHelper.xor(ivData, ivOffset, payload, payloadOffset, buf, 0, 16);
        boolean dup = this._filter.add(buf);
        SimpleByteCache.release(buf);
        if (dup) {
            this._context.statManager().addRateData("tunnel.duplicateIV", 1L);
        }
        return !dup;
    }

    public void destroy() {
        if (this._filter != null) {
            this._filter.stopDecaying();
        }
    }

    private void warn(long maxMemory, int KBps, long recMaxMem, int threshKBps) {
        if (SystemVersion.isAndroid()) {
            return;
        }
        String path = SystemVersion.isLinuxService() ? "/etc/i2p" : this._context.getBaseDir().toString();
        String msg = "Configured for " + DataHelper.formatSize((long)KBps * 1024L) + "Bps share bandwidth but only " + DataHelper.formatSize(maxMemory) + "B available memory.";
        msg = this._context.hasWrapper() ? msg + " Recommend increasing wrapper.java.maxmemory in " + path + File.separatorChar + "wrapper.config" : (!SystemVersion.isWindows() ? msg + " Recommend increasing MAXMEMOPT in " + path + File.separatorChar + "runplain.sh or /usr/bin/i2prouter-nowrapper" : msg + " Recommend running the restartable version of I2P, and increasing wrapper.java.maxmemory in " + path + File.separatorChar + "wrapper.config");
        msg = msg + " to at least " + recMaxMem * 11L / 10L / 0x100000L + " (MB) if the actual share bandwidth exceeds " + DataHelper.formatSize((long)threshKBps * 1024L) + "Bps.";
        System.out.println("WARN: " + msg);
        this._context.logManager().getLog(BloomFilterIVValidator.class).logAlways(30, msg);
    }
}

