/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.time;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.router.time.NtpMessage;
import net.i2p.util.HexDump;
import net.i2p.util.Log;

public class NtpClient {
    static final double SECONDS_1900_TO_EPOCH = 2.2089888E9;
    private static final int NTP_PORT = 123;
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int OFF_ORIGTIME = 24;
    private static final int OFF_TXTIME = 40;
    private static final int MIN_PKT_LEN = 48;
    private static final Map<String, String> kisses = new ConcurrentHashMap<String, String>(2);

    static long[] currentTimeAndStratum(String[] serverNames, int perServerTimeout, boolean preferIPv6, Log log) {
        int i;
        if (serverNames == null) {
            throw new IllegalArgumentException("No NTP servers specified");
        }
        ArrayList<String> names = new ArrayList<String>(serverNames.length);
        for (i = 0; i < serverNames.length; ++i) {
            names.add(serverNames[i]);
        }
        Collections.shuffle(names);
        for (i = 0; i < names.size(); ++i) {
            long[] rv = NtpClient.currentTimeAndStratum((String)names.get(i), perServerTimeout, preferIPv6, log);
            if (rv == null || rv[0] <= 0L) continue;
            return rv;
        }
        throw new IllegalArgumentException("No reachable NTP servers specified");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] currentTimeAndStratum(String serverName, int timeout, boolean preferIPv6, Log log) {
        try (DatagramSocket socket = null;){
            String who;
            String why;
            InetAddress address;
            if (preferIPv6) {
                InetAddress[] addrs = InetAddress.getAllByName(serverName);
                if (addrs == null || addrs.length == 0) {
                    throw new UnknownHostException();
                }
                address = null;
                for (int i = 0; i < addrs.length; ++i) {
                    if (addrs[i] instanceof Inet6Address) {
                        address = addrs[i];
                        break;
                    }
                    if (address != null) continue;
                    address = addrs[0];
                }
            } else {
                address = InetAddress.getByName(serverName);
            }
            if ((why = kisses.get(who = address.getHostAddress())) != null) {
                if (log != null) {
                    log.warn("Not querying, previous KoD from NTP server " + serverName + " (" + who + ") " + why);
                }
                long[] lArray = null;
                return lArray;
            }
            byte[] buf = new NtpMessage().toByteArray();
            DatagramPacket packet = new DatagramPacket(buf, buf.length, address, 123);
            byte[] txtime = new byte[8];
            socket = new DatagramSocket();
            NtpMessage.encodeTimestamp(packet.getData(), 40, (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9);
            socket.send(packet);
            System.arraycopy(packet.getData(), 40, txtime, 0, 8);
            if (log != null && log.shouldDebug()) {
                log.debug("Sent to " + serverName + " (" + who + ")\n" + HexDump.dump(buf));
            }
            packet = new DatagramPacket(buf, buf.length);
            socket.setSoTimeout(timeout);
            socket.receive(packet);
            double destinationTimestamp = (double)System.currentTimeMillis() / 1000.0 + 2.2089888E9;
            if (packet.getLength() < 48) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Short packet length " + packet.getLength());
                }
                long[] lArray = null;
                return lArray;
            }
            NtpMessage msg = new NtpMessage(packet.getData());
            String from = packet.getAddress().getHostAddress();
            int port = packet.getPort();
            if (log != null && log.shouldDebug()) {
                log.debug("Received from: " + from + " port " + port + '\n' + msg + '\n' + HexDump.dump(packet.getData()));
            }
            if (port != 123 || !who.equals(from)) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Sent to " + who + " port " + 123 + " but received from " + packet.getSocketAddress());
                }
                long[] lArray = null;
                return lArray;
            }
            if (msg.stratum > 15) {
                if (log != null && log.shouldWarn()) {
                    log.warn("NTP server " + serverName + " bad stratum " + msg.stratum);
                }
                long[] lArray = null;
                return lArray;
            }
            if (!DataHelper.eq(txtime, 0, packet.getData(), 24, 8)) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Origin time mismatch sent:\n" + HexDump.dump(txtime) + "rcvd:\n" + HexDump.dump(packet.getData(), 24, 8));
                }
                long[] lArray = null;
                return lArray;
            }
            if (msg.leapIndicator == 3 || msg.version < 3 || msg.mode != 4 || msg.transmitTimestamp <= 0.0 || Math.abs(msg.rootDelay) > 1.0 || Math.abs(msg.rootDispersion) > 1.0) {
                if (log != null && log.shouldWarn()) {
                    log.warn("Failed sanity checks:\n" + msg);
                }
                long[] lArray = null;
                return lArray;
            }
            if (msg.stratum == 0) {
                why = msg.referenceIdentifierToString();
                kisses.put(who, why);
                if (log != null) {
                    log.logAlways(30, "KoD from NTP server " + serverName + " (" + who + ") " + why);
                }
                long[] lArray = null;
                return lArray;
            }
            double localClockOffset = (msg.receiveTimestamp - msg.originateTimestamp + (msg.transmitTimestamp - destinationTimestamp)) / 2.0;
            long[] rv = new long[]{(long)((double)System.currentTimeMillis() + localClockOffset * 1000.0), msg.stratum};
            if (log != null && log.shouldInfo()) {
                double roundTripDelay = destinationTimestamp - msg.originateTimestamp - (msg.receiveTimestamp - msg.transmitTimestamp);
                log.info("host: " + packet.getAddress().getHostAddress() + " rtt: " + roundTripDelay + " offset: " + localClockOffset + " seconds");
            }
            long[] lArray = rv;
            return lArray;
        }
    }

    public static void main(String[] args) throws IOException {
        boolean ipv6 = false;
        if (args.length > 0 && args[0].equals("-6")) {
            ipv6 = true;
            args = args.length == 1 ? new String[]{} : Arrays.copyOfRange(args, 1, args.length);
        }
        if (args.length <= 0) {
            args = new String[]{"pool.ntp.org"};
        }
        System.out.println("Querying " + Arrays.toString(args));
        Log log = new Log(NtpClient.class);
        try {
            long[] rv = NtpClient.currentTimeAndStratum(args, 10000, ipv6, log);
            System.out.println("Current time: " + new Date(rv[0]) + " (stratum " + rv[1] + ") offset " + (rv[0] - System.currentTimeMillis()) + "ms");
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Failed: " + iae.getMessage());
        }
    }
}

