/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import net.i2p.router.Router;
import net.i2p.router.RouterContext;
import net.i2p.util.FileUtil;
import net.i2p.util.SystemVersion;

public class InstallUpdate {
    private static final String DELETE_FILE = "deletelist.txt";

    public static void installUpdates(Router r) {
        RouterContext context = r.getContext();
        File updateFile = new File(context.getRouterDir(), "i2pupdate.zip");
        boolean exists = updateFile.exists();
        if (!exists) {
            updateFile = new File(context.getBaseDir(), "i2pupdate.zip");
            exists = updateFile.exists();
        }
        if (exists) {
            File test = new File(context.getBaseDir(), "history.txt");
            if (test.exists() && !test.canWrite() || !context.getBaseDir().canWrite()) {
                System.out.println("ERROR: No write permissions on " + context.getBaseDir() + " to extract software update file");
                return;
            }
            System.out.println("INFO: Update file exists [i2pupdate.zip] - installing");
            boolean ok = FileUtil.verifyZip(updateFile);
            if (ok) {
                HashMap<String, String> config = new HashMap<String, String>(4);
                config.put("router.updateLastInstalled", "" + System.currentTimeMillis());
                config.put("router.previousVersion", "0.9.34");
                config.put("router.previousFullVersion", "0.9.34-0");
                r.saveConfig(config, null);
                ok = FileUtil.extractZip(updateFile, context.getBaseDir());
            }
            try {
                boolean deleted;
                if (ok) {
                    InstallUpdate.deleteListedFiles(context);
                    System.out.println("INFO: Update installed");
                } else {
                    System.out.println("ERROR: Update failed!");
                }
                if (!ok) {
                    File bad = new File(context.getRouterDir(), "BAD-i2pupdate.zip");
                    boolean renamed = updateFile.renameTo(bad);
                    if (renamed) {
                        System.out.println("Moved update file to " + bad.getAbsolutePath());
                    } else {
                        System.out.println("Deleting file " + updateFile.getAbsolutePath());
                        ok = true;
                    }
                }
                if (ok && !(deleted = updateFile.delete())) {
                    System.out.println("ERROR: Unable to delete the update file!");
                    updateFile.deleteOnExit();
                }
                if (context.hasWrapper()) {
                    System.out.println("INFO: Restarting after update");
                } else {
                    System.out.println("WARNING: Exiting after update, restart I2P");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            System.exit(4);
        } else {
            InstallUpdate.deleteJbigiFiles(context);
            InstallUpdate.deleteListedFiles(context);
        }
    }

    private static void deleteJbigiFiles(RouterContext context) {
        boolean isX86 = SystemVersion.isX86();
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        boolean isWin = SystemVersion.isWindows();
        boolean isMac = SystemVersion.isMac();
        boolean goodOS = isWin || isMac || osName.contains("linux") || osName.contains("freebsd");
        File jbigiJar = new File(context.getBaseDir(), "lib/jbigi.jar");
        if (goodOS && jbigiJar.exists()) {
            File jbigiLib;
            boolean success2;
            String path;
            boolean success;
            File jcpuidLib;
            String libSuffix;
            String libPrefix;
            String string = libPrefix = isWin ? "" : "lib";
            String string2 = isWin ? ".dll" : (libSuffix = isMac ? ".jnilib" : ".so");
            if (isX86 && (jcpuidLib = new File(context.getBaseDir(), libPrefix + "jcpuid" + libSuffix)).canWrite() && jbigiJar.lastModified() > jcpuidLib.lastModified() && (success = FileUtil.copy(path = jcpuidLib.getAbsolutePath(), path + ".bak", true, true)) && (success2 = jcpuidLib.delete())) {
                System.out.println("New jbigi.jar detected, moved jcpuid library to " + path + ".bak");
                System.out.println("Check logs for successful installation of new library");
            }
            if ((isX86 || SystemVersion.isARM()) && (jbigiLib = new File(context.getBaseDir(), libPrefix + "jbigi" + libSuffix)).canWrite() && jbigiJar.lastModified() > jbigiLib.lastModified() && (success = FileUtil.copy(path = jbigiLib.getAbsolutePath(), path + ".bak", true, true)) && (success2 = jbigiLib.delete())) {
                System.out.println("New jbigi.jar detected, moved jbigi library to " + path + ".bak");
                System.out.println("Check logs for successful installation of new library");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteListedFiles(RouterContext context) {
        File deleteFile = new File(context.getBaseDir(), DELETE_FILE);
        if (!deleteFile.exists()) {
            return;
        }
        FileInputStream fis = null;
        BufferedReader in = null;
        try {
            String line;
            fis = new FileInputStream(deleteFile);
            in = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            while ((line = in.readLine()) != null) {
                File df;
                String fl = line.trim();
                if (fl.contains("..") || fl.startsWith("#") || fl.length() == 0 || (df = new File(fl)).isAbsolute() || !(df = new File(context.getBaseDir(), fl)).exists() || !df.isFile() || !df.delete()) continue;
                System.out.println("INFO: File [" + fl + "] deleted");
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (deleteFile.delete()) {
                // empty if block
            }
        }
    }
}

