/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.reseed;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.i2p.I2PAppContext;
import net.i2p.crypto.SU3File;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.util.EepGet;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.RFC822Date;
import net.i2p.util.SSLEepGet;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class Reseeder {
    private final RouterContext _context;
    private final Log _log;
    private final ReseedChecker _checker;
    private static final long MAX_RESEED_RESPONSE_SIZE = 0x200000L;
    private static final long MAX_SU3_RESPONSE_SIZE = 0x100000L;
    private static final int MAX_TIME_PER_HOST = 420000;
    private static final long MAX_FILE_AGE = 2592000000L;
    private static final boolean ENABLE_SU3 = true;
    private static final boolean ENABLE_NON_SU3 = false;
    private static final int MIN_RI_WANTED = 100;
    private static final int MIN_RESEED_SERVERS = 2;
    public static final String DEFAULT_SEED_URL = "";
    public static final String DEFAULT_SSL_SEED_URL = "https://i2p.novg.net/,https://i2pseed.creativecowpat.net:8443/,https://itoopie.atomike.ninja/,https://reseed.onion.im/,https://reseed.memcpy.io/,https://reseed.atomike.ninja/,https://i2p.manas.ca:8443/,https://i2p-0.manas.ca:8443/,https://i2p.mooo.com/netDb/,https://download.xxlspeed.com/,https://netdb.i2p2.no/,https://reseed.i2p-projekt.de/";
    private static final String SU3_FILENAME = "i2pseeds.su3";
    public static final String PROP_PROXY_HOST = "router.reseedProxyHost";
    public static final String PROP_PROXY_PORT = "router.reseedProxyPort";
    public static final String PROP_PROXY_ENABLE = "router.reseedProxyEnable";
    public static final String PROP_SSL_DISABLE = "router.reseedSSLDisable";
    public static final String PROP_SSL_REQUIRED = "router.reseedSSLRequired";
    public static final String PROP_RESEED_URL = "i2p.reseedURL";
    public static final String PROP_PROXY_USERNAME = "router.reseedProxy.username";
    public static final String PROP_PROXY_PASSWORD = "router.reseedProxy.password";
    public static final String PROP_PROXY_AUTH_ENABLE = "router.reseedProxy.authEnable";
    public static final String PROP_SPROXY_HOST = "router.reseedSSLProxyHost";
    public static final String PROP_SPROXY_PORT = "router.reseedSSLProxyPort";
    public static final String PROP_SPROXY_ENABLE = "router.reseedSSLProxyEnable";
    public static final String PROP_SPROXY_USERNAME = "router.reseedSSLProxy.username";
    public static final String PROP_SPROXY_PASSWORD = "router.reseedSSLProxy.password";
    public static final String PROP_SPROXY_AUTH_ENABLE = "router.reseedSSLProxy.authEnable";
    public static final String PROP_SPROXY_TYPE = "router.reseedSSLProxyType";
    public static final String PROP_DISABLE = "router.reseedDisable";
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    Reseeder(RouterContext ctx, ReseedChecker rc) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(Reseeder.class);
        this._checker = rc;
    }

    void requestReseed() {
        ReseedRunner reseedRunner = new ReseedRunner();
        I2PAppThread reseed = new I2PAppThread(reseedRunner, "Reseed", true);
        ((Thread)reseed).start();
    }

    void requestReseed(URI url) throws IllegalArgumentException {
        ReseedRunner reseedRunner = new ReseedRunner(url);
        I2PAppThread reseed = new I2PAppThread(reseedRunner, "Reseed", true);
        ((Thread)reseed).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int requestReseed(InputStream in) throws IOException {
        this._checker.setError(DEFAULT_SEED_URL);
        this._checker.setStatus("Reseeding from file");
        byte[] su3Magic = DataHelper.getASCII("I2Psu3");
        byte[] zipMagic = new byte[]{80, 75, 3, 4};
        int len = Math.max(su3Magic.length, zipMagic.length);
        byte[] magic = new byte[len];
        File tmp = null;
        OutputStream out = null;
        try {
            boolean isSU3;
            DataHelper.read(in, magic);
            if (DataHelper.eq(magic, 0, su3Magic, 0, su3Magic.length)) {
                isSU3 = true;
            } else if (DataHelper.eq(magic, 0, zipMagic, 0, zipMagic.length)) {
                isSU3 = false;
            } else {
                throw new IOException("Not a zip or su3 file");
            }
            tmp = new File(this._context.getTempDir(), "manualreseeds-" + this._context.random().nextInt() + (isSU3 ? ".su3" : ".zip"));
            out = new BufferedOutputStream(new SecureFileOutputStream(tmp));
            out.write(magic);
            DataHelper.copy(in, out);
            out.close();
            ReseedRunner reseedRunner = new ReseedRunner();
            int[] stats = isSU3 ? reseedRunner.extractSU3(tmp) : reseedRunner.extractZip(tmp);
            int fetched = stats[0];
            int errors = stats[1];
            if (fetched <= 0) {
                throw new IOException("No seeds extracted");
            }
            this._checker.setStatus(this._t("Reseeding: got router info from file ({0} successful, {1} errors).", fetched, errors));
            System.err.println("Reseed got " + fetched + " router infos from file with " + errors + " errors");
            this._context.router().eventLog().addEvent("reseed", fetched + " from file");
            int n = fetched;
            return n;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    private static boolean isSNISupported() {
        return SystemVersion.isJava7() || SystemVersion.isAndroid();
    }

    private String _t(String key) {
        return Translate.getString(key, this._context, BUNDLE_NAME);
    }

    private String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    private String _t(String s, Object o, Object o2) {
        return Translate.getString(s, o, o2, (I2PAppContext)this._context, BUNDLE_NAME);
    }

    private String ngettext(String s, String p, int n) {
        return Translate.getString(n, s, p, (I2PAppContext)this._context, BUNDLE_NAME);
    }

    private class ReseedRunner
    implements Runnable,
    EepGet.StatusListener {
        private boolean _isRunning;
        private final String _proxyHost;
        private final String _sproxyHost;
        private final int _proxyPort;
        private final int _sproxyPort;
        private final boolean _shouldProxyHTTP;
        private final boolean _shouldProxySSL;
        private final SSLEepGet.ProxyType _sproxyType;
        private SSLEepGet.SSLState _sslState;
        private int _gotDate;
        private long _attemptStarted;
        private final List<Long> _bandwidths;
        private static final int MAX_DATE_SETS = 2;
        private final URI _url;

        public ReseedRunner() {
            this(null);
        }

        public ReseedRunner(URI url) throws IllegalArgumentException {
            SSLEepGet.ProxyType sproxyType;
            String lc;
            if (url != null && !(lc = url.getPath().toLowerCase(Locale.US)).endsWith(".zip") && !lc.endsWith(".su3")) {
                throw new IllegalArgumentException("Reseed URL must end with .zip or .su3");
            }
            this._url = url;
            this._bandwidths = new ArrayList<Long>(4);
            if (Reseeder.this._context.getBooleanProperty(Reseeder.PROP_PROXY_ENABLE)) {
                this._proxyHost = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_HOST);
                this._proxyPort = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PORT, -1);
            } else {
                this._proxyHost = null;
                this._proxyPort = -1;
            }
            this._shouldProxyHTTP = this._proxyHost != null && this._proxyHost.length() > 0 && this._proxyPort > 0;
            boolean shouldProxySSL = Reseeder.this._context.getBooleanProperty(Reseeder.PROP_SPROXY_ENABLE);
            if (shouldProxySSL) {
                sproxyType = this.getProxyType();
                if (sproxyType == SSLEepGet.ProxyType.INTERNAL) {
                    this._sproxyHost = "localhost";
                    this._sproxyPort = Reseeder.this._context.portMapper().getPort("HTTP", 4444);
                } else {
                    this._sproxyHost = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_HOST);
                    this._sproxyPort = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_PORT, -1);
                }
            } else {
                sproxyType = SSLEepGet.ProxyType.NONE;
                this._sproxyHost = null;
                this._sproxyPort = -1;
            }
            this._shouldProxySSL = shouldProxySSL && this._sproxyHost != null && this._sproxyHost.length() > 0 && this._sproxyPort > 0;
            this._sproxyType = this._shouldProxySSL ? sproxyType : SSLEepGet.ProxyType.NONE;
        }

        @Override
        public void run() {
            try {
                this.run2();
            }
            finally {
                Reseeder.this._checker.done();
                this.processBandwidths();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void run2() {
            String s;
            int total;
            this._isRunning = true;
            Reseeder.this._checker.setError(Reseeder.DEFAULT_SEED_URL);
            Reseeder.this._checker.setStatus(Reseeder.this._t("Reseeding"));
            System.out.println("Reseed start");
            if (this._url != null) {
                String lc = this._url.getPath().toLowerCase(Locale.US);
                if (lc.endsWith(".su3")) {
                    total = this.reseedSU3(this._url, false);
                } else {
                    if (!lc.endsWith(".zip")) throw new IllegalArgumentException("Must end with .zip or .su3");
                    total = this.reseedZip(this._url, false);
                }
            } else {
                total = this.reseed(false);
            }
            if (total >= 20) {
                s = Reseeder.this.ngettext("Reseed successful, fetched {0} router info", "Reseed successful, fetched {0} router infos", total);
                System.out.println(s + this.getDisplayString(this._url));
                Reseeder.this._checker.setStatus(s);
                Reseeder.this._checker.setError(Reseeder.DEFAULT_SEED_URL);
            } else if (total > 0) {
                s = Reseeder.this.ngettext("Reseed fetched only 1 router.", "Reseed fetched only {0} routers.", total);
                System.out.println(s + this.getDisplayString(this._url));
                Reseeder.this._checker.setError(s);
                Reseeder.this._checker.setStatus(Reseeder.DEFAULT_SEED_URL);
            } else {
                if (total == 0) {
                    System.out.println("Reseed failed " + this.getDisplayString(this._url) + "- check network connection");
                    System.out.println("Ensure that nothing blocks outbound HTTP or HTTPS, check the logs, and if nothing helps, read the FAQ about reseeding manually.");
                    if (this._url == null || "https".equals(this._url.getScheme())) {
                        if (this._sproxyHost != null && this._sproxyPort > 0) {
                            System.out.println("Check current proxy setting! Type: " + this.getDisplayString(this._sproxyType) + " Host: " + this._sproxyHost + " Port: " + this._sproxyPort);
                        } else {
                            System.out.println("Consider enabling a proxy for https on the reseed configuration page");
                        }
                    } else if (this._proxyHost != null && this._proxyPort > 0) {
                        System.out.println("Check HTTP proxy setting - host: " + this._proxyHost + " port: " + this._proxyPort);
                    } else {
                        System.out.println("Consider enabling an HTTP proxy on the reseed configuration page");
                    }
                }
                String old = Reseeder.this._checker.getError();
                Reseeder.this._checker.setError(Reseeder.this._t("Reseed failed.") + ' ' + Reseeder.this._t("See {0} for help.", "<a target=\"_top\" href=\"/configreseed\">" + Reseeder.this._t("reseed configuration page") + "</a>") + "<br>" + old);
                Reseeder.this._checker.setStatus(Reseeder.DEFAULT_SEED_URL);
            }
            this._isRunning = false;
            Reseeder.this._context.router().eventLog().addEvent("reseed", Integer.toString(total));
        }

        private void processBandwidths() {
            if (this._bandwidths.isEmpty()) {
                return;
            }
            long tot = 0L;
            for (Long sample : this._bandwidths) {
                tot += sample.longValue();
            }
            long avg = tot / (long)this._bandwidths.size();
            if (Reseeder.this._log.shouldLog(20)) {
                Reseeder.this._log.info("Bandwidth average: " + avg + " KBps from " + this._bandwidths.size() + " samples");
            }
        }

        @Override
        public void attemptFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt, int numRetries, Exception cause) {
            if (Reseeder.this._log.shouldLog(30)) {
                Reseeder.this._log.warn("EepGet failed on " + url, cause);
            } else {
                Reseeder.this._log.logAlways(30, "EepGet failed on " + url + " : " + cause);
            }
            if (cause != null && cause.getMessage() != null) {
                Reseeder.this._checker.setError(DataHelper.escapeHTML(cause.getMessage()));
            }
        }

        @Override
        public void bytesTransferred(long alreadyTransferred, int currentWrite, long bytesTransferred, long bytesRemaining, String url) {
        }

        @Override
        public void transferComplete(long alreadyTransferred, long bytesTransferred, long bytesRemaining, String url, String outputFile, boolean notModified) {
        }

        @Override
        public void transferFailed(String url, long bytesTransferred, long bytesRemaining, int currentAttempt) {
        }

        @Override
        public void headerReceived(String url, int attemptNum, String key, String val) {
            if (this._gotDate < 2 && "date".equals(key.toLowerCase(Locale.US)) && this._attemptStarted > 0L) {
                long timeRcvd = System.currentTimeMillis();
                long serverTime = RFC822Date.parse822Date(val);
                if (serverTime > 0L) {
                    long now = serverTime + 500L + (timeRcvd - this._attemptStarted) / 2L;
                    long offset = now - Reseeder.this._context.clock().now();
                    if (Reseeder.this._context.clock().getUpdatedSuccessfully()) {
                        if (this._gotDate > 0) {
                            Reseeder.this._context.clock().setNow(now, 6);
                        } else {
                            Reseeder.this._context.clock().setNow(now, 7);
                        }
                        if (Reseeder.this._log.shouldLog(30)) {
                            Reseeder.this._log.warn("Reseed adjusting clock by " + DataHelper.formatDuration(Math.abs(offset)));
                        }
                    } else {
                        Reseeder.this._context.clock().setNow(now, 7);
                        Reseeder.this._log.logAlways(30, "NTP failure, Reseed adjusting clock by " + DataHelper.formatDuration(Math.abs(offset)));
                    }
                    ++this._gotDate;
                }
            }
        }

        @Override
        public void attempting(String url) {
            if (this._gotDate < 2) {
                this._attemptStarted = System.currentTimeMillis();
            }
        }

        private int reseed(boolean echoStatus) {
            ArrayList<URI> URLList = new ArrayList<URI>();
            String URLs = Reseeder.this._context.getProperty(Reseeder.PROP_RESEED_URL);
            boolean defaulted = URLs == null;
            boolean SSLDisable = Reseeder.this._context.getBooleanProperty(Reseeder.PROP_SSL_DISABLE);
            boolean SSLRequired = Reseeder.this._context.getBooleanPropertyDefaultTrue(Reseeder.PROP_SSL_REQUIRED);
            if (defaulted) {
                URLs = SSLDisable ? Reseeder.DEFAULT_SEED_URL : Reseeder.DEFAULT_SSL_SEED_URL;
                StringTokenizer tok = new StringTokenizer(URLs, " ,");
                while (tok.hasMoreTokens()) {
                    String u = tok.nextToken().trim();
                    if (!u.endsWith("/")) {
                        u = u + '/';
                    }
                    try {
                        URLList.add(new URI(u));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                Collections.shuffle(URLList, Reseeder.this._context.random());
                if (!SSLDisable && !SSLRequired) {
                    ArrayList<URI> URLList2 = new ArrayList<URI>();
                    tok = new StringTokenizer(Reseeder.DEFAULT_SEED_URL, " ,");
                    while (tok.hasMoreTokens()) {
                        String u = tok.nextToken().trim();
                        if (!u.endsWith("/")) {
                            u = u + '/';
                        }
                        try {
                            URLList2.add(new URI(u));
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                    Collections.shuffle(URLList2, Reseeder.this._context.random());
                    URLList.addAll(URLList2);
                }
            } else {
                ArrayList<URI> SSLList = new ArrayList<URI>();
                ArrayList<URI> nonSSLList = new ArrayList<URI>();
                StringTokenizer tok = new StringTokenizer(URLs, " ,");
                while (tok.hasMoreTokens()) {
                    String u = tok.nextToken().trim();
                    if (!u.endsWith("/")) {
                        u = u + '/';
                    }
                    if (u.startsWith("https")) {
                        try {
                            SSLList.add(new URI(u));
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                        continue;
                    }
                    try {
                        nonSSLList.add(new URI(u));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                }
                if (!SSLDisable) {
                    Collections.shuffle(SSLList, Reseeder.this._context.random());
                    URLList.addAll(SSLList);
                }
                if (SSLDisable || !SSLRequired) {
                    Collections.shuffle(nonSSLList, Reseeder.this._context.random());
                    URLList.addAll(nonSSLList);
                }
            }
            if (!Reseeder.isSNISupported()) {
                try {
                    URLList.remove(new URI("https://i2p.manas.ca:8443/"));
                    URLList.remove(new URI("https://i2p-0.manas.ca:8443/"));
                    URLList.remove(new URI("https://download.xxlspeed.com/"));
                    URLList.remove(new URI("https://netdb.i2p2.no/"));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            if (URLList.isEmpty()) {
                System.out.println("No valid reseed URLs");
                Reseeder.this._checker.setError("No valid reseed URLs");
                return -1;
            }
            return this.reseed(URLList, echoStatus);
        }

        private int reseed(List<URI> URLList, boolean echoStatus) {
            int total = 0;
            int fetched_reseed_servers = 0;
            for (int i = 0; i < URLList.size() && this._isRunning; ++i) {
                if (Reseeder.this._context.router().gracefulShutdownInProgress()) {
                    System.out.println("Reseed aborted, shutdown in progress");
                    return total;
                }
                URI url = URLList.get(i);
                int dl = 0;
                try {
                    dl = this.reseedSU3(new URI(url.toString() + Reseeder.SU3_FILENAME), echoStatus);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                if (dl <= 0) continue;
                if ((total += dl) >= 100 && ++fetched_reseed_servers >= 2) break;
                int j = i + 1;
                while (j < URLList.size()) {
                    if (url.getHost().equals(URLList.get(j).getHost())) {
                        URLList.remove(j);
                        continue;
                    }
                    ++j;
                }
            }
            return total;
        }

        private int reseedOne(URI seedURL, boolean echoStatus) {
            String s = this.getDisplayString(seedURL);
            try {
                int end;
                int start;
                long timeLimit = System.currentTimeMillis() + 420000L;
                Reseeder.this._checker.setStatus(Reseeder.this._t("Reseeding: fetching seed URL."));
                System.err.println("Reseeding from " + s);
                byte[] contentRaw = this.readURL(seedURL);
                if (contentRaw == null) {
                    if (Reseeder.this._log.shouldWarn()) {
                        Reseeder.this._log.warn("Failed reading seed " + s);
                    }
                    System.err.println("Reseed got no router infos " + s);
                    return 0;
                }
                String content = DataHelper.getUTF8(contentRaw);
                HashSet<String> urls = new HashSet<String>(1024);
                Hash ourHash = Reseeder.this._context.routerHash();
                String ourB64 = ourHash != null ? ourHash.toBase64() : null;
                int cur = 0;
                int total = 0;
                while (total++ < 1000 && ((start = content.indexOf("href=\"routerInfo-", cur)) >= 0 || (start = content.indexOf("HREF=\"routerInfo-", cur)) >= 0) && (end = content.indexOf(".dat\">", start)) >= 0) {
                    if (start - end > 200) {
                        cur = end + 1;
                        continue;
                    }
                    String name = content.substring(start + "href=\"routerInfo-".length(), end);
                    if (ourB64 == null || !name.contains(ourB64)) {
                        urls.add(name);
                    } else if (Reseeder.this._log.shouldLog(20)) {
                        Reseeder.this._log.info("Skipping our own RI");
                    }
                    cur = end + 1;
                }
                if (total <= 0) {
                    if (Reseeder.this._log.shouldWarn()) {
                        Reseeder.this._log.warn("Read " + contentRaw.length + " bytes " + s + ", but found no routerInfo URLs.");
                    }
                    System.err.println("Reseed got no router infos " + s);
                    return 0;
                }
                ArrayList urlList = new ArrayList(urls);
                Collections.shuffle(urlList, Reseeder.this._context.random());
                int fetched = 0;
                int errors = 0;
                Iterator iter = urlList.iterator();
                while (iter.hasNext() && fetched < 200 && System.currentTimeMillis() < timeLimit) {
                    try {
                        Reseeder.this._checker.setStatus(Reseeder.this._t("Reseeding: fetching router info from seed URL ({0} successful, {1} errors).", fetched, errors));
                        if (!this.fetchSeed(seedURL.toString(), (String)iter.next())) continue;
                        ++fetched;
                        if (echoStatus) {
                            System.out.print(".");
                            if (fetched % 60 == 0) {
                                System.out.println();
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        if (Reseeder.this._log.shouldLog(20)) {
                            Reseeder.this._log.info("Failed fetch", e);
                        }
                        ++errors;
                    }
                    if (errors < 50 && (errors < 10 || fetched > 1)) continue;
                }
                System.err.println("Reseed got " + fetched + " router infos " + s + " with " + errors + " errors");
                if (fetched > 0) {
                    Reseeder.this._context.netDb().rescan();
                }
                return fetched;
            }
            catch (Throwable t) {
                if (Reseeder.this._log.shouldWarn()) {
                    Reseeder.this._log.warn("Error reseeding", t);
                }
                System.err.println("Reseed got no router infos " + s);
                return 0;
            }
        }

        public int reseedSU3(URI seedURL, boolean echoStatus) {
            return this.reseedSU3OrZip(seedURL, true, echoStatus);
        }

        public int reseedZip(URI seedURL, boolean echoStatus) {
            return this.reseedSU3OrZip(seedURL, false, echoStatus);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int reseedSU3OrZip(URI seedURL, boolean isSU3, boolean echoStatus) {
            int fetched = 0;
            int errors = 0;
            File contentRaw = null;
            try {
                Reseeder.this._checker.setStatus(Reseeder.this._t("Reseeding: fetching seed URL."));
                String s = this.getDisplayString(seedURL);
                System.err.println("Reseeding " + s);
                long startTime = System.currentTimeMillis();
                contentRaw = this.fetchURL(seedURL);
                long totalTime = System.currentTimeMillis() - startTime;
                if (contentRaw == null) {
                    if (Reseeder.this._log.shouldWarn()) {
                        Reseeder.this._log.warn("Failed reading " + s);
                    }
                    System.err.println("Reseed got no router infos " + s);
                    int n = 0;
                    return n;
                }
                if (totalTime > 0L) {
                    long sz = contentRaw.length();
                    long bw = 1000L * sz / totalTime;
                    this._bandwidths.add(bw);
                    if (Reseeder.this._log.shouldLog(10)) {
                        Reseeder.this._log.debug("Rcvd " + sz + " bytes in " + totalTime + " ms " + this.getDisplayString(seedURL));
                    }
                }
                int[] stats = isSU3 ? this.extractSU3(contentRaw) : this.extractZip(contentRaw);
                fetched = stats[0];
                errors = stats[1];
            }
            catch (Throwable t) {
                String s = this.getDisplayString(seedURL);
                System.err.println("Error reseeding " + s + ": " + t);
                Reseeder.this._log.error("Error reseeding " + s, t);
                ++errors;
            }
            finally {
                if (contentRaw != null) {
                    contentRaw.delete();
                }
            }
            Reseeder.this._checker.setStatus(Reseeder.this._t("Reseeding: fetching router info from seed URL ({0} successful, {1} errors).", fetched, errors));
            System.err.println("Reseed got " + fetched + " router infos " + this.getDisplayString(seedURL) + " with " + errors + " errors");
            return fetched;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] extractSU3(File contentRaw) throws IOException {
            int fetched = 0;
            int errors = 0;
            File zip = null;
            try {
                SU3File su3 = new SU3File(Reseeder.this._context, contentRaw);
                zip = new File(Reseeder.this._context.getTempDir(), "reseed-" + Reseeder.this._context.random().nextInt() + ".zip");
                su3.verifyAndMigrate(zip);
                int type = su3.getContentType();
                if (type != 3) {
                    throw new IOException("Bad content type " + type);
                }
                String version = su3.getVersionString();
                try {
                    Long ver = Long.parseLong(version.trim());
                    if (ver >= 1400000000L && (ver = Long.valueOf(ver * 1000L)) < Reseeder.this._context.clock().now() - 2592000000L) {
                        throw new IOException("su3 file too old");
                    }
                }
                catch (NumberFormatException ver) {
                    // empty catch block
                }
                int[] stats = this.extractZip(zip);
                fetched = stats[0];
                errors = stats[1];
            }
            catch (Throwable t) {
                System.err.println("Error reseeding: " + t);
                Reseeder.this._log.error("Error reseeding", t);
            }
            finally {
                contentRaw.delete();
                if (zip != null) {
                    zip.delete();
                }
            }
            int[] rv = new int[]{fetched, ++errors};
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int[] extractZip(File zip) throws IOException {
            int errors;
            int fetched;
            block12: {
                fetched = 0;
                errors = 0;
                File tmpDir = null;
                try {
                    tmpDir = new File(Reseeder.this._context.getTempDir(), "reseeds-" + Reseeder.this._context.random().nextInt());
                    if (!FileUtil.extractZip(zip, tmpDir)) {
                        throw new IOException("Bad zip file");
                    }
                    Hash ourHash = Reseeder.this._context.routerHash();
                    String ourB64 = ourHash != null ? Reseeder.ROUTERINFO_PREFIX + ourHash.toBase64() + Reseeder.ROUTERINFO_SUFFIX : Reseeder.DEFAULT_SEED_URL;
                    File[] files = tmpDir.listFiles();
                    if (files == null || files.length == 0) {
                        throw new IOException("No files in zip");
                    }
                    List<File> fList = Arrays.asList(files);
                    Collections.shuffle(fList, Reseeder.this._context.random());
                    long minTime = Reseeder.this._context.clock().now() - 2592000000L;
                    SecureDirectory netDbDir = new SecureDirectory(Reseeder.this._context.getRouterDir(), "netDb");
                    if (!netDbDir.exists()) {
                        ((File)netDbDir).mkdirs();
                    }
                    Iterator<File> iter = fList.iterator();
                    while (iter.hasNext() && fetched < 400) {
                        File f = iter.next();
                        String name = f.getName();
                        if (name.length() != Reseeder.ROUTERINFO_PREFIX.length() + 44 + Reseeder.ROUTERINFO_SUFFIX.length() || name.equals(ourB64) || f.length() > 10240L || f.lastModified() < minTime || !name.startsWith(Reseeder.ROUTERINFO_PREFIX) || !name.endsWith(Reseeder.ROUTERINFO_SUFFIX) || !f.isFile()) {
                            if (Reseeder.this._log.shouldLog(30)) {
                                Reseeder.this._log.warn("Skipping " + f);
                            }
                            f.delete();
                            ++errors;
                            continue;
                        }
                        File to = new File(netDbDir, name);
                        if (FileUtil.rename(f, to)) {
                            ++fetched;
                        } else {
                            f.delete();
                            ++errors;
                        }
                        if (errors < 5) continue;
                    }
                    if (tmpDir == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tmpDir != null) {
                        FileUtil.rmdir(tmpDir, false);
                    }
                    throw throwable;
                }
                FileUtil.rmdir(tmpDir, false);
            }
            if (fetched > 0) {
                Reseeder.this._context.netDb().rescan();
            }
            int[] rv = new int[]{fetched, errors};
            return rv;
        }

        private boolean fetchSeed(String seedURL, String peer) throws IOException, URISyntaxException {
            URI uri = new URI(peer);
            String b64 = uri.getPath();
            if (b64 == null) {
                throw new IOException("bad hash " + peer);
            }
            byte[] hash = Base64.decode(b64);
            if (hash == null || hash.length != 32) {
                throw new IOException("bad hash " + peer);
            }
            Hash ourHash = Reseeder.this._context.routerHash();
            if (ourHash != null && DataHelper.eq(hash, ourHash.getData())) {
                return false;
            }
            URI url = new URI(seedURL + (seedURL.endsWith("/") ? Reseeder.DEFAULT_SEED_URL : "/") + Reseeder.ROUTERINFO_PREFIX + peer + Reseeder.ROUTERINFO_SUFFIX);
            byte[] data = this.readURL(url);
            if (data == null || data.length <= 0) {
                throw new IOException("Failed fetch of " + url);
            }
            return this.writeSeed(b64, data);
        }

        private byte[] readURL(URI url) throws IOException {
            EepGet get;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            boolean ssl = "https".equals(url.getScheme());
            if (ssl) {
                SSLEepGet sslget;
                if (this._sslState == null) {
                    sslget = this._shouldProxySSL ? new SSLEepGet((I2PAppContext)Reseeder.this._context, this._sproxyType, this._sproxyHost, this._sproxyPort, baos, url.toString()) : new SSLEepGet((I2PAppContext)Reseeder.this._context, baos, url.toString());
                    this._sslState = sslget.getSSLState();
                } else {
                    sslget = this._shouldProxySSL ? new SSLEepGet((I2PAppContext)Reseeder.this._context, this._sproxyType, this._sproxyHost, this._sproxyPort, baos, url.toString(), this._sslState) : new SSLEepGet((I2PAppContext)Reseeder.this._context, baos, url.toString(), this._sslState);
                }
                get = sslget;
                if (this._shouldProxySSL && Reseeder.this._context.getBooleanProperty(Reseeder.PROP_SPROXY_AUTH_ENABLE)) {
                    String user = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_USERNAME);
                    String pass = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_PASSWORD);
                    if (user != null && user.length() > 0 && pass != null && pass.length() > 0) {
                        get.addAuthorization(user, pass);
                    }
                }
            } else {
                get = new EepGet(Reseeder.this._context, this._shouldProxyHTTP, this._proxyHost, this._proxyPort, 0, 0L, 0x200000L, null, baos, url.toString(), false, null, null);
                if (this._shouldProxyHTTP && Reseeder.this._context.getBooleanProperty(Reseeder.PROP_PROXY_AUTH_ENABLE)) {
                    String user = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_USERNAME);
                    String pass = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PASSWORD);
                    if (user != null && user.length() > 0 && pass != null && pass.length() > 0) {
                        get.addAuthorization(user, pass);
                    }
                }
            }
            if (!url.toString().endsWith("/")) {
                String minLastMod = RFC822Date.to822Date(Reseeder.this._context.clock().now() - 2592000000L);
                get.addHeader("If-Modified-Since", minLastMod);
            }
            get.addStatusListener(this);
            if (get.fetch() && get.getStatusCode() == 200) {
                return baos.toByteArray();
            }
            return null;
        }

        private File fetchURL(URI url) throws IOException {
            EepGet get;
            File out = new File(Reseeder.this._context.getTempDir(), "reseed-" + Reseeder.this._context.random().nextInt() + ".tmp");
            boolean ssl = "https".equals(url.getScheme());
            if (ssl) {
                SSLEepGet sslget;
                if (this._sslState == null) {
                    sslget = this._shouldProxySSL ? new SSLEepGet((I2PAppContext)Reseeder.this._context, this._sproxyType, this._sproxyHost, this._sproxyPort, out.getPath(), url.toString()) : new SSLEepGet((I2PAppContext)Reseeder.this._context, out.getPath(), url.toString());
                    this._sslState = sslget.getSSLState();
                } else {
                    sslget = this._shouldProxySSL ? new SSLEepGet((I2PAppContext)Reseeder.this._context, this._sproxyType, this._sproxyHost, this._sproxyPort, out.getPath(), url.toString(), this._sslState) : new SSLEepGet((I2PAppContext)Reseeder.this._context, out.getPath(), url.toString(), this._sslState);
                }
                get = sslget;
                if (this._shouldProxySSL && Reseeder.this._context.getBooleanProperty(Reseeder.PROP_SPROXY_AUTH_ENABLE)) {
                    String user = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_USERNAME);
                    String pass = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_PASSWORD);
                    if (user != null && user.length() > 0 && pass != null && pass.length() > 0) {
                        get.addAuthorization(user, pass);
                    }
                }
            } else {
                get = new EepGet(Reseeder.this._context, this._shouldProxyHTTP, this._proxyHost, this._proxyPort, 0, 0L, 0x100000L, out.getPath(), null, url.toString(), false, null, null);
                if (this._shouldProxyHTTP && Reseeder.this._context.getBooleanProperty(Reseeder.PROP_PROXY_AUTH_ENABLE)) {
                    String user = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_USERNAME);
                    String pass = Reseeder.this._context.getProperty(Reseeder.PROP_PROXY_PASSWORD);
                    if (user != null && user.length() > 0 && pass != null && pass.length() > 0) {
                        get.addAuthorization(user, pass);
                    }
                }
            }
            if (!url.toString().endsWith("/")) {
                String minLastMod = RFC822Date.to822Date(Reseeder.this._context.clock().now() - 2592000000L);
                get.addHeader("If-Modified-Since", minLastMod);
            }
            get.addStatusListener(this);
            if (get.fetch() && get.getStatusCode() == 200) {
                return out;
            }
            out.delete();
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean writeSeed(String name, byte[] data) throws IOException {
            File file;
            String dirName = "netDb";
            SecureDirectory netDbDir = new SecureDirectory(Reseeder.this._context.getRouterDir(), dirName);
            if (!netDbDir.exists()) {
                ((File)netDbDir).mkdirs();
            }
            if ((file = new File(netDbDir, Reseeder.ROUTERINFO_PREFIX + name + Reseeder.ROUTERINFO_SUFFIX)).exists() && file.lastModified() > Reseeder.this._context.clock().now() - 3600000L) {
                if (Reseeder.this._log.shouldLog(20)) {
                    Reseeder.this._log.info("Skipping RI, ours is recent: " + file);
                }
                return false;
            }
            SecureFileOutputStream fos = null;
            try {
                fos = new SecureFileOutputStream(file);
                fos.write(data);
                if (Reseeder.this._log.shouldLog(20)) {
                    Reseeder.this._log.info("Saved RI (" + data.length + " bytes) to " + file);
                }
            }
            finally {
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return true;
        }

        private SSLEepGet.ProxyType getProxyType() throws IllegalArgumentException {
            String sptype = Reseeder.this._context.getProperty(Reseeder.PROP_SPROXY_TYPE, "HTTP").toUpperCase(Locale.US);
            return SSLEepGet.ProxyType.valueOf(sptype);
        }

        private String getDisplayString(URI url) {
            if (url == null) {
                return Reseeder.DEFAULT_SEED_URL;
            }
            return this.getDisplayString(url.toString());
        }

        private String getDisplayString(String url) {
            if (url == null) {
                return Reseeder.DEFAULT_SEED_URL;
            }
            StringBuilder buf = new StringBuilder(64);
            buf.append("from ").append(url);
            boolean ssl = url.startsWith("https://");
            if (ssl && this._shouldProxySSL) {
                buf.append(" (using ");
                buf.append(this.getDisplayString(this._sproxyType));
                buf.append(" proxy ");
                if (this._sproxyHost.contains(":")) {
                    buf.append('[').append(this._sproxyHost).append(']');
                } else {
                    buf.append(this._sproxyHost);
                }
                buf.append(':').append(this._sproxyPort);
                buf.append(')');
            } else if (!ssl && this._shouldProxyHTTP) {
                buf.append(" (using HTTP proxy ");
                if (this._proxyHost.contains(":")) {
                    buf.append('[').append(this._proxyHost).append(']');
                } else {
                    buf.append(this._proxyHost);
                }
                buf.append(':').append(this._proxyPort);
                buf.append(')');
            }
            return buf.toString();
        }

        private String getDisplayString(SSLEepGet.ProxyType type) {
            switch (type) {
                case HTTP: {
                    return "HTTPS";
                }
                case SOCKS4: {
                    return "SOCKS 4/4a";
                }
                case SOCKS5: {
                    return "SOCKS 5";
                }
                case INTERNAL: {
                    return "I2P Outproxy";
                }
            }
            return type.toString();
        }
    }
}

