/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.client;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.crypto.SigType;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Payload;
import net.i2p.data.PublicKey;
import net.i2p.data.i2cp.BandwidthLimitsMessage;
import net.i2p.data.i2cp.CreateLeaseSetMessage;
import net.i2p.data.i2cp.CreateSessionMessage;
import net.i2p.data.i2cp.DestLookupMessage;
import net.i2p.data.i2cp.DestroySessionMessage;
import net.i2p.data.i2cp.GetBandwidthLimitsMessage;
import net.i2p.data.i2cp.GetDateMessage;
import net.i2p.data.i2cp.HostLookupMessage;
import net.i2p.data.i2cp.I2CPMessage;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageReader;
import net.i2p.data.i2cp.MessageId;
import net.i2p.data.i2cp.MessagePayloadMessage;
import net.i2p.data.i2cp.MessageStatusMessage;
import net.i2p.data.i2cp.ReceiveMessageBeginMessage;
import net.i2p.data.i2cp.ReceiveMessageEndMessage;
import net.i2p.data.i2cp.ReconfigureSessionMessage;
import net.i2p.data.i2cp.SendMessageExpiresMessage;
import net.i2p.data.i2cp.SendMessageMessage;
import net.i2p.data.i2cp.SessionConfig;
import net.i2p.data.i2cp.SessionId;
import net.i2p.data.i2cp.SessionStatusMessage;
import net.i2p.data.i2cp.SetDateMessage;
import net.i2p.router.ClientTunnelSettings;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.RouterContext;
import net.i2p.router.client.ClientConnectionRunner;
import net.i2p.router.client.CreateSessionJob;
import net.i2p.router.client.LookupDestJob;
import net.i2p.util.Log;
import net.i2p.util.PasswordManager;

class ClientMessageEventListener
implements I2CPMessageReader.I2CPMessageEventListener {
    private final Log _log;
    protected final RouterContext _context;
    protected final ClientConnectionRunner _runner;
    private final boolean _enforceAuth;
    private volatile boolean _authorized;
    private static final String PROP_AUTH = "i2cp.auth";
    private static final String PROP_AUTH_STRICT = "i2cp.strictAuth";

    public ClientMessageEventListener(RouterContext context, ClientConnectionRunner runner, boolean enforceAuth) {
        this._context = context;
        this._log = this._context.logManager().getLog(ClientMessageEventListener.class);
        this._runner = runner;
        this._enforceAuth = enforceAuth;
        if (!this._enforceAuth || !this._context.getBooleanProperty(PROP_AUTH)) {
            this._authorized = true;
        }
        this._context.statManager().createRateStat("client.distributeTime", "How long it took to inject the client message into the router", "ClientMessages", new long[]{60000L, 600000L, 3600000L});
    }

    @Override
    public void messageReceived(I2CPMessageReader reader, I2CPMessage message) {
        boolean strict;
        if (this._runner.isDead()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Received but runner dead: \n" + message);
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Message received: \n" + message);
        }
        int type = message.getType();
        if (!this._authorized && ((strict = this._context.getBooleanPropertyDefaultTrue(PROP_AUTH_STRICT)) && type != 32 || type != 1 && type != 32 && type != 34 && type != 8)) {
            this._log.error("Received message type " + type + " without required authentication");
            this._runner.disconnectClient("Authorization required");
            return;
        }
        switch (message.getType()) {
            case 32: {
                this.handleGetDate((GetDateMessage)message);
                break;
            }
            case 33: {
                this.handleSetDate((SetDateMessage)message);
                break;
            }
            case 1: {
                this.handleCreateSession((CreateSessionMessage)message);
                break;
            }
            case 5: {
                this.handleSendMessage((SendMessageMessage)message);
                break;
            }
            case 36: {
                this.handleSendMessage((SendMessageExpiresMessage)message);
                break;
            }
            case 6: {
                this.handleReceiveBegin((ReceiveMessageBeginMessage)message);
                break;
            }
            case 7: {
                this.handleReceiveEnd((ReceiveMessageEndMessage)message);
                break;
            }
            case 4: {
                this.handleCreateLeaseSet((CreateLeaseSetMessage)message);
                break;
            }
            case 3: {
                this.handleDestroySession((DestroySessionMessage)message);
                break;
            }
            case 34: {
                this.handleDestLookup((DestLookupMessage)message);
                break;
            }
            case 38: {
                this.handleHostLookup((HostLookupMessage)message);
                break;
            }
            case 2: {
                this.handleReconfigureSession((ReconfigureSessionMessage)message);
                break;
            }
            case 8: {
                this.handleGetBWLimits((GetBandwidthLimitsMessage)message);
                break;
            }
            default: {
                if (!this._log.shouldLog(40)) break;
                this._log.error("Unhandled I2CP type received: " + message.getType());
            }
        }
    }

    @Override
    public void readError(I2CPMessageReader reader, Exception error) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(40)) {
            this._log.error("Error occurred", error);
        }
        this._runner.disconnectClient(error.toString());
        this._runner.stopRunning();
    }

    @Override
    public void disconnected(I2CPMessageReader reader) {
        if (this._runner.isDead()) {
            return;
        }
        this._runner.disconnected();
    }

    private void handleGetDate(GetDateMessage message) {
        block4: {
            Properties props;
            String clientVersion = message.getVersion();
            if (clientVersion != null) {
                this._runner.setClientVersion(clientVersion);
            }
            if (!this.checkAuth(props = message.getOptions())) {
                return;
            }
            try {
                this._runner.doSend(new SetDateMessage(clientVersion != null ? "0.9.34" : null));
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(40)) break block4;
                this._log.error("Error writing out the setDate message", ime);
            }
        }
    }

    private void handleSetDate(SetDateMessage message) {
    }

    private void handleCreateSession(CreateSessionMessage message) {
        SessionConfig in = message.getSessionConfig();
        Destination dest = in.getDestination();
        if (in.verifySignature()) {
            if (this._log.shouldLog(10)) {
                this._log.debug("Signature verified correctly on create session message");
            }
        } else {
            int itype = dest.getCertificate().getCertificateType();
            SigType stype = SigType.getByCode(itype);
            if (stype == null || !stype.isAvailable()) {
                this._log.error("Client requested unsupported signature type " + itype);
                this._runner.disconnectClient("Unsupported signature type " + itype);
            } else if (in.tooOld()) {
                long skew = this._context.clock().now() - in.getCreationDate().getTime();
                String msg = "Create session message client clock skew? ";
                msg = skew >= 0L ? msg + DataHelper.formatDuration(skew) + " in the past" : msg + DataHelper.formatDuration(0L - skew) + " in the future";
                this._log.error(msg);
                this._runner.disconnectClient(msg);
            } else {
                this._log.error("Signature verification failed on a create session message");
                this._runner.disconnectClient("Invalid signature on CreateSessionMessage");
            }
            return;
        }
        Properties inProps = in.getOptions();
        if (!this.checkAuth(inProps)) {
            return;
        }
        SessionId id = this._runner.getSessionId(dest.calculateHash());
        if (id != null) {
            this._runner.disconnectClient("Already have session " + id);
            return;
        }
        SessionConfig cfg = new SessionConfig(dest);
        cfg.setSignature(in.getSignature());
        Properties props = new Properties();
        boolean isPrimary = this._runner.getSessionIds().isEmpty();
        if (!isPrimary) {
            SessionConfig pcfg = this._runner.getPrimaryConfig();
            if (pcfg != null) {
                props.putAll((Map<?, ?>)pcfg.getOptions());
            } else {
                this._log.error("no primary config?");
            }
        }
        props.putAll((Map<?, ?>)inProps);
        cfg.setOptions(props);
        int status = this._runner.sessionEstablished(cfg);
        if (status != 1) {
            if (this._log.shouldLog(40)) {
                this._log.error("Session establish failed: code = " + status);
            }
            String msg = status == 3 ? "duplicate destination" : (status == 4 ? "session limit exceeded" : "unknown error");
            this._runner.disconnectClient(msg);
            return;
        }
        id = this._runner.getSessionId(dest.calculateHash());
        if (this._log.shouldLog(20)) {
            this._log.info("Session " + id + " established for " + dest.calculateHash());
        }
        if (isPrimary) {
            this.sendStatusMessage(id, status);
            this.startCreateSessionJob(cfg);
        } else {
            SessionConfig pcfg = this._runner.getPrimaryConfig();
            if (pcfg != null) {
                ClientTunnelSettings settings = new ClientTunnelSettings(dest.calculateHash());
                settings.readFromProperties(props);
                this.sendStatusMessage(id, status);
                boolean ok = this._context.tunnelManager().addAlias(dest, settings, pcfg.getDestination());
                if (!ok) {
                    this._log.error("Add alias failed");
                }
            } else {
                this._log.error("no primary config?");
                status = 3;
                this.sendStatusMessage(id, status);
            }
        }
    }

    private boolean checkAuth(Properties props) {
        if (this._authorized) {
            return true;
        }
        if (this._enforceAuth && this._context.getBooleanProperty(PROP_AUTH)) {
            String user = null;
            String pw = null;
            if (props != null) {
                user = props.getProperty("i2cp.username");
                pw = props.getProperty("i2cp.password");
            }
            if (user == null || user.length() == 0 || pw == null || pw.length() == 0) {
                this._log.logAlways(30, "I2CP authentication failed");
                this._runner.disconnectClient("Authorization required, specify i2cp.username and i2cp.password in options");
                this._authorized = false;
                return false;
            }
            PasswordManager mgr = new PasswordManager(this._context);
            if (!mgr.checkHash(PROP_AUTH, user, pw)) {
                this._log.logAlways(30, "I2CP authentication failed, user: " + user);
                this._runner.disconnectClient("Authorization failed, user = " + user);
                this._authorized = false;
                return false;
            }
            if (this._log.shouldLog(20)) {
                this._log.info("I2CP auth success user: " + user);
            }
        }
        this._authorized = true;
        return true;
    }

    protected void startCreateSessionJob(SessionConfig config) {
        this._context.jobQueue().addJob(new CreateSessionJob(this._context, config));
    }

    private void handleSendMessage(SendMessageMessage message) {
        SessionId sid = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(sid);
        if (cfg == null) {
            block7: {
                List<SessionId> current = this._runner.getSessionIds();
                String msg = "SendMessage invalid session: " + sid + " current: " + current;
                if (this._log.shouldLog(40)) {
                    this._log.error(msg);
                }
                if (sid != null && message.getNonce() > 0L) {
                    MessageStatusMessage status = new MessageStatusMessage();
                    status.setMessageId(this._runner.getNextMessageId());
                    status.setSessionId(sid.getSessionId());
                    status.setSize(0L);
                    status.setNonce(message.getNonce());
                    status.setStatus(10);
                    try {
                        this._runner.doSend(status);
                    }
                    catch (I2CPMessageException ime) {
                        if (!this._log.shouldLog(30)) break block7;
                        this._log.warn("Error writing out the message status message", ime);
                    }
                }
            }
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("handleSendMessage called");
        }
        long beforeDistribute = this._context.clock().now();
        MessageId id = this._runner.distributeMessage(message);
        long timeToDistribute = this._context.clock().now() - beforeDistribute;
        this._runner.ackSendMessage(sid, id, message.getNonce());
        this._context.statManager().addRateData("client.distributeTime", timeToDistribute);
        if (timeToDistribute > 50L && this._log.shouldLog(10)) {
            this._log.debug("Took too long to distribute the message (which holds up the ack): " + timeToDistribute);
        }
    }

    private void handleReceiveBegin(ReceiveMessageBeginMessage message) {
        if (this._runner.isDead()) {
            return;
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("Handling receive begin: id = " + message.getMessageId());
        }
        MessagePayloadMessage msg = new MessagePayloadMessage();
        msg.setMessageId(message.getMessageId());
        msg.setSessionId(message.getSessionId());
        Payload payload = this._runner.getPayload(new MessageId(message.getMessageId()));
        if (payload == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Payload for message id [" + message.getMessageId() + "] is null!  Dropped or Unknown message id");
            }
            return;
        }
        msg.setPayload(payload);
        try {
            this._runner.doSend(msg);
        }
        catch (I2CPMessageException ime) {
            String emsg = "Error sending data to client " + this._runner.getDestHash();
            if (this._log.shouldWarn()) {
                this._log.warn(emsg, ime);
            } else {
                this._log.logAlways(30, emsg);
            }
            this._runner.removePayload(new MessageId(message.getMessageId()));
        }
    }

    private void handleReceiveEnd(ReceiveMessageEndMessage message) {
        this._runner.removePayload(new MessageId(message.getMessageId()));
    }

    private void handleDestroySession(DestroySessionMessage message) {
        SessionId id = message.getSessionId();
        if (id != null) {
            this._runner.removeSession(id);
        } else if (this._log.shouldLog(30)) {
            this._log.warn("destroy session with null ID");
        }
        int left = this._runner.getSessionIds().size();
        if (left <= 0 || id == null) {
            this._runner.stopRunning();
        } else if (this._log.shouldLog(20)) {
            this._log.info("Still " + left + " sessions left");
        }
    }

    protected void handleCreateLeaseSet(CreateLeaseSetMessage message) {
        Destination ndest;
        if (message.getLeaseSet() == null || message.getPrivateKey() == null || message.getSigningPrivateKey() == null) {
            if (this._log.shouldLog(40)) {
                this._log.error("Null lease set granted: " + message);
            }
            this._runner.disconnectClient("Invalid CreateLeaseSetMessage");
            return;
        }
        SessionId id = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(id);
        if (cfg == null) {
            List<SessionId> current = this._runner.getSessionIds();
            String msg = "CreateLeaseSet invalid session: " + id + " current: " + current;
            if (this._log.shouldLog(40)) {
                this._log.error(msg);
            }
            this._runner.disconnectClient(msg);
            return;
        }
        Destination dest = cfg.getDestination();
        if (!dest.equals(ndest = message.getLeaseSet().getDestination())) {
            if (this._log.shouldLog(40)) {
                this._log.error("Different destination in LS");
            }
            this._runner.disconnectClient("Different destination in LS");
            return;
        }
        LeaseSetKeys keys = this._context.keyManager().getKeys(dest);
        if (keys == null || !message.getPrivateKey().equals(keys.getDecryptionKey())) {
            PublicKey pk;
            try {
                pk = message.getPrivateKey().toPublic();
            }
            catch (IllegalArgumentException iae) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Bad private key in LS");
                }
                this._runner.disconnectClient("Bad private key in LS");
                return;
            }
            if (!pk.equals(message.getLeaseSet().getEncryptionKey())) {
                if (this._log.shouldLog(40)) {
                    this._log.error("Private/public crypto key mismatch in LS");
                }
                this._runner.disconnectClient("Private/public crypto key mismatch in LS");
                return;
            }
            this._context.keyManager().registerKeys(dest, message.getSigningPrivateKey(), message.getPrivateKey());
        } else if (!message.getSigningPrivateKey().equals(keys.getRevocationKey())) {
            this._context.keyManager().registerKeys(dest, message.getSigningPrivateKey(), message.getPrivateKey());
        }
        try {
            this._context.netDb().publish(message.getLeaseSet());
        }
        catch (IllegalArgumentException iae) {
            if (this._log.shouldLog(40)) {
                this._log.error("Invalid leaseset from client", iae);
            }
            this._runner.disconnectClient("Invalid leaseset: " + iae);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("New lease set granted for destination " + dest);
        }
        this._runner.leaseSetCreated(message.getLeaseSet());
    }

    protected void handleDestLookup(DestLookupMessage message) {
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getHash(), this._runner.getDestHash()));
    }

    protected void handleHostLookup(HostLookupMessage message) {
        Hash h;
        SessionId sid = message.getSessionId();
        if (sid != null) {
            h = this._runner.getDestHash(sid);
        } else {
            if (message.getReqID() >= 0L) {
                sid = new SessionId(65535);
            }
            h = null;
        }
        if (h == null) {
            h = this._runner.getDestHash();
        }
        this._context.jobQueue().addJob(new LookupDestJob(this._context, this._runner, message.getReqID(), message.getTimeout(), sid, message.getHash(), message.getHostname(), h));
    }

    private void handleReconfigureSession(ReconfigureSessionMessage message) {
        SessionId id = message.getSessionId();
        SessionConfig cfg = this._runner.getConfig(id);
        if (cfg == null) {
            List<SessionId> current = this._runner.getSessionIds();
            String msg = "ReconfigureSession invalid session: " + id + " current: " + current;
            if (this._log.shouldLog(40)) {
                this._log.error(msg);
            }
            this._runner.disconnectClient(msg);
            return;
        }
        if (this._log.shouldLog(20)) {
            this._log.info("Updating options - old: " + cfg + " new: " + message.getSessionConfig());
        }
        if (!message.getSessionConfig().getDestination().equals(cfg.getDestination())) {
            this._log.error("Dest mismatch");
            this.sendStatusMessage(id, 3);
            this._runner.stopRunning();
            return;
        }
        Hash dest = cfg.getDestination().calculateHash();
        cfg.getOptions().putAll((Map<?, ?>)message.getSessionConfig().getOptions());
        ClientTunnelSettings settings = new ClientTunnelSettings(dest);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)cfg.getOptions());
        settings.readFromProperties(props);
        this._context.tunnelManager().setInboundSettings(dest, settings.getInboundSettings());
        this._context.tunnelManager().setOutboundSettings(dest, settings.getOutboundSettings());
        this.sendStatusMessage(id, 2);
    }

    private void sendStatusMessage(SessionId id, int status) {
        block2: {
            SessionStatusMessage msg = new SessionStatusMessage();
            msg.setSessionId(id);
            msg.setStatus(status);
            try {
                this._runner.doSend(msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block2;
                this._log.warn("Error writing out the session status message", ime);
            }
        }
    }

    protected void handleGetBWLimits(GetBandwidthLimitsMessage message) {
        block3: {
            if (this._log.shouldLog(20)) {
                this._log.info("Got BW Limits request");
            }
            int in = this._context.bandwidthLimiter().getInboundKBytesPerSecond() * 4 / 7;
            int out = this._context.bandwidthLimiter().getOutboundKBytesPerSecond() * 4 / 7;
            BandwidthLimitsMessage msg = new BandwidthLimitsMessage(in, out);
            try {
                this._runner.doSend(msg);
            }
            catch (I2CPMessageException ime) {
                if (!this._log.shouldLog(30)) break block3;
                this._log.warn("Error writing bw limits msg", ime);
            }
        }
    }
}

