/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.app.Outproxy;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.socks.I2PSOCKSTunnel;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SocketWrapper;
import net.i2p.socks.SOCKSException;
import net.i2p.util.HexDump;

class SOCKS4aServer
extends SOCKSServer {
    private boolean setupCompleted;

    public SOCKS4aServer(I2PAppContext ctx, Socket clientSock, Properties props) {
        super(ctx, clientSock, props);
    }

    @Override
    public Socket getClientSocket() throws SOCKSException {
        this.setupServer();
        return this.clientSock;
    }

    @Override
    protected void setupServer() throws SOCKSException {
        if (this.setupCompleted) {
            return;
        }
        try {
            DataInputStream in = new DataInputStream(this.clientSock.getInputStream());
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.manageRequest(in, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
        this.setupCompleted = true;
    }

    private void manageRequest(DataInputStream in, DataOutputStream out) throws IOException, SOCKSException {
        int command = in.readByte() & 0xFF;
        switch (command) {
            case 1: {
                break;
            }
            case 2: {
                this._log.debug("BIND command is not supported!");
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                throw new SOCKSException("BIND command not supported");
            }
            default: {
                this._log.debug("unknown command in request (" + Integer.toHexString(command) + ")");
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                throw new SOCKSException("Invalid command in request");
            }
        }
        this.connPort = in.readUnsignedShort();
        if (this.connPort == 0) {
            this._log.debug("trying to connect to TCP port 0?  Dropping!");
            this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            throw new SOCKSException("Invalid port number in request");
        }
        StringBuilder builder = new StringBuilder();
        boolean alreadyWarned = false;
        for (int i = 0; i < 4; ++i) {
            int octet = in.readByte() & 0xFF;
            builder.append(Integer.toString(octet));
            if (i == 3) continue;
            builder.append(".");
            if (octet == 0 || alreadyWarned) continue;
            this._log.warn("IPV4 address type in request: " + this.connHostName + ". Is your client secure?");
            alreadyWarned = true;
        }
        this.connHostName = builder.toString();
        String mappedDomainName = this.getMappedDomainNameForIP(this.connHostName);
        if (mappedDomainName != null) {
            this._log.debug("IPV4 address " + this.connHostName + " was mapped to domain name " + mappedDomainName);
            this.connHostName = mappedDomainName;
        }
        this.readString(in);
        if (this.connHostName.startsWith("0.0.0.") && !this.connHostName.equals("0.0.0.0")) {
            this.connHostName = this.readString(in);
        }
    }

    private String readString(DataInputStream in) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder(16);
        while ((c = (char)(in.readByte() & 0xFF)) != '\u0000') {
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    protected void confirmConnection() throws SOCKSException {
        try {
            DataOutputStream out = new DataOutputStream(this.clientSock.getOutputStream());
            this.sendRequestReply(90, InetAddress.getByName("127.0.0.1"), 1, out);
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
    }

    private void sendRequestReply(int replyCode, InetAddress inetAddr, int bindPort, DataOutputStream out) throws IOException {
        ByteArrayOutputStream reps = new ByteArrayOutputStream();
        DataOutputStream dreps = new DataOutputStream(reps);
        dreps.write(0);
        dreps.write(replyCode);
        dreps.writeShort(bindPort);
        dreps.write(inetAddr.getAddress());
        byte[] reply = reps.toByteArray();
        if (this._log.shouldLog(10)) {
            this._log.debug("Sending request reply:\n" + HexDump.dump(reply));
        }
        out.write(reply);
    }

    @Override
    public I2PSocket getDestinationI2PSocket(I2PSOCKSTunnel t) throws SOCKSException {
        I2PSocket destSock;
        DataOutputStream out;
        this.setupServer();
        if (this.connHostName == null) {
            this._log.error("BUG: destination host name has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        if (this.connPort == 0) {
            this._log.error("BUG: destination port has not been initialized!");
            throw new SOCKSException("BUG! See the logs!");
        }
        try {
            out = new DataOutputStream(this.clientSock.getOutputStream());
        }
        catch (IOException e) {
            throw new SOCKSException("Connection error", e);
        }
        try {
            if (this.connHostName.toLowerCase(Locale.US).endsWith(".i2p")) {
                Destination dest = this._context.namingService().lookup(this.connHostName);
                if (dest == null) {
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SOCKSException("Host not found");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("connecting to " + this.connHostName + "...");
                }
                Properties overrides = new Properties();
                I2PSocketOptions sktOpts = t.buildOptions(overrides);
                sktOpts.setPort(this.connPort);
                destSock = t.createI2PSocket(dest, sktOpts);
            } else {
                if ("localhost".equals(this.connHostName) || "127.0.0.1".equals(this.connHostName)) {
                    String err = "No localhost accesses allowed through the Socks Proxy";
                    this._log.error(err);
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException overrides) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                Outproxy outproxy = this.getOutproxyPlugin();
                if (outproxy != null) {
                    try {
                        destSock = new SocketWrapper(outproxy.connect(this.connHostName, this.connPort));
                    }
                    catch (IOException ioe) {
                        try {
                            this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                        }
                        catch (IOException sktOpts) {
                            // empty catch block
                        }
                        throw new SOCKSException("connect failed via outproxy plugin", ioe);
                    }
                }
                List<String> proxies = t.getProxies(this.connPort);
                if (proxies == null || proxies.isEmpty()) {
                    String err = "No outproxy configured for port " + this.connPort + " and no default configured either - host: " + this.connHostName;
                    this._log.error(err);
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SOCKSException(err);
                }
                int p = this._context.random().nextInt(proxies.size());
                String proxy = proxies.get(p);
                Destination dest = this._context.namingService().lookup(proxy);
                if (dest == null) {
                    try {
                        this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new SOCKSException("Outproxy not found");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("connecting to port " + this.connPort + " proxy " + proxy + " for " + this.connHostName + "...");
                }
                destSock = t.createI2PSocket(dest);
            }
            this.confirmConnection();
            this._log.debug("connection confirmed - exchanging data...");
        }
        catch (DataFormatException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Error in destination format", e);
        }
        catch (IOException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting", e);
        }
        catch (I2PException e) {
            try {
                this.sendRequestReply(91, InetAddress.getByName("127.0.0.1"), 0, out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SOCKSException("Error connecting", e);
        }
        return destSock;
    }
}

