/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.socks;

import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelClientBase;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.socks.SOCKSServer;
import net.i2p.i2ptunnel.socks.SOCKSServerFactory;
import net.i2p.socks.SOCKSException;
import net.i2p.util.EventDispatcher;

public class I2PSOCKSTunnel
extends I2PTunnelClientBase {
    protected static final int INITIAL_SO_TIMEOUT = 15000;
    private HashMap<String, List<String>> proxies = null;
    public static final String PROP_PROXY_PREFIX = "i2ptunnel.socks.proxy.";
    public static final String DEFAULT = "default";
    public static final String PROP_PROXY_DEFAULT = "i2ptunnel.socks.proxy.default";

    public I2PSOCKSTunnel(int localPort, Logging l, boolean ownDest, EventDispatcher notifyThis, I2PTunnel tunnel, String pkf) {
        super(localPort, ownDest, l, notifyThis, "SOCKS Proxy on " + tunnel.listenHost + ':' + localPort, tunnel, pkf);
        this.setName("SOCKS Proxy on " + tunnel.listenHost + ':' + localPort);
        this.parseOptions();
        this.notifyEvent("openSOCKSTunnelResult", "ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        Closeable destSock = null;
        try {
            try {
                s.setSoTimeout(15000);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            SOCKSServer serv = SOCKSServerFactory.createSOCKSServer(this._context, s, this.getTunnel().getClientOptions());
            Socket clientSock = serv.getClientSocket();
            try {
                s.setSoTimeout(0);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
            destSock = serv.getDestinationI2PSocket(this);
            I2PTunnelRunner t = new I2PTunnelRunner(clientSock, (I2PSocket)destSock, this.sockLock, null, null, (List<I2PSocket>)this.mySockets, (I2PTunnelRunner.FailCallback)null);
            ((Thread)t).run();
        }
        catch (SOCKSException e) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Error from SOCKS connection", e);
            }
        }
        finally {
            I2PSOCKSTunnel.closeSocket(s);
            if (destSock != null) {
                try {
                    destSock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void parseOptions() {
        Properties opts = this.getTunnel().getClientOptions();
        this.proxies = new HashMap(1);
        for (Map.Entry<Object, Object> e : opts.entrySet()) {
            String prop = (String)e.getKey();
            if (!prop.startsWith(PROP_PROXY_PREFIX) || prop.length() <= PROP_PROXY_PREFIX.length()) continue;
            String port = prop.substring(PROP_PROXY_PREFIX.length());
            ArrayList<String> proxyList = new ArrayList<String>(1);
            StringTokenizer tok = new StringTokenizer((String)e.getValue(), ", \t");
            while (tok.hasMoreTokens()) {
                String proxy = tok.nextToken().trim();
                if (proxy.endsWith(".i2p")) {
                    proxyList.add(proxy);
                    continue;
                }
                this._log.error("Non-i2p SOCKS outproxy: " + proxy);
            }
            this.proxies.put(port, proxyList);
        }
    }

    public HashMap<String, List<String>> getProxyMap() {
        return this.proxies;
    }

    public List<String> getProxies(int port) {
        List<String> rv = this.proxies.get(port + "");
        if (rv == null) {
            rv = this.getDefaultProxies();
        }
        return rv;
    }

    public List<String> getDefaultProxies() {
        return this.proxies.get(DEFAULT);
    }

    public I2PSocketOptions buildOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }
}

