/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.I2PClient;
import net.i2p.client.I2PClientFactory;
import net.i2p.client.I2PSession;
import net.i2p.crypto.SigType;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.TunnelControllerGroup;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.SecureFile;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

public class TunnelController
implements Logging {
    private final Log _log;
    private Properties _config;
    private final I2PTunnel _tunnel = new I2PTunnel();
    private final List<String> _messages;
    private List<I2PSession> _sessions;
    private volatile TunnelState _state;
    public static final String KEY_BACKUP_DIR = "i2ptunnel-keyBackup";
    public static final String PROP_DESCR = "description";
    public static final String PROP_DEST = "targetDestination";
    public static final String PROP_I2CP_HOST = "i2cpHost";
    public static final String PROP_I2CP_PORT = "i2cpPort";
    public static final String PROP_INTFC = "interface";
    public static final String PROP_FILE = "privKeyFile";
    public static final String PROP_LISTEN_PORT = "listenPort";
    public static final String PROP_NAME = "name";
    public static final String PROP_PROXIES = "proxyList";
    public static final String PROP_SHARED = "sharedClient";
    public static final String PROP_SPOOFED_HOST = "spoofedHost";
    public static final String PROP_START = "startOnLoad";
    public static final String PROP_TARGET_HOST = "targetHost";
    public static final String PROP_TARGET_PORT = "targetPort";
    public static final String PROP_TYPE = "type";
    public static final String PROP_MAX_CONNS_MIN = "i2p.streaming.maxConnsPerMinute";
    public static final String PROP_MAX_CONNS_HOUR = "i2p.streaming.maxConnsPerHour";
    public static final String PROP_MAX_CONNS_DAY = "i2p.streaming.maxConnsPerDay";
    public static final String PROP_MAX_TOTAL_CONNS_MIN = "i2p.streaming.maxTotalConnsPerMinute";
    public static final String PROP_MAX_TOTAL_CONNS_HOUR = "i2p.streaming.maxTotalConnsPerHour";
    public static final String PROP_MAX_TOTAL_CONNS_DAY = "i2p.streaming.maxTotalConnsPerDay";
    public static final String PROP_MAX_STREAMS = "i2p.streaming.maxConcurrentStreams";
    public static final String PROP_LIMITS_SET = "i2p.streaming.limitsManuallySet";
    public static final int DEFAULT_MAX_CONNS_MIN = 10;
    public static final int DEFAULT_MAX_CONNS_HOUR = 40;
    public static final int DEFAULT_MAX_CONNS_DAY = 100;
    public static final int DEFAULT_MAX_TOTAL_CONNS_MIN = 25;
    public static final int DEFAULT_MAX_TOTAL_CONNS_HOUR = 0;
    public static final int DEFAULT_MAX_TOTAL_CONNS_DAY = 0;
    public static final int DEFAULT_MAX_STREAMS = 20;
    public static final String PROP_LIMIT_ACTION = "i2p.streaming.limitAction";
    public static final String PFX_OPTION = "option.";
    private static final String OPT_PERSISTENT = "option.persistentClientKey";
    public static final String OPT_BUNDLE_REPLY = "option.shouldBundleReplyInfo";
    private static final String OPT_TAGS_SEND = "option.crypto.tagsToSend";
    private static final String OPT_LOW_TAGS = "option.crypto.lowTagThreshold";
    private static final String OPT_SIG_TYPE = "option.i2cp.destination.sigType";
    private static final String OPT_ALT_PKF = "option.altPrivKeyFile";
    private static final String OPT_MAX_CONNS_MIN = "option.i2p.streaming.maxConnsPerMinute";
    private static final String OPT_MAX_CONNS_HOUR = "option.i2p.streaming.maxConnsPerHour";
    private static final String OPT_MAX_CONNS_DAY = "option.i2p.streaming.maxConnsPerDay";
    private static final String OPT_MAX_TOTAL_CONNS_MIN = "option.i2p.streaming.maxTotalConnsPerMinute";
    private static final String OPT_MAX_TOTAL_CONNS_HOUR = "option.i2p.streaming.maxTotalConnsPerHour";
    private static final String OPT_MAX_TOTAL_CONNS_DAY = "option.i2p.streaming.maxTotalConnsPerDay";
    private static final String OPT_MAX_STREAMS = "option.i2p.streaming.maxConcurrentStreams";
    private static final String OPT_LIMITS_SET = "option.i2p.streaming.limitsManuallySet";
    public static final String OPT_POST_MAX = "option.maxPosts";
    public static final String OPT_POST_TOTAL_MAX = "option.maxTotalPosts";
    private static final String OPT_LIMIT_ACTION = "option.i2p.streaming.limitAction";
    public static final String TYPE_CONNECT = "connectclient";
    public static final String TYPE_HTTP_BIDIR_SERVER = "httpbidirserver";
    public static final String TYPE_HTTP_CLIENT = "httpclient";
    public static final String TYPE_HTTP_SERVER = "httpserver";
    public static final String TYPE_IRC_CLIENT = "ircclient";
    public static final String TYPE_IRC_SERVER = "ircserver";
    public static final String TYPE_SOCKS = "sockstunnel";
    public static final String TYPE_SOCKS_IRC = "socksirctunnel";
    public static final String TYPE_STD_CLIENT = "client";
    public static final String TYPE_STD_SERVER = "server";
    public static final String TYPE_STREAMR_CLIENT = "streamrclient";
    public static final String TYPE_STREAMR_SERVER = "streamrserver";
    public static final SigType PREFERRED_SIGTYPE = SystemVersion.isGNU() || SystemVersion.isAndroid() ? (SigType.ECDSA_SHA256_P256.isAvailable() ? SigType.ECDSA_SHA256_P256 : SigType.DSA_SHA1) : SigType.EdDSA_SHA512_Ed25519;

    public TunnelController(Properties config, String prefix) {
        this(config, prefix, true);
    }

    public TunnelController(Properties config, String prefix, boolean createKey) {
        this._log = I2PAppContext.getGlobalContext().logManager().getLog(TunnelController.class);
        this.setConfig(config, prefix);
        this._messages = new ArrayList<String>(4);
        boolean keyOK = true;
        if (createKey && (!this.isClient() || this.getPersistentClientKey()) && (keyOK = this.createPrivateKey()) && !this.isClient() && !this.getType().equals(TYPE_STREAMR_SERVER)) {
            this.createAltPrivateKey();
        }
        this._state = keyOK && this.getStartOnLoad() ? TunnelState.START_ON_LOAD : TunnelState.STOPPED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPrivateKey() {
        I2PClient client = I2PClientFactory.createClient();
        File keyFile = this.getPrivateKeyFile();
        if (keyFile == null) {
            this.log("No filename specified for the private key");
            return false;
        }
        if (keyFile.exists()) {
            return true;
        }
        File parent = keyFile.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        SecureFileOutputStream fos = null;
        try {
            String name;
            File backup;
            fos = new SecureFileOutputStream(keyFile);
            SigType stype = PREFERRED_SIGTYPE;
            String st = this._config.getProperty(OPT_SIG_TYPE);
            if (st != null) {
                SigType type = SigType.parseSigType(st);
                if (type != null && type.isAvailable()) {
                    stype = type;
                } else {
                    this.log("Unsupported sig type " + st + ", reverting to " + (Object)((Object)stype));
                }
            }
            Destination dest = client.createDestination((OutputStream)fos, stype);
            String destStr = dest.toBase64();
            this.log("Private key created and saved in " + keyFile.getAbsolutePath());
            this.log("You should backup this file in a secure place.");
            this.log("New destination: " + destStr);
            String b32 = dest.toBase32();
            this.log("Base32: " + b32);
            SecureFile backupDir = new SecureFile(I2PAppContext.getGlobalContext().getConfigDir(), KEY_BACKUP_DIR);
            if ((backupDir.isDirectory() || ((File)backupDir).mkdir()) && FileUtil.copy(keyFile, backup = new File(backupDir, name = b32 + '-' + I2PAppContext.getGlobalContext().clock().now() + ".dat"), false, true)) {
                SecureFileOutputStream.setPerms(backup);
                this.log("Private key backup saved to " + backup.getAbsolutePath());
            }
        }
        catch (I2PException ie) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error creating new destination", ie);
            }
            this.log("Error creating new destination: " + ie.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ioe) {
            if (this._log.shouldLog(40)) {
                this._log.error("Error creating writing the destination to " + keyFile.getAbsolutePath(), ioe);
            }
            this.log("Error writing the keys to " + keyFile.getAbsolutePath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean createAltPrivateKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 40[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTunnelBackground() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.STOPPED && this._state != TunnelState.START_ON_LOAD) {
                return;
            }
        }
        new I2PAppThread(new Runnable(){

            @Override
            public void run() {
                TunnelController.this.startTunnel();
            }
        }, "Tunnel Starter " + this.getName()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTunnel() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.STOPPED && this._state != TunnelState.START_ON_LOAD) {
                if (this._state == TunnelState.RUNNING) {
                    if (this._log.shouldLog(20)) {
                        this._log.info("Already running");
                    }
                    this.log("Tunnel " + this.getName() + " is already running");
                }
                return;
            }
            this.changeState(TunnelState.STARTING);
        }
        try {
            this.doStartTunnel();
        }
        catch (RuntimeException e) {
            this._log.error("Error starting the tunnel " + this.getName(), e);
            this.log("Error starting the tunnel " + this.getName() + ": " + e.getMessage());
            this.acquire();
            this.stopTunnel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStartTunnel() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.STARTING) {
                return;
            }
        }
        String type = this.getType();
        if (type == null || type.length() <= 0) {
            this.changeState(TunnelState.STOPPED);
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start the tunnel - no type specified");
            }
            return;
        }
        if (!this.isClient() || this.getPersistentClientKey()) {
            boolean ok = this.createPrivateKey();
            if (!ok) {
                this.changeState(TunnelState.STOPPED);
                this.log("Failed to start tunnel " + this.getName() + " as the private key file could not be created");
                return;
            }
            if (!this.isClient() && !this.getType().equals(TYPE_STREAMR_SERVER)) {
                this.createAltPrivateKey();
            }
        }
        this.setI2CPOptions();
        this.setSessionOptions();
        if (TYPE_HTTP_CLIENT.equals(type)) {
            this.startHttpClient();
        } else if (TYPE_IRC_CLIENT.equals(type)) {
            this.startIrcClient();
        } else if (TYPE_SOCKS.equals(type)) {
            this.startSocksClient();
        } else if (TYPE_SOCKS_IRC.equals(type)) {
            this.startSocksIRCClient();
        } else if (TYPE_CONNECT.equals(type)) {
            this.startConnectClient();
        } else if (TYPE_STD_CLIENT.equals(type)) {
            this.startClient();
        } else if (TYPE_STREAMR_CLIENT.equals(type)) {
            this.startStreamrClient();
        } else if (TYPE_STD_SERVER.equals(type)) {
            this.startServer();
        } else if (TYPE_HTTP_SERVER.equals(type)) {
            this.startHttpServer();
        } else if (TYPE_HTTP_BIDIR_SERVER.equals(type)) {
            this.startHttpBidirServer();
        } else if (TYPE_IRC_SERVER.equals(type)) {
            this.startIrcServer();
        } else if (TYPE_STREAMR_SERVER.equals(type)) {
            this.startStreamrServer();
        } else {
            this.changeState(TunnelState.STOPPED);
            if (this._log.shouldLog(40)) {
                this._log.error("Cannot start tunnel - unknown type [" + type + "]");
            }
            return;
        }
        this.acquire();
        this.changeState(TunnelState.RUNNING);
    }

    private void startHttpClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runHttpClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startConnectClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String proxyList = this.getProxyList();
        String sharedClient = this.getSharedClient();
        if (proxyList == null) {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient}, this);
        } else {
            this._tunnel.runConnectClient(new String[]{listenPort, sharedClient, proxyList}, this);
        }
    }

    private void startIrcClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runIrcClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startSocksClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runSOCKSTunnel(new String[]{listenPort, "false", privKeyFile}, this);
        } else {
            this._tunnel.runSOCKSTunnel(new String[]{listenPort, sharedClient}, this);
        }
    }

    private void startSocksIRCClient() {
        Properties props;
        this.setListenOn();
        String listenPort = this.getListenPort();
        String sharedClient = this.getSharedClient();
        String proxyList = this.getProxyList();
        if (proxyList != null && !(props = this._tunnel.getClientOptions()).containsKey("i2ptunnel.socks.proxy.default")) {
            props.setProperty("i2ptunnel.socks.proxy.default", proxyList);
        }
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, "false", privKeyFile}, this);
        } else {
            this._tunnel.runSOCKSIRCTunnel(new String[]{listenPort, sharedClient}, this);
        }
    }

    private void startStreamrClient() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getListenPort();
        String dest = this.getTargetDestination();
        this._tunnel.runStreamrClient(new String[]{targetHost, targetPort, dest}, this);
    }

    private void startStreamrServer() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
        String listenPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runStreamrServer(new String[]{listenPort, privKeyFile}, this);
    }

    private void acquire() {
        List<I2PSession> sessions = this._tunnel.getSessions();
        if (!sessions.isEmpty()) {
            for (int i = 0; i < sessions.size(); ++i) {
                TunnelControllerGroup group;
                I2PSession session = sessions.get(i);
                if (this._log.shouldLog(20)) {
                    this._log.info("Acquiring session " + session);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.acquire(this, session);
            }
            this._sessions = sessions;
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to acquire? for " + this.getName());
        }
    }

    private void release(Collection<I2PSession> sessions) {
        if (!sessions.isEmpty()) {
            for (I2PSession s : sessions) {
                TunnelControllerGroup group;
                if (this._log.shouldLog(20)) {
                    this._log.info("Releasing session " + s);
                }
                if ((group = TunnelControllerGroup.getInstance()) == null) continue;
                group.release(this, s);
            }
        } else if (this._log.shouldLog(30)) {
            this._log.warn("No sessions to release? for " + this.getName());
        }
    }

    private Collection<I2PSession> getAllSessions() {
        HashSet<I2PSession> sessions = new HashSet<I2PSession>(this._tunnel.getSessions());
        if (this._sessions != null) {
            sessions.addAll(this._sessions);
        }
        return sessions;
    }

    private void startClient() {
        this.setListenOn();
        String listenPort = this.getListenPort();
        String dest = this.getTargetDestination();
        String sharedClient = this.getSharedClient();
        if (this.getPersistentClientKey()) {
            String privKeyFile = this.getPrivKeyFile();
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient, privKeyFile}, this);
        } else {
            this._tunnel.runClient(new String[]{listenPort, dest, sharedClient}, this);
        }
    }

    private void startServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void startHttpServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpServer(new String[]{targetHost, targetPort, spoofedHost, privKeyFile}, this);
    }

    private void startHttpBidirServer() {
        this.setListenOn();
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String listenPort = this.getListenPort();
        String spoofedHost = this.getSpoofedHost();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runHttpBidirServer(new String[]{targetHost, targetPort, listenPort, spoofedHost, privKeyFile}, this);
    }

    private void startIrcServer() {
        String targetHost = this.getTargetHost();
        String targetPort = this.getTargetPort();
        String privKeyFile = this.getPrivKeyFile();
        this._tunnel.runIrcServer(new String[]{targetHost, targetPort, privKeyFile}, this);
    }

    private void setListenOn() {
        String listenOn = this.getListenOnInterface();
        if (listenOn != null && listenOn.length() > 0) {
            this._tunnel.runListenOn(new String[]{listenOn}, this);
        }
    }

    public Properties getClientOptionProps() {
        Properties opts = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(PFX_OPTION)) continue;
            key = key.substring(PFX_OPTION.length());
            String val = (String)e.getValue();
            opts.setProperty(key, val);
        }
        return opts;
    }

    private void setSessionOptions() {
        String targetport;
        String targethost;
        String spoofhost;
        String proxies;
        Properties opts = this.getClientOptionProps();
        String target = this.getTargetDestination();
        if (target != null) {
            opts.setProperty(PROP_DEST, target);
        }
        if ((proxies = this.getProxyList()) != null) {
            opts.setProperty(PROP_PROXIES, proxies);
        }
        if ((spoofhost = this.getSpoofedHost()) != null) {
            opts.setProperty(PROP_SPOOFED_HOST, spoofhost);
        }
        if ((targethost = this.getTargetHost()) != null) {
            opts.setProperty(PROP_TARGET_HOST, targethost);
        }
        if ((targetport = this.getTargetPort()) != null) {
            opts.setProperty(PROP_TARGET_PORT, targetport);
        }
        this._tunnel.setClientOptions(opts);
    }

    private void setI2CPOptions() {
        String port;
        String host = this.getI2CPHost();
        if (host != null && host.length() > 0) {
            this._tunnel.host = host;
        }
        if ("localhost".equals(this._tunnel.host)) {
            this._tunnel.host = "127.0.0.1";
        }
        if ((port = this.getI2CPPort()) != null && port.length() > 0) {
            try {
                int portNum = Integer.parseInt(port);
                this._tunnel.port = String.valueOf(portNum);
            }
            catch (NumberFormatException nfe) {
                this._tunnel.port = "7654";
            }
        } else {
            this._tunnel.port = "7654";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTunnel() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.STARTING && this._state != TunnelState.RUNNING) {
                return;
            }
            this.changeState(TunnelState.STOPPING);
        }
        Collection<I2PSession> sessions = this.getAllSessions();
        this._tunnel.runClose(new String[]{"forced", "all"}, this);
        this.release(sessions);
        this.changeState(TunnelState.STOPPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyTunnel() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.RUNNING) {
                return;
            }
            this.changeState(TunnelState.DESTROYING);
        }
        Collection<I2PSession> sessions = this.getAllSessions();
        this._tunnel.runClose(new String[]{"destroy", "all"}, this);
        this.release(sessions);
        this.changeState(TunnelState.DESTROYED);
    }

    public void restartTunnel() {
        this.stopTunnel();
        this.startTunnel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(Properties config, String prefix) {
        Collection<I2PSession> sessions;
        Object p1;
        Properties props = new Properties();
        for (Map.Entry<Object, Object> e : config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            String val = (String)e.getValue();
            props.setProperty(key, val);
        }
        Properties oldConfig = this._config;
        this._config = props;
        String type = this.getType();
        if (type != null) {
            if (type.equals(TYPE_HTTP_SERVER) && !this._config.containsKey(OPT_LIMIT_ACTION)) {
                this._config.setProperty(OPT_LIMIT_ACTION, "http");
            }
            if (type.equals(TYPE_HTTP_SERVER) || type.equals(TYPE_STREAMR_SERVER)) {
                if (!this._config.containsKey(OPT_BUNDLE_REPLY)) {
                    this._config.setProperty(OPT_BUNDLE_REPLY, "false");
                }
            } else if (!TunnelController.isClient(type)) {
                this._config.setProperty(OPT_BUNDLE_REPLY, "true");
            }
            if (type.contains("irc") || type.equals(TYPE_STREAMR_CLIENT)) {
                if (!this._config.containsKey(OPT_TAGS_SEND)) {
                    this._config.setProperty(OPT_TAGS_SEND, "20");
                }
                if (!this._config.containsKey(OPT_LOW_TAGS)) {
                    this._config.setProperty(OPT_LOW_TAGS, "14");
                }
            }
            if ((!TunnelController.isClient(type) || type.equals(TYPE_IRC_CLIENT) || type.equals(TYPE_STD_CLIENT) || type.equals(TYPE_SOCKS) || type.equals(TYPE_SOCKS_IRC) || type.equals(TYPE_STREAMR_CLIENT) || type.equals(TYPE_HTTP_CLIENT) && Boolean.valueOf(this.getSharedClient()).booleanValue()) && !this._config.containsKey(OPT_SIG_TYPE)) {
                this._config.setProperty(OPT_SIG_TYPE, PREFERRED_SIGTYPE.name());
            }
            if (!TunnelController.isClient(type)) {
                p1 = this._config.getProperty(OPT_MAX_CONNS_MIN, "0");
                String p2 = this._config.getProperty(OPT_MAX_CONNS_HOUR, "0");
                String p3 = this._config.getProperty(OPT_MAX_CONNS_DAY, "0");
                String p4 = this._config.getProperty(OPT_MAX_TOTAL_CONNS_MIN, "0");
                String p5 = this._config.getProperty(OPT_MAX_TOTAL_CONNS_HOUR, "0");
                String p6 = this._config.getProperty(OPT_MAX_TOTAL_CONNS_DAY, "0");
                String p7 = this._config.getProperty(OPT_MAX_STREAMS, "0");
                String p8 = this._config.getProperty(OPT_LIMITS_SET, "false");
                if (((String)p1).equals("0") && p2.equals("0") && p3.equals("0") && p4.equals("0") && p5.equals("0") && p6.equals("0") && p7.equals("0") && !p8.equals("true")) {
                    this._config.setProperty(OPT_MAX_CONNS_MIN, Integer.toString(10));
                    this._config.setProperty(OPT_MAX_CONNS_HOUR, Integer.toString(40));
                    this._config.setProperty(OPT_MAX_CONNS_DAY, Integer.toString(100));
                    this._config.setProperty(OPT_MAX_TOTAL_CONNS_MIN, Integer.toString(25));
                    this._config.setProperty(OPT_MAX_STREAMS, Integer.toString(20));
                }
                if (type.equals(TYPE_HTTP_SERVER) && !p8.equals("true")) {
                    String p9 = this._config.getProperty(OPT_POST_MAX, "0");
                    String p10 = this._config.getProperty(OPT_POST_TOTAL_MAX, "0");
                    if (p9.equals("0") && p10.equals("0")) {
                        this._config.setProperty(OPT_POST_MAX, Integer.toString(3));
                        this._config.setProperty(OPT_POST_TOTAL_MAX, Integer.toString(10));
                    }
                }
            }
        }
        this.setSessionOptions();
        p1 = this;
        synchronized (p1) {
            if (this._state != TunnelState.RUNNING) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Not running, not updating sessions");
                }
                return;
            }
        }
        if (oldConfig != null && (TunnelController.configChanged(this._config, oldConfig, PROP_FILE) || TunnelController.configChanged(this._config, oldConfig, OPT_ALT_PKF) || TunnelController.configChanged(this._config, oldConfig, OPT_SIG_TYPE))) {
            this.log("Tunnel must be stopped and restarted for private key file changes to take effect");
        }
        if ((sessions = this.getAllSessions()).isEmpty() && this._log.shouldLog(10)) {
            this._log.debug("Running but no sessions to update");
        }
        for (I2PSession s : sessions) {
            if (!s.isClosed()) {
                if (this._log.shouldLog(10)) {
                    this._log.debug("Session is open, updating: " + s);
                }
                s.updateOptions(this._tunnel.getClientOptions());
                continue;
            }
            if (!this._log.shouldLog(10)) continue;
            this._log.debug("Session is closed, not updating: " + s);
        }
    }

    private static boolean configChanged(Properties p1, Properties p2, String p) {
        String s1 = p1.getProperty(p);
        String s2 = p2.getProperty(p);
        return s1 != null && !s1.equals(s2) || s1 == null && s2 != null;
    }

    public Properties getConfig(String prefix) {
        Properties rv = new Properties();
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            rv.setProperty(prefix + key, val);
        }
        return rv;
    }

    public String getType() {
        return this._config.getProperty(PROP_TYPE);
    }

    public String getName() {
        return this._config.getProperty(PROP_NAME);
    }

    public String getDescription() {
        return this._config.getProperty(PROP_DESCR);
    }

    public String getI2CPHost() {
        return this._config.getProperty(PROP_I2CP_HOST);
    }

    public String getI2CPPort() {
        return this._config.getProperty(PROP_I2CP_PORT);
    }

    public boolean isClient() {
        return TunnelController.isClient(this.getType());
    }

    public static boolean isClient(String type) {
        return TYPE_STD_CLIENT.equals(type) || TYPE_HTTP_CLIENT.equals(type) || TYPE_SOCKS.equals(type) || TYPE_SOCKS_IRC.equals(type) || TYPE_CONNECT.equals(type) || TYPE_STREAMR_CLIENT.equals(type) || TYPE_IRC_CLIENT.equals(type);
    }

    @Deprecated
    public String getClientOptions() {
        StringBuilder opts = new StringBuilder(64);
        for (Map.Entry<Object, Object> e : this._config.entrySet()) {
            String key = (String)e.getKey();
            if (!key.startsWith(PFX_OPTION)) continue;
            key = key.substring(PFX_OPTION.length());
            String val = (String)e.getValue();
            if (opts.length() > 0) {
                opts.append(' ');
            }
            opts.append(key).append('=').append(val);
        }
        return opts.toString();
    }

    public String getListenOnInterface() {
        return this._config.getProperty(PROP_INTFC);
    }

    public String getTargetHost() {
        return this._config.getProperty(PROP_TARGET_HOST);
    }

    public String getTargetPort() {
        return this._config.getProperty(PROP_TARGET_PORT);
    }

    public String getSpoofedHost() {
        return this._config.getProperty(PROP_SPOOFED_HOST);
    }

    public String getPrivKeyFile() {
        return this._config.getProperty(PROP_FILE);
    }

    public String getListenPort() {
        return this._config.getProperty(PROP_LISTEN_PORT);
    }

    public String getTargetDestination() {
        return this._config.getProperty(PROP_DEST);
    }

    public String getProxyList() {
        return this._config.getProperty(PROP_PROXIES);
    }

    public String getSharedClient() {
        return this._config.getProperty(PROP_SHARED, "true");
    }

    public boolean getStartOnLoad() {
        return Boolean.parseBoolean(this._config.getProperty(PROP_START, "true"));
    }

    public boolean getPersistentClientKey() {
        return Boolean.parseBoolean(this._config.getProperty(OPT_PERSISTENT));
    }

    public File getPrivateKeyFile() {
        return TunnelController.filenameToFile(this.getPrivKeyFile());
    }

    public File getAlternatePrivateKeyFile() {
        return TunnelController.filenameToFile(this._config.getProperty(OPT_ALT_PKF));
    }

    static File filenameToFile(String f) {
        if (f == null) {
            return null;
        }
        if ((f = f.trim()).length() == 0) {
            return null;
        }
        File rv = new File(f);
        if (!rv.isAbsolute()) {
            rv = new File(I2PAppContext.getGlobalContext().getConfigDir(), f);
        }
        return rv;
    }

    public String getMyDestination() {
        Destination dest = this.getDestination();
        if (dest != null) {
            return dest.toBase64();
        }
        return null;
    }

    public String getMyDestHashBase32() {
        Destination dest = this.getDestination();
        if (dest != null) {
            return dest.toBase32();
        }
        return null;
    }

    public Destination getDestination() {
        if (this._tunnel != null) {
            List<I2PSession> sessions = this._tunnel.getSessions();
            for (int i = 0; i < sessions.size(); ++i) {
                I2PSession session = sessions.get(i);
                Destination dest = session.getMyDestination();
                if (dest == null) continue;
                return dest;
            }
        }
        return null;
    }

    public boolean getIsRunning() {
        return this._state == TunnelState.RUNNING;
    }

    public boolean getIsStarting() {
        return this._state == TunnelState.START_ON_LOAD || this._state == TunnelState.STARTING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsStandby() {
        TunnelController tunnelController = this;
        synchronized (tunnelController) {
            if (this._state != TunnelState.RUNNING) {
                return false;
            }
        }
        for (I2PSession sess : this._tunnel.getSessions()) {
            if (sess.isClosed()) continue;
            return false;
        }
        return true;
    }

    private synchronized void changeState(TunnelState state) {
        this._state = state;
    }

    @Deprecated
    public void getSummary(StringBuilder buf) {
        String type = this.getType();
        buf.append(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String s) {
        List<String> list = this._messages;
        synchronized (list) {
            this._messages.add(s);
            while (this._messages.size() > 10) {
                this._messages.remove(0);
            }
        }
        if (this._log.shouldLog(20)) {
            this._log.info(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> clearMessages() {
        ArrayList<String> rv;
        List<String> list = this._messages;
        synchronized (list) {
            rv = new ArrayList<String>(this._messages);
            this._messages.clear();
        }
        return rv;
    }

    public String toString() {
        return "TC " + this.getType() + ' ' + this.getName() + " for " + this._tunnel + ' ' + (Object)((Object)this._state);
    }

    private static enum TunnelState {
        START_ON_LOAD,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED,
        DESTROYING,
        DESTROYED;

    }
}

