/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PException;
import net.i2p.app.Outproxy;
import net.i2p.client.streaming.I2PSocket;
import net.i2p.client.streaming.I2PSocketManager;
import net.i2p.client.streaming.I2PSocketOptions;
import net.i2p.crypto.SHA256Generator;
import net.i2p.data.Base32;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.i2ptunnel.I2PTunnel;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientBase;
import net.i2p.i2ptunnel.I2PTunnelHTTPClientRunner;
import net.i2p.i2ptunnel.I2PTunnelOutproxyRunner;
import net.i2p.i2ptunnel.I2PTunnelRunner;
import net.i2p.i2ptunnel.InternalSocketRunner;
import net.i2p.i2ptunnel.Logging;
import net.i2p.i2ptunnel.localServer.LocalHTTPServer;
import net.i2p.util.ConvertToHash;
import net.i2p.util.EventDispatcher;

public class I2PTunnelHTTPClient
extends I2PTunnelHTTPClientBase
implements Runnable {
    private final ConcurrentHashMap<String, String> addressHelpers = new ConcurrentHashMap(8);
    private final String _proxyNonce = Long.toString(this._context.random().nextLong());
    public static final String AUTH_REALM = "I2P HTTP Proxy";
    private static final String ERR_REQUEST_DENIED = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>";
    private static final String ERR_NO_OUTPROXY = "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel";
    private static final String ERR_AHELPER_CONFLICT = "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another website, or people have given two websites identical names.<p>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<p>";
    private static final String ERR_AHELPER_NOTFOUND = "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.";
    private static final String ERR_AHELPER_NEW = "HTTP/1.1 409 New Address\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>New Host Name with Address Helper</H1>The address helper link you followed is for a new host name that is not in your address book. You may either save the destination for this host name to your address book, or remember it only until your router restarts. If you save it to your address book, you will not see this message again. If you do not wish to visit this host, click the \"back\" button on your browser.";
    private static final String ERR_BAD_PROTOCOL = "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports HTTP and HTTPS requests only. Other protocols such as FTP are not allowed.<BR>";
    private static final String ERR_BAD_URI = "HTTP/1.1 403 Bad URI\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: INVALID REQUEST URI</H1>The request URI is invalid, and probably contains illegal characters. If you clicked e.g. a forum link, check the end of the URI for any characters the browser has mistakenly added on.<BR>";
    private static final String ERR_LOCALHOST = "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>";
    private static final String ERR_INTERNAL_SSL = "HTTP/1.1 403 SSL Rejected\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: SSL to I2P address rejected</H1>SSL to .i2p addresses denied by configuration.You may change the configuration in I2PTunnel";
    private InternalSocketRunner isr;
    private static final String HELPER_PARAM = "i2paddresshelper";
    public static final String LOCAL_SERVER = "proxy.i2p";
    private static final boolean DEFAULT_GZIP = true;
    public static final String PROP_REFERER = "i2ptunnel.httpclient.sendReferer";
    public static final String PROP_USER_AGENT = "i2ptunnel.httpclient.sendUserAgent";
    public static final String PROP_VIA = "i2ptunnel.httpclient.sendVia";
    public static final String PROP_JUMP_SERVERS = "i2ptunnel.httpclient.jumpServers";
    public static final String PROP_DISABLE_HELPER = "i2ptunnel.httpclient.disableAddressHelper";
    public static final String PROP_SSL_OUTPROXIES = "i2ptunnel.httpclient.SSLOutproxies";
    public static final String PROP_ACCEPT = "i2ptunnel.httpclient.sendAccept";
    public static final String PROP_INTERNAL_SSL = "i2ptunnel.httpclient.allowInternalSSL";
    public static final String DEFAULT_JUMP_SERVERS = "http://stats.i2p/cgi-bin/jump.cgi?a=,http://no.i2p/jump/,http://i2pjump.i2p/jump/";
    private static final String ERR_HELPER_DISABLED = "HTTP/1.1 403 Disabled\r\nContent-Type: text/plain\r\nConnection: close\r\nProxy-Connection: close\r\n\r\nAddress helpers disabled";

    public I2PTunnelHTTPClient(int localPort, Logging l, I2PSocketManager sockMgr, I2PTunnel tunnel, EventDispatcher notifyThis, long clientId) {
        super(localPort, l, sockMgr, tunnel, notifyThis, clientId);
        if (tunnel.getClientOptions().getProperty("i2p.streaming.connectDelay") == null) {
            tunnel.getClientOptions().setProperty("i2p.streaming.connectDelay", "1000");
        }
        this.setName("HTTP Proxy on " + this.getTunnel().listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    public I2PTunnelHTTPClient(int localPort, Logging l, boolean ownDest, String wwwProxy, EventDispatcher notifyThis, I2PTunnel tunnel) throws IllegalArgumentException {
        super(localPort, ownDest, l, notifyThis, "HTTP Proxy on " + tunnel.listenHost + ':' + localPort, tunnel);
        if (wwwProxy != null) {
            StringTokenizer tok = new StringTokenizer(wwwProxy, ", ");
            while (tok.hasMoreTokens()) {
                this._proxyList.add(tok.nextToken().trim());
            }
        }
        if (tunnel.getClientOptions().getProperty("i2p.streaming.connectDelay") == null) {
            tunnel.getClientOptions().setProperty("i2p.streaming.connectDelay", "1000");
        }
        this.setName("HTTP Proxy on " + tunnel.listenHost + ':' + localPort);
        this.notifyEvent("openHTTPClientResult", "ok");
    }

    @Override
    protected I2PSocketOptions getDefaultOptions() {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    protected I2PSocketOptions getDefaultOptions(Properties overrides) {
        Properties defaultOpts = this.getTunnel().getClientOptions();
        defaultOpts.putAll((Map<?, ?>)overrides);
        if (!defaultOpts.contains("i2p.streaming.readTimeout")) {
            defaultOpts.setProperty("i2p.streaming.readTimeout", "300000");
        }
        if (!defaultOpts.contains("i2p.streaming.inactivityTimeout")) {
            defaultOpts.setProperty("i2p.streaming.inactivityTimeout", "300000");
        }
        this.verifySocketManager();
        I2PSocketOptions opts = this.sockMgr.buildOptions(defaultOpts);
        if (!defaultOpts.containsKey("i2p.streaming.connectTimeout")) {
            opts.setConnectTimeout(60000L);
        }
        return opts;
    }

    @Override
    public void startRunning() {
        super.startRunning();
        if (this.open) {
            this.isr = new InternalSocketRunner(this);
            this.isr.start();
            int port = this.getLocalPort();
            this._context.portMapper().register("HTTP", this.getTunnel().listenHost, port);
            this._context.portMapper().register("HTTPS", this.getTunnel().listenHost, port);
        }
    }

    @Override
    public boolean close(boolean forced) {
        int port = this.getLocalPort();
        int reg = this._context.portMapper().getPort("HTTP");
        if (reg == port) {
            this._context.portMapper().unregister("HTTP");
        }
        if ((reg = this._context.portMapper().getPort("HTTPS")) == port) {
            this._context.portMapper().unregister("HTTPS");
        }
        boolean rv = super.close(forced);
        if (this.isr != null) {
            this.isr.stopRunning();
        }
        return rv;
    }

    @Override
    protected String getRealm() {
        return AUTH_REALM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected void clientConnectionRun(Socket s) {
        out = null;
        targetRequest = null;
        usingWWWProxy = false;
        usingInternalOutproxy = false;
        outproxy = null;
        usingInternalServer = false;
        internalPath = null;
        internalRawQuery = null;
        currentProxy = null;
        requestId = I2PTunnelHTTPClient.__requestId.incrementAndGet();
        shout = false;
        try {
            s.setSoTimeout(15000);
            out = s.getOutputStream();
            reader = new InputReader(s.getInputStream());
            method = null;
            protocol = null;
            host = null;
            destination = null;
            newRequest = new StringBuilder();
            ahelperPresent = false;
            ahelperNew = false;
            ahelperKey = null;
            userAgent = null;
            authorization = null;
            remotePort = 0;
            referer = null;
            origRequestURI = null;
            while ((line = reader.readLine(method)) != null) {
                block232: {
                    block241: {
                        block226: {
                            block243: {
                                block244: {
                                    block228: {
                                        block245: {
                                            block242: {
                                                line = line.trim();
                                                if (this._log.shouldLog(10)) {
                                                    this._log.debug(this.getPrefix(requestId) + "Line=[" + line + "]");
                                                }
                                                if ((lowercaseLine = line.toLowerCase(Locale.US)).startsWith("connection: ") || lowercaseLine.startsWith("keep-alive: ") || lowercaseLine.startsWith("proxy-connection: ")) continue;
                                                if (method != null) break block241;
                                                if (this._log.shouldLog(10)) {
                                                    this._log.debug(this.getPrefix(requestId) + "First line [" + line + "]");
                                                }
                                                if ((params = DataHelper.split(line, " ", 3)).length != 3) break;
                                                request = params[1];
                                                if (request.startsWith("/") && this.getTunnel().getClientOptions().getProperty("i2ptunnel.noproxy") != null) {
                                                    request = "http://i2p" + request;
                                                } else if (request.startsWith("/eepproxy/")) {
                                                    subRequest = request.substring("/eepproxy/".length());
                                                    if (subRequest.indexOf(47) == -1) {
                                                        subRequest = subRequest + '/';
                                                    }
                                                    request = "http://" + subRequest;
                                                }
                                                method = params[0];
                                                if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                                                    request = "https://" + request + '/';
                                                }
                                                requestURI = null;
                                                try {
                                                    block224: {
                                                        try {
                                                            requestURI = new URI(request);
                                                        }
                                                        catch (URISyntaxException use) {
                                                            error = true;
                                                            idx = 0;
                                                            for (i = 0; i < 2 && (idx = request.indexOf(47, idx)) >= 0; ++i) {
                                                                ++idx;
                                                            }
                                                            if (idx > 0) {
                                                                schemeHostPort = request.substring(0, idx);
                                                                rest = request.substring(idx);
                                                                rest = rest.replace("[", "%5B");
                                                                rest = rest.replace("]", "%5D");
                                                                rest = rest.replace("|", "%7C");
                                                                testRequest = schemeHostPort + rest;
                                                                if (!testRequest.equals(request)) {
                                                                    try {
                                                                        requestURI = new URI(testRequest);
                                                                        request = testRequest;
                                                                        error = false;
                                                                    }
                                                                    catch (URISyntaxException var39_81) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            if (!error) break block224;
                                                            throw use;
                                                        }
                                                    }
                                                    origRequestURI = requestURI;
                                                    if (requestURI.getRawUserInfo() != null || requestURI.getRawFragment() != null) {
                                                        if (this._log.shouldLog(30)) {
                                                            this._log.warn(this.getPrefix(requestId) + "Removing userinfo or fragment [" + request + "]");
                                                        }
                                                        requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, null);
                                                    }
                                                    if (requestURI.getPath() == null || requestURI.getPath().length() <= 0) {
                                                        if (this._log.shouldLog(30)) {
                                                            this._log.warn(this.getPrefix(requestId) + "Adding / path to [" + request + "]");
                                                        }
                                                        requestURI = I2PTunnelHTTPClient.changeURI(requestURI, null, 0, "/");
                                                    }
                                                }
                                                catch (URISyntaxException use) {
                                                    if (this._log.shouldLog(30)) {
                                                        this._log.warn(this.getPrefix(requestId) + "Bad request [" + request + "]", use);
                                                    }
                                                    try {
                                                        out.write(this.getErrorPage("baduri", "HTTP/1.1 403 Bad URI\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: INVALID REQUEST URI</H1>The request URI is invalid, and probably contains illegal characters. If you clicked e.g. a forum link, check the end of the URI for any characters the browser has mistakenly added on.<BR>").getBytes("UTF-8"));
                                                        msg = use.getLocalizedMessage();
                                                        if (msg != null) {
                                                            out.write(DataHelper.getASCII("<p>\n"));
                                                            out.write(DataHelper.getUTF8(DataHelper.escapeHTML(msg)));
                                                            out.write(DataHelper.getASCII("</p>\n"));
                                                        }
                                                        out.write(DataHelper.getASCII("</div>\n"));
                                                        I2PTunnelHTTPClient.writeFooter(out);
                                                        reader.drain();
                                                    }
                                                    catch (IOException msg) {
                                                    }
                                                    finally {
                                                        I2PTunnelHTTPClient.closeSocket(s);
                                                    }
                                                    return;
                                                }
                                                protocolVersion = params[2];
                                                protocol = requestURI.getScheme();
                                                host = requestURI.getHost();
                                                if (protocol == null || host == null) {
                                                    this._log.warn("Null protocol or host: " + request + ' ' + protocol + ' ' + host);
                                                    method = null;
                                                    break;
                                                }
                                                port = requestURI.getPort();
                                                hostLowerCase = host.toLowerCase(Locale.US);
                                                if (!hostLowerCase.equals("proxy.i2p")) break block242;
                                                destination = host;
                                                usingInternalServer = true;
                                                internalPath = requestURI.getPath();
                                                internalRawQuery = requestURI.getRawQuery();
                                                break block226;
                                            }
                                            if (hostLowerCase.equals("i2p")) {
                                                oldPath = requestURI.getPath().substring(1);
                                                slash = oldPath.indexOf(47);
                                                if (slash < 0) {
                                                    slash = oldPath.length();
                                                    oldPath = oldPath + '/';
                                                }
                                                _dest = oldPath.substring(0, slash);
                                                if (slash >= 516 && !_dest.contains(".")) {
                                                    destination = _dest;
                                                    host = this.getHostName(destination);
                                                    targetRequest = requestURI.toASCIIString();
                                                    newURI = oldPath.substring(slash);
                                                    query = requestURI.getRawQuery();
                                                    if (query != null) {
                                                        newURI = newURI + '?' + query;
                                                    }
                                                    try {
                                                        requestURI = new URI(newURI);
                                                        break block226;
                                                    }
                                                    catch (URISyntaxException use) {
                                                        this._log.warn(request, use);
                                                        method = null;
                                                        break;
                                                    }
                                                }
                                                this._log.warn("Bad http://i2p/b64dest " + request);
                                                host = null;
                                                break;
                                            }
                                            if (!hostLowerCase.endsWith(".i2p")) break block243;
                                            destination = host;
                                            host = this.getHostName(destination);
                                            rPort = requestURI.getPort();
                                            remotePort = rPort > 0 ? rPort : ("https".equals(protocol) != false || method.toUpperCase(Locale.US).equals("CONNECT") != false ? 443 : 80);
                                            query = requestURI.getRawQuery();
                                            if (query == null) break block244;
                                            ahelperConflict = false;
                                            helperStrings = I2PTunnelHTTPClient.removeHelper(query);
                                            if (helperStrings != null && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.disableAddressHelper"))) {
                                                query = helperStrings[0];
                                                if (query.equals("")) {
                                                    query = null;
                                                }
                                                try {
                                                    requestURI = I2PTunnelHTTPClient.replaceQuery(requestURI, query);
                                                }
                                                catch (URISyntaxException use) {
                                                    this._log.warn(request, use);
                                                    method = null;
                                                    break;
                                                }
                                                ahelperKey = helperStrings[1];
                                                if (ahelperKey.length() > 0) {
                                                    if (ahelperKey.endsWith(".i2p")) {
                                                        _dest = this._context.namingService().lookup(ahelperKey);
                                                        if (_dest == null) {
                                                            if (this._log.shouldLog(30)) {
                                                                this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + ahelperKey);
                                                            }
                                                            header = this.getErrorPage("ahelper-notfound", "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.");
                                                            try {
                                                                out.write(header.getBytes("UTF-8"));
                                                                out.write(("<p>" + this._t("This seems to be a bad destination:") + " " + ahelperKey + " " + this._t("i2paddresshelper cannot help you with a destination like that!") + "</p>").getBytes("UTF-8"));
                                                                I2PTunnelHTTPClient.writeFooter(out);
                                                                reader.drain();
                                                            }
                                                            catch (IOException var42_89) {
                                                            }
                                                            finally {
                                                                I2PTunnelHTTPClient.closeSocket(s);
                                                            }
                                                            return;
                                                        }
                                                        ahelperKey = _dest.toBase64();
                                                    }
                                                    ahelperPresent = true;
                                                    if (host == null || "i2p".equals(host)) {
                                                        old = this.addressHelpers.putIfAbsent(destination.toLowerCase(Locale.US), ahelperKey);
                                                        v0 = ahelperNew = old == null;
                                                        if (!ahelperNew && !old.replace("=", "").equals(ahelperKey.replace("=", ""))) {
                                                            ahelperConflict = true;
                                                            if (this._log.shouldLog(30)) {
                                                                this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + old + "], specified key [" + ahelperKey + "].");
                                                            }
                                                        }
                                                    } else {
                                                        hostDest = this._context.namingService().lookup(destination);
                                                        if (hostDest != null && (destB64 = hostDest.toBase64()) != null && !destB64.equals(ahelperKey)) {
                                                            ahelperConflict = true;
                                                            if (this._log.shouldLog(30)) {
                                                                this._log.warn(this.getPrefix(requestId) + "Addresshelper key conflict for site [" + destination + "], trusted key [" + destB64 + "], specified key [" + ahelperKey + "].");
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            if (!ahelperConflict) break block244;
                                            alias = this.getHostName(ahelperKey);
                                            if (!alias.equals("i2p")) break block245;
                                            header = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                                            this.writeErrorMessage(header, out, targetRequest, false, destination);
                                            ** GOTO lbl254
                                        }
                                        trustedURL = requestURI.toASCIIString();
                                        try {
                                            conflictURI = I2PTunnelHTTPClient.changeURI(requestURI, alias, 0, null);
                                        }
                                        catch (URISyntaxException use) {
                                            this._log.warn(request, use);
                                            method = null;
                                            I2PTunnelHTTPClient.closeSocket(s);
                                            break;
                                        }
                                        try {
                                            conflictURL = conflictURI.toASCIIString();
                                            header = this.getErrorPage("ahelper-conflict", "HTTP/1.1 409 Conflict\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Destination key conflict</H1>The addresshelper link you followed specifies a different destination key than a host entry in your host database. Someone could be trying to impersonate another website, or people have given two websites identical names.<p>You can resolve the conflict by considering which key you trust, and either discarding the addresshelper link, discarding the host entry from your host database, or naming one of them differently.<p>");
                                            out.write(header.getBytes("UTF-8"));
                                            out.write("<p>".getBytes("UTF-8"));
                                            out.write(this._t("To visit the destination in your address book, click <a href=\"{0}\">here</a>. To visit the conflicting addresshelper destination, click <a href=\"{1}\">here</a>.", trustedURL, conflictURL).getBytes("UTF-8"));
                                            out.write("</p>".getBytes("UTF-8"));
                                            h1 = ConvertToHash.getHash(requestURI.getHost());
                                            h2 = ConvertToHash.getHash(ahelperKey);
                                            if (h1 != null && h2 != null) {
                                                unset = "*unset*";
                                                httpHost = this._context.portMapper().getActualHost("console", "*unset*");
                                                httpsHost = this._context.portMapper().getActualHost("https_console", "*unset*");
                                                httpPort = this._context.portMapper().getPort("console", 7657);
                                                httpsPort = this._context.portMapper().getPort("https_console", -1);
                                                httpsOnly = httpsPort > 0 && httpHost.equals("*unset*") != false && httpsHost.equals("*unset*") == false;
                                                cport = httpsOnly != false ? httpsPort : httpPort;
                                                v1 = chost = httpsOnly != false ? httpsHost : httpHost;
                                                if (chost.equals("*unset*")) {
                                                    chost = "127.0.0.1";
                                                }
                                                chostport = httpsOnly != false || cport != 7657 || chost.equals("127.0.0.1") == false ? (httpsOnly != false ? "https://" : "http://") + chost + ':' + cport : "http://127.0.0.1:7657";
                                                out.write(("\n<table class=\"conflict\"><tr><th align=\"center\"><a href=\"" + trustedURL + "\">").getBytes("UTF-8"));
                                                out.write(this._t("Destination for {0} in address book", requestURI.getHost()).getBytes("UTF-8"));
                                                out.write(("</a></th>\n<th align=\"center\"><a href=\"" + conflictURL + "\">").getBytes("UTF-8"));
                                                out.write(this._t("Conflicting address helper destination").getBytes("UTF-8"));
                                                out.write(("</a></th></tr>\n<tr><td align=\"center\"><a href=\"" + trustedURL + "\"><img src=\"" + chostport + "/imagegen/id?s=160&amp;c=" + h1.toBase64().replace("=", "%3d") + "\" width=\"160\" height=\"160\"></a>\n").getBytes("UTF-8"));
                                                out.write(("</td>\n<td align=\"center\"><a href=\"" + conflictURL + "\"><img src=\"" + chostport + "/imagegen/id?s=160&amp;c=" + h2.toBase64().replace("=", "%3d") + "\" width=\"160\" height=\"160\"></a>\n").getBytes("UTF-8"));
                                                out.write("</td></tr></table>".getBytes("UTF-8"));
                                            }
                                            out.write("</div>".getBytes("UTF-8"));
                                            I2PTunnelHTTPClient.writeFooter(out);
lbl254:
                                            // 2 sources

                                            reader.drain();
                                        }
                                        catch (IOException alias) {
                                            break block228;
                                            catch (Throwable var56_106) {
                                                throw var56_106;
                                            }
                                        }
                                        finally {
                                            I2PTunnelHTTPClient.closeSocket(s);
                                        }
                                    }
                                    return;
                                }
                                if ((addressHelper = this.addressHelpers.get(destination)) != null) {
                                    host = this.getHostName(addressHelper);
                                }
                                targetRequest = requestURI.toASCIIString();
                                newURI = requestURI.getRawPath();
                                if (query != null) {
                                    newURI = newURI + '?' + query;
                                }
                                try {
                                    requestURI = new URI(newURI);
                                    break block226;
                                }
                                catch (URISyntaxException use) {
                                    this._log.warn(request, use);
                                    method = null;
                                    break;
                                }
                            }
                            if (hostLowerCase.equals("localhost") || host.equals("127.0.0.1") || host.startsWith("192.168.") || host.equals("[::1]")) {
                                try {
                                    out.write(this.getErrorPage("localhost", "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>Your browser is misconfigured. Do not use the proxy to access the router console or other localhost destinations.<BR>").getBytes("UTF-8"));
                                    I2PTunnelHTTPClient.writeFooter(out);
                                    reader.drain();
                                }
                                catch (IOException rPort) {
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                                return;
                            }
                            if (host.contains(".") || host.startsWith("[")) {
                                if (Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.useLocalOutproxy", "true")) && (mgr = this._context.clientAppManager()) != null && (op = mgr.getRegisteredApp("outproxy")) != null) {
                                    outproxy = (Outproxy)op;
                                    rPort = requestURI.getPort();
                                    remotePort = rPort > 0 ? rPort : ("https".equals(protocol) != false || method.toUpperCase(Locale.US).equals("CONNECT") != false ? 443 : 80);
                                    usingInternalOutproxy = true;
                                    targetRequest = requestURI.toASCIIString();
                                    if (this._log.shouldLog(10)) {
                                        this._log.debug(this.getPrefix(requestId) + " [" + host + "]: outproxy!");
                                    }
                                }
                                if (!usingInternalOutproxy) {
                                    if (port >= 0) {
                                        host = host + ':' + port;
                                    }
                                    if (this._log.shouldLog(10)) {
                                        this._log.debug("Before selecting outproxy for " + host);
                                    }
                                    currentProxy = "https".equals(protocol) != false || method.toUpperCase(Locale.US).equals("CONNECT") != false ? this.selectSSLProxy() : this.selectProxy();
                                    if (this._log.shouldLog(10)) {
                                        this._log.debug("After selecting outproxy for " + host + ": " + currentProxy);
                                    }
                                    if (currentProxy == null) {
                                        if (this._log.shouldLog(30)) {
                                            this._log.warn(this.getPrefix(requestId) + "Host wants to be outproxied, but we dont have any!");
                                        }
                                        this.l.log("No outproxy found for the request.");
                                        try {
                                            out.write(this.getErrorPage("noproxy", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: No outproxy found</H1>Your request was for a site outside of I2P, but you have no HTTP outproxy configured.  Please configure an outproxy in I2PTunnel").getBytes("UTF-8"));
                                            I2PTunnelHTTPClient.writeFooter(out);
                                            reader.drain();
                                        }
                                        catch (IOException mgr) {
                                        }
                                        finally {
                                            I2PTunnelHTTPClient.closeSocket(s);
                                        }
                                        return;
                                    }
                                    destination = currentProxy;
                                    usingWWWProxy = true;
                                    targetRequest = requestURI.toASCIIString();
                                    if (this._log.shouldLog(10)) {
                                        this._log.debug(this.getPrefix(requestId) + " [" + host + "]: wwwProxy!");
                                    }
                                }
                            } else {
                                if (this._log.shouldLog(30)) {
                                    this._log.warn("NODOTS, NOI2P: " + request);
                                }
                                try {
                                    out.write(this.getErrorPage("denied", "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>").getBytes("UTF-8"));
                                    I2PTunnelHTTPClient.writeFooter(out);
                                    reader.drain();
                                }
                                catch (IOException mgr) {
                                }
                                finally {
                                    I2PTunnelHTTPClient.closeSocket(s);
                                }
                                return;
                            }
                        }
                        v2 = isValid = usingInternalOutproxy != false || usingWWWProxy != false || usingInternalServer != false || I2PTunnelHTTPClient.isSupportedAddress(host, protocol) != false;
                        if (!isValid) {
                            if (this._log.shouldLog(20)) {
                                this._log.info(this.getPrefix(requestId) + "notValid(" + host + ")");
                            }
                            method = null;
                            destination = null;
                            break;
                        }
                        line = method.toUpperCase(Locale.US).equals("CONNECT") != false ? method + ' ' + requestURI.getHost() + ':' + requestURI.getPort() + ' ' + protocolVersion : method + ' ' + requestURI.toASCIIString() + ' ' + protocolVersion;
                        if (this._log.shouldLog(10)) {
                            this._log.debug(this.getPrefix(requestId) + "NEWREQ: \"" + line + "\"");
                            this._log.debug(this.getPrefix(requestId) + "HOST  : \"" + host + "\"");
                            this._log.debug(this.getPrefix(requestId) + "DEST  : \"" + destination + "\"");
                        }
                        break block232;
                    }
                    if (lowercaseLine.startsWith("host: ") && !usingWWWProxy && !usingInternalOutproxy) {
                        line = "Host: " + host;
                        if (this._log.shouldLog(20)) {
                            this._log.info(this.getPrefix(requestId) + "Setting host = " + host);
                        }
                    } else if (lowercaseLine.startsWith("user-agent: ")) {
                        userAgent = lowercaseLine.substring(12);
                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.sendUserAgent"))) {
                            line = null;
                            continue;
                        }
                    } else if (lowercaseLine.startsWith("accept")) {
                        if (!lowercaseLine.startsWith("accept-encoding: ") && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.sendAccept"))) {
                            line = null;
                            continue;
                        }
                    } else if (lowercaseLine.startsWith("referer: ")) {
                        referer = line.substring(9);
                        if (!Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.sendReferer"))) {
                            try {
                                refererURI = new URI(referer);
                                refererHost = refererURI.getHost();
                                if (refererHost != null) {
                                    origHost = origRequestURI.getHost();
                                    if (!refererHost.equals(origHost) || refererURI.getPort() != origRequestURI.getPort() || !DataHelper.eq(refererURI.getScheme(), origRequestURI.getScheme())) {
                                        line = null;
                                        continue;
                                    }
                                    buf = new StringBuilder();
                                    buf.append("Referer: ");
                                    refererPath = refererURI.getRawPath();
                                    buf.append(refererPath != null ? refererPath : "/");
                                    refererQuery = refererURI.getRawQuery();
                                    if (refererQuery != null) {
                                        buf.append('?').append(refererQuery);
                                    }
                                    line = buf.toString();
                                }
                            }
                            catch (URISyntaxException use) {
                                line = null;
                                continue;
                            }
                        }
                    } else {
                        if (lowercaseLine.startsWith("via: ") && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.sendVia"))) {
                            line = null;
                            continue;
                        }
                        if (lowercaseLine.startsWith("from: ")) {
                            line = null;
                            continue;
                        }
                        if (lowercaseLine.startsWith("authorization: ntlm ")) {
                            line = null;
                            continue;
                        }
                        if (lowercaseLine.startsWith("proxy-authorization: ")) {
                            authorization = line.substring(21);
                            line = null;
                            continue;
                        }
                        if (lowercaseLine.startsWith("icy")) {
                            shout = true;
                        }
                    }
                }
                if (line.length() == 0) {
                    ok = this.getTunnel().getClientOptions().getProperty("i2ptunnel.gzip");
                    gzip = true;
                    if (ok != null) {
                        gzip = Boolean.parseBoolean(ok);
                    }
                    if (gzip && !usingInternalServer && !method.toUpperCase(Locale.US).equals("CONNECT") && !usingInternalOutproxy) {
                        newRequest.append("X-Accept-Encoding: x-i2p-gzip;q=1.0, identity;q=0.5, deflate;q=0, gzip;q=0, *;q=0\r\n");
                    }
                    if (!(shout || method.toUpperCase(Locale.US).equals("CONNECT") || Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.sendUserAgent")))) {
                        if (usingWWWProxy || usingInternalOutproxy) {
                            newRequest.append("User-Agent: Mozilla/5.0 (Windows NT 6.1; rv:24.0) Gecko/20100101 Firefox/24.0\r\n");
                        } else {
                            newRequest.append("User-Agent: MYOB/6.66 (AN/ON)\r\n");
                        }
                    }
                    if (usingWWWProxy && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("outproxyAuth"))) {
                        user = this.getTunnel().getClientOptions().getProperty("outproxyUsername." + currentProxy);
                        pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword." + currentProxy);
                        if (user == null || pw == null) {
                            user = this.getTunnel().getClientOptions().getProperty("outproxyUsername");
                            pw = this.getTunnel().getClientOptions().getProperty("outproxyPassword");
                        }
                        if (user != null && pw != null) {
                            newRequest.append("Proxy-Authorization: Basic ").append(Base64.encode((user + ':' + pw).getBytes("UTF-8"), true)).append("\r\n");
                        }
                    }
                    newRequest.append("Connection: close\r\n\r\n");
                    s.setSoTimeout(0);
                    break;
                }
                newRequest.append(line).append("\r\n");
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix(requestId) + "NewRequest header: [" + newRequest.toString() + "]");
            }
            if (method == null || destination == null && !usingInternalOutproxy) {
                try {
                    if (protocol != null && "http".equals(protocol.toLowerCase(Locale.US))) {
                        out.write(this.getErrorPage("denied", "HTTP/1.1 403 Access Denied\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: REQUEST DENIED</H1>You attempted to connect to a non-I2P website or location.<BR>").getBytes("UTF-8"));
                    } else {
                        out.write(this.getErrorPage("protocol", "HTTP/1.1 403 Bad Protocol\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: NON-HTTP PROTOCOL</H1>The request uses a bad protocol. The I2P HTTP Proxy supports HTTP and HTTPS requests only. Other protocols such as FTP are not allowed.<BR>").getBytes("UTF-8"));
                    }
                    I2PTunnelHTTPClient.writeFooter(out);
                }
                catch (IOException lowercaseLine) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            if (this._log.shouldLog(10)) {
                this._log.debug(this.getPrefix(requestId) + "Destination: " + destination);
            }
            if ((result = this.authorize(s, requestId, method, authorization)) != I2PTunnelHTTPClientBase.AuthResult.AUTH_GOOD) {
                if (this._log.shouldLog(30)) {
                    if (authorization != null) {
                        this._log.warn(this.getPrefix(requestId) + "Auth failed, sending 407 again");
                    } else {
                        this._log.warn(this.getPrefix(requestId) + "Auth required, sending 407");
                    }
                }
                try {
                    out.write(this.getAuthError(result == I2PTunnelHTTPClientBase.AuthResult.AUTH_STALE).getBytes("UTF-8"));
                    I2PTunnelHTTPClient.writeFooter(out);
                }
                catch (IOException ok) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            if (usingInternalServer) {
                try {
                    if (internalPath.equals("/add") && Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.disableAddressHelper"))) {
                        out.write("HTTP/1.1 403 Disabled\r\nContent-Type: text/plain\r\nConnection: close\r\nProxy-Connection: close\r\n\r\nAddress helpers disabled".getBytes("UTF-8"));
                    } else {
                        LocalHTTPServer.serveLocalFile(out, method, internalPath, internalRawQuery, this._proxyNonce);
                    }
                }
                catch (IOException ok) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            if (usingInternalOutproxy) {
                outSocket = outproxy.connect(host, remotePort);
                onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
                if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                    data = null;
                    response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                } else {
                    data = newRequest.toString().getBytes("ISO-8859-1");
                    response = null;
                }
                t = new I2PTunnelOutproxyRunner(s, outSocket, this.sockLock, data, response, onTimeout);
                t.run();
                return;
            }
            clientDest = null;
            addressHelper = this.addressHelpers.get(destination.toLowerCase(Locale.US));
            if (addressHelper != null) {
                clientDest = this._context.namingService().lookup(addressHelper);
                if (clientDest == null) {
                    this.addressHelpers.remove(destination.toLowerCase(Locale.US));
                    if (this._log.shouldLog(30)) {
                        this._log.warn(this.getPrefix(requestId) + "Could not find destination for " + addressHelper);
                    }
                    header = this.getErrorPage("ahelper-notfound", "HTTP/1.1 404 Not Found\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: Helper key not resolvable.</H1>The helper key you put for i2paddresshelper= is not resolvable. It seems to be garbage data, or a mistyped b32. Check your URL to try and fix the helper key to be either a b32 or a base64.");
                    try {
                        this.writeErrorMessage(header, out, targetRequest, false, destination);
                    }
                    catch (IOException response) {
                    }
                    finally {
                        I2PTunnelHTTPClient.closeSocket(s);
                    }
                    return;
                }
            } else if ("i2p".equals(host)) {
                clientDest = null;
            } else if (destination.length() == 60 && destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                this.verifySocketManager();
                sess = this.sockMgr.getSession();
                if (!sess.isClosed()) {
                    hData = Base32.decode(destination.substring(0, 52));
                    if (hData != null) {
                        if (this._log.shouldLog(20)) {
                            this._log.info("lookup in-session " + destination);
                        }
                        hash = Hash.create(hData);
                        clientDest = sess.lookupDest(hash, 20000L);
                    }
                } else {
                    clientDest = this._context.namingService().lookup(destination);
                }
            } else {
                clientDest = this._context.namingService().lookup(destination);
            }
            if (clientDest == null) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to resolve " + destination + " (proxy? " + usingWWWProxy + ", request: " + targetRequest);
                }
                jumpServers = null;
                extraMessage = null;
                if (usingWWWProxy) {
                    header = this.getErrorPage("dnfp", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                } else if (ahelperPresent) {
                    header = this.getErrorPage("dnfb", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                } else if (destination.length() == 60 && destination.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
                    header = this.getErrorPage("nols", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    extraMessage = this._t("Destination lease set not found");
                } else {
                    header = this.getErrorPage("dnfh", "HTTP/1.1 503 Service Unavailable\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: DESTINATION NOT FOUND</H1>That I2P Destination was not found. Perhaps you pasted in the wrong BASE64 I2P Destination or the link you are following is bad. The host (or the WWW proxy, if you're using one) could also be temporarily offline.  You may want to <b>retry</b>.  Could not find the following Destination:<BR><BR><div>");
                    jumpServers = this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.jumpServers");
                    if (jumpServers == null) {
                        jumpServers = "http://stats.i2p/cgi-bin/jump.cgi?a=,http://no.i2p/jump/,http://i2pjump.i2p/jump/";
                    }
                    jumpDelay = 400 + this._context.random().nextInt(256);
                    try {
                        Thread.sleep(jumpDelay);
                    }
                    catch (InterruptedException isValid) {
                        // empty catch block
                    }
                }
                try {
                    this.writeErrorMessage(header, extraMessage, out, targetRequest, usingWWWProxy, destination, jumpServers);
                }
                catch (IOException jumpDelay) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            if (method.toUpperCase(Locale.US).equals("CONNECT") && !usingWWWProxy && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.allowInternalSSL"))) {
                try {
                    this.writeErrorMessage("HTTP/1.1 403 SSL Rejected\r\nContent-Type: text/html; charset=iso-8859-1\r\nCache-control: no-cache\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n<html><body><H1>I2P ERROR: SSL to I2P address rejected</H1>SSL to .i2p addresses denied by configuration.You may change the configuration in I2PTunnel", out, targetRequest, false, destination);
                }
                catch (IOException header) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                if (this._log.shouldLog(30)) {
                    this._log.warn("SSL to i2p destinations denied by configuration: " + targetRequest);
                }
                return;
            }
            if (ahelperNew && "GET".equals(method) && (userAgent == null || !userAgent.startsWith("Wget")) && !Boolean.parseBoolean(this.getTunnel().getClientOptions().getProperty("i2ptunnel.httpclient.disableAddressHelper"))) {
                try {
                    this.writeHelperSaveForm(out, destination, ahelperKey, targetRequest, referer);
                }
                catch (IOException header) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            if (ahelperPresent && !"POST".equals(method)) {
                uri = targetRequest;
                if (this._log.shouldLog(10)) {
                    this._log.debug("Auto redirecting to " + uri);
                }
                try {
                    out.write(("HTTP/1.1 301 Address Helper Accepted\r\nLocation: " + uri + "\r\nConnection: close\r\nProxy-Connection: close\r\n\r\n").getBytes("UTF-8"));
                }
                catch (IOException jumpServers) {
                }
                finally {
                    I2PTunnelHTTPClient.closeSocket(s);
                }
                return;
            }
            opts = new Properties();
            sktOpts = this.getDefaultOptions(opts);
            if (remotePort > 0) {
                sktOpts.setPort(remotePort);
            }
            i2ps = this.createI2PSocket(clientDest, sktOpts);
            onTimeout = new I2PTunnelHTTPClientBase.OnTimeout(this, s, s.getOutputStream(), targetRequest, usingWWWProxy, currentProxy, requestId);
            if (method.toUpperCase(Locale.US).equals("CONNECT")) {
                if (usingWWWProxy) {
                    data = newRequest.toString().getBytes("ISO-8859-1");
                    response = null;
                } else {
                    data = null;
                    response = "HTTP/1.1 200 Connection Established\r\nProxy-agent: I2P\r\n\r\n".getBytes("UTF-8");
                }
                t /* !! */  = new I2PTunnelRunner(s, i2ps, this.sockLock, data, response, (List<I2PSocket>)this.mySockets, onTimeout);
            } else {
                data = newRequest.toString().getBytes("ISO-8859-1");
                t /* !! */  = new I2PTunnelHTTPClientRunner(s, i2ps, this.sockLock, data, (List<I2PSocket>)this.mySockets, onTimeout);
            }
            t /* !! */ .run();
        }
        catch (IOException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info(this.getPrefix(requestId) + "Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (I2PException ex) {
            if (this._log.shouldLog(20)) {
                this._log.info("getPrefix(requestId) + Error trying to connect", ex);
            }
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
        catch (OutOfMemoryError oom) {
            ex = new IOException("OOM");
            this._log.error("getPrefix(requestId) + Error trying to connect", oom);
            this.handleClientException(ex, out, targetRequest, usingWWWProxy, currentProxy, requestId);
            I2PTunnelHTTPClient.closeSocket(s);
        }
    }

    private String selectSSLProxy() {
        String s = this.getTunnel().getClientOptions().getProperty(PROP_SSL_OUTPROXIES);
        if (s == null) {
            return null;
        }
        String[] p = DataHelper.split(s, "[,; \r\n\t]");
        if (p.length == 0) {
            return null;
        }
        if (p.length == 1) {
            return p[0];
        }
        int i = this._context.random().nextInt(p.length);
        return p[i];
    }

    private void writeHelperSaveForm(OutputStream outs, String destination, String ahelperKey, String targetRequest, String referer) throws IOException {
        if (outs == null) {
            return;
        }
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outs, "UTF-8"));
        String header = this.getErrorPage("ahelper-new", ERR_AHELPER_NEW);
        out.write(header);
        out.write("<table id=\"proxyNewHost\">\n<tr><td align=\"right\">" + this._t("Host") + "</td><td>" + destination + "</td></tr>\n");
        try {
            String b32 = Base32.encode(SHA256Generator.getInstance().calculateHash(Base64.decode(ahelperKey)).getData());
            out.write("<tr><td align=\"right\">" + this._t("Base 32") + "</td><td><a href=\"http://" + b32 + ".b32.i2p/\">" + b32 + ".b32.i2p</a></td></tr>");
        }
        catch (Exception b32) {
            // empty catch block
        }
        out.write("<tr><td align=\"right\">" + this._t("Destination") + "</td><td><textarea rows=\"1\" style=\"height: 6em; min-width: 0; min-height: 0;\" cols=\"70\" wrap=\"off\" readonly=\"readonly\" >" + ahelperKey + "</textarea></td></tr>\n</table>\n<hr>\n<form method=\"GET\" action=\"" + targetRequest + "\">\n<h4>" + this._t("Continue to {0} without saving", destination) + "</h4>\n<p>" + this._t("You can browse to the site without saving it to the address book. The address will be remembered until you restart your I2P router.") + "</p>\n<div class=\"formaction\"><button type=\"submit\" class=\"go\">" + this._t("Continue without saving") + "</button></div>\n</form>\n<form method=\"GET\" action=\"http://" + LOCAL_SERVER + "/add\">\n<input type=\"hidden\" name=\"host\" value=\"" + destination + "\">\n<input type=\"hidden\" name=\"dest\" value=\"" + ahelperKey + "\">\n<input type=\"hidden\" name=\"nonce\" value=\"" + this._proxyNonce + "\">\n<h4>" + this._t("Save {0} to router address book and continue to website", destination) + "</h4>\n<p>" + this._t("This address will be saved to your Router address book where your subscription-based addresses are stored."));
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write(" " + this._t("If you want to keep track of sites you have added manually, add to your Master or Private address book instead."));
        }
        String label = this._t("Save & continue").replace("&", "&amp;");
        out.write("</p>\n<div class=\"formaction\"><button type=\"submit\" class=\"accept\" name=\"router\" value=\"router\">" + label + "</button></div>\n");
        if (this._context.namingService().getName().equals("BlockfileNamingService")) {
            out.write("<h4>" + this._t("Save {0} to master address book and continue to website", destination) + "</h4>\n<p>" + this._t("This address will be saved to your Master address book. Select this option for addresses you wish to keep separate from the main router address book, but don't mind publishing.") + "</p>\n<div class=\"formaction\"><button type=\"submit\" class=\"accept\" name=\"master\" value=\"master\">" + label + "</button></div>\n");
            out.write("<h4>" + this._t("Save {0} to private address book and continue to website", destination) + "</h4>\n<p>" + this._t("This address will be saved to your Private address book, ensuring it is never published.") + "</p>\n<div class=\"formaction\"><button type=\"submit\" class=\"accept\" name=\"private\" value=\"private\">" + label + "</button></div>\n");
        }
        if (referer != null) {
            out.write("<input type=\"hidden\" name=\"referer\" value=\"" + referer + "\">\n");
        }
        out.write("<input type=\"hidden\" name=\"url\" value=\"" + targetRequest + "\">\n</form>\n</div>\n");
        I2PTunnelHTTPClient.writeFooter(out);
    }

    private final String getHostName(String host) {
        if (host == null) {
            return null;
        }
        if (host.length() == 60 && host.toLowerCase(Locale.US).endsWith(".b32.i2p")) {
            return host;
        }
        Destination dest = this._context.namingService().lookup(host);
        if (dest == null) {
            return "i2p";
        }
        return dest.toBase32();
    }

    private static boolean isSupportedAddress(String host, String protocol) {
        if (host == null || protocol == null) {
            return false;
        }
        String lc = protocol.toLowerCase(Locale.US);
        return lc.equals("http") || lc.equals("https");
    }

    private static URI changeURI(URI uri, String host, int port, String path) throws URISyntaxException {
        return new URI(uri.getScheme(), null, host != null ? host : uri.getHost(), port != 0 ? port : uri.getPort(), path != null ? path : uri.getPath(), uri.getQuery(), null);
    }

    private static URI replaceQuery(URI uri, String query) throws URISyntaxException {
        URI rv = uri;
        if (rv.getRawQuery() != null) {
            rv = new URI(rv.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), null, null);
        }
        if (query != null) {
            String newURI = rv.toASCIIString() + '?' + query;
            rv = new URI(newURI);
        }
        return rv;
    }

    private static String[] removeHelper(String query) {
        int keystart = 0;
        int valstart = -1;
        String key = null;
        for (int i = 0; i <= query.length(); ++i) {
            int c;
            int n = c = i < query.length() ? (int)query.charAt(i) : 38;
            if (c == 59 || c == 38) {
                String decodedKey;
                if (valstart < 0) {
                    key = query.substring(keystart, i);
                }
                if ((decodedKey = LocalHTTPServer.decode(key)).equals(HELPER_PARAM)) {
                    String newQuery;
                    String string = newQuery = keystart > 0 ? query.substring(0, keystart - 1) : "";
                    if (i < query.length() - 1) {
                        newQuery = keystart > 0 ? newQuery + query.substring(i) : newQuery + query.substring(i + 1);
                    }
                    String value = valstart >= 0 ? query.substring(valstart, i) : "";
                    String helperValue = LocalHTTPServer.decode(value);
                    return new String[]{newQuery, helperValue};
                }
                keystart = i + 1;
                valstart = -1;
                continue;
            }
            if (c != 61 || valstart >= 0) continue;
            key = query.substring(keystart, i);
            valstart = i + 1;
        }
        return null;
    }

    private static class InputReader {
        InputStream _s;

        public InputReader(InputStream s) {
            this._s = s;
        }

        String readLine(String method) throws IOException {
            return DataHelper.readLine(this._s);
        }

        public void drain() {
            try {
                String line;
                while ((line = DataHelper.readLine(this._s)) != null && line.length() > 1) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

